/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunMidiFileWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class StandardMidiFileWriter
extends SunMidiFileWriter {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int MIDI_TYPE_2 = 2;
    private InputStream stream;
    private DataInputStream dis;
    private Sequence sequence;
    private short type;
    private short tracks;
    private long tick;
    private int status;
    private int bytesRemaining = 0;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    public static final int[] types = new int[]{0, 1};

    public int[] getMidiFileTypes() {
        int[] nArray = new int[types.length];
        System.arraycopy(types, 0, nArray, 0, types.length);
        return nArray;
    }

    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] trackArray = sequence.getTracks();
        int[] nArray = trackArray.length == 1 ? new int[]{0, 1} : new int[]{1};
        return nArray;
    }

    public boolean isFileTypeSupported(int n2) {
        int n3 = 0;
        while (n3 < types.length) {
            if (n2 == types[n3]) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int write(Sequence sequence, int n2, OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        long l2 = 0L;
        long l3 = 0L;
        if (!this.isFileTypeSupported(n2, sequence)) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        InputStream inputStream = this.getFileStream(n2, sequence);
        if (inputStream == null) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        byArray = new byte[16384];
        while ((l2 = (long)inputStream.read(byArray)) >= 0L) {
            outputStream.write(byArray, 0, (int)l2);
            l3 += l2;
        }
        return (int)l3;
    }

    public int write(Sequence sequence, int n2, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        Object var5_5 = null;
        int n3 = 0;
        fileOutputStream = new FileOutputStream(file);
        n3 = this.write(sequence, n2, fileOutputStream);
        fileOutputStream.close();
        return n3;
    }

    private InputStream getFileStream(int n2, Sequence sequence) throws IOException {
        int n3;
        Track[] trackArray = sequence.getTracks();
        int n4 = 0;
        int n5 = 14;
        int n6 = 0;
        PipedOutputStream pipedOutputStream = null;
        DataOutputStream dataOutputStream = null;
        PipedInputStream pipedInputStream = null;
        InputStream[] inputStreamArray = null;
        InputStream inputStream = null;
        SequenceInputStream sequenceInputStream = null;
        if (n2 == 0) {
            if (trackArray.length != 1) {
                return null;
            }
        } else if (n2 == 1) {
            if (trackArray.length < 1) {
                return null;
            }
        } else if (trackArray.length == 1) {
            n2 = 0;
        } else if (trackArray.length > 1) {
            n2 = 1;
        } else {
            return null;
        }
        inputStreamArray = new InputStream[trackArray.length];
        int n7 = 0;
        while (n7 < trackArray.length) {
            try {
                inputStreamArray[n7] = this.writeTrack(trackArray[n7], n2);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
            ++n7;
        }
        if (trackArray.length == 1) {
            inputStream = inputStreamArray[0];
        } else if (trackArray.length > 1) {
            inputStream = inputStreamArray[0];
            int n8 = 1;
            while (n8 < trackArray.length) {
                inputStream = new SequenceInputStream(inputStream, inputStreamArray[n8]);
                ++n8;
            }
        }
        pipedOutputStream = new PipedOutputStream();
        dataOutputStream = new DataOutputStream(pipedOutputStream);
        pipedInputStream = new PipedInputStream(pipedOutputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(n5 - 8);
        if (n2 == 0) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(1);
        }
        dataOutputStream.writeShort((short)trackArray.length);
        float f2 = sequence.getDivisionType();
        if (f2 == 0.0f) {
            n3 = sequence.getResolution();
        } else if (f2 == 24.0f) {
            n3 = -6144;
            n3 += sequence.getResolution() & 0xFF;
        } else if (f2 == 25.0f) {
            n3 = -6400;
            n3 += sequence.getResolution() & 0xFF;
        } else if (f2 == 29.97f) {
            n3 = -7424;
            n3 += sequence.getResolution() & 0xFF;
        } else if (f2 == 30.0f) {
            n3 = -7680;
            n3 += sequence.getResolution() & 0xFF;
        } else {
            return null;
        }
        dataOutputStream.writeShort(n3);
        sequenceInputStream = new SequenceInputStream(pipedInputStream, inputStream);
        dataOutputStream.close();
        n6 = n4 + n5;
        return sequenceInputStream;
    }

    private int getType(int n2) throws InvalidMidiDataException {
        if ((n2 & 0xF0) == 240) {
            switch (n2) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            throw new InvalidMidiDataException("Invalid status byte: " + n2);
        }
        switch (n2 & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + n2);
    }

    private int writeVarInt(int n2) throws IOException, InvalidMidiDataException {
        int n3 = 6;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < n3) {
            byArray[n5] = 0;
            ++n5;
        }
        int n6 = n3 - 1;
        while (n6 >= 0) {
            byArray[n6] = (byte)(n2 & 0x7F);
            n2 >>>= 7;
            if (++n4 > 1) {
                int n7 = n6;
                byArray[n7] = (byte)(byArray[n7] | 0x80);
            }
            if (n2 == 0) break;
            --n6;
        }
        if ((byArray[n3 - 1] & 0x80) != 0) {
            throw new InvalidMidiDataException("Unable to create variable-length integer");
        }
        this.tddos.write(byArray, n3 - n4, n4);
        return n4;
    }

    private InputStream writeTrack(Track track, int n2) throws IOException, InvalidMidiDataException {
        int n3 = 0;
        boolean bl2 = false;
        int n4 = track.size();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(pipedOutputStream);
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.tddos = new DataOutputStream(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        SequenceInputStream sequenceInputStream = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        n5 = 0;
        int n9 = 0;
        while (n9 < n4) {
            MidiEvent midiEvent = track.get(n9);
            byte[] byArray = null;
            ShortMessage shortMessage = null;
            MetaMessage metaMessage = null;
            SysexMessage sysexMessage = null;
            n7 = (int)midiEvent.getTick();
            n6 = (int)midiEvent.getTick() - n5;
            n5 = (int)midiEvent.getTick();
            int n10 = midiEvent.getMessage().getStatus();
            int n11 = this.getType(n10);
            switch (n11) {
                case 1: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n12 = shortMessage.getData1();
                    n3 += this.writeVarInt(n6);
                    if (n10 != n8) {
                        n8 = n10;
                        this.tddos.writeByte(n10);
                        ++n3;
                    }
                    this.tddos.writeByte(n12);
                    ++n3;
                    break;
                }
                case 2: {
                    shortMessage = (ShortMessage)midiEvent.getMessage();
                    int n12 = shortMessage.getData1();
                    int n13 = shortMessage.getData2();
                    n3 += this.writeVarInt(n6);
                    if (n10 != n8) {
                        n8 = n10;
                        this.tddos.writeByte(n10);
                        ++n3;
                    }
                    this.tddos.writeByte(n12);
                    ++n3;
                    this.tddos.writeByte(n13);
                    ++n3;
                    break;
                }
                case 3: {
                    sysexMessage = (SysexMessage)midiEvent.getMessage();
                    int n14 = sysexMessage.getLength();
                    byArray = sysexMessage.getMessage();
                    n3 += this.writeVarInt(n6);
                    n8 = n10;
                    this.tddos.writeByte(byArray[0]);
                    ++n3;
                    n3 += this.writeVarInt(byArray.length - 1);
                    this.tddos.write(byArray, 1, byArray.length - 1);
                    n3 += byArray.length - 1;
                    break;
                }
                case 4: {
                    metaMessage = (MetaMessage)midiEvent.getMessage();
                    int n14 = metaMessage.getLength();
                    byArray = metaMessage.getMessage();
                    n3 += this.writeVarInt(n6);
                    n8 = n10;
                    this.tddos.write(byArray, 0, byArray.length);
                    n3 += byArray.length;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Invalid midi event");
                }
            }
            ++n9;
        }
        dataOutputStream.writeInt(1297379947);
        dataOutputStream.writeInt(n3);
        n3 += 8;
        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        sequenceInputStream = new SequenceInputStream(pipedInputStream, byteArrayInputStream);
        dataOutputStream.close();
        this.tddos.close();
        return sequenceInputStream;
    }
}

