/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

public final class LdapName
implements Name {
    private transient String unparsed;
    private transient Vector rdns;
    private transient boolean valuesCaseSensitive = false;
    static final long serialVersionUID = -1595520034788997356L;

    public LdapName(String string) throws InvalidNameException {
        this.unparsed = string;
        this.parse();
    }

    private LdapName(String string, Vector vector) {
        this.unparsed = string;
        this.rdns = (Vector)vector.clone();
    }

    private LdapName(String string, Vector vector, int n2, int n3) {
        this.unparsed = string;
        this.rdns = new Vector();
        int n4 = n2;
        while (n4 < n3) {
            this.rdns.addElement(vector.elementAt(n4));
            ++n4;
        }
    }

    public Object clone() {
        return new LdapName(this.unparsed, this.rdns);
    }

    public String toString() {
        if (this.unparsed != null) {
            return this.unparsed;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.rdns.size() - 1;
        while (n2 >= 0) {
            if (n2 < this.rdns.size() - 1) {
                stringBuffer.append(',');
            }
            Rdn rdn = (Rdn)this.rdns.elementAt(n2);
            stringBuffer.append(rdn);
            --n2;
        }
        this.unparsed = new String(stringBuffer);
        return this.unparsed;
    }

    public boolean equals(Object object) {
        return object instanceof LdapName && this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        LdapName ldapName = (LdapName)object;
        if (object == this || this.unparsed != null && this.unparsed.equals(ldapName.unparsed)) {
            return 0;
        }
        int n2 = Math.min(this.rdns.size(), ldapName.rdns.size());
        int n3 = 0;
        while (n3 < n2) {
            Rdn rdn;
            Rdn rdn2 = (Rdn)this.rdns.elementAt(n3);
            int n4 = rdn2.compareTo(rdn = (Rdn)ldapName.rdns.elementAt(n3));
            if (n4 != 0) {
                return n4;
            }
            ++n3;
        }
        return this.rdns.size() - ldapName.rdns.size();
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rdns.size()) {
            Rdn rdn = (Rdn)this.rdns.elementAt(n3);
            n2 += rdn.hashCode();
            ++n3;
        }
        return n2;
    }

    public int size() {
        return this.rdns.size();
    }

    public boolean isEmpty() {
        return this.rdns.isEmpty();
    }

    public Enumeration getAll() {
        final Enumeration enumeration = this.rdns.elements();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                return enumeration.nextElement().toString();
            }
        };
    }

    public String get(int n2) {
        return this.rdns.elementAt(n2).toString();
    }

    public Name getPrefix(int n2) {
        return new LdapName(null, this.rdns, 0, n2);
    }

    public Name getSuffix(int n2) {
        return new LdapName(null, this.rdns, n2, this.rdns.size());
    }

    public boolean startsWith(Name name) {
        int n2;
        int n3 = this.rdns.size();
        return n3 >= (n2 = name.size()) && this.matches(0, n2, name);
    }

    public boolean endsWith(Name name) {
        int n2;
        int n3 = this.rdns.size();
        return n3 >= (n2 = name.size()) && this.matches(n3 - n2, n3, name);
    }

    public void setValuesCaseSensitive(boolean bl2) {
        this.toString();
        this.rdns = null;
        try {
            this.parse();
        }
        catch (InvalidNameException invalidNameException) {
            throw new IllegalStateException("Cannot parse name: " + this.unparsed);
        }
        this.valuesCaseSensitive = bl2;
    }

    private boolean matches(int n2, int n3, Name name) {
        int n4 = n2;
        while (n4 < n3) {
            Rdn rdn;
            Object object;
            if (name instanceof LdapName) {
                object = (LdapName)name;
                rdn = (Rdn)((LdapName)object).rdns.elementAt(n4 - n2);
            } else {
                object = name.get(n4 - n2);
                try {
                    rdn = new DnParser((String)object, this.valuesCaseSensitive).getRdn();
                }
                catch (InvalidNameException invalidNameException) {
                    return false;
                }
            }
            if (!rdn.equals(this.rdns.elementAt(n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public Name addAll(Name name) throws InvalidNameException {
        return this.addAll(this.size(), name);
    }

    public Name addAll(int n2, Name name) throws InvalidNameException {
        if (name instanceof LdapName) {
            LdapName ldapName = (LdapName)name;
            int n3 = 0;
            while (n3 < ldapName.rdns.size()) {
                this.rdns.insertElementAt(ldapName.rdns.elementAt(n3), n2++);
                ++n3;
            }
        } else {
            Enumeration enumeration = name.getAll();
            while (enumeration.hasMoreElements()) {
                DnParser dnParser = new DnParser((String)enumeration.nextElement(), this.valuesCaseSensitive);
                this.rdns.insertElementAt(dnParser.getRdn(), n2++);
            }
        }
        this.unparsed = null;
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        return this.add(this.size(), string);
    }

    public Name add(int n2, String string) throws InvalidNameException {
        Rdn rdn = new DnParser(string, this.valuesCaseSensitive).getRdn();
        this.rdns.insertElementAt(rdn, n2);
        this.unparsed = null;
        return this;
    }

    public Object remove(int n2) throws InvalidNameException {
        String string = this.get(n2);
        this.rdns.removeElementAt(n2);
        this.unparsed = null;
        return string;
    }

    private void parse() throws InvalidNameException {
        this.rdns = new DnParser(this.unparsed, this.valuesCaseSensitive).getDn();
    }

    private static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\r';
    }

    public static String escapeAttributeValue(Object object) {
        return TypeAndValue.escapeValue(object);
    }

    public static Object unescapeAttributeValue(String string) {
        return TypeAndValue.unescapeValue(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.toString());
        objectOutputStream.writeBoolean(this.valuesCaseSensitive);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.unparsed = (String)objectInputStream.readObject();
        this.valuesCaseSensitive = objectInputStream.readBoolean();
        try {
            this.parse();
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name: " + this.unparsed);
        }
    }

    static class TypeAndValue {
        private final String type;
        private final String value;
        private final boolean binary;
        private final boolean valueCaseSensitive;
        private String comparable = null;

        TypeAndValue(String string, String string2, boolean bl2) {
            this.type = string;
            this.value = string2;
            this.binary = string2.startsWith("#");
            this.valueCaseSensitive = bl2;
        }

        public String toString() {
            return this.type + "=" + this.value;
        }

        public int compareTo(Object object) {
            TypeAndValue typeAndValue = (TypeAndValue)object;
            int n2 = this.type.toUpperCase().compareTo(typeAndValue.type.toUpperCase());
            if (n2 != 0) {
                return n2;
            }
            if (this.value.equals(typeAndValue.value)) {
                return 0;
            }
            return this.getValueComparable().compareTo(typeAndValue.getValueComparable());
        }

        public boolean equals(Object object) {
            if (!(object instanceof TypeAndValue)) {
                return false;
            }
            TypeAndValue typeAndValue = (TypeAndValue)object;
            return this.type.equalsIgnoreCase(typeAndValue.type) && (this.value.equals(typeAndValue.value) || this.getValueComparable().equals(typeAndValue.getValueComparable()));
        }

        public int hashCode() {
            return this.type.toUpperCase().hashCode() + this.getValueComparable().hashCode();
        }

        String getType() {
            return this.type;
        }

        Object getUnescapedValue() {
            return TypeAndValue.unescapeValue(this.value);
        }

        private String getValueComparable() {
            if (this.comparable != null) {
                return this.comparable;
            }
            if (this.binary) {
                this.comparable = this.value.toUpperCase();
            } else {
                this.comparable = (String)TypeAndValue.unescapeValue(this.value);
                if (!this.valueCaseSensitive) {
                    this.comparable = this.comparable.toUpperCase();
                }
            }
            return this.comparable;
        }

        static String escapeValue(Object object) {
            return object instanceof byte[] ? TypeAndValue.escapeBinaryValue((byte[])object) : TypeAndValue.escapeStringValue((String)object);
        }

        private static String escapeStringValue(String string) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(2 * string.length());
            int n2 = 0;
            while (n2 < cArray.length) {
                if (!LdapName.isWhitespace(cArray[n2])) break;
                ++n2;
            }
            int n3 = cArray.length - 1;
            while (n3 >= 0) {
                if (!LdapName.isWhitespace(cArray[n3])) break;
                --n3;
            }
            int n4 = 0;
            while (n4 < cArray.length) {
                char c2 = cArray[n4];
                if (n4 < n2 || n4 > n3 || ",=+<>#;\"\\".indexOf(c2) >= 0) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c2);
                ++n4;
            }
            return new String(stringBuffer);
        }

        private static String escapeBinaryValue(byte[] byArray) {
            StringBuffer stringBuffer = new StringBuffer(1 + 2 * byArray.length);
            stringBuffer.append("#");
            int n2 = 0;
            while (n2 < byArray.length) {
                byte by = byArray[n2];
                stringBuffer.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuffer.append(Character.forDigit(0xF & by, 16));
                ++n2;
            }
            return new String(stringBuffer).toUpperCase();
        }

        static Object unescapeValue(String string) {
            char[] cArray = string.toCharArray();
            int n2 = 0;
            int n3 = cArray.length;
            while (n2 < n3 && LdapName.isWhitespace(cArray[n2])) {
                ++n2;
            }
            while (n2 < n3 && LdapName.isWhitespace(cArray[n3 - 1])) {
                --n3;
            }
            if (n2 >= n3) {
                return "";
            }
            if (cArray[n2] == '#') {
                return TypeAndValue.decodeHexPairs(cArray, ++n2, n3);
            }
            if (cArray[n2] == '\"' && cArray[n3 - 1] == '\"') {
                ++n2;
                --n3;
            }
            StringBuffer stringBuffer = new StringBuffer(n3 - n2);
            int n4 = n2;
            while (n4 < n3) {
                if (cArray[n4] == '\\' && n4 + 1 < n3) {
                    if (!Character.isLetterOrDigit(cArray[n4 + 1])) {
                        stringBuffer.append(cArray[++n4]);
                    } else {
                        byte[] byArray = TypeAndValue.getUtf8Octets(cArray, n4, n3);
                        try {
                            stringBuffer.append(new String(byArray, "UTF8"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        n4 += byArray.length * 3 - 1;
                    }
                } else {
                    stringBuffer.append(cArray[n4]);
                }
                ++n4;
            }
            return new String(stringBuffer);
        }

        private static byte[] decodeHexPairs(char[] cArray, int n2, int n3) {
            byte[] byArray = new byte[(n3 - n2) / 2];
            int n4 = 0;
            while (n2 + 1 < n3) {
                int n5 = Character.digit(cArray[n2], 16);
                int n6 = Character.digit(cArray[n2 + 1], 16);
                if (n5 < 0 || n6 < 0) break;
                byArray[n4] = (byte)((n5 << 4) + n6);
                n2 += 2;
                ++n4;
            }
            if (n2 != n3) {
                throw new IllegalArgumentException("Illegal attribute value: #" + new String(cArray));
            }
            return byArray;
        }

        private static byte[] getUtf8Octets(char[] cArray, int n2, int n3) {
            byte[] byArray = new byte[(n3 - n2) / 3];
            int n4 = 0;
            while (n2 + 2 < n3 && cArray[n2++] == '\\') {
                int n5 = Character.digit(cArray[n2++], 16);
                int n6 = Character.digit(cArray[n2++], 16);
                if (n5 < 0 || n6 < 0) break;
                byArray[n4++] = (byte)((n5 << 4) + n6);
            }
            if (n4 == byArray.length) {
                return byArray;
            }
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
    }

    static class Rdn {
        private final Vector tvs = new Vector();

        Rdn() {
        }

        void add(TypeAndValue typeAndValue) {
            int n2 = 0;
            while (n2 < this.tvs.size()) {
                int n3 = typeAndValue.compareTo(this.tvs.elementAt(n2));
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) break;
                ++n2;
            }
            this.tvs.insertElementAt(typeAndValue, n2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.tvs.size()) {
                if (n2 > 0) {
                    stringBuffer.append('+');
                }
                stringBuffer.append(this.tvs.elementAt(n2));
                ++n2;
            }
            return new String(stringBuffer);
        }

        public boolean equals(Object object) {
            return object instanceof Rdn && this.compareTo(object) == 0;
        }

        public int compareTo(Object object) {
            Rdn rdn = (Rdn)object;
            int n2 = Math.min(this.tvs.size(), rdn.tvs.size());
            int n3 = 0;
            while (n3 < n2) {
                TypeAndValue typeAndValue = (TypeAndValue)this.tvs.elementAt(n3);
                int n4 = typeAndValue.compareTo(rdn.tvs.elementAt(n3));
                if (n4 != 0) {
                    return n4;
                }
                ++n3;
            }
            return this.tvs.size() - rdn.tvs.size();
        }

        public int hashCode() {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.tvs.size()) {
                n2 += this.tvs.elementAt(n3).hashCode();
                ++n3;
            }
            return n2;
        }

        Attributes toAttributes() {
            BasicAttributes basicAttributes = new BasicAttributes(true);
            int n2 = 0;
            while (n2 < this.tvs.size()) {
                TypeAndValue typeAndValue = (TypeAndValue)this.tvs.elementAt(n2);
                Attribute attribute = basicAttributes.get(typeAndValue.getType());
                if (attribute == null) {
                    basicAttributes.put(typeAndValue.getType(), typeAndValue.getUnescapedValue());
                } else {
                    attribute.add(typeAndValue.getUnescapedValue());
                }
                ++n2;
            }
            return basicAttributes;
        }
    }

    static class DnParser {
        private final String name;
        private final char[] chars;
        private final int len;
        private int cur = 0;
        private boolean valuesCaseSensitive;

        DnParser(String string, boolean bl2) throws InvalidNameException {
            this.name = string;
            this.len = string.length();
            this.chars = string.toCharArray();
            this.valuesCaseSensitive = bl2;
        }

        Vector getDn() throws InvalidNameException {
            this.cur = 0;
            Vector vector = new Vector(this.len / 3 + 10);
            if (this.len == 0) {
                return vector;
            }
            vector.addElement(this.parseRdn());
            while (this.cur < this.len) {
                if (this.chars[this.cur] == ',' || this.chars[this.cur] == ';') {
                    ++this.cur;
                    vector.insertElementAt(this.parseRdn(), 0);
                    continue;
                }
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return vector;
        }

        Rdn getRdn() throws InvalidNameException {
            Rdn rdn = this.parseRdn();
            if (this.cur < this.len) {
                throw new InvalidNameException("Invalid RDN: " + this.name);
            }
            return rdn;
        }

        private Rdn parseRdn() throws InvalidNameException {
            Rdn rdn = new Rdn();
            while (this.cur < this.len) {
                this.consumeWhitespace();
                String string = this.parseAttrType();
                this.consumeWhitespace();
                if (this.cur >= this.len || this.chars[this.cur] != '=') {
                    throw new InvalidNameException("Invalid name: " + this.name);
                }
                ++this.cur;
                this.consumeWhitespace();
                String string2 = this.parseAttrValue();
                this.consumeWhitespace();
                rdn.add(new TypeAndValue(string, string2, this.valuesCaseSensitive));
                if (this.cur >= this.len || this.chars[this.cur] != '+') break;
                ++this.cur;
            }
            return rdn;
        }

        private String parseAttrType() throws InvalidNameException {
            int n2 = this.cur;
            while (this.cur < this.len) {
                char c2 = this.chars[this.cur];
                if (!Character.isLetterOrDigit(c2) && c2 != '.' && c2 != '-' && c2 != ' ') break;
                ++this.cur;
            }
            while (this.cur > n2 && this.chars[this.cur - 1] == ' ') {
                --this.cur;
            }
            if (n2 == this.cur) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            return new String(this.chars, n2, this.cur - n2);
        }

        private String parseAttrValue() throws InvalidNameException {
            if (this.cur < this.len && this.chars[this.cur] == '#') {
                return this.parseBinaryAttrValue();
            }
            if (this.cur < this.len && this.chars[this.cur] == '\"') {
                return this.parseQuotedAttrValue();
            }
            return this.parseStringAttrValue();
        }

        private String parseBinaryAttrValue() throws InvalidNameException {
            int n2 = this.cur++;
            while (this.cur < this.len && Character.isLetterOrDigit(this.chars[this.cur])) {
                ++this.cur;
            }
            return new String(this.chars, n2, this.cur - n2);
        }

        private String parseQuotedAttrValue() throws InvalidNameException {
            int n2 = this.cur++;
            while (this.cur < this.len && this.chars[this.cur] != '\"') {
                if (this.chars[this.cur] == '\\') {
                    ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur >= this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            ++this.cur;
            return new String(this.chars, n2, this.cur - n2);
        }

        private String parseStringAttrValue() throws InvalidNameException {
            int n2 = this.cur;
            int n3 = -1;
            while (this.cur < this.len && !this.atTerminator()) {
                if (this.chars[this.cur] == '\\') {
                    n3 = ++this.cur;
                }
                ++this.cur;
            }
            if (this.cur > this.len) {
                throw new InvalidNameException("Invalid name: " + this.name);
            }
            int n4 = this.cur;
            while (n4 > n2) {
                if (!LdapName.isWhitespace(this.chars[n4 - 1]) || n3 == n4 - 1) break;
                --n4;
            }
            return new String(this.chars, n2, n4 - n2);
        }

        private void consumeWhitespace() {
            while (this.cur < this.len && LdapName.isWhitespace(this.chars[this.cur])) {
                ++this.cur;
            }
        }

        private boolean atTerminator() {
            return this.cur < this.len && (this.chars[this.cur] == ',' || this.chars[this.cur] == ';' || this.chars[this.cur] == '+');
        }
    }
}

