/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.Component;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.StringTokenizer;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.EventMulticaster;
import sun.plugin.usability.PluginLogger;
import sun.plugin.usability.TraceListener;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public class Trace {
    private static boolean bBasicTraceOn = false;
    private static boolean bExtTraceOn = false;
    private static boolean bSecurityTraceOn = false;
    private static boolean bNetTraceOn = false;
    private static boolean bLiveConnectTraceOn = false;
    private static boolean bAutomationOn = false;
    private static HashMap threadGroups;

    public static void reset() {
        if (AccessController.doPrivileged(new GetBooleanAction("javaplugin.trace")).booleanValue()) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.trace.option"));
            if (string == null) {
                bBasicTraceOn = true;
                bNetTraceOn = true;
                bSecurityTraceOn = true;
                bExtTraceOn = true;
                bLiveConnectTraceOn = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null || string2.equalsIgnoreCase("all")) {
                        bBasicTraceOn = true;
                        bNetTraceOn = true;
                        bSecurityTraceOn = true;
                        bExtTraceOn = true;
                        bLiveConnectTraceOn = true;
                        break;
                    }
                    if (string2.equalsIgnoreCase("basic")) {
                        bBasicTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("net")) {
                        bNetTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("security")) {
                        bSecurityTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("ext")) {
                        bExtTraceOn = true;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("liveconnect")) continue;
                    bLiveConnectTraceOn = true;
                }
            }
        }
    }

    public static boolean isEnabled() {
        return bBasicTraceOn || bNetTraceOn || bSecurityTraceOn || bExtTraceOn || bLiveConnectTraceOn;
    }

    public static void setBasicTrace(boolean bl) {
        bBasicTraceOn = bl;
    }

    public static void setNetTrace(boolean bl) {
        bNetTraceOn = bl;
    }

    public static void setSecurityTrace(boolean bl) {
        bSecurityTraceOn = bl;
    }

    public static void setExtTrace(boolean bl) {
        bExtTraceOn = bl;
    }

    public static void setLiveConnectTrace(boolean bl) {
        bLiveConnectTraceOn = bl;
    }

    public static boolean isAutomationEnabled() {
        return bAutomationOn;
    }

    public static void println(String string) {
        Trace.println(string, null);
    }

    public static void println(String string, int n) {
        Trace.println(string, null, n);
    }

    public static void println(String string, TraceListener traceListener) {
        Trace.println(string, traceListener, 2);
    }

    public static void println(String string, TraceListener traceListener, int n) {
        if ((n & 2) == 2) {
            if ((n & 0xFF0) == 0) {
                n |= 0x10;
            }
            switch (n & 0xFF0) {
                case 16: {
                    if (bBasicTraceOn) break;
                    return;
                }
                case 32: {
                    if (bNetTraceOn) break;
                    return;
                }
                case 64: {
                    if (bSecurityTraceOn) break;
                    return;
                }
                case 128: {
                    if (bExtTraceOn) break;
                    return;
                }
                case 256: {
                    if (bLiveConnectTraceOn) break;
                    return;
                }
            }
            System.err.println(string);
            System.err.flush();
            PluginLogger.log(string);
        }
        Trace.firePrintlnEvent(string, traceListener, n);
    }

    public static void msgPrintln(String string) {
        Trace.msgPrintln(string, null, 2);
    }

    public static void msgPrintln(String string, int n) {
        Trace.msgPrintln(string, null, n);
    }

    public static void msgPrintln(String string, TraceListener traceListener) {
        Trace.msgPrintln(string, traceListener, 2);
    }

    public static void msgPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, null, 2);
    }

    public static void msgPrintln(String string, TraceListener traceListener, int n) {
        Trace.msgPrintln(string, null, traceListener, n);
    }

    public static void msgPrintln(String string, Object[] objectArray, TraceListener traceListener) {
        Trace.msgPrintln(string, objectArray, traceListener, 2);
    }

    public static void msgPrintln(String string, Object[] objectArray, TraceListener traceListener, int n) {
        if ((n & 2) == 2) {
            if ((n & 0xFF0) == 0) {
                n |= 0x10;
            }
            switch (n & 0xFF0) {
                case 16: {
                    if (bBasicTraceOn) break;
                    return;
                }
                case 32: {
                    if (bNetTraceOn) break;
                    return;
                }
                case 64: {
                    if (bSecurityTraceOn) break;
                    return;
                }
                case 128: {
                    if (bExtTraceOn) break;
                    return;
                }
                case 256: {
                    if (bLiveConnectTraceOn) break;
                    return;
                }
            }
        }
        String string2 = null;
        if (objectArray == null) {
            string2 = ResourceHandler.getMessage(string);
        } else {
            MessageFormat messageFormat = new MessageFormat(ResourceHandler.getMessage(string));
            string2 = messageFormat.format(objectArray);
        }
        if ((n & 2) == 2) {
            System.err.println(string2);
            System.err.flush();
            PluginLogger.log(string2);
        }
        Trace.firePrintlnEvent(string2, traceListener, n);
    }

    public static void printException(Throwable throwable) {
        Trace.printException(null, throwable);
    }

    public static void printException(Component component, Throwable throwable) {
        Trace.printException(component, throwable, null, null);
    }

    public static void printException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2) {
        Trace.printException(component, throwable, string, string2, true);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2, boolean bl) {
        throwable.printStackTrace();
        if (string == null) {
            PluginLogger.logException(throwable);
        } else {
            PluginLogger.logException(string, throwable);
        }
        if (bl && !Trace.isAutomationEnabled()) {
            if (string == null) {
                string = ResourceHandler.getMessage("usability.general_error");
            }
            DialogFactory.showExceptionDialog(component, throwable, string, string2);
        }
    }

    public static void netPrintln(String string) {
        Trace.println(string, null, 34);
    }

    public static void netPrintln(String string, int n) {
        Trace.println(string, null, n | 0x20);
    }

    public static void msgNetPrintln(String string) {
        Trace.msgPrintln(string, null, null, 34);
    }

    public static void msgNetPrintln(String string, int n) {
        Trace.msgPrintln(string, null, null, n | 0x20);
    }

    public static void msgNetPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, null, 34);
    }

    public static void netPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceHandler.getMessage("usability.net_error"), null, false);
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, false);
    }

    public static void securityPrintln(String string) {
        Trace.println(string, null, 66);
    }

    public static void msgSecurityPrintln(String string) {
        Trace.msgPrintln(string, null, null, 66);
    }

    public static void msgSecurityPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, null, 66);
    }

    public static void securityPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceHandler.getMessage("usability.security_error"), null, true);
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void extPrintln(String string) {
        Trace.println(string, null, 130);
    }

    public static void extPrintln(String string, int n) {
        Trace.println(string, null, n | 0x80);
    }

    public static void msgExtPrintln(String string) {
        Trace.msgPrintln(string, null, null, 130);
    }

    public static void msgExtPrintln(String string, int n) {
        Trace.msgPrintln(string, null, null, n | 0x80);
    }

    public static void msgExtPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, null, 130);
    }

    public static void extPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceHandler.getMessage("usability.ext_error"), null, true);
    }

    public static void extPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void liveConnectPrintln(String string) {
        Trace.println(string, null, 258);
    }

    public static void liveConnectPrintln(String string, int n) {
        Trace.println(string, null, n | 0x100);
    }

    public static void msgLiveConnectPrintln(String string) {
        Trace.msgPrintln(string, null, null, 258);
    }

    public static void msgLiveConnectPrintln(String string, int n) {
        Trace.msgPrintln(string, null, null, n | 0x100);
    }

    public static void msgLiveConnectPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, null, 258);
    }

    public static void liveConnectPrintException(Throwable throwable) {
        Trace.printException(null, throwable, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.msgPrintln("trace.listener.added", new Object[]{traceListener});
        HashMap hashMap = threadGroups;
        synchronized (hashMap) {
            TraceListener traceListener2 = (TraceListener)threadGroups.get(new Integer(threadGroup.hashCode()));
            traceListener2 = EventMulticaster.add(traceListener2, traceListener);
            threadGroups.put(new Integer(threadGroup.hashCode()), traceListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.msgPrintln("trace.listener.removed", new Object[]{traceListener});
        HashMap hashMap = threadGroups;
        synchronized (hashMap) {
            TraceListener traceListener2 = (TraceListener)threadGroups.get(new Integer(threadGroup.hashCode()));
            traceListener2 = EventMulticaster.remove(traceListener2, traceListener);
            if (traceListener2 != null) {
                threadGroups.put(new Integer(threadGroup.hashCode()), traceListener2);
            } else {
                threadGroups.remove(new Integer(threadGroup.hashCode()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void firePrintlnEvent(String string, TraceListener traceListener, int n) {
        if (traceListener != null && traceListener.isSupported(n)) {
            traceListener.println(string, n);
        } else if (threadGroups.size() > 0) {
            Thread thread = Thread.currentThread();
            ThreadGroup threadGroup = thread.getThreadGroup();
            TraceListener traceListener2 = null;
            HashMap hashMap = threadGroups;
            synchronized (hashMap) {
                traceListener2 = (TraceListener)threadGroups.get(new Integer(threadGroup.hashCode()));
            }
            if (traceListener2 != null) {
                traceListener2.println(string, n);
            }
        }
    }

    static {
        Trace.reset();
        bAutomationOn = AccessController.doPrivileged(new GetBooleanAction("javaplugin.automation"));
        threadGroups = new HashMap();
    }
}

