/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.util.WeakHashMap;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import sun.awt.AppContext;

public class PluginUIManager {
    private static WeakHashMap themeMap = new WeakHashMap();

    public static LookAndFeel setTheme() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof MetalLookAndFeel) {
            themeMap.put(lookAndFeel, PluginUIManager.getCurrentMetalTheme());
        }
        try {
            MetalLookAndFeel.setCurrentTheme(new PluginMetalTheme());
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {}
        return lookAndFeel;
    }

    public static void restoreTheme(LookAndFeel lookAndFeel) {
        block6: {
            try {
                if (lookAndFeel instanceof MetalLookAndFeel) {
                    MetalTheme metalTheme = (MetalTheme)themeMap.get(lookAndFeel);
                    if (metalTheme != null) {
                        MetalLookAndFeel.setCurrentTheme(metalTheme);
                    } else {
                        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                    }
                }
                if (lookAndFeel == null) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    break block6;
                }
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception exception) {}
        }
    }

    private static MetalTheme getCurrentMetalTheme() {
        AppContext appContext = AppContext.getAppContext();
        return (MetalTheme)appContext.get("currentMetalTheme");
    }

    static class PluginMetalTheme
    extends DefaultMetalTheme {
        private FontUIResource controlTextFont = null;
        private FontUIResource menuTextFont = null;
        private FontUIResource windowTitleFont = null;

        PluginMetalTheme() {
            FontUIResource fontUIResource = super.getControlTextFont();
            this.controlTextFont = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle() & 0xFFFFFFFE, fontUIResource.getSize());
            fontUIResource = super.getMenuTextFont();
            this.menuTextFont = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle() & 0xFFFFFFFE, fontUIResource.getSize());
            fontUIResource = super.getWindowTitleFont();
            this.windowTitleFont = new FontUIResource(fontUIResource.getName(), fontUIResource.getStyle() & 0xFFFFFFFE, fontUIResource.getSize());
        }

        public FontUIResource getControlTextFont() {
            return this.controlTextFont;
        }

        public FontUIResource getMenuTextFont() {
            return this.menuTextFont;
        }

        public FontUIResource getWindowTitleFont() {
            return this.windowTitleFont;
        }
    }
}

