/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;

abstract class BaseSSLSocketImpl
extends SSLSocket {
    final Socket a;
    private static final String b = "com.sun.net.ssl.requireCloseNotify";
    static final boolean c = Debug.a("com.sun.net.ssl.requireCloseNotify", false);
    static final byte d = 1;
    static final byte e = 2;
    static final byte f = 0;
    static final byte g = 10;
    static final byte h = 20;
    static final byte i = 21;
    static final byte j = 22;
    static final byte k = 30;
    static final byte l = 40;
    static final byte m = 41;
    static final byte n = 42;
    static final byte o = 43;
    static final byte p = 44;
    static final byte q = 45;
    static final byte r = 46;
    static final byte s = 47;
    static final byte t = 48;
    static final byte u = 49;
    static final byte v = 50;
    static final byte w = 51;
    static final byte x = 60;
    static final byte y = 70;
    static final byte z = 71;
    static final byte aa = 80;
    static final byte ab = 90;
    static final byte ac = 100;

    BaseSSLSocketImpl() {
        this.a = this;
    }

    BaseSSLSocketImpl(Socket socket) {
        this.a = socket;
    }

    static String b(byte by) {
        switch (by) {
            case 0: {
                return "close_notify";
            }
            case 10: {
                return "unexpected_message";
            }
            case 20: {
                return "bad_record_mac";
            }
            case 21: {
                return "decryption_failed";
            }
            case 22: {
                return "record_overflow";
            }
            case 30: {
                return "decompression_failure";
            }
            case 40: {
                return "handshake_failure";
            }
            case 41: {
                return "no_certificate";
            }
            case 42: {
                return "bad_certificate";
            }
            case 43: {
                return "unsupported_certificate";
            }
            case 44: {
                return "certificate_revoked";
            }
            case 45: {
                return "certificate_expired";
            }
            case 46: {
                return "certificate_unknown";
            }
            case 47: {
                return "illegal_parameter";
            }
            case 48: {
                return "unknown_ca";
            }
            case 49: {
                return "access_denied";
            }
            case 50: {
                return "decode_error";
            }
            case 51: {
                return "decrypt_error";
            }
            case 60: {
                return "export_restriction";
            }
            case 70: {
                return "protocol_version";
            }
            case 71: {
                return "insufficient_security";
            }
            case 80: {
                return "internal_error";
            }
            case 90: {
                return "user_canceled";
            }
            case 100: {
                return "no_negotiation";
            }
        }
        return "<UNKNOWN ALERT: " + (by & 0xFF) + ">";
    }

    static SSLException b(byte by, String string) {
        return BaseSSLSocketImpl.a(by, null, string);
    }

    static SSLException a(byte by, Throwable throwable, String string) {
        SSLException sSLException;
        if (string == null) {
            string = throwable != null ? throwable.toString() : "";
        }
        switch (by) {
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 51: 
            case 60: 
            case 71: {
                sSLException = new SSLHandshakeException(string);
                break;
            }
            default: {
                sSLException = new SSLException(string);
            }
        }
        if (throwable != null) {
            sSLException.initCause(throwable);
        }
        return sSLException;
    }

    public final SocketChannel getChannel() {
        if (this.a == this) {
            return super.getChannel();
        }
        return this.a.getChannel();
    }

    public final void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    public final boolean isConnected() {
        if (this.a == this) {
            return super.isConnected();
        }
        return this.a.isConnected();
    }

    public final boolean isBound() {
        if (this.a == this) {
            return super.isBound();
        }
        return this.a.isBound();
    }

    public final void shutdownInput() throws IOException {
        throw new UnsupportedOperationException("The method shutdownInput() is not supported in SSLSocket");
    }

    public final void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException("The method shutdownOutput() is not supported in SSLSocket");
    }

    public final boolean isInputShutdown() {
        if (this.a == this) {
            return super.isInputShutdown();
        }
        return this.a.isInputShutdown();
    }

    public final boolean isOutputShutdown() {
        if (this.a == this) {
            return super.isOutputShutdown();
        }
        return this.a.isOutputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void finalize() throws Throwable {
        try {
            try {
                this.close();
            }
            catch (IOException iOException) {
                try {
                    if (this.a == this) {
                        super.close();
                    }
                }
                catch (IOException iOException2) {
                }
                Object var4_2 = null;
                super.finalize();
                return;
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public final InetAddress getInetAddress() {
        if (this.a == this) {
            return super.getInetAddress();
        }
        return this.a.getInetAddress();
    }

    public final InetAddress getLocalAddress() {
        if (this.a == this) {
            return super.getLocalAddress();
        }
        return this.a.getLocalAddress();
    }

    public final int getPort() {
        if (this.a == this) {
            return super.getPort();
        }
        return this.a.getPort();
    }

    public final int getLocalPort() {
        if (this.a == this) {
            return super.getLocalPort();
        }
        return this.a.getLocalPort();
    }

    public final void setTcpNoDelay(boolean bl) throws SocketException {
        if (this.a == this) {
            super.setTcpNoDelay(bl);
        } else {
            this.a.setTcpNoDelay(bl);
        }
    }

    public final boolean getTcpNoDelay() throws SocketException {
        if (this.a == this) {
            return super.getTcpNoDelay();
        }
        return this.a.getTcpNoDelay();
    }

    public final void setSoLinger(boolean bl, int n) throws SocketException {
        if (this.a == this) {
            super.setSoLinger(bl, n);
        } else {
            this.a.setSoLinger(bl, n);
        }
    }

    public final int getSoLinger() throws SocketException {
        if (this.a == this) {
            return super.getSoLinger();
        }
        return this.a.getSoLinger();
    }

    public final void sendUrgentData(int n) throws SocketException {
        throw new SocketException("This method is not supported by SSLSockets");
    }

    public final void setOOBInline(boolean bl) throws SocketException {
        throw new SocketException("This method is ineffective, since sending urgent data is not supported by SSLSockets");
    }

    public final boolean getOOBInline() throws SocketException {
        throw new SocketException("This method is ineffective, since sending urgent data is not supported by SSLSockets");
    }

    public final int getSoTimeout() throws SocketException {
        if (this.a == this) {
            return super.getSoTimeout();
        }
        return this.a.getSoTimeout();
    }

    public final void setSendBufferSize(int n) throws SocketException {
        if (this.a == this) {
            super.setSendBufferSize(n);
        } else {
            this.a.setSendBufferSize(n);
        }
    }

    public final int getSendBufferSize() throws SocketException {
        if (this.a == this) {
            return super.getSendBufferSize();
        }
        return this.a.getSendBufferSize();
    }

    public final void setReceiveBufferSize(int n) throws SocketException {
        if (this.a == this) {
            super.setReceiveBufferSize(n);
        } else {
            this.a.setReceiveBufferSize(n);
        }
    }

    public final int getReceiveBufferSize() throws SocketException {
        if (this.a == this) {
            return super.getReceiveBufferSize();
        }
        return this.a.getReceiveBufferSize();
    }

    public final void setKeepAlive(boolean bl) throws SocketException {
        if (this.a == this) {
            super.setKeepAlive(bl);
        } else {
            this.a.setKeepAlive(bl);
        }
    }

    public final boolean getKeepAlive() throws SocketException {
        if (this.a == this) {
            return super.getKeepAlive();
        }
        return this.a.getKeepAlive();
    }

    public final void setTrafficClass(int n) throws SocketException {
        if (this.a == this) {
            super.setTrafficClass(n);
        } else {
            this.a.setTrafficClass(n);
        }
    }

    public final int getTrafficClass() throws SocketException {
        if (this.a == this) {
            return super.getTrafficClass();
        }
        return this.a.getTrafficClass();
    }

    public final void setReuseAddress(boolean bl) throws SocketException {
        if (this.a == this) {
            super.setReuseAddress(bl);
        } else {
            this.a.setReuseAddress(bl);
        }
    }

    public final boolean getReuseAddress() throws SocketException {
        if (this.a == this) {
            return super.getReuseAddress();
        }
        return this.a.getReuseAddress();
    }
}

