; asmsyntax=nasm
;
; theme-zh.asm
;
; Chinese theme data for Smart Boot Manager
;
; Copyright (C) 2000, Suzhe. See file COPYING for details.
;

; some constant used in this theme.

; PLEASE DO NOT CHANGE THESE, UNLESS YOU KNOW WHAT YOU ARE DOING!
%define SBMT_MAGIC      0x544D4253         ; magic number of
                                           ; Smart Boot Manager theme.
%define SBMT_VERSION    0x0307             ; version of theme.

        bits 16

%ifndef MAIN
        org 0                       ; DO NOT REMOVE/MODIFY THIS LINE!!!
%endif

start_of_theme:

;!!! PLEASE DON NOT CHANGE THE SIZE AND ORDER OF FOLLOWING DATA !!!

;=============================================================================
;the header of Smart Boot Manager theme ( 16 bytes )
;=============================================================================
theme_magic         dd  SBMT_MAGIC ; magic number = 'SBMT', 4 bytes.
                                   ; it's abbr. of 'Smart Boot Manager Theme'
                    dw  0          ;
theme_lang          db  'zh-CN',0  ; language of this theme, 6 bytes.
theme_version       dw  SBMT_VERSION ; version, high byte is major version,
                                   ; low byte is minor version. should be
                                   ; equal to the version of Smart Boot Manager.
theme_size          dw  (end_of_theme - start_of_theme)
                                   ; size of the theme (bytes).

;=============================================================================
; fix size data and index tables of variable size data
;=============================================================================

video_mode          db  0          ; 0 = 90x25, 0xff = 80x25
                                   ; do not use other value!!!

keyboard_type       db 0x10        ; = 0x10 means use enhanced keyboard
                                   ; = 0x00 means use normal keyboard
                                   ; CAUTION: cannot use other value!!!

show_date_method    db  2          ; the method of show date:
                                   ; 0 = don't show date
                                   ; 1 = week mm-dd-yyyy
                                   ; 2 = week yyyy-mm-dd
                                   ; 3 = week dd-mm-yyyy

show_time_method    db  1          ; the method of show time:
                                   ; 0 = don't show time
                                   ; 1 = hh:mm (24 hours)

yes_key_lower       db  'y'
yes_key_upper       db  'Y'
 
; position of screen elements
position:
.main_win_col       db  19         ; start column of main window
.main_win_row       db  6          ; start row of main window
.brand_col          db  255        ; start column of brand icon
                                   ; if = 255 then brand will be
                                   ; right justified in the screen.
.brand_row          db  0          ; start row of brand icon

.cmd_menu_col       db  1          ; the position of command menu.
.cmd_menu_row       db  1          ;

.date_col           db  64
.date_row           db  0

.time_col           db  80
.time_row           db  0

; size of screen elements
size:
.copyright          db  1          ; number of rows used by copyright info
.hint               db  1          ; number of rows used by hint info
.box_width          db  5          ; the minimal width of info/error/input box
                                   ; (when no info string)
.box_height         db  3          ; the minimal height of info/error/input box
                                   ; (when no info string)
.main_win_height    db  12         ; the height of main window
.bootmenu_height    db  8          ; the height of boot menu area

;Black          = 0
;Blue           = 1
;Green          = 2
;Cyan           = 3
;Red            = 4
;Violet         = 5
;Yellow (brown) = 6
;White          = 7
;Black (gray)   = 8
;Intense blue   = 9
;Intense green  = a
;Intense cyan   = b
;Intense red    = c
;Intense violet = d
;Intense yellow = e
;Intense white  = f

; color of screen elements
; high 4 bits is background color, low 4 bits is foreground color

color:
.main_win_frame     db  0x3F        ; main window
.main_win_title     db  0xF1        ;
.menu_title         db  0x1F        ;
.menu_normal        db  0x70        ; boot menu
.menu_focus         db  0x0F        ;
.scrollbar          db  0x3F        ; scroll bar
.delay_time         db  0x70        ; delay time
.background         db  0x80        ; background (if no background icon)
.copyright          db  0x70        ; copyright string
.copyright_hl       db  0x74        ; high lighted copyright string
.hint               db  0x70        ; hint string
.hint_hl            db  0x74        ; high lighted hint string
.knl_flags          db  0x7C        ; the color of kernal fags. 
.knl_drvid          db  0x70        ; the color of kernel drive id.
.date               db  0x70        ; color of date string
.time               db  0x70        ; color of time string
.input_box_frame    db  0xF1        ;
.input_box_title    db  0x1F        ; input box
.input_box_msg      db  0xF0        ;
.error_box_frame    db  0xCF        ;
.error_box_title    db  0xF1        ; error box
.error_box_msg      db  0xCF        ;
.info_box_frame     db  0xF1        ;
.info_box_title     db  0x1F        ; info box
.info_box_msg       db  0xF0        ;
.help_win_frame     db  0x3F        ;
.help_win_title     db  0xF1        ; help window
.help_msg           db  0x30        ;
.about_win_frame    db  0x3F        ;
.about_win_title    db  0xF1        ; about window
.about_msg          db  0x3E        ;

.cmd_menu_winframe  db  0x3F        ;
.cmd_menu_wintitle  db  0xF1        ; the colors used 
.cmd_menu_normal    db  0x30        ; in command menu
.cmd_menu_normal_hl db  0x3C        ; 
.cmd_menu_focus     db  0x07        ;
.cmd_menu_focus_hl  db  0x0C        ;

; icon data
icon:
.brand_size         dw  0x0104              ; the size of brand icon,
                                            ; high byte = row, low byte = col.
.brand              dw  icon_data.brand     ; offset of brand icon data, set to
                                            ; zero if no brand icon.

.background_size    dw  0                   ; the size of background icon,
                                            ; high byte = row, low byte = col.
.background         dw  0                   ; offset of background icon data,
                                            ; set to zero if no background icon.

; font data
font:
.number             dw  (font_data.end-font_data)/17
                                            ; number of chars to be replaced,
.data               dw  font_data           ; offset of font set data, set to
                                            ; zero if no font to be replaced.


; chars used by window frame
frame_char:
.top                db     0x20            ; top horizontal
.bottom             db     253            ; bottom horiztontal
.left               db     251            ; left vertical
.right              db     252            ; right vertical
.tl_corner          db     0x20            ; top left corner
.tr_corner          db     0x20            ; top right corner
.bl_corner          db     254            ; bottom left corner
.br_corner          db     255            ; bottom right corner

; how to draw window frame
draw_frame_method   db  2          ; = 0 means draw all frame using frame attr.
                                   ; = 1 means draw top horizontal line using
                                   ;     title attr.
                                   ; = 2 means draw top corners and horizontal
                                   ;     line using title attr.


; keymap data
keymap:                                  ; entry of keymap
.number             dw  (keymap_data.end-keymap_data)/4
                                           ; number of keymap entries
.data               dw  keymap_data      ; pointer to keymap


; index table of strings
str_idx:
.main_win_title     dw  string.main_win_title
.menu_title         dw  string.menu_title
.about              dw  string.about
.error              dw  string.error
.help               dw  string.help
.info               dw  string.info
.input              dw  string.input

.delay_time         dw  string.delay_time
.name               dw  string.name
.new_root_passwd    dw  string.new_root_passwd
.root_passwd        dw  string.root_passwd
.new_record_passwd  dw  string.new_record_passwd
.record_passwd      dw  string.record_passwd
.retype_passwd      dw  string.retype_passwd
.input_schedule     dw  string.input_schedule
.input_keystrokes   dw  string.input_keystrokes
.key_count          dw  string.key_count
.io_port            dw  string.io_port
.year               dw  string.year

.drive_id           dw  string.drive_id
.part_id            dw  string.part_id
.record_type        dw  string.record_type
.record_name        dw  string.record_name
.auto_active        dw  string.auto_active
.active             dw  string.active
.auto_hide          dw  string.auto_hide
.hidden             dw  string.hidden
.swap_drv           dw  string.swap_drv
.logical            dw  string.logical
.key_strokes        dw  string.key_strokes
.password           dw  string.password
.schedule           dw  string.schedule
.yes                dw  string.yes
.no                 dw  string.no

.copyright          dw  string.copyright
.hint               dw  string.hint
.about_content      dw  string.about_content
.help_content       dw  string.help_content

.changes_saved      dw  string.changes_saved
.passwd_changed     dw  string.passwd_changed
.ask_save_changes   dw  string.ask_save_changes

.wrong_passwd       dw  string.wrong_passwd
.disk_error         dw  string.disk_error
.mark_act_failed    dw  string.mark_act_failed
.toggle_hid_failed  dw  string.toggle_hid_failed
.no_system          dw  string.no_system
.invalid_record     dw  string.invalid_record
.invalid_schedule   dw  string.invalid_schedule
.inst_confirm       dw  string.inst_confirm
.inst_ok            dw  string.inst_ok
.inst_abort         dw  string.inst_abort
.uninst_confirm     dw  string.uninst_confirm
.uninst_ok          dw  string.uninst_ok
.uninst_abort       dw  string.uninst_abort
.confirm            dw  string.confirm
.no_sbml            dw  string.no_sbml
.invalid_ioports    dw  string.invalid_ioports

; command menu str_idx
; main menu
.main_menu_title    dw  string.main_mnu_title
.main_menu_strings:
                    dw string.main_mnu_help
                    dw string.main_mnu_about
                    dw string.main_mnu_save
                    dw string.main_mnu_bootit
                    dw string.main_mnu_bootprev
                    dw string.main_mnu_bar
                    dw string.main_mnu_recordset
                    dw string.main_mnu_sysset
                    dw string.main_mnu_bar
                    dw string.main_mnu_quit
                    dw string.main_mnu_poweroff

; record settings menu
.record_menu_title  dw string.record_mnu_title
.record_menu_strings:
                    dw string.record_mnu_info
                    dw string.record_mnu_name
                    dw string.record_mnu_passwd
                    dw string.record_mnu_schedule
                    dw string.record_mnu_keys
                    dw string.record_mnu_bar
                    dw string.record_mnu_act
                    dw string.record_mnu_hide
                    dw string.record_mnu_autoact
                    dw string.record_mnu_autohide
                    dw string.record_mnu_swapdrv
                    dw string.record_mnu_bar
                    dw string.record_mnu_del
                    dw string.record_mnu_dup
                    dw string.record_mnu_moveup
                    dw string.record_mnu_movedown

; system setting menu
.sys_menu_title     dw string.sys_mnu_title
.sys_menu_strings:
                    dw string.sys_mnu_rootpasswd
                    dw string.sys_mnu_admin
                    dw string.sys_mnu_security
                    dw string.sys_mnu_bar
                    dw string.sys_mnu_setdef
                    dw string.sys_mnu_unsetdef
                    dw string.sys_mnu_delay
                    dw string.sys_mnu_bmstyle
                    dw string.sys_mnu_remlast
                    dw string.sys_mnu_int13ext
                    dw string.sys_mnu_bar
                    dw string.sys_mnu_rescanall
                    dw string.sys_mnu_rescanpart
                    dw string.sys_mnu_set_ioports
                    dw string.sys_mnu_set_y2kfix
                    dw string.sys_mnu_bar
                    dw string.sys_mnu_inst
                    dw string.sys_mnu_uninst

.cdimg_menu_title   dw string.cdimg_mnu_title
.cdimg_menu_strings dw string.cdimg_mnu_noemu
                    dw string.cdimg_mnu_120m
                    dw string.cdimg_mnu_144m
                    dw string.cdimg_mnu_288m

.sunday             dw string.sunday
.monday             dw string.monday
.tuesday            dw string.tuesday
.wednesday          dw string.wednesday
.thursday           dw string.thursday
.friday             dw string.friday
.saturday           dw string.saturday

end_of_str_idx:

end_of_checksum_area:                   ; DO NOT REMOVE THIS LINE!!!
;=============================================================================
; variable size data
;=============================================================================

; icon data

; two bytes corresponding to a char,
; high byte is color, low byte is char code.
icon_data:
.brand:
db  247, 0x7C, 248, 0x7C, 249, 0x7C, 250, 0x7C

.background:

;
; font data
; each char occupied 17 bytes
; the first bytes is the ascii code used by this char
; the following 16 bytes is font data
;
; NOTE:
;   Do not replace ascii char 0, 0x0d, 0x1e and 0x1f, 
;   these chars have special use.
;

font_data:

  db 1      ;-1, count:9
  db 0x01,0x00,0x1F,0x10,0x10,0x10,0x1F,0x10,0x10,0x10,0x17,0x24,0x24,0x44,0x87,0x04
  db 2      ;-2
  db 0x00,0x84,0xFE,0x04,0x04,0x04,0xFC,0x00,0x00,0x04,0xFE,0x04,0x04,0x04,0xFC,0x04

  db 3      ;-1, count:18
  db 0x00,0x00,0x7C,0x00,0x01,0xFE,0x10,0x10,0x20,0x24,0x42,0xFE,0x42,0x01,0x02,0x04
  db 4      ;-2
  db 0x40,0x40,0x40,0x44,0xFE,0x44,0x44,0x44,0x44,0x44,0x84,0x84,0x84,0x04,0x28,0x10

  db 5      ;-1, count:4
  db 0x04,0x04,0xFF,0x04,0x00,0x3F,0x12,0x09,0x01,0xFF,0x03,0x05,0x09,0x11,0x61,0x01
  db 6      ;-2
  db 0x40,0x44,0xFE,0x40,0x38,0xC0,0x10,0x20,0x04,0xFE,0x80,0x40,0x30,0x0E,0x04,0x00

  db 7      ;-1, count:4
  db 0x10,0x08,0x04,0x3F,0x21,0x21,0x3F,0x21,0x21,0x3F,0x21,0x01,0xFF,0x01,0x01,0x01
  db 8      ;-2
  db 0x10,0x20,0x40,0xF8,0x08,0x08,0xF8,0x08,0x08,0xF8,0x00,0x04,0xFE,0x00,0x00,0x00

  db 9      ;-1, count:1
  db 0x10,0x10,0x13,0x10,0xFC,0x10,0x37,0x38,0x54,0x51,0x91,0x12,0x14,0x10,0x11,0x10
  db 10      ;-2
  db 0x00,0x10,0xF8,0x00,0x00,0x04,0xFE,0x40,0x40,0x50,0x48,0x44,0x44,0x40,0x40,0x80

  db 11      ;־-1, count:1
  db 0x01,0x01,0x01,0xFF,0x01,0x01,0x01,0x3F,0x00,0x02,0x11,0x50,0x50,0x90,0x0F,0x00
  db 12      ;־-2
  db 0x00,0x00,0x04,0xFE,0x00,0x00,0x00,0xFC,0x00,0x00,0x80,0x84,0x12,0x12,0xF0,0x00

  db 14      ;-1, count:3
  db 0x10,0x10,0x23,0x22,0x4A,0xFB,0x12,0x22,0x43,0xF6,0x4A,0x03,0x1A,0xE2,0x42,0x02
  db 15      ;-2
  db 0x80,0x48,0xFC,0x08,0x08,0xF8,0x00,0x00,0xFC,0x94,0x94,0xFC,0x94,0x94,0x94,0x0C

  db 16      ;-1, count:3
  db 0x00,0x1F,0x10,0x10,0x10,0x1F,0x00,0xFF,0x04,0x08,0x1F,0x00,0x00,0x00,0x00,0x00
  db 17      ;-2
  db 0x10,0xF8,0x10,0x10,0x10,0xF0,0x04,0xFE,0x00,0x00,0xF0,0x10,0x10,0x10,0xA0,0x40

  db 18      ;-1, count:2
  db 0x01,0x11,0x09,0x01,0x7F,0x01,0x05,0x09,0x11,0x01,0xFF,0x02,0x04,0x08,0x10,0x60
  db 19      ;-2
  db 0x00,0x10,0x20,0x08,0xFC,0x00,0x40,0x30,0x10,0x00,0xFE,0x80,0x40,0x20,0x1C,0x08

  db 20      ;-1, count:2
  db 0x00,0x7F,0x12,0x12,0x12,0xFF,0x12,0x12,0x12,0x23,0x41,0x7F,0x01,0x01,0xFF,0x00
  db 21      ;-2
  db 0x04,0x84,0x24,0x24,0x24,0xA4,0x24,0x24,0x04,0x14,0x08,0xFC,0x00,0x04,0xFE,0x00

  db 22      ;-1, count:6
  db 0x02,0x02,0x07,0x04,0x0C,0x12,0x01,0x06,0x18,0xE0,0x0F,0x08,0x08,0x08,0x0F,0x08
  db 23      ;-2
  db 0x00,0x10,0xF8,0x10,0x20,0x40,0x80,0x00,0x00,0x08,0xFC,0x08,0x08,0x08,0xF8,0x08

  db 24      ;-1, count:6
  db 0x04,0x0E,0x78,0x08,0x08,0xFE,0x09,0x1C,0x1A,0x28,0x29,0x49,0x8A,0x08,0x08,0x08
  db 25      ;-2
  db 0x40,0x40,0x40,0x84,0xFE,0x84,0x28,0x20,0xA8,0xA4,0x22,0x22,0x20,0x20,0xA0,0x40

  db 26      ;-1, count:8
  db 0x10,0x10,0x10,0x1D,0x20,0x20,0x7B,0x90,0x11,0x7D,0x11,0x11,0x15,0x19,0x11,0x01
  db 27      ;-2
  db 0x90,0x90,0x90,0xFC,0x90,0x90,0xFE,0x00,0xF8,0x08,0x08,0xF8,0x08,0x08,0xF8,0x08

  db 28      ;-1, count:8
  db 0x00,0x43,0x32,0x12,0x03,0x00,0xE0,0x27,0x20,0x20,0x2F,0x20,0x28,0x31,0x22,0x04
  db 29      ;-2
  db 0x08,0xFC,0x08,0x08,0xF8,0x00,0x08,0xFC,0x40,0x44,0xFE,0xA0,0xA0,0x10,0x0E,0x04

  db 128      ;-1, count:2
  db 0x08,0x08,0x0F,0x10,0x10,0x33,0x30,0x50,0x93,0x10,0x10,0x13,0x12,0x12,0x12,0x13
  db 129      ;-2
  db 0x80,0x44,0xFE,0x00,0x08,0xFC,0x00,0x08,0xFC,0x00,0x08,0xFC,0x08,0x08,0x08,0xF8

  db 130      ;Ϣ-1, count:2
  db 0x02,0x1F,0x10,0x10,0x1F,0x10,0x10,0x1F,0x10,0x10,0x1F,0x02,0x51,0x50,0x90,0x0F
  db 131      ;Ϣ-2
  db 0x00,0xF0,0x10,0x10,0xF0,0x10,0x10,0xF0,0x10,0x10,0xF0,0x00,0x84,0x92,0x12,0xF0

  db 132      ;-1, count:2
  db 0x20,0x20,0x20,0xFD,0x22,0x45,0x50,0x93,0xFA,0x13,0x3A,0xD3,0x12,0x12,0x12,0x12
  db 133      ;-2
  db 0x40,0xA0,0xA0,0x10,0x0E,0xF4,0x00,0xC4,0x54,0xD4,0x54,0xD4,0x54,0x44,0x44,0xCC

  db 134      ;-1, count:2
  db 0x04,0x02,0x01,0x01,0x01,0x02,0x02,0x02,0x04,0x04,0x08,0x08,0x10,0x20,0x40,0x80
  db 135      ;-2
  db 0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x40,0x40,0x20,0x20,0x10,0x10,0x0E,0x04

  db 136      ;-1, count:2
  db 0x00,0x00,0x7D,0x04,0x08,0x11,0x21,0x7D,0x05,0x05,0x49,0x29,0x10,0x28,0x47,0x80
  db 137      ;-2
  db 0x08,0x1C,0xE0,0x20,0x20,0x20,0x3C,0x20,0x20,0x20,0x20,0xFC,0x00,0x00,0xFE,0x00

  db 138      ;ʱ-1, count:2
  db 0x00,0x04,0x7E,0x44,0x47,0x44,0x44,0x7C,0x44,0x44,0x44,0x44,0x7C,0x44,0x00,0x00
  db 139      ;ʱ-2
  db 0x08,0x08,0x08,0x08,0xFE,0x08,0x08,0x88,0x48,0x48,0x08,0x08,0x08,0x48,0x28,0x10

  db 140      ;-1, count:2
  db 0x10,0x08,0x7F,0x00,0x22,0x14,0xFF,0x08,0x7F,0x08,0x0A,0x29,0x48,0x88,0x29,0x10
  db 141      ;-2
  db 0x00,0x0C,0x70,0x40,0x40,0x40,0x7E,0x48,0x48,0x48,0x48,0x48,0x88,0x88,0x08,0x08

  db 142      ;-1, count:3
  db 0x10,0x1F,0x28,0x45,0x01,0x7F,0x40,0x9F,0x10,0x1F,0x10,0x1F,0x10,0x10,0x1F,0x10
  db 143      ;-2
  db 0x40,0x7C,0x90,0x08,0x00,0xFE,0x02,0xE4,0x20,0xE0,0x00,0xF0,0x10,0x10,0xF0,0x00

  db 144      ;-1, count:3
  db 0x00,0x13,0xFA,0x22,0x23,0x22,0xFA,0x23,0x20,0x20,0x23,0x3C,0xE0,0x40,0x0F,0x00
  db 145      ;-2
  db 0x08,0xFC,0x48,0x48,0xF8,0x48,0x48,0xF8,0x40,0x40,0xF8,0x40,0x40,0x44,0xFE,0x00

  db 146      ;-1, count:8
  db 0x00,0x00,0x3F,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3F,0x20,0x00,0x00
  db 147      ;-2
  db 0x00,0x08,0xFC,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0xF8,0x08,0x00,0x00

  db 148      ;-1, count:8
  db 0x01,0x01,0x02,0x04,0x0A,0x11,0x21,0xC0,0x1F,0x00,0x00,0x04,0x02,0x01,0x00,0x00
  db 149      ;-2
  db 0x00,0x00,0x80,0x40,0x20,0x10,0x0E,0x04,0xF0,0x10,0x20,0x40,0x80,0x00,0x80,0x80

  db 150      ;-1, count:9
  db 0x00,0x20,0x17,0x10,0x00,0x00,0xF0,0x13,0x12,0x12,0x12,0x12,0x16,0x1A,0x11,0x00
  db 151      ;-2
  db 0x00,0x08,0xFC,0x08,0x08,0x08,0x08,0xF8,0x08,0x00,0x00,0x02,0x02,0x02,0xFE,0x00

  db 152      ;¼-1, count:9
  db 0x00,0x3F,0x00,0x00,0x1F,0x00,0x00,0xFF,0x01,0x11,0x09,0x05,0x09,0x11,0x65,0x02
  db 153      ;¼-2
  db 0x10,0xF8,0x10,0x10,0xF0,0x10,0x10,0xFE,0x08,0x10,0xA0,0x40,0x20,0x1E,0x04,0x00

  db 154      ;ȷ-1, count:5
  db 0x00,0x04,0xFE,0x10,0x11,0x23,0x25,0x7D,0xA5,0x25,0x25,0x25,0x25,0x3D,0x22,0x04
  db 155      ;ȷ-2
  db 0x40,0x40,0x78,0x90,0x20,0xFC,0x24,0x24,0xFC,0x24,0x24,0xFC,0x24,0x24,0x24,0x0C

  db 156      ;-1, count:5
  db 0x00,0x40,0x30,0x10,0x00,0x00,0xF0,0x10,0x10,0x11,0x11,0x15,0x1A,0x12,0x04,0x08
  db 157      ;-2
  db 0x40,0x40,0x40,0x40,0x40,0x40,0xA0,0xA0,0xA0,0x10,0x10,0x10,0x08,0x08,0x06,0x04

  db 158      ;-1, count:5
  db 0x00,0x1F,0x10,0x10,0x10,0x10,0x10,0x1F,0x10,0x10,0x10,0x10,0x10,0x1F,0x10,0x00
  db 159      ;-2
  db 0x10,0xF8,0x10,0x10,0x10,0x10,0x10,0xF0,0x10,0x10,0x10,0x10,0x10,0xF0,0x10,0x00

  db 160      ;-1, count:4
  db 0x08,0x1D,0xF1,0x11,0x11,0xFD,0x11,0x38,0x35,0x54,0x50,0x91,0x10,0x10,0x17,0x10
  db 161      ;-2
  db 0x04,0xFE,0x04,0x04,0x04,0xFC,0x04,0x00,0xFC,0x20,0x20,0xFC,0x20,0x20,0xFE,0x00

  db 162      ;-1, count:6
  db 0x10,0x10,0x10,0x13,0xFA,0x14,0x10,0x1B,0x30,0xD0,0x11,0x10,0x10,0x10,0x50,0x23
  db 163      ;-2
  db 0x40,0x20,0x00,0xFE,0x02,0x44,0x40,0xFE,0x88,0x88,0x10,0x90,0x60,0x50,0x8C,0x04

  db 164      ;-1, count:5
  db 0x20,0x27,0x39,0x41,0x82,0x7A,0x24,0x27,0xF9,0x21,0x25,0x22,0x2A,0x35,0x28,0x00
  db 165      ;-2
  db 0x10,0x10,0x7C,0x14,0xFE,0x14,0x7C,0x10,0x7C,0x10,0x10,0xFE,0x10,0x10,0x90,0x7E

  db 166      ;-1, count:5
  db 0x08,0xFD,0x09,0x49,0x49,0x49,0x49,0x49,0x7D,0x05,0x05,0x1D,0xE5,0x45,0x15,0x08
  db 167      ;-2
  db 0x04,0xFE,0x00,0x44,0x44,0x28,0x28,0x10,0x10,0x28,0x28,0x44,0x84,0x00,0xFE,0x00

  db 168      ;-1, count:5
  db 0x3E,0x22,0x22,0x22,0x3E,0x01,0x01,0xFF,0x02,0x0C,0x30,0xFE,0x22,0x22,0x22,0x3E
  db 169      ;-2
  db 0xF8,0x88,0x88,0x88,0xF8,0x20,0x10,0xFE,0x80,0x60,0x18,0xFE,0x88,0x88,0x88,0xF8

  db 170      ;-1, count:1
  db 0x00,0x04,0x04,0x08,0x08,0x10,0x20,0x5F,0x84,0x04,0x04,0x04,0x08,0x08,0x11,0x20
  db 171      ;-2
  db 0x80,0x80,0x40,0x40,0x20,0x10,0x08,0xEE,0x24,0x20,0x20,0x20,0x20,0x20,0x40,0x80

  db 172      ;-1, count:1
  db 0x00,0x3F,0x20,0x28,0x24,0x22,0x21,0x20,0x21,0x22,0x24,0x28,0x20,0x20,0x3F,0x00
  db 173      ;-2
  db 0x08,0xFC,0x00,0x08,0x18,0x20,0x40,0x80,0x40,0x30,0x18,0x08,0x00,0x04,0xFE,0x00

  db 174      ;-1, count:4
  db 0x01,0x02,0x04,0x1F,0x10,0x10,0x10,0x1F,0x10,0x10,0x1F,0x10,0x10,0x10,0x1F,0x10
  db 175      ;-2
  db 0x00,0x00,0x10,0xF8,0x10,0x10,0x10,0xF0,0x10,0x10,0xF0,0x10,0x10,0x10,0xF0,0x10

  db 176      ;-1, count:7
  db 0x02,0x44,0x2F,0x28,0x0F,0x88,0x4F,0x42,0x1F,0x24,0xC7,0x44,0x44,0x48,0x4B,0x50
  db 177      ;-2
  db 0x10,0x10,0x90,0x90,0xBE,0xC4,0xA4,0x28,0xA8,0x28,0x90,0x90,0xA8,0xA8,0x46,0x84

  db 178      ;-1, count:7
  db 0x40,0x30,0x17,0x00,0x80,0x60,0x2F,0x08,0x10,0x10,0x23,0x62,0x22,0x22,0x23,0x22
  db 179      ;-2
  db 0x10,0x38,0xC0,0x40,0x40,0x44,0xFE,0x40,0x40,0x48,0xFC,0x08,0x08,0x08,0xF8,0x08

  db 180      ;-1, count:8
  db 0x00,0x78,0x48,0x51,0x52,0x67,0x50,0x4B,0x48,0x4B,0x68,0x52,0x42,0x46,0x4A,0x41
  db 181      ;-2
  db 0x80,0x90,0xF8,0x10,0x20,0xFC,0x04,0xFC,0x04,0xFC,0x04,0x80,0x64,0x2A,0x08,0xF8

  db 182      ;-1, count:8
  db 0x04,0xFF,0x04,0x04,0x5F,0x50,0x57,0x75,0x17,0x74,0x57,0x55,0x95,0x27,0x44,0x80
  db 183      ;-2
  db 0x84,0xFE,0xA8,0xA4,0xFE,0x20,0xA0,0x24,0xA4,0xA4,0xA8,0x28,0x10,0xB2,0x4A,0x86

  db 184      ;-1, count:2
  db 0x02,0x01,0x01,0xFF,0x08,0x08,0x10,0x28,0x44,0x02,0x01,0x02,0x04,0x08,0x30,0xC0
  db 185      ;-2
  db 0x00,0x00,0x04,0xFE,0x20,0x10,0x0C,0x24,0x40,0x80,0x00,0x80,0x40,0x30,0x0E,0x04

  db 186      ;-1, count:2
  db 0x10,0x10,0x11,0x12,0xFC,0x13,0x12,0x1E,0x32,0xD2,0x1F,0x10,0x10,0x11,0x52,0x2C
  db 187      ;-2
  db 0x80,0x80,0xF0,0x20,0x40,0xF8,0x48,0x48,0x48,0x48,0xFE,0x40,0xA0,0x10,0x0E,0x04

  db 188      ;-1, count:1
  db 0x00,0x4F,0x29,0x29,0x0F,0x08,0xE1,0x23,0x26,0x29,0x20,0x20,0x27,0x50,0x8F,0x00
  db 189      ;-2
  db 0x04,0xFE,0x24,0x24,0xFC,0x84,0x00,0xF8,0x08,0x10,0xA0,0xC0,0x00,0x00,0xFE,0x00

  db 190      ;-1, count:1
  db 0x10,0x11,0x11,0xFD,0x21,0x28,0x4B,0x7D,0x09,0x09,0x0F,0xF9,0x49,0x0F,0x08,0x08
  db 191      ;-2
  db 0x08,0xFC,0x08,0x08,0xF8,0x00,0xFE,0x08,0xF8,0x08,0xF8,0x08,0x08,0xFE,0x08,0x08

  db 192      ;-1, count:6
  db 0x08,0x0B,0x0A,0x12,0x12,0x33,0x32,0x50,0x9F,0x10,0x10,0x11,0x12,0x14,0x18,0x10
  db 193      ;-2
  db 0x08,0xFC,0x08,0x08,0x08,0xF8,0x40,0x44,0xFE,0x40,0xE0,0x50,0x48,0x4E,0x44,0x40

  db 194      ;-1, count:6
  db 0x02,0x02,0xFF,0x04,0x08,0x0B,0x10,0x10,0x30,0x5F,0x90,0x10,0x10,0x10,0x11,0x10
  db 195      ;-2
  db 0x00,0x04,0xFE,0x00,0x00,0xF8,0x10,0x20,0x44,0xFE,0x40,0x40,0x40,0x40,0x40,0x80

  db 196      ;-1, count:10
  db 0x01,0x21,0x11,0x11,0x01,0x02,0xF4,0x13,0x11,0x11,0x10,0x10,0x14,0x18,0x13,0x0C
  db 197      ;-2
  db 0xF0,0x10,0x10,0x10,0x10,0x0E,0x00,0xF8,0x08,0x10,0x90,0xA0,0x40,0xB0,0x0E,0x04

  db 198      ;-1, count:10
  db 0x3F,0x24,0x3F,0x01,0x7F,0x01,0x1F,0x10,0x1F,0x10,0x1F,0x10,0x1F,0x10,0xFF,0x00
  db 199      ;-2
  db 0xF8,0x48,0xF8,0x00,0xFC,0x00,0xF0,0x10,0xF0,0x10,0xF0,0x10,0xF0,0x14,0xFE,0x00

  db 200      ;ȡ-1, count:4
  db 0x01,0xFF,0x22,0x23,0x3E,0x22,0x22,0x3E,0x22,0x22,0x22,0x3E,0xE2,0x42,0x03,0x02
  db 201      ;ȡ-2
  db 0x00,0x80,0x00,0xFC,0x04,0x84,0x88,0x88,0x48,0x50,0x20,0x50,0x48,0x8E,0x04,0x00

  db 202      ;-1, count:4
  db 0x00,0x42,0x31,0x11,0x80,0x63,0x22,0x0A,0x13,0x22,0xE2,0x23,0x22,0x22,0x22,0x22
  db 203      ;-2
  db 0x40,0x48,0x50,0x60,0x40,0xF8,0x08,0x08,0xF8,0x08,0x08,0xF8,0x08,0x08,0x28,0x10

  db 204      ;-1, count:5
  db 0x02,0x01,0x3F,0x20,0x42,0x02,0x02,0xFF,0x04,0x08,0x18,0x06,0x01,0x02,0x0C,0x30
  db 205      ;-2
  db 0x00,0x00,0xFC,0x04,0x08,0x00,0x04,0xFE,0x20,0x20,0x40,0x40,0x80,0x40,0x30,0x10

  db 206      ;װ-1, count:4
  db 0x08,0x48,0x2B,0x08,0x18,0x29,0x4A,0x09,0xFF,0x02,0x05,0x0C,0x34,0xC5,0x06,0x04
  db 207      ;װ-2
  db 0x40,0x48,0xFC,0x40,0x40,0xF8,0x00,0x04,0xFE,0x00,0x10,0xA0,0x40,0x30,0x0E,0x04

  db 208      ;-1, count:1
  db 0x01,0x7F,0x08,0x10,0x22,0x41,0x7F,0x08,0x08,0x08,0x7F,0x08,0x08,0x0F,0xF8,0x40
  db 209      ;-2
  db 0x04,0x84,0x04,0x24,0x24,0x24,0xA4,0xA4,0x24,0x24,0x24,0x24,0x04,0x84,0x14,0x08

  db 210      ;ɾ-1, count:5
  db 0x00,0x7B,0x4A,0x4A,0x4A,0x4A,0x4A,0xFF,0x4A,0x4A,0x4A,0x4A,0x4A,0x5A,0x44,0x88
  db 211      ;ɾ-2
  db 0x04,0xC4,0x44,0x54,0x54,0x54,0x54,0xF4,0x54,0x54,0x54,0x54,0x44,0x44,0x54,0xC8

  db 212      ;-1, count:5
  db 0x00,0x78,0x48,0x50,0x51,0x62,0x55,0x48,0x48,0x4F,0x68,0x51,0x42,0x44,0x41,0x40
  db 213      ;-2
  db 0x40,0x40,0xA0,0xA0,0x10,0x08,0xF6,0x40,0x40,0xFC,0x40,0x50,0x4C,0x44,0x40,0x80

  db 214      ;ԭ-1, count:1
  db 0x00,0x3F,0x21,0x22,0x2F,0x28,0x28,0x2F,0x28,0x28,0x2F,0x20,0x44,0x48,0x92,0x01
  db 215      ;ԭ-2
  db 0x04,0xFE,0x00,0x00,0xF8,0x08,0x08,0xF8,0x08,0x08,0xF8,0x80,0x90,0x8C,0x84,0x00

  db 216      ;-1, count:1
  db 0x02,0x02,0xFF,0x04,0x04,0x0F,0x08,0x18,0x2F,0x48,0x88,0x0F,0x08,0x08,0x08,0x08
  db 217      ;-2
  db 0x00,0x04,0xFE,0x00,0x10,0xF8,0x10,0x10,0xF0,0x10,0x10,0xF0,0x10,0x10,0x50,0x20

  db 218      ;ϵ-1, count:2
  db 0x00,0x7F,0x02,0x04,0x08,0x3F,0x01,0x06,0x18,0x3F,0x11,0x01,0x11,0x21,0x45,0x02
  db 219      ;ϵ-2
  db 0x38,0xC0,0x00,0x20,0x40,0x80,0x00,0x20,0x10,0xF8,0x08,0x00,0x10,0x08,0x08,0x00

  db 220      ;ͳ-1, count:2
  db 0x10,0x10,0x20,0x27,0x48,0xF9,0x12,0x27,0x41,0xF9,0x41,0x01,0x1A,0xE2,0x44,0x08
  db 221      ;ͳ-2
  db 0x80,0x40,0x48,0xFC,0x80,0x10,0x08,0xFC,0x24,0x20,0x20,0x20,0x22,0x22,0x1E,0x00

  db 222      ;-1, count:1
  db 0x10,0x1F,0x20,0x2F,0x48,0x8F,0x08,0x0F,0x04,0x0F,0x0C,0x12,0x21,0x43,0x0C,0x30
  db 223      ;-2
  db 0x08,0xFC,0x00,0xF0,0x10,0xF0,0x10,0xF0,0x00,0xF0,0x20,0x40,0x80,0x40,0x30,0x0E

  db 224      ;-1, count:1
  db 0x04,0x24,0x24,0x3F,0x24,0x44,0xFF,0x04,0x04,0x3F,0x24,0x24,0x26,0x25,0x04,0x04
  db 225      ;-2
  db 0x04,0x04,0x04,0xA4,0x24,0x24,0xE4,0x24,0x24,0xA4,0xA4,0x84,0x84,0x04,0x14,0x08

  db 226      ;-1, count:2
  db 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,0x00
  db 227      ;-2
  db 0x00,0x00,0x00,0x00,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0xFE,0x00

  db 228      ;-1, count:2
  db 0x08,0x1C,0xF0,0x11,0x12,0xFC,0x10,0x39,0x34,0x54,0x90,0x11,0x10,0x10,0x10,0x17
  db 229      ;-2
  db 0x40,0x40,0xFC,0x84,0x48,0x30,0x60,0xA0,0x3E,0x42,0xC4,0x24,0x18,0x30,0xC0,0x00

  db 230      ;-1, count:1
  db 0x00,0xFF,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02
  db 231      ;-2
  db 0x04,0xFE,0x00,0x00,0x00,0x80,0x40,0x30,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00

  db 232      ;ģ-1, count:3
  db 0x11,0x11,0x17,0x11,0xFD,0x13,0x32,0x3B,0x56,0x53,0x90,0x1F,0x10,0x10,0x11,0x16
  db 233      ;ģ-2
  db 0x10,0x10,0xFE,0x10,0x10,0xF8,0x08,0xF8,0x08,0xF8,0x40,0xFE,0x40,0xB0,0x0E,0x04

  db 234      ;ʽ-1, count:3
  db 0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0x3E,0x08,0x08,0x08,0x08,0x0F,0x70,0x20,0x00
  db 235      ;ʽ-2
  db 0x80,0xA0,0x90,0x84,0xFE,0x80,0x80,0x80,0x80,0x40,0x40,0x20,0x22,0x12,0x0A,0x04

  db 236      ;ȫ-1, count:1
  db 0x01,0x01,0x02,0x04,0x08,0x10,0x2F,0xC1,0x01,0x01,0x0F,0x01,0x01,0x01,0x7F,0x00
  db 237      ;ȫ-2
  db 0x00,0x00,0x80,0x40,0x20,0x10,0xEE,0x04,0x00,0x00,0xE0,0x00,0x00,0x00,0xFC,0x00

  db 238      ;ȱ-1, count:2
  db 0x20,0x20,0x24,0x3E,0x51,0x90,0x10,0xFE,0x10,0x55,0x54,0x54,0x54,0x7D,0x46,0x04
  db 239      ;ȱ-2
  db 0x40,0x40,0x40,0x48,0xFC,0x48,0x48,0x48,0x48,0xFE,0x40,0xA0,0xA0,0x10,0x0E,0x04

  db 240      ;ʡ-1, count:2
  db 0x01,0x09,0x09,0x11,0x11,0x20,0x03,0x0C,0x3F,0xC8,0x0F,0x08,0x0F,0x08,0x0F,0x08
  db 241      ;ʡ-2
  db 0x00,0x20,0x10,0x0C,0x24,0xC0,0x00,0x08,0xFC,0x08,0xF8,0x08,0xF8,0x08,0xF8,0x08

  db 242      ;-1, count:1
  db 0x00,0x40,0x30,0x11,0x01,0x0A,0x12,0x24,0xE0,0x20,0x20,0x20,0x21,0x21,0x22,0x24
  db 243      ;-2
  db 0x80,0x80,0x80,0x04,0xFE,0x04,0x48,0x40,0x40,0x40,0xA0,0xA0,0x10,0x08,0x0E,0x04

  db 244      ;-1, count:7
  db 0x00,0x3F,0x21,0x21,0x2F,0x21,0x21,0x3F,0x20,0x27,0x24,0x24,0x27,0x44,0x80,0x00
  db 245      ;-2
  db 0x08,0xFC,0x08,0x08,0xE8,0x08,0x08,0xF8,0x08,0xC8,0x48,0x48,0xC8,0x08,0x28,0x10

  db  247     ; brand 1
  db  0x00,0x00,0x00,0x00,0x07,0x0c,0x08,0x08,0x0c,0x07,0x00,0x00,0x00,0x00,0xfe,0x00
  db  248     ; brand 2
  db  0x01,0x01,0x01,0x01,0xfd,0x01,0x1f,0x1f,0x03,0xf7,0x0d,0x19,0x31,0x61,0xff,0xff
  db  249     ; brand 3
  db  0x80,0x80,0x80,0x80,0xbf,0x80,0xf0,0xf8,0x98,0x9b,0x98,0x98,0x98,0x98,0x9e,0x9e
  db  250     ; brand 4
  db  0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0xf0,0x18,0x08,0x08,0x18,0xf0,0x00

  db  251     ; left vertical line
  db  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0
  db  252     ; right vertical line
  db  0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03
  db  253     ; bottom horizontal line
  db  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF
  db  254     ; bottom left corner
  db  0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFF,0xFF
  db  255     ; bottom right corner
  db  0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xFF,0xFF
.end:

; keymap
; each entry has two words, the first is original keycode, 
; the second is new keycode.
keymap_data:
%ifdef KEYMAP_AZERTY
  %include "azerty.kbd"
%elifdef KEYMAP_QWERTZ
  %include "qwertz.kbd"
%elifdef KEYMAP_DVORAK
  %include "dvorak.kbd"
%elifdef KEYMAP_DVORAK_ANSI
  %include "dvorak-ansi.kbd"
%endif
.end:


; strings
; all strings are zero ending,
; use 0x0d to break string into multi-lines.
string:
; used in main window and boot menu.
.main_win_title     db  1,2,' ',3,4,' ',5,6,' ',7,8,0
.menu_title         db  '    ',9,10,'  ',11,12,'    ',14,15,'  ',16,17,'  ',18,19,'  ',20,21,'   ',22,23,'  ',24,25,0

; window titles.
.about              db  'About',0
.error              db  26,27,'  ',28,29,0
.help               db  'Help',0
.info               db  128,129,'  ',130,131,0
.input              db  132,133,'  ',134,135,0

; used in input boxes.
.delay_time         db  136,137,'  ',138,139,': ',0
.name               db  22,23,'  ',24,25,': ',0
.new_root_passwd    db  140,141, 
.root_passwd        db  142,143,144,145,146,147,148,149,': ',0
.new_record_passwd  db  140,141, 
.record_passwd      db  1,2,3,4,150,151,152,153,146,147,148,149,': ',0
.retype_passwd      db  154,155,156,157,146,147,148,149,':',0
.input_schedule     db  158,159,160,161,' (hh:mm-hh:mm;days): ',0
.input_keystrokes   db  132,133,134,135,162,163,164,165,'. ',162,163,' <Scroll Lock> ',164,165,154,155,156,157,0x0d
                    db  162,163,'  ',164,165,' = 0x',0
.key_count          db  '    No. ',0
.io_port            db  'I/O Base Ports (hex1,hex2): ',0
.year               db  'Year: ',0 

; used in record info box.
.drive_id           db     166,167,3,4,168,169,14,15,16,17,': ',0
.part_id            db  '  ',170,171,172,173,14,15,16,17,': ',0
.record_type        db  0x0d,'  ',150,151,152,153,18,19,20,21,': ',0
.record_name        db  0x0d,'  ',150,151,152,153,22,23,24,25,': ',0

.auto_active        db  0x0d,0x0d,'  ',174,175,3,4,176,177,178,179,': ',0
.active             db  '  ',176,177,178,179,': ',0
.auto_hide          db  0x0d,'  ',174,175,3,4,180,181,182,183,': ',0
.hidden             db  '  ',180,181,182,183,': ',0
.swap_drv           db  0x0d,184,185,186,187,166,167,3,4,168,169,': ',0
.logical            db  '  ',188,189,190,191,': ',0
.key_strokes        db  0x0d,0x0d,'    ',162,163,'  ',164,165,': ',0
.password           db  '  ',146,147,148,149,': ',0
.schedule           db  0x0d,'    ',158,159,'  ',160,161,': ',0

.yes                db  'Yes',0
.no                 db  'No ',0

; copyright infomation, displayed at the top of the screen.
.copyright          db  ' Smart Boot Manager 3.7.1 | Copyright (C) 2001 Suzhe',0

; hint message, displayed at the bottom of the screen.
.hint               db   '~F1~-Help  ~F2~-',192,193,194,195,'  ~F3~-',22,23,24,25,'  ~F4~-',176,177,178,179,'  ~F5~-',180,181,182,183,'  ~TAB~-',5,6,7,8,0

; about infomation.
.about_content     db '           Smart Boot Manager 3.7.1-zh',0x0d
                   db ' Copyright (C) 2001 Suzhe <suzhe@gnuchina.org>',0x0d,0x0d
                   db ' This is free software, you can redistribute',0x0d
                   db ' it and/or modify it under the terms of the',0x0d
                   db '   GNU General Public License version 2.',0x0d,0x0d
                   db 'This program comes with ABSOLUTELY NO WARRANTY!',0

; help infomation.
.help_content:
        db '  F1 = Help        Ctrl+F1 = About',0x0d
        db '  F2 = ',192,193,'  ',194,195,'           F3 = ',22,23,'  ',24,25,0x0d
        db '  F4 = ',176,177,'  ',178,179,'           F5 = ',180,181,'  ',182,183,0x0d
        db ' TAB = ',5,6,'  ',7,8,0x0d,0x0d
        db ' Please read the documentation for details.',0


; normal messages.
.changes_saved      db  192,193,194,195,' OK.',0
.passwd_changed     db  146,147,148,149,196,197,198,199, ' OK.',0
.ask_save_changes   db  192,193,194,195,196,197,198,199,'(y/n)?',0

; error messages.
.wrong_passwd       db  146,147,148,149,26,27,28,29,'!',0
.disk_error         db  166,167,3,4,168,169,26,27,28,29,'! 0x',0
.mark_act_failed    db  176,177,178,179,26,27,28,29,'!',0
.toggle_hid_failed  db  180,181,182,183,'/',200,201,202,203,180,181,182,183,26,27,28,29,'!',0
.no_system          db  'No Operating System!',0
.invalid_record     db  1,2,3,4,150,151,152,153,26,27,28,29,'!',0
.invalid_schedule   db  158,159,160,161,26,27,28,29,'!',0
.inst_confirm       db  154,155,156,157,204,205,206,207,' Smart BootManager ',
                    db  208,209,166,167,3,4,168,169,0
.inst_ok            db  204,205,206,207,' OK!',0
.inst_abort         db  200,201,202,203,204,205,206,207,'.',0
.uninst_confirm     db  154,155,156,157,210,211,212,213,' Smart BootManager?',0x0d,0
.uninst_ok          db  210,211,212,213,' OK!',0x0d
                    db  'Computer will be restarted.',0
.uninst_abort       db  200,201,202,203,210,211,212,213,'.',0
.confirm            db  162,163,' Y ',154,155,156,157,'.',0
.no_sbml            db  'Smart Boot Manager Loader missing ',0x0d
                    db  'or version mismatch!',0
.invalid_ioports    db  'I/O Ports ',26,27,28,29,'!',0

; command menu strings
; main menu
.main_mnu_title     db  'Main Menu',0
.main_mnu_help      db  'Help             ~F1~',0
.main_mnu_about     db  'About       ~Ctrl-F1~',0
.main_mnu_bootit    db  1,2,'  ',3,4,0
.main_mnu_bootprev  db  1,2,3,4,214,215,216,217,' MBR',0
.main_mnu_quit      db  'Quit         ~Ctrl-Q~',0
.main_mnu_poweroff  db  'Power Off  ~Ctrl-F12~',0
.main_mnu_recordset db  1,2,3,4,150,151,152,153,196,197,198,199,'     ->',0
.main_mnu_sysset    db  218,219,220,221,196,197,198,199,'         ->',0
.main_mnu_save      db  192,193,'  ',194,195,'           ~F2~',0
.main_mnu_bar       db  '-------------------',0

; record settings menu
.record_mnu_title    db  1,2,3,4,150,151,152,153,196,197,198,199,0
.record_mnu_info     db  128,129,'    ',130,131,'      ~/ or ?~',0
.record_mnu_name     db  22,23,'    ',24,25,'          ~F3~',0
.record_mnu_passwd   db  146,147,'    ',148,149,'          ~F9~',0
.record_mnu_schedule db  158,159,'    ',160,161,'      ~Ctrl-S~',0
.record_mnu_keys     db  162,163,'    ',164,165,'      ~Ctrl-K~',0
.record_mnu_act      db  176,177,'    ',178,179,'          ~F4~',0
.record_mnu_hide     db  180,181,'    ',182,183,'          ~F5~',0
.record_mnu_autoact  db  174,175,3,4,176,177,178,179,'          ~F6~',0
.record_mnu_autohide db  174,175,3,4,180,181,182,183,'          ~F7~',0
.record_mnu_swapdrv  db  184,185,186,187,166,167,3,4,168,169,'    ~Ctrl-X~',0
.record_mnu_del      db  210,211,'    ',212,213,'      ~Ctrl-D~',0
.record_mnu_dup      db  222,223,'    ',224,225,'      ~Ctrl-P~',0
.record_mnu_moveup   db  226,227,'    ',228,229,'      ~Ctrl-U~',0
.record_mnu_movedown db  230,231,'    ',228,229,'      ~Ctrl-N~',0
.record_mnu_bar      db  '--------------------',0

; system setting menu
.sys_mnu_title       db  218,219,220,221,196,197,198,199,0
.sys_mnu_rootpasswd  db  142,143,144,145,146,147,148,149,'                   ~F10~',0
.sys_mnu_admin       db  142,143,144,145,232,233,234,235,'              ~Ctrl-F10~',0
.sys_mnu_security    db  204,205,236,237,232,233,234,235,'               ~Alt-F10~',0
.sys_mnu_setdef      db  196,197,198,199,238,239,240,241,150,151,152,153,'                ~F8~',0
.sys_mnu_unsetdef    db  200,201,202,203,238,239,240,241,150,151,152,153,'          ~Shift-F8~',0
.sys_mnu_delay       db  196,197,198,199,136,137,138,139,'                ~Ctrl-T~',0
.sys_mnu_bmstyle     db  196,197,198,199,1,2,3,4,5,6,7,8,232,233,234,235,'        ~Ctrl-F~',0
.sys_mnu_remlast     db  192,193,194,195,226,227,242,243,1,2,3,4,150,151,152,153,'        ~Ctrl-L~',0
.sys_mnu_int13ext    db  'Toggle Extended Int 13H',0
.sys_mnu_rescanall   db  'Rescan All Boot Records ~Ctrl-I~',0
.sys_mnu_rescanpart  db  'Rescan All Partitions   ~Ctrl-H~',0
.sys_mnu_set_ioports db  196,197,198,199,' CD-ROM I/O Ports',0
.sys_mnu_set_y2kfix  db  'Set year (fix Y2K BIOS bug)',0
.sys_mnu_inst        db  204,205,206,207,' Smart BootManager',0
.sys_mnu_uninst      db  210,211,212,213,' Smart BootManager',0
.sys_mnu_bar         db  '------------------------------',0
.cdimg_mnu_title     db  'Choose a CD Image', 0
.cdimg_mnu_noemu     db  'No Emulation',0
.cdimg_mnu_120m      db  '1.2 M Diskette',0
.cdimg_mnu_144m      db  '1.44M Diskette',0
.cdimg_mnu_288m      db  '2.88M Diskette',0

.sunday              db 244,245,158,159,0
.monday              db 244,245,' 1',0
.tuesday             db 244,245,' 2',0
.wednesday           db 244,245,' 3',0
.thursday            db 244,245,' 4',0
.friday              db 244,245,' 5',0
.saturday            db 244,245,' 6',0


; END OF THEME.
end_of_theme:

; vi:ts=8:et:nowrap
