/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.provider.Gnu;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public final class Security {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static Vector providers;
    private static Properties secprops;

    private Security() {
    }

    private static boolean loadProviders(String baseUrl, String vendor) {
        if (baseUrl == null || vendor == null) {
            return false;
        }
        boolean result = true;
        String secfilestr = baseUrl + "/security/" + vendor + ".security";
        try {
            String name;
            InputStream fin = new URL(secfilestr).openStream();
            secprops.load(fin);
            int i = 1;
            while ((name = secprops.getProperty("security.provider." + i)) != null) {
                Exception exception = null;
                try {
                    providers.addElement(Class.forName(name).newInstance());
                }
                catch (ClassNotFoundException x) {
                    exception = x;
                }
                catch (InstantiationException x) {
                    exception = x;
                }
                catch (IllegalAccessException x) {
                    exception = x;
                }
                if (exception != null) {
                    System.err.println("WARNING: Error loading security provider " + name + ": " + exception);
                    result = false;
                }
                ++i;
            }
        }
        catch (IOException ignored) {
            result = false;
        }
        return false;
    }

    public static String getAlgorithmProperty(String algName, String propName) {
        if (algName == null || propName == null) {
            return null;
        }
        String property = String.valueOf(propName) + "." + String.valueOf(algName);
        Iterator i = providers.iterator();
        while (i.hasNext()) {
            Provider p = (Provider)i.next();
            Iterator j = p.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                if (!key.equalsIgnoreCase(property)) continue;
                return p.getProperty(key);
            }
        }
        return null;
    }

    public static int insertProviderAt(Provider provider, int position) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("insertProvider." + provider.getName());
        }
        --position;
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            if (((Provider)providers.elementAt(i)).getName() != provider.getName()) continue;
            return -1;
        }
        if (position < 0) {
            position = 0;
        }
        if (position > max) {
            position = max;
        }
        providers.insertElementAt(provider, position);
        return position + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("removeProvider." + name);
        }
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            if (((Provider)providers.elementAt(i)).getName() != name) continue;
            providers.remove(i);
            break;
        }
    }

    public static Provider[] getProviders() {
        Object[] array = new Provider[providers.size()];
        providers.copyInto(array);
        return array;
    }

    public static Provider getProvider(String name) {
        int max = providers.size();
        for (int i = 0; i < max; ++i) {
            Provider p = (Provider)providers.elementAt(i);
            if (p.getName() != name) continue;
            return p;
        }
        return null;
    }

    public static String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("getProperty." + key);
        }
        return secprops.getProperty(key);
    }

    public static void setProperty(String key, String datnum) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setProperty." + key);
        }
        secprops.put(key, datnum);
    }

    public static Set getAlgorithms(String serviceName) {
        HashSet result = new HashSet();
        if (serviceName == null || serviceName.length() == 0) {
            return result;
        }
        if ((serviceName = serviceName.trim()).length() == 0) {
            return result;
        }
        serviceName = serviceName.toUpperCase() + ".";
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Enumeration e = providers[i].propertyNames();
            while (e.hasMoreElements()) {
                String service = ((String)e.nextElement()).trim();
                if (!service.toUpperCase().startsWith(serviceName)) continue;
                int ndx = (service = service.substring(serviceName.length()).trim()).indexOf(32);
                if (ndx != -1) {
                    service = service.substring(0, ndx);
                }
                result.add(service);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static Provider[] getProviders(String filter) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (filter == null || filter.length() == 0) {
            return Security.getProviders();
        }
        HashMap map = new HashMap(1);
        int i = filter.indexOf(58);
        if (i == -1) {
            map.put(filter, "");
        } else {
            map.put(filter.substring(0, i), filter.substring(i + 1));
        }
        return Security.getProviders(map);
    }

    public static Provider[] getProviders(Map filter) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (filter == null) {
            return Security.getProviders();
        }
        Set querries = filter.keySet();
        if (querries == null || querries.isEmpty()) {
            return Security.getProviders();
        }
        LinkedHashSet result = new LinkedHashSet(providers);
        LinkedHashSet serviceProviders = new LinkedHashSet();
        Iterator i = querries.iterator();
        while (i.hasNext()) {
            String algorithm;
            String service;
            String attribute;
            String querry = (String)i.next();
            if (querry == null || (querry = querry.trim()).length() == 0) continue;
            int dot = querry.indexOf(46);
            if (dot == -1) {
                throw new InvalidParameterException("missing dot in '" + String.valueOf(querry) + "'");
            }
            String value = (String)filter.get(querry);
            if (value == null || value.trim().length() == 0) {
                value = null;
                attribute = null;
                service = querry.substring(0, dot).trim();
                algorithm = querry.substring(dot + 1).trim();
            } else {
                int ws = querry.indexOf(32);
                if (ws == -1) {
                    throw new InvalidParameterException("value (" + String.valueOf(value) + ") is not empty, but querry (" + String.valueOf(querry) + ") is missing at least one space character");
                }
                value = value.trim();
                attribute = querry.substring(ws + 1).trim();
                if (attribute.indexOf(46) != -1) {
                    throw new InvalidParameterException("attribute_name (" + String.valueOf(attribute) + ") in querry (" + String.valueOf(querry) + ") contains a dot");
                }
                querry = querry.substring(0, ws).trim();
                service = querry.substring(0, dot).trim();
                algorithm = querry.substring(dot + 1).trim();
            }
            if (service.length() == 0) {
                throw new InvalidParameterException("<crypto_service> in querry (" + String.valueOf(querry) + ") is empty");
            }
            if (algorithm.length() == 0) {
                throw new InvalidParameterException("<algorithm_or_type> in querry (" + String.valueOf(querry) + ") is empty");
            }
            Security.selectProviders(service, algorithm, attribute, value, result, serviceProviders);
            result.retainAll(serviceProviders);
            if (!result.isEmpty()) continue;
            break;
        }
        if (result.isEmpty()) {
            return null;
        }
        return (Provider[])result.toArray(new Provider[0]);
    }

    private static void selectProviders(String svc, String algo, String attr, String val, LinkedHashSet providerSet, LinkedHashSet result) {
        result.clear();
        Iterator i = providerSet.iterator();
        while (i.hasNext()) {
            Provider p = (Provider)i.next();
            if (!Security.provides(p, svc, algo, attr, val)) continue;
            result.add(p);
        }
    }

    private static boolean provides(Provider p, String svc, String algo, String attr, String val) {
        Iterator it;
        String serviceDotAlgorithm = null;
        String key = null;
        boolean found = false;
        block0: for (int r = 0; r < 3; ++r) {
            serviceDotAlgorithm = (svc + "." + String.valueOf(algo)).trim();
            it = p.keySet().iterator();
            while (it.hasNext()) {
                key = (String)it.next();
                if (key.equalsIgnoreCase(serviceDotAlgorithm)) {
                    found = true;
                    break block0;
                }
                if (!key.equalsIgnoreCase(ALG_ALIAS + serviceDotAlgorithm)) continue;
                algo = p.getProperty(key);
                continue block0;
            }
        }
        if (!found) {
            return false;
        }
        if (val == null) {
            return true;
        }
        int limit = serviceDotAlgorithm.length() + 1;
        it = p.keySet().iterator();
        while (it.hasNext()) {
            String realAttr;
            key = (String)it.next();
            if (key.length() <= limit || !key.substring(0, limit).equalsIgnoreCase(serviceDotAlgorithm + " ") || !(realAttr = key.substring(limit).trim()).equalsIgnoreCase(attr)) continue;
            String realVal = p.getProperty(key);
            if (realVal == null) {
                return false;
            }
            if (val.equalsIgnoreCase(realVal = realVal.trim())) {
                return true;
            }
            return new Integer(val) >= new Integer(realVal);
        }
        return false;
    }

    static {
        ALG_ALIAS = ALG_ALIAS;
        providers = new Vector();
        secprops = new Properties();
        String base = System.getProperty("gnu.classpath.home.url");
        String vendor = System.getProperty("gnu.classpath.vm.shortname");
        boolean loaded = Security.loadProviders(base, vendor);
        if (!Security.loadProviders(base, "classpath") && !loaded && providers.size() == 0) {
            System.err.println("WARNING: could not properly read security provider files:");
            System.err.println("         " + base + "/security/" + vendor + ".security");
            System.err.println("         " + base + "/security/" + "classpath" + ".security");
            System.err.println("         Falling back to standard GNU security provider");
            providers.addElement(new Gnu());
        }
    }
}

