/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import gnu.java.security.provider.SHA1PRNG;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.util.Enumeration;
import java.util.Random;

public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter;
    Provider provider;
    byte[] randomBytes;
    int randomBytesUsed;
    SecureRandomSpi secureRandomSpi;
    byte[] state;

    private /* synthetic */ void finit$() {
        this.counter = 0L;
        this.provider = null;
        this.randomBytes = null;
        this.randomBytesUsed = 0;
        this.secureRandomSpi = null;
        this.state = null;
    }

    public SecureRandom() {
        this.finit$();
        Provider[] p = Security.getProviders();
        String classname = null;
        boolean flag = false;
        for (int i = 0; i < p.length; ++i) {
            Enumeration e = p[i].propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("SECURERANDOM.") || (classname = p[i].getProperty(key)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(classname).newInstance();
                    this.provider = p[i];
                    return;
                }
                catch (Throwable ignore) {
                }
            }
        }
        this.secureRandomSpi = new SHA1PRNG();
    }

    public SecureRandom(byte[] seed) {
        this();
        this.setSeed(seed);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this.finit$();
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
    }

    public static SecureRandom getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            try {
                return SecureRandom.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static SecureRandom getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null || provider.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return SecureRandom.getInstance(algorithm, p);
    }

    public static SecureRandom getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new SecureRandom((SecureRandomSpi)Engine.getInstance(SECURE_RANDOM, algorithm, provider), provider);
        }
        catch (InvocationTargetException ite) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        catch (ClassCastException cce) {
            throw new NoSuchAlgorithmException(algorithm);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void setSeed(byte[] seed) {
        this.secureRandomSpi.engineSetSeed(seed);
    }

    public void setSeed(long seed) {
        if (this.secureRandomSpi != null) {
            byte[] tmp = new byte[]{(byte)(seed >> 56) & 0xFFFFFFFF, (byte)(seed >> 48) & 0xFFFFFFFF, (byte)(seed >> 40) & 0xFFFFFFFF, (byte)(seed >> 32) & 0xFFFFFFFF, (byte)(seed >> 24) & 0xFFFFFFFF, (byte)(seed >> 16) & 0xFFFFFFFF, (byte)(seed >> 8) & 0xFFFFFFFF, (byte)seed & 0xFFFFFFFF};
            this.secureRandomSpi.engineSetSeed(tmp);
        }
    }

    public void nextBytes(byte[] bytes) {
        this.randomBytesUsed += bytes.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(bytes);
    }

    protected final int next(int numBits) {
        if (numBits == 0) {
            return 0;
        }
        byte[] tmp = new byte[numBits / 8 + 1 * (numBits % 8)];
        this.secureRandomSpi.engineNextBytes(tmp);
        this.randomBytesUsed += tmp.length;
        ++this.counter;
        int ret = 0;
        for (int i = 0; i < tmp.length; ++i) {
            ret |= (tmp[i] & 0xFF) << (8 * i & 0x1F);
        }
        long mask = (1L << (numBits & 0x3F)) - 1L;
        return (int)mask & ret;
    }

    public static byte[] getSeed(int numBytes) {
        byte[] tmp = new byte[numBytes];
        new Random().nextBytes(tmp);
        return tmp;
    }

    public byte[] generateSeed(int numBytes) {
        return this.secureRandomSpi.engineGenerateSeed(numBytes);
    }

    static {
        SECURE_RANDOM = SECURE_RANDOM;
    }
}

