/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public final class Naming {
    public static Remote lookup(String name) throws NotBoundException, MalformedURLException, RemoteException {
        URL u;
        String filename;
        if (name.startsWith("rmi:")) {
            name = name.substring(4);
        }
        if ((filename = (u = new URL("http:" + name)).getFile()).charAt(0) == '/') {
            return Naming.getRegistry(u).lookup(filename.substring(1));
        }
        return Naming.getRegistry(u).lookup(filename);
    }

    public static void bind(String name, Remote obj) throws AlreadyBoundException, MalformedURLException, RemoteException {
        URL u = new URL("http:" + name);
        String filename = u.getFile();
        if (filename.charAt(0) == '/') {
            Naming.getRegistry(u).bind(filename.substring(1), obj);
        } else {
            Naming.getRegistry(u).bind(filename, obj);
        }
    }

    public static void unbind(String name) throws RemoteException, NotBoundException, MalformedURLException {
        URL u = new URL("http:" + name);
        String filename = u.getFile();
        if (filename.charAt(0) == '/') {
            Naming.getRegistry(u).unbind(filename.substring(1));
        } else {
            Naming.getRegistry(u).unbind(filename);
        }
    }

    public static void rebind(String name, Remote obj) throws RemoteException, MalformedURLException {
        URL u = new URL("http:" + name);
        String filename = u.getFile();
        if (filename.charAt(0) == '/') {
            Naming.getRegistry(u).rebind(filename.substring(1), obj);
        } else {
            Naming.getRegistry(u).rebind(filename, obj);
        }
    }

    public static String[] list(String name) throws RemoteException, MalformedURLException {
        return Naming.getRegistry(new URL("http:" + name)).list();
    }

    private static Registry getRegistry(URL u) throws RemoteException {
        if (u.getPort() == -1) {
            return LocateRegistry.getRegistry(u.getHost());
        }
        return LocateRegistry.getRegistry(u.getHost(), u.getPort());
    }
}

