/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractObjectContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.MethodFinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class PropertyContext
extends AbstractObjectContext {
    private Object argument;
    private String propertyName;
    private String prefix;
    private boolean methodCalled;

    public void addParameterObject(Object o) throws AssemblyException {
        if (this.methodCalled) {
            throw new AssemblyException(new IllegalArgumentException("Cannot add parameter object when method was already called."));
        }
        if (this.argument != null) {
            throw new AssemblyException(new IllegalArgumentException("Property attribut allows zero or one argument only."));
        }
        this.argument = o;
        this.setStatement(true);
        this.prefix = "set";
    }

    public void notifyStatement(Context outerContext) throws AssemblyException {
        Object[] objectArray;
        if (this.methodCalled) {
            return;
        }
        this.methodCalled = true;
        Object outerObject = outerContext.getResult();
        if (outerObject == null) {
            throw new AssemblyException(new NullPointerException("No object to access property " + this.propertyName));
        }
        String methodName = this.prefix + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
        if (this.argument != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.argument;
        } else {
            objectArray = null;
        }
        Object[] args = objectArray;
        try {
            Method method = MethodFinder.getMethod(outerObject.getClass(), methodName, args);
            this.setObject(method.invoke(outerObject, args));
        }
        catch (NoSuchMethodException nsme) {
            throw new AssemblyException(nsme);
        }
        catch (InvocationTargetException ite) {
            throw new AssemblyException(ite.getCause());
        }
        catch (IllegalAccessException iae) {
            throw new AssemblyException(iae);
        }
    }

    public Object endContext(Context outerContext) throws AssemblyException {
        this.notifyStatement(outerContext);
        return this.getResult();
    }

    public boolean subContextFailed() {
        return this.methodCalled ^ true;
    }

    private final /* synthetic */ void this() {
        this.prefix = "get";
    }

    PropertyContext(String id, String newPropertyName) {
        this.this();
        this.setId(id);
        this.propertyName = newPropertyName;
    }
}

