/*
 * This declarations of the PIC16C765 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:03 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16C765_H__
#define __PIC16C765_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PORTC_ADDR              0x0007
#define PORTD_ADDR              0x0008
#define PORTE_ADDR              0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIR2_ADDR               0x000D
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define RCSTA_ADDR              0x0018
#define TXREG_ADDR              0x0019
#define RCREG_ADDR              0x001A
#define CCPR2_ADDR              0x001B
#define CCPR2L_ADDR             0x001B
#define CCPR2H_ADDR             0x001C
#define CCP2CON_ADDR            0x001D
#define ADRES_ADDR              0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISC_ADDR              0x0087
#define TRISD_ADDR              0x0088
#define TRISE_ADDR              0x0089
#define PIE1_ADDR               0x008C
#define PIE2_ADDR               0x008D
#define PCON_ADDR               0x008E
#define PR2_ADDR                0x0092
#define TXSTA_ADDR              0x0098
#define SPBRG_ADDR              0x0099
#define ADCON1_ADDR             0x009F
#define UIR_ADDR                0x0190
#define UIE_ADDR                0x0191
#define UEIR_ADDR               0x0192
#define UEIE_ADDR               0x0193
#define USTAT_ADDR              0x0194
#define UCTRL_ADDR              0x0195
#define UADDR_ADDR              0x0196
#define USWSTAT_ADDR            0x0197
#define UEP0_ADDR               0x0198
#define UEP1_ADDR               0x0199
#define UEP2_ADDR               0x019A
#define BD0OST_ADDR             0x01A0
#define BD0OBC_ADDR             0x01A1
#define BD0OAL_ADDR             0x01A2
#define BD0IST_ADDR             0x01A4
#define BD0IBC_ADDR             0x01A5
#define BD0IAL_ADDR             0x01A6
#define BD1OST_ADDR             0x01A8
#define BD1OBC_ADDR             0x01A9
#define BD1OAL_ADDR             0x01AA
#define BD1IST_ADDR             0x01AC
#define BD1IBC_ADDR             0x01AD
#define BD1IAL_ADDR             0x01AE
#define BD2OST_ADDR             0x01B0
#define BD2OBC_ADDR             0x01B1
#define BD2OAL_ADDR             0x01B2
#define BD2IST_ADDR             0x01B4
#define BD2IBC_ADDR             0x01B5
#define BD2IAL_ADDR             0x01B6

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0008) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x0008) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0009) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 3;
    unsigned                    : 5;
    };
  } __PORTEbits_t;

extern __at(0x0009) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INTF               : 1;
    unsigned T0IF               : 1;
    unsigned RBIE               : 1;
    unsigned INTE               : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0IF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR0IE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _T0IF                   0x04
#define _TMR0IF                 0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _T0IE                   0x20
#define _TMR0IE                 0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned USBIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned PSPIF                : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _USBIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _PSPIF                  0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x000D) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x000D) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1INSYNC               0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0018) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned                    : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC9                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0018) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _SPEN                   0x80

//==============================================================================

extern __at(0x0019) __sfr TXREG;
extern __at(0x001A) __sfr RCREG;
extern __at(0x001B) __sfr CCPR2;
extern __at(0x001B) __sfr CCPR2L;
extern __at(0x001C) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x001D) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x001D) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20

//==============================================================================

extern __at(0x001E) __sfr ADRES;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned                    : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CHS                : 3;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned ADCS               : 2;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x04
#define _GO                     0x04
#define _NOT_DONE               0x04
#define _GO_DONE                0x04
#define _CHS0                   0x08
#define _CHS1                   0x10
#define _CHS2                   0x20
#define _ADCS0                  0x40
#define _ADCS1                  0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 6;
    unsigned                    : 2;
    };
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0088) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x0088) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0089) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned                    : 1;
    unsigned PSPMODE            : 1;
    unsigned IBOV               : 1;
    unsigned OBF                : 1;
    unsigned IBF                : 1;
    };

  struct
    {
    unsigned TRISE              : 3;
    unsigned                    : 5;
    };
  } __TRISEbits_t;

extern __at(0x0089) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _PSPMODE                0x10
#define _IBOV                   0x20
#define _OBF                    0x40
#define _IBF                    0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned USBIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned PSPIE                : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _USBIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _PSPIE                  0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x008D) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x008D) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BO             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BO                 0x01
#define _NOT_POR                0x02

//==============================================================================

extern __at(0x0092) __sfr PR2;

//==============================================================================
//        TXSTA Bits

extern __at(0x0098) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX8_9              : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0098) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _NOT_TX8                0x40
#define _TX8_9                  0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0099) __sfr SPBRG;

//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCFG               : 3;
    unsigned                    : 5;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04

//==============================================================================


//==============================================================================
//        UIR Bits

extern __at(0x0190) __sfr UIR;

typedef struct
  {
  unsigned USB_RST              : 1;
  unsigned UERR                 : 1;
  unsigned ACTIVITY             : 1;
  unsigned TOK_DNE              : 1;
  unsigned UIDLE                : 1;
  unsigned STALL                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UIRbits_t;

extern __at(0x0190) volatile __UIRbits_t UIRbits;

#define _UIR_USB_RST            0x01
#define _UIR_UERR               0x02
#define _UIR_ACTIVITY           0x04
#define _UIR_TOK_DNE            0x08
#define _UIR_UIDLE              0x10
#define _UIR_STALL              0x20

//==============================================================================


//==============================================================================
//        UIE Bits

extern __at(0x0191) __sfr UIE;

typedef struct
  {
  unsigned USB_RST              : 1;
  unsigned UERR                 : 1;
  unsigned ACTIVITY             : 1;
  unsigned TOK_DNE              : 1;
  unsigned UIDLE                : 1;
  unsigned STALL                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UIEbits_t;

extern __at(0x0191) volatile __UIEbits_t UIEbits;

#define _USB_RST                0x01
#define _UERR                   0x02
#define _ACTIVITY               0x04
#define _TOK_DNE                0x08
#define _UIDLE                  0x10
#define _STALL                  0x20

//==============================================================================


//==============================================================================
//        UEIR Bits

extern __at(0x0192) __sfr UEIR;

typedef struct
  {
  unsigned PID_ERR              : 1;
  unsigned CRC5                 : 1;
  unsigned CRC16                : 1;
  unsigned DFN8                 : 1;
  unsigned BTO_ERR              : 1;
  unsigned WRT_ERR              : 1;
  unsigned OWN_ERR              : 1;
  unsigned BTS_ERR              : 1;
  } __UEIRbits_t;

extern __at(0x0192) volatile __UEIRbits_t UEIRbits;

#define _UEIR_PID_ERR           0x01
#define _UEIR_CRC5              0x02
#define _UEIR_CRC16             0x04
#define _UEIR_DFN8              0x08
#define _UEIR_BTO_ERR           0x10
#define _UEIR_WRT_ERR           0x20
#define _UEIR_OWN_ERR           0x40
#define _UEIR_BTS_ERR           0x80

//==============================================================================


//==============================================================================
//        UEIE Bits

extern __at(0x0193) __sfr UEIE;

typedef struct
  {
  unsigned PID_ERR              : 1;
  unsigned CRC5                 : 1;
  unsigned CRC16                : 1;
  unsigned DFN8                 : 1;
  unsigned BTO_ERR              : 1;
  unsigned WRT_ERR              : 1;
  unsigned OWN_ERR              : 1;
  unsigned BTS_ERR              : 1;
  } __UEIEbits_t;

extern __at(0x0193) volatile __UEIEbits_t UEIEbits;

#define _PID_ERR                0x01
#define _CRC5                   0x02
#define _CRC16                  0x04
#define _DFN8                   0x08
#define _BTO_ERR                0x10
#define _WRT_ERR                0x20
#define _OWN_ERR                0x40
#define _BTS_ERR                0x80

//==============================================================================


//==============================================================================
//        USTAT Bits

extern __at(0x0194) __sfr USTAT;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IN                 : 1;
    unsigned ENDP0              : 1;
    unsigned ENDP1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ENDP               : 2;
    unsigned                    : 3;
    };
  } __USTATbits_t;

extern __at(0x0194) volatile __USTATbits_t USTATbits;

#define _IN                     0x04
#define _ENDP0                  0x08
#define _ENDP1                  0x10

//==============================================================================


//==============================================================================
//        UCTRL Bits

extern __at(0x0195) __sfr UCTRL;

typedef struct
  {
  unsigned                      : 1;
  unsigned SUSPND               : 1;
  unsigned RESUME               : 1;
  unsigned DEV_ATT              : 1;
  unsigned PKT_DIS              : 1;
  unsigned SE0                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UCTRLbits_t;

extern __at(0x0195) volatile __UCTRLbits_t UCTRLbits;

#define _SUSPND                 0x02
#define _RESUME                 0x04
#define _DEV_ATT                0x08
#define _PKT_DIS                0x10
#define _SE0                    0x20

//==============================================================================

extern __at(0x0196) __sfr UADDR;
extern __at(0x0197) __sfr USWSTAT;

//==============================================================================
//        UEP0 Bits

extern __at(0x0198) __sfr UEP0;

typedef struct
  {
  unsigned EP_STALL             : 1;
  unsigned EP_IN_EN             : 1;
  unsigned EP_OUT_EN            : 1;
  unsigned EP_CTL_DIS           : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP0bits_t;

extern __at(0x0198) volatile __UEP0bits_t UEP0bits;

#define _EP_STALL               0x01
#define _EP_IN_EN               0x02
#define _EP_OUT_EN              0x04
#define _EP_CTL_DIS             0x08

//==============================================================================


//==============================================================================
//        UEP1 Bits

extern __at(0x0199) __sfr UEP1;

typedef struct
  {
  unsigned EP_STALL             : 1;
  unsigned EP_IN_EN             : 1;
  unsigned EP_OUT_EN            : 1;
  unsigned EP_CTL_DIS           : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP1bits_t;

extern __at(0x0199) volatile __UEP1bits_t UEP1bits;

#define _UEP1_EP_STALL          0x01
#define _UEP1_EP_IN_EN          0x02
#define _UEP1_EP_OUT_EN         0x04
#define _UEP1_EP_CTL_DIS        0x08

//==============================================================================


//==============================================================================
//        UEP2 Bits

extern __at(0x019A) __sfr UEP2;

typedef struct
  {
  unsigned EP_STALL             : 1;
  unsigned EP_IN_EN             : 1;
  unsigned EP_OUT_EN            : 1;
  unsigned EP_CTL_DIS           : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP2bits_t;

extern __at(0x019A) volatile __UEP2bits_t UEP2bits;

#define _UEP2_EP_STALL          0x01
#define _UEP2_EP_IN_EN          0x02
#define _UEP2_EP_OUT_EN         0x04
#define _UEP2_EP_CTL_DIS        0x08

//==============================================================================


//==============================================================================
//        BD0OST Bits

extern __at(0x01A0) __sfr BD0OST;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0_BSTALL        : 1;
    unsigned PID1_DTS           : 1;
    unsigned PID2               : 1;
    unsigned PID3               : 1;
    unsigned DATA0_1            : 1;
    unsigned UOWN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0               : 1;
    unsigned PID1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA01             : 1;
    unsigned OWN                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BSTALL             : 1;
    unsigned DTS                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PID                : 4;
    unsigned                    : 2;
    };
  } __BD0OSTbits_t;

extern __at(0x01A0) volatile __BD0OSTbits_t BD0OSTbits;

#define _BD0OST_PID0_BSTALL     0x04
#define _BD0OST_PID0            0x04
#define _BD0OST_BSTALL          0x04
#define _BD0OST_PID1_DTS        0x08
#define _BD0OST_PID1            0x08
#define _BD0OST_DTS             0x08
#define _BD0OST_PID2            0x10
#define _BD0OST_PID3            0x20
#define _BD0OST_DATA0_1         0x40
#define _BD0OST_DATA01          0x40
#define _BD0OST_UOWN            0x80
#define _BD0OST_OWN             0x80

//==============================================================================


//==============================================================================
//        BD0OBC Bits

extern __at(0x01A1) __sfr BD0OBC;

typedef union
  {
  struct
    {
    unsigned BC0                : 1;
    unsigned BC1                : 1;
    unsigned BC2                : 1;
    unsigned BC3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BC                 : 4;
    unsigned                    : 4;
    };
  } __BD0OBCbits_t;

extern __at(0x01A1) volatile __BD0OBCbits_t BD0OBCbits;

#define _BD0OBC_BC0             0x01
#define _BD0OBC_BC1             0x02
#define _BD0OBC_BC2             0x04
#define _BD0OBC_BC3             0x08

//==============================================================================

extern __at(0x01A2) __sfr BD0OAL;

//==============================================================================
//        BD0IST Bits

extern __at(0x01A4) __sfr BD0IST;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0_BSTALL        : 1;
    unsigned PID1_DTS           : 1;
    unsigned PID2               : 1;
    unsigned PID3               : 1;
    unsigned DATA0_1            : 1;
    unsigned UOWN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0               : 1;
    unsigned PID1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA01             : 1;
    unsigned OWN                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BSTALL             : 1;
    unsigned DTS                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PID                : 4;
    unsigned                    : 2;
    };
  } __BD0ISTbits_t;

extern __at(0x01A4) volatile __BD0ISTbits_t BD0ISTbits;

#define _PID0_BSTALL            0x04
#define _PID0                   0x04
#define _BSTALL                 0x04
#define _PID1_DTS               0x08
#define _PID1                   0x08
#define _DTS                    0x08
#define _PID2                   0x10
#define _PID3                   0x20
#define _DATA0_1                0x40
#define _DATA01                 0x40
#define _UOWN                   0x80
#define _OWN                    0x80

//==============================================================================


//==============================================================================
//        BD0IBC Bits

extern __at(0x01A5) __sfr BD0IBC;

typedef union
  {
  struct
    {
    unsigned BC0                : 1;
    unsigned BC1                : 1;
    unsigned BC2                : 1;
    unsigned BC3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BC                 : 4;
    unsigned                    : 4;
    };
  } __BD0IBCbits_t;

extern __at(0x01A5) volatile __BD0IBCbits_t BD0IBCbits;

#define _BC0                    0x01
#define _BC1                    0x02
#define _BC2                    0x04
#define _BC3                    0x08

//==============================================================================

extern __at(0x01A6) __sfr BD0IAL;

//==============================================================================
//        BD1OST Bits

extern __at(0x01A8) __sfr BD1OST;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0_BSTALL        : 1;
    unsigned PID1_DTS           : 1;
    unsigned PID2               : 1;
    unsigned PID3               : 1;
    unsigned DATA0_1            : 1;
    unsigned UOWN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0               : 1;
    unsigned PID1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA01             : 1;
    unsigned OWN                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BSTALL             : 1;
    unsigned DTS                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PID                : 4;
    unsigned                    : 2;
    };
  } __BD1OSTbits_t;

extern __at(0x01A8) volatile __BD1OSTbits_t BD1OSTbits;

#define _BD1OST_PID0_BSTALL     0x04
#define _BD1OST_PID0            0x04
#define _BD1OST_BSTALL          0x04
#define _BD1OST_PID1_DTS        0x08
#define _BD1OST_PID1            0x08
#define _BD1OST_DTS             0x08
#define _BD1OST_PID2            0x10
#define _BD1OST_PID3            0x20
#define _BD1OST_DATA0_1         0x40
#define _BD1OST_DATA01          0x40
#define _BD1OST_UOWN            0x80
#define _BD1OST_OWN             0x80

//==============================================================================


//==============================================================================
//        BD1OBC Bits

extern __at(0x01A9) __sfr BD1OBC;

typedef union
  {
  struct
    {
    unsigned BC0                : 1;
    unsigned BC1                : 1;
    unsigned BC2                : 1;
    unsigned BC3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BC                 : 4;
    unsigned                    : 4;
    };
  } __BD1OBCbits_t;

extern __at(0x01A9) volatile __BD1OBCbits_t BD1OBCbits;

#define _BD1OBC_BC0             0x01
#define _BD1OBC_BC1             0x02
#define _BD1OBC_BC2             0x04
#define _BD1OBC_BC3             0x08

//==============================================================================

extern __at(0x01AA) __sfr BD1OAL;

//==============================================================================
//        BD1IST Bits

extern __at(0x01AC) __sfr BD1IST;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0_BSTALL        : 1;
    unsigned PID1_DTS           : 1;
    unsigned PID2               : 1;
    unsigned PID3               : 1;
    unsigned DATA0_1            : 1;
    unsigned UOWN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0               : 1;
    unsigned PID1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA01             : 1;
    unsigned OWN                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BSTALL             : 1;
    unsigned DTS                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PID                : 4;
    unsigned                    : 2;
    };
  } __BD1ISTbits_t;

extern __at(0x01AC) volatile __BD1ISTbits_t BD1ISTbits;

#define _BD1IST_PID0_BSTALL     0x04
#define _BD1IST_PID0            0x04
#define _BD1IST_BSTALL          0x04
#define _BD1IST_PID1_DTS        0x08
#define _BD1IST_PID1            0x08
#define _BD1IST_DTS             0x08
#define _BD1IST_PID2            0x10
#define _BD1IST_PID3            0x20
#define _BD1IST_DATA0_1         0x40
#define _BD1IST_DATA01          0x40
#define _BD1IST_UOWN            0x80
#define _BD1IST_OWN             0x80

//==============================================================================


//==============================================================================
//        BD1IBC Bits

extern __at(0x01AD) __sfr BD1IBC;

typedef union
  {
  struct
    {
    unsigned BC0                : 1;
    unsigned BC1                : 1;
    unsigned BC2                : 1;
    unsigned BC3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BC                 : 4;
    unsigned                    : 4;
    };
  } __BD1IBCbits_t;

extern __at(0x01AD) volatile __BD1IBCbits_t BD1IBCbits;

#define _BD1IBC_BC0             0x01
#define _BD1IBC_BC1             0x02
#define _BD1IBC_BC2             0x04
#define _BD1IBC_BC3             0x08

//==============================================================================

extern __at(0x01AE) __sfr BD1IAL;

//==============================================================================
//        BD2OST Bits

extern __at(0x01B0) __sfr BD2OST;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0_BSTALL        : 1;
    unsigned PID1_DTS           : 1;
    unsigned PID2               : 1;
    unsigned PID3               : 1;
    unsigned DATA0_1            : 1;
    unsigned UOWN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0               : 1;
    unsigned PID1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA01             : 1;
    unsigned OWN                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BSTALL             : 1;
    unsigned DTS                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PID                : 4;
    unsigned                    : 2;
    };
  } __BD2OSTbits_t;

extern __at(0x01B0) volatile __BD2OSTbits_t BD2OSTbits;

#define _BD2OST_PID0_BSTALL     0x04
#define _BD2OST_PID0            0x04
#define _BD2OST_BSTALL          0x04
#define _BD2OST_PID1_DTS        0x08
#define _BD2OST_PID1            0x08
#define _BD2OST_DTS             0x08
#define _BD2OST_PID2            0x10
#define _BD2OST_PID3            0x20
#define _BD2OST_DATA0_1         0x40
#define _BD2OST_DATA01          0x40
#define _BD2OST_UOWN            0x80
#define _BD2OST_OWN             0x80

//==============================================================================


//==============================================================================
//        BD2OBC Bits

extern __at(0x01B1) __sfr BD2OBC;

typedef union
  {
  struct
    {
    unsigned BC0                : 1;
    unsigned BC1                : 1;
    unsigned BC2                : 1;
    unsigned BC3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BC                 : 4;
    unsigned                    : 4;
    };
  } __BD2OBCbits_t;

extern __at(0x01B1) volatile __BD2OBCbits_t BD2OBCbits;

#define _BD2OBC_BC0             0x01
#define _BD2OBC_BC1             0x02
#define _BD2OBC_BC2             0x04
#define _BD2OBC_BC3             0x08

//==============================================================================

extern __at(0x01B2) __sfr BD2OAL;

//==============================================================================
//        BD2IST Bits

extern __at(0x01B4) __sfr BD2IST;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0_BSTALL        : 1;
    unsigned PID1_DTS           : 1;
    unsigned PID2               : 1;
    unsigned PID3               : 1;
    unsigned DATA0_1            : 1;
    unsigned UOWN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PID0               : 1;
    unsigned PID1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA01             : 1;
    unsigned OWN                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned BSTALL             : 1;
    unsigned DTS                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PID                : 4;
    unsigned                    : 2;
    };
  } __BD2ISTbits_t;

extern __at(0x01B4) volatile __BD2ISTbits_t BD2ISTbits;

#define _BD2IST_PID0_BSTALL     0x04
#define _BD2IST_PID0            0x04
#define _BD2IST_BSTALL          0x04
#define _BD2IST_PID1_DTS        0x08
#define _BD2IST_PID1            0x08
#define _BD2IST_DTS             0x08
#define _BD2IST_PID2            0x10
#define _BD2IST_PID3            0x20
#define _BD2IST_DATA0_1         0x40
#define _BD2IST_DATA01          0x40
#define _BD2IST_UOWN            0x80
#define _BD2IST_OWN             0x80

//==============================================================================


//==============================================================================
//        BD2IBC Bits

extern __at(0x01B5) __sfr BD2IBC;

typedef union
  {
  struct
    {
    unsigned BC0                : 1;
    unsigned BC1                : 1;
    unsigned BC2                : 1;
    unsigned BC3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BC                 : 4;
    unsigned                    : 4;
    };
  } __BD2IBCbits_t;

extern __at(0x01B5) volatile __BD2IBCbits_t BD2IBCbits;

#define _BD2IBC_BC0             0x01
#define _BD2IBC_BC1             0x02
#define _BD2IBC_BC2             0x04
#define _BD2IBC_BC3             0x08

//==============================================================================

extern __at(0x01B6) __sfr BD2IAL;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x2007

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_HS                0x3FFC  // HS oscillator.
#define _HS_OSC                 0x3FFC  // HS oscillator.
#define _FOSC_EC                0x3FFD  // External clock. CLKOUT on OSC2 pin.
#define _EC_OSC                 0x3FFD  // External clock. CLKOUT on OSC2 pin.
#define _FOSC_H4                0x3FFE  // HS osc with 4x PLL enabled.
#define _H4_OSC                 0x3FFE  // HS osc with 4x PLL enabled.
#define _FOSC_E4                0x3FFF  // External clock with 4x PLL enabled. CLKOUT on OSC2 pin.
#define _E4_OSC                 0x3FFF  // External clock with 4x PLL enabled. CLKOUT on OSC2 pin.
#define _WDTE_OFF               0x3FFB  // WDT disabled.
#define _WDT_OFF                0x3FFB  // WDT disabled.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FF7  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _CP_ALL                 0x00CF  // All memory is code protected.
#define _CP_75                  0x15DF  // 0800h-1FFFh code protected.
#define _CP_50                  0x2AEF  // 1000h-1FFFh code protected.
#define _CP_OFF                 0x3FFF  // Code protection off.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 2, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 2, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 2, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 2, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 3
#define CHS1                    ADCON0bits.CHS1                 // bit 4
#define CHS2                    ADCON0bits.CHS2                 // bit 5
#define ADCS0                   ADCON0bits.ADCS0                // bit 6
#define ADCS1                   ADCON0bits.ADCS1                // bit 7

#define PCFG0                   ADCON1bits.PCFG0                // bit 0
#define PCFG1                   ADCON1bits.PCFG1                // bit 1
#define PCFG2                   ADCON1bits.PCFG2                // bit 2

#define BC0                     BD0IBCbits.BC0                  // bit 0
#define BC1                     BD0IBCbits.BC1                  // bit 1
#define BC2                     BD0IBCbits.BC2                  // bit 2
#define BC3                     BD0IBCbits.BC3                  // bit 3

#define PID0_BSTALL             BD0ISTbits.PID0_BSTALL          // bit 2, shadows bit in BD0ISTbits
#define PID0                    BD0ISTbits.PID0                 // bit 2, shadows bit in BD0ISTbits
#define BSTALL                  BD0ISTbits.BSTALL               // bit 2, shadows bit in BD0ISTbits
#define PID1_DTS                BD0ISTbits.PID1_DTS             // bit 3, shadows bit in BD0ISTbits
#define PID1                    BD0ISTbits.PID1                 // bit 3, shadows bit in BD0ISTbits
#define DTS                     BD0ISTbits.DTS                  // bit 3, shadows bit in BD0ISTbits
#define PID2                    BD0ISTbits.PID2                 // bit 4
#define PID3                    BD0ISTbits.PID3                 // bit 5
#define DATA0_1                 BD0ISTbits.DATA0_1              // bit 6, shadows bit in BD0ISTbits
#define DATA01                  BD0ISTbits.DATA01               // bit 6, shadows bit in BD0ISTbits
#define UOWN                    BD0ISTbits.UOWN                 // bit 7, shadows bit in BD0ISTbits
#define OWN                     BD0ISTbits.OWN                  // bit 7, shadows bit in BD0ISTbits

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BO                  PCONbits.NOT_BO                 // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define USBIE                   PIE1bits.USBIE                  // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define PSPIE                   PIE1bits.PSPIE                  // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define USBIF                   PIR1bits.USBIF                  // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define PSPIF                   PIR1bits.PSPIF                  // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RD0                     PORTDbits.RD0                   // bit 0
#define RD1                     PORTDbits.RD1                   // bit 1
#define RD2                     PORTDbits.RD2                   // bit 2
#define RD3                     PORTDbits.RD3                   // bit 3
#define RD4                     PORTDbits.RD4                   // bit 4
#define RD5                     PORTDbits.RD5                   // bit 5
#define RD6                     PORTDbits.RD6                   // bit 6
#define RD7                     PORTDbits.RD7                   // bit 7

#define RE0                     PORTEbits.RE0                   // bit 0
#define RE1                     PORTEbits.RE1                   // bit 1
#define RE2                     PORTEbits.RE2                   // bit 2

#define RX9D                    RCSTAbits.RX9D                  // bit 0, shadows bit in RCSTAbits
#define RCD8                    RCSTAbits.RCD8                  // bit 0, shadows bit in RCSTAbits
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6, shadows bit in RCSTAbits
#define RC9                     RCSTAbits.RC9                   // bit 6, shadows bit in RCSTAbits
#define NOT_RC8                 RCSTAbits.NOT_RC8               // bit 6, shadows bit in RCSTAbits
#define RC8_9                   RCSTAbits.RC8_9                 // bit 6, shadows bit in RCSTAbits
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1INSYNC                T1CONbits.T1INSYNC              // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define PSPMODE                 TRISEbits.PSPMODE               // bit 4
#define IBOV                    TRISEbits.IBOV                  // bit 5
#define OBF                     TRISEbits.OBF                   // bit 6
#define IBF                     TRISEbits.IBF                   // bit 7

#define TX9D                    TXSTAbits.TX9D                  // bit 0, shadows bit in TXSTAbits
#define TXD8                    TXSTAbits.TXD8                  // bit 0, shadows bit in TXSTAbits
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6, shadows bit in TXSTAbits
#define NOT_TX8                 TXSTAbits.NOT_TX8               // bit 6, shadows bit in TXSTAbits
#define TX8_9                   TXSTAbits.TX8_9                 // bit 6, shadows bit in TXSTAbits
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define SUSPND                  UCTRLbits.SUSPND                // bit 1
#define RESUME                  UCTRLbits.RESUME                // bit 2
#define DEV_ATT                 UCTRLbits.DEV_ATT               // bit 3
#define PKT_DIS                 UCTRLbits.PKT_DIS               // bit 4
#define SE0                     UCTRLbits.SE0                   // bit 5

#define PID_ERR                 UEIEbits.PID_ERR                // bit 0
#define CRC5                    UEIEbits.CRC5                   // bit 1
#define CRC16                   UEIEbits.CRC16                  // bit 2
#define DFN8                    UEIEbits.DFN8                   // bit 3
#define BTO_ERR                 UEIEbits.BTO_ERR                // bit 4
#define WRT_ERR                 UEIEbits.WRT_ERR                // bit 5
#define OWN_ERR                 UEIEbits.OWN_ERR                // bit 6
#define BTS_ERR                 UEIEbits.BTS_ERR                // bit 7

#define EP_STALL                UEP0bits.EP_STALL               // bit 0
#define EP_IN_EN                UEP0bits.EP_IN_EN               // bit 1
#define EP_OUT_EN               UEP0bits.EP_OUT_EN              // bit 2
#define EP_CTL_DIS              UEP0bits.EP_CTL_DIS             // bit 3

#define USB_RST                 UIEbits.USB_RST                 // bit 0
#define UERR                    UIEbits.UERR                    // bit 1
#define ACTIVITY                UIEbits.ACTIVITY                // bit 2
#define TOK_DNE                 UIEbits.TOK_DNE                 // bit 3
#define UIDLE                   UIEbits.UIDLE                   // bit 4
#define STALL                   UIEbits.STALL                   // bit 5

#define IN                      USTATbits.IN                    // bit 2
#define ENDP0                   USTATbits.ENDP0                 // bit 3
#define ENDP1                   USTATbits.ENDP1                 // bit 4

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16C765_H__
