<?php

###############################################################################
# japanese_utf-8.php
#
# This is the Japanese language file for Geeklog
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
# Copyright (C) 2002,2003,2004,2005,2006 SAKATA Yusuke
# sakata AT ecofirm.com
# Copyright (C) 2008 Takahiro Kambe
# taca AT back-street DOT net
# Copyright (C) 2006,2007,2008 Tetsuko Komma
# ivy AT geeklog DOT jp
# Copyright (C) 2006-2021 Geeklog.jp group
# info AT geeklog DOT jp
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

$LANG_ISO639_1 = 'ja';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '投稿者:',
    2 => '続きを読む',
    3 => 'コメント',
    4 => '編集',
    5 => 'Contributed by: %s on %s',
    6 => 'Last modified on %s',
    7 => '',
    8 => '',
    9 => '管理機能:',
    10 => '投稿',
    11 => '記事',
    12 => 'ブロック',
    13 => '話題',
    14 => '管理画面TOP',
    15 => '',
    16 => '',
    17 => 'ユーザー',
    18 => 'SQL Query',
    19 => 'ログアウト',
    20 => 'ユーザー情報:',
    21 => 'ユーザー名',
    22 => 'ユーザーID',
    23 => '管理レベル',
    24 => 'ゲストユーザー',
    25 => 'コメントを追加',
    26 => '以下のコメントは、その投稿者が所有するものでサイト管理者はコメントに関する責任を負いません。',
    27 => '最新の投稿',
    28 => '削除',
    29 => '-',
    30 => '過去の記事',
    31 => '使用できるHTMLタグ:',
    32 => 'エラーです、ユーザー名を入力していません。',
    33 => 'エラーです、ログファイルに書き込めません。',
    34 => 'エラー',
    35 => 'ログアウト',
    36 => 'on',
    37 => '-',
    38 => 'フィード',
    39 => '更新',
    40 => 'パスワードリクエストエラー、ユーザーネームエラー',
    41 => 'ゲストユーザー',
    42 => '投稿者:',
    43 => 'コメントを追加',
    44 => '元の記事',
    45 => 'MySQLのエラー番号は、',
    46 => 'MySQLのエラーメッセージは、',
    47 => 'ユーザー機能',
    48 => 'マイアカウント',
    49 => '設定',
    50 => 'SQL文にエラーがあります。',
    51 => 'ヘルプ',
    52 => '新規',
    53 => '管理画面',
    54 => 'ファイルを開けません。',
    55 => 'エラーが発生 ',
    56 => '投票',
    57 => 'パスワード',
    58 => 'ログイン',
    59 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新規登録</a>",
    60 => 'コメントの投稿',
    61 => 'アカウントの登録',
    62 => 'ワード',
    63 => 'コメントの設定',
    64 => '記事を友だちにメール',
    65 => '印刷用ページ',
    66 => '',
    67 => 'ようこそ! ',
    68 => 'ホーム',
    69 => '連絡先',
    70 => '検索',
    71 => '記事投稿',
    72 => 'リンク',
    73 => '',
    74 => '',
    75 => '検索オプション',
    76 => 'サイト情報',
    77 => 'プラグイン',
    78 => '',
    79 => '新着情報',
    80 => '件の記事(',
    81 => '件の記事(',
    82 => '時間以内)',
    83 => 'コメント',
    84 => '',
    85 => '(48時間以内)',
    86 => '  -',
    87 => '(最近2週間)',
    88 => '',
    89 => '',
    90 => 'ホーム',
    91 => 'ページ作成時間',
    92 => '秒',
    93 => 'Copyright',
    94 => '本ページのすべての商標と著作権はそれぞれの所有者に帰属します。',
    95 => 'Powered by',
    96 => 'グループ',
    97 => 'ワードリスト',
    98 => 'プラグイン',
    99 => '記事',
    100 => '-',
    101 => '古い記事はありません',
    102 => '',
    103 => 'データベース',
    104 => ':',
    105 => 'メール',
    106 => '表示回数',
    107 => 'GLバージョン確認',
    108 => 'キャッシュ一括削除',
    109 => '不正報告',
    110 => '投稿をサイト管理者に報告',
    111 => '',
    112 => '登録ユーザー数',
    113 => 'ドキュメント',
    114 => 'トラックバック',
    115 => '-',
    116 => 'トラックバック',
    117 => '記事一覧',
    118 => 'Multi-page Article Navigation:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">password</a>?",
    120 => 'このコメントへのパーマリンク',
    121 => 'コメント (%d件)',
    122 => 'トラックバック (%d件)',
    123 => 'すべてのHTMLを許可。',
    124 => '選択したアイテムを削除するならここをクリック',
    125 => '選択したアイテムを削除してよいですか?',
    126 => 'すべて選択または選択を解除',
    127 => 'パーマリンク',
    128 => 'OpenIDログイン',
    129 => 'コンフィギュレーション',
    130 => 'Webサービス',
    131 => 'HTMLは使えません',
    132 => 'インフォメーション',
    133 => '重要',
    134 => 'ヘルプ',
    135 => '警告',
    136 => '警告: 強化した機能のためにJavaScriptの使用の許可を推奨します',
    137 => '警告: 機能を有効とするにはJavaScriptの使用の許可が必要です',
    138 => "アドバンストエディターを無効にして、JavaScriptが不要なノーマルエディターを有効にするには<a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">こちら</a>をクリックしてください。",
    139 => "ホームページへは<a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">こちら</a>をクリック",
    140 => '使用できる自動タグ:',
    141 => 'エラーが発生しました',
    142 => 'このページを表示する際にエラーが発生しました。しばらくしてから、もう一度お試しください。',
    143 => 'コメント (%d件)',
    144 => 'パースエラー。PHPコードをパースする際にエラーが発生しました。',
    'loginform' => "<a href=\"{$_CONF['site_url']}/users.php\">ログイン</a>",
    'remoteloginoptions' => 'リモートログイン',
    'facebook' => 'Facebookでログイン',
    'twitter' => 'Twitterでログイン',
    'linkedin' => 'LinkedInでログイン',
    'google' => 'Googleでログイン',
    'microsoft' => 'Microsoftでログイン',
    'yahoo' => 'Yahooでログイン',
    'github' => 'GitHubでログイン',
    'ctl' => 'キャッシュ一括削除',
    'ok' => 'OK',
    'filemanager' => 'ファイルマネージャー',
    'error_invalid_password' => 'エラー: パスワードが無効です',
    'error_filemanager_disabled' => 'ファイルマネージャーは無効にされています。',
    'terms_of_use' => '利用規約',
    'terms_of_service' => '利用規約',
    'privacy_policy' => 'プライバシーポリシー',
    'about_cookies' => 'クッキーについて',
    'parse_php_error' => 'PHPをパース中にエラーが発生しました: %s',
    'error_title' => 'An Error Occurred'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'コメントの投稿',
    2 => '投稿方法',
    3 => 'ログアウト',
    4 => 'アカウントを作成',
    5 => 'ユーザー名',
    6 => 'コメントの投稿にはログインが必要です。<a href="%s">ここからログイン(アカウントをお持ちでない場合はアカウントを新規作成)</a>してください。',
    7 => 'あなたは',
    8 => " 秒前にコメントしています。投稿と投稿の間は {$_CONF['commentspeedlimit']} 秒以上あけてください。",
    9 => 'コメント',
    10 => '報告',
    11 => 'コメントの投稿',
    12 => '投稿するにはタイトルと本文が必要です。',
    13 => 'あなたの情報',
    14 => 'プレビュー',
    15 => 'この投稿を報告',
    16 => 'タイトル',
    17 => 'エラーです',
    18 => '注意事項',
    19 => '内容にそった話題で投稿してください。',
    20 => 'できるだけ新しいスレッドを立てず、コメントを追加してください。',
    21 => '他の人のコメントをよく読んで同じようなコメントを投稿しないようにしてください。',
    22 => '内容がよくわかるタイトルをつけてください。',
    23 => 'あなたのメールアドレスは公開しません!',
    'instr_line6' => 'ログイン時のコメントはアカウントと関連付けられています。コメントに返信がついたときに通知を受けるかどうかを指定できます。',
    24 => 'ゲストユーザー',
    25 => 'この投稿をサイト管理者に不正な投稿として報告してよいですか?',
    26 => '%s さんが以下を不正なコメントの投稿と報告しています:',
    27 => '不正の報告',
    28 => '変更をプレビュー',
    29 => '変更を投稿',
    30 => '編集:',
    31 => 'by',
    32 => 'コメントを編集中',
    33 => 'コメントの投稿を編集中',
    34 => '投稿の変更をプレビュー',
    35 => '変更をキューに保存',
    36 => '新しい返信をメールで通知',
    37 => '新しいコメント',
    38 => 'あなたのコメント\'%s\'に返信がありました。',
    39 => '次のアドレスでコメントのスレッドを見ることができます:',
    40 => '返信の通知が不要な場合は、次のリンクを参照してください',
    41 => 'こんにちは %s,',
    42 => '通知を解除',
    43 => '返信の通知を解除',
    44 => 'あなたの名前',
    45 => "コメントをありがとうございます。 新たなコメント投稿のために {$_CONF['commentspeedlimit']} 秒以上お待ちください。",
    100 => 'コメント管理',
    101 => '既存のコメント',
    102 => '一括操作',
    103 => 'このユーザーを禁止する',
    104 => 'このIPアドレスをSpamxプラグインで禁止する',
    105 => 'IPアドレス',
    106 => 'ユーザーやIPアドレスの一括承認・削除・禁止を含めて、コメントに対するアクションを一括して行います。<span style="color: red;">赤字のIPアドレス</span>は、承認待ちのコメントをSpam-Xプラグインで禁止されたユーザーかBanプラグインで退去処分を受けたユーザーのIPです。</span><span style="color: red;">赤字のユーザー名</span>は退去処分を受けたユーザーです。',
    'record_edit' => '編集者と編集時刻を記録する',
    'ban_plugin_ban_ip' => 'BanプラグインでこのIPアドレスを禁止する',
    'num_comments' => '%s件のコメント',
    'anon_user_name' => '%s (ゲストユーザー)',
    'comments_closed_msg' => 'コメントの新規受付は終了しています。',
    'read_comment' => 'すべてのコメントを読む',
    'comment_for' => '上記のコメントは次のアイテムのものです',
    'comment_page_title' => 'Comments for %s',
    'comments' => 'Comments'
);

###############################################################################
# usersettings.php

$LANG04 = array(
    1 => 'アカウント情報',
    2 => 'ユーザー名',
    3 => '氏名',
    4 => 'パスワード',
    5 => 'メール',
    6 => 'ホームページ',
    7 => '自己紹介',
    8 => 'PGP鍵',
    9 => '保存',
    10 => '最新コメント(10件)',
    11 => '-',
    12 => 'ユーザー情報',
    13 => 'メールでダイジェストを読む',
    14 => "なお、パスワードの変更をお勧めします。\nサイトにログインして、「マイアカウント」をクリックすると、\nパスワードを変更できます。",
    15 => "{$_CONF['site_name']}からのお知らせです。\n\n{$_CONF['site_name']} であなたのアカウントを作成しました。\n下記のユーザー名とパスワードでログインしてください。\nこのメールは念のため保存してください。",
    'email_convert_remote' => "{$_CONF['site_name']} さんのリモートアカウントは通常アカウントに変換されました。このアカウントを続けて使用するには、以下の情報を用いてログインする必要があります。このメールは保存してください。",
    16 => 'ユーザー情報',
    17 => 'アカウントがありません',
    18 => '入力したメールアドレスは有効なものではないようです。',
    19 => 'ユーザー名かメールアドレスは既に使用しています。',
    20 => 'このメールアドレスは既に使用されているか、所属ドメインが禁止処分になっています。<br' . XHTML . '><br' . XHTML . '>アカウントをお持ちなら、<a href="/users.php">ここからログイン</a>してください。',
    21 => 'エラー',
    22 => "{$_CONF['site_name']}に新規登録",
    23 => "{$_CONF['site_name']}にユーザーアカウントを登録すると、コメントや記事の投稿をあなたの名前で投稿できます。そうでなければゲストユーザーとしてしか投稿できません。なお、サイト上でメールアドレスを表示することはありません。",
    24 => 'パスワードをここに入力したメールアドレス宛てに送信します。',
    25 => 'パスワードの再設定',
    26 => 'ご登録頂いているユーザー名、またはメールアドレスの<strong>どちらかを入力</strong>して「送信」ボタンを押してください。ご登録のメールアドレス宛にパスワード再設定用のURLを記載したメールを送信します。',
    27 => '新規登録',
    28 => '送信',
    29 => 'ログアウトしました:',
    30 => 'ログインしました:',
    31 => 'ログインが必要です。',
    32 => '署名',
    33 => '公開しません',
    34 => '本名',
    35 => '変更後のパスワード',
    36 => 'http:// または https:// から始めてください',
    37 => 'あなたのコメントに使用します。',
    38 => 'あなたの紹介文です。公開します。',
    39 => 'あなたの公開PGP鍵',
    42 => '日時のフォーマット',
    43 => '記事の表示最大数',
    48 => '話題',
    52 => 'デフォルト:',
    53 => 'その日の記事を毎晩メールで受け取る。',
    56 => '投稿者',
    57 => '表示モード',
    58 => '並べ替えの順序',
    59 => 'コメントの最大数',
    60 => 'コメントの表示方法',
    61 => '順番',
    62 => 'デフォルトは100件です',
    63 => "パスワードをメールで送信しました。メッセージにログイン方法をご案内しています。{$_CONF['site_name']}のご利用をお待ちしています。",
    64 => 'コメントの設定:',
    65 => '再度ログインしてください',
    66 => 'ログインに失敗しました。再度ログインしてください。',
    67 => '登録日時',
    68 => '認証の保存期間',
    69 => 'いったんログインした後、どのくらいの間認証情報を残しますか?',
    'cookietimeout_tooltip' => 'このサイトでは、一定期間アクセスがなかったため自動的にログアウトしたかどうかにかかわらず、使用中のデバイスからログインしたことを記録します。%s 秒間アクセスがないと自動的にログアウトします(これを「ユーザーセッションのタイムアウト」と呼びます)。マイアカウントの「認証の保存期間」を設定すると、その期間にはここで選択した時間に加えて「ユーザーセッションのタイムアウト」を含むことになります。',
    70 => "{$_CONF['site_name']}の表示と内容を設定",
    71 => "{$_CONF['site_name']}では、レイアウトを自由に変えることができます。そのためには、{$_CONF['site_name']}に<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">登録</a>する必要があります。もし、既に登録済みなら左のフォームを利用してログインしてください。",
    72 => 'テーマ',
    73 => '言語',
    74 => 'このサイトのデザインを変更',
    75 => '記事をメールで送信しました。送信先:',
    76 => '下記のリストから話題を選択すると、毎晩その話題の記事をメールで受け取ることができます。興味のある話題だけ選択してください。',
    77 => '写真',
    78 => '写真を追加',
    79 => '写真を削除する場合、ここをチェックしてください',
    80 => 'ログイン',
    81 => 'メール送信',
    82 => '最新投稿(10件)',
    83 => '投稿状況',
    84 => '投稿記事の総数:',
    85 => 'コメントの総数:',
    86 => 'すべての投稿を検索:',
    87 => 'あなたのログイン名',
    88 => "誰か(たぶん、あなた)があなたのアカウントの新しいパスワードを要求しました: \"%s\" サイト: {$_CONF['site_name']}, {$_CONF['site_url']}.",
    'user_password_action_msg' => 'このアクションを本当に実行するなら、次のリンクをクリックしてください: ',
    89 => "パスワードを変えたくない場合はこのメッセージを無視してください。\n(パスワードは変わりません。)",
    90 => '新しいパスワードを入力して「再設定」ボタンを押してください。',
    91 => '再設定',
    92 => 'パスワードの再設定',
    93 => 'パスワード再設定は%d秒前に行われています。このサイトでは、パスワードの再設定のリクエストには少なくとも%d秒の時間をおく必要があります。',
    94 => 'アカウント("%s")を削除',
    96 => 'アカウント削除',
    97 => 'アカウント削除の確認',
    98 => '本当にアカウントを削除しますか。削除すると、このサイトに新しいアカウントを作らない限り、ログインできなくなります。よろしければ、もう一度「アカウント削除」ボタンをクリックしてください。',
    99 => 'プライバシーオプション:',
    100 => '管理者からのメール',
    101 => 'サイト管理者からのメールを受け取る',
    102 => '他のユーザーからのメール',
    103 => '他のユーザーからのメールを受け取る',
    104 => 'オンラインの状態を表示',
    105 => '「オンラインユーザー」ブロックにアカウントを表示',
    106 => '居住地',
    107 => '公開プロフィールで表示',
    108 => 'パスワード(再入力)',
    109 => '新しいパスワードを再入力',
    110 => '現在のパスワード',
    111 => '現在のパスワードを入力してください',
    112 => 'ログインの試行回数を超えました。後ほどまたログインしてください。',
    113 => 'ログインできませんでした',
    114 => 'アカウントが無効です',
    115 => 'アカウントが無効になりましたのでログインできません。管理者に連絡してください。',
    116 => 'アカウントが有効になるのを待機しています',
    117 => 'あなたのアカウントは管理者が有効にするのを待っています。管理者が承認するまでログインできません。',
    118 => '',
    119 => '',
    120 => 'アカウントを有効にしました。',
    121 => 'サービス',
    122 => 'ユーザーの新規登録はただ今停止中です。',
    123 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新規登録</a>",
    124 => '(確認)メールアドレス',
    125 => '両方の入力欄に同じメールアドレスを入力してください。',
    126 => '確認のため再度入力してください。メールアドレスを更新すると、検証用のリンクを含むメールが新しいアドレスに送信されます。このアカウントのメールアドレスを変更するために、そのリンクをクリックする必要があります。',
    127 => '設定を変更するには、現在のパスワードを入力する必要があります。',
    128 => 'お名前',
    129 => 'パスワードとメールアドレス',
    130 => '個人情報',
    131 => '毎日のダイジェスト版オプション',
    132 => '毎日のダイジェスト版機能',
    133 => 'コメントを表示',
    134 => 'コメントオプション',
    135 => '<li>表示モードのデフォルトを設定してください。</li><li>コメントを表示する際の並べ替えの順序のデフォルトを設定してください。</li><li>表示するコメントの最大数を設定してください。デフォルトは100件です。</li>',
    138 => 'その他の設定',
    139 => 'レイアウトと言語',
    140 => '<li>1ページに表示する記事の最大数を設定してください。</li><li>テーマと好みの日時のフォーマットを設定してください。</li>',
    141 => 'プライバシーの設定',
    142 => 'デフォルトでは、他のユーザーや管理者があなたにメールを送ることができ、オンラインかどうかを表示するようになっています。プライバシーを保護するには、対応するオプションのチェックを外してください。',
    145 => '公開プロフィール',
    146 => 'パスワードとメールアドレス',
    147 => 'パスワード、メールアドレス、自動ログイン機能を編集します。パスワードとメールアドレスは確認のため、2回入力する必要があります。',
    148 => '個人情報',
    149 => '他のユーザーに表示する個人情報を編集します。<ul><li>「署名」はコメントや掲示板の投稿に付加します。自動タグを使うことができます。</li><li>「自己紹介」は他のユーザーにも読める短い自己紹介です。自動タグを使うことができます。</li><li>「PGP公開鍵」を共有しましょう。</li></ul>',
    150 => '',
    156 => 'アカウントを削除',
    157 => 'アカウントの削除オプション',
    158 => 'タイムゾーン',
    160 => '(最大. %d X %d ピクセル, %d バイト; %s)',
    161 => 'リサイズされます',
    162 => 'リサイズなし',
    163 => '再認証のエラー',
    164 => '再認証の試行回数の上限を超えました。操作は中断して、今回の編集内容は失われました。',
    165 => 'アドバンストエディターの使用',
    166 => 'リモートアカウントの再同期',
    167 => 'リモートアカウントでログインまたは登録',
    168 => 'リモート認証サービスによるログインも可能です。',
    169 => 'ユーザーのプロファイル更新',
    170 => "{$_CONF['site_name']} の管理者があなたのアカウントのパスワードを下記のように変更しました。このメールは念のため保存してください。",
    171 => '「署名」と「自己紹介」の投稿モードです。',
    'user_login' => 'ユーザーログイン',
    'user_login_message' => 'ログインしてください。ユーザー名とパスワードの両方を入力してください。',
    'user_remote_login_desc_long' => 'リモートサービスをサポートしている他のサイト上のアカウントを利用して、ログイン/アカウント作成を行うには、下のボタンをクリックしてください。このサイトでアカウントを新規作成する場合は、このサイトが名前やメールアドレス、プロフィール写真にアクセスするのを許可する必要があります。',
    'remote_register_instructions' => "<strong>注意:</strong> リモートサービスを利用してアカウントを新規作成するには、<a href=\"{$_CONF['site_url']}/users.php\" rel=\"nofollow\">ユーザーログイン</a>を行ってください。",
    'user_logged_in_message' => "すでにログインしています。<a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">ログアウト</a>しますか?",
    'user_max_login_attempts' => 'ログインの試行回数の上限を超えました、',
    'tfa_two_factor_auth' => '2段階認証',
    'tfa_help1' => '2段階認証を有効にする前に、Google認証システムのアプリケーションをモバイル端末にインストールしてください。',
    'tfa_help2' => '「2段階認証を有効にする」を「はい」にしてください。',
    'tfa_help3' => 'Google認証システムを起動して、プラスアイコンをタップし、QRコードをスキャンしてください。',
    'tfa_help4' => 'Google認証システムをインストールしたデバイスを使えない場合に備えて、下記のバックアップコードを印刷するかダウンロードしてください。各バックアップコードは1回だけ有効です。新しいバックアップコードを生成すると、現在のバックアップコードは無効になります。',
    'tfa_help5' => '画面下部の「保存」をクリックしてください。',
    'tfa_enter_code' => 'Google認証システムに表示されている%d桁の数字かマイアカウントのページに表示されていたバックアップコードを入力してください',
    'tfa_backup_code_desc' => '注意: バックアップコードは1回のみ使用でき、その後は無効になります。不足の場合は、ユーザー設定ページから改めてバックアップコードを生成してください。',
    'tfa_code' => '認証コード',
    'tfa_authenticate' => '認証',
    'tfa_qrcode' => 'QRコード',
    'tfa_show_hide' => '表示する/隠す',
    'tfa_backup_code' => 'バックアップコード',
    'tfa_download' => 'バックアップコードをダウンロード',
    'tfa_new_backup_code' => 'バックアップコードを生成し直す',
    'tfa_generate_confirm' => '実行してもよいですか?',
    'lang_tfa_user_edit_desc' => '必要に応じて(ユーザーがバックアップコードを持っていない場合など)、このフォームから2段階認証(2FA)のみを無効にすることができます。ユーザー自身がスマートフォンのGoogle認証システムアプリやバックアップコードへの対処を含め、自分のアカウントから2FAを有効にして設定する必要があるため、管理者はこれを有効にしないでください。',
    'desc_new_pwd_status' => 'アカウントのパスワードを入力する必要があります。以下にアカウントのパスワードを入力してください。<em>パスワードが更新されるまで、あなたのアカウントは使用できません。</em>',
    'new_email' => 'メールアドレス',
    'set_new_email' => 'メールアドレスの設定',
    'confirm_new_email' => 'メールアドレスの確認',
    'enter_new_email' => 'メールアドレスの入力',
    'desc_new_email_status' => 'アカウントのメールアドレスを入力する必要があります。以下にアカウントのメールアドレスを入力してください。<em>メールアドレスが更新され、検証されるまで、あなたのアカウントは使用できません。</em>',
    'email_msg_email_status_1' => "{$_CONF['site_name']}<{$_CONF['site_url']}> のアカウント \"%s\" のメールアドレスは更新されました。",
    'email_msg_verify' => 'このメールアドレスを検証するため、次のリンクをクリックしてください:',
    'email_msg_email_status_2' => 'このメールアドレスを検証せずにアカウントへログインすると、新しいメールアドレスの入力と検証のプロセスが再度必要になります。',
    'email_verify' => '検証対象のメールアドレス',
    'email_verify_delete' => '検証対象のメールアドレスを削除',
    'email_verify_msg' => "あなたのアカウントのメールアドレスは更新されていますが、検証が必要です。{$_CONF['site_name']}から送信された検証用のリンクを含むメールを確認してください。あなたがそのリンクをクリックし、メールアドレスが検証されると、アカウントが有効になります。<br" . XHTML . "><br" . XHTML . ">あなたの希望により、上の入力欄でメールアドレスを更新するか、削除することができます。",
    'remove_account_msg' => 'あなたのアカウントを削除するには、上の「現在のパスワード」にパスワードを入力してから、下の「アカウントの削除オプション」にチェックを入れ、「保存」をクリックしてください。ただし、あなたのアカウント名で投稿した記事やコメントの<strong>削除はしません</strong>。これらの記事やコメントは「ゲストユーザー」の投稿として表示するようになります。',
    'remove_remote_account_msg' => 'あなたのリモートアカウントを削除するには、下の「アカウントの削除オプション」にチェックを入れ、「保存」をクリックしてください。ただし、あなたのアカウント名で投稿した記事やコメントの<strong>削除はしません</strong>。これらの記事やコメントは「ゲストユーザー」の投稿として表示するようになります。',
    'theme_info' => '%1$s %2$s (Geeklog %3$sが必要)'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'プレビュー',
    'pe_namepass' => 'ユーザー名とパスワード',
    'pe_userinfo' => '個人情報',
    'pe_layout' => 'レイアウトと言語',
    'pe_content' => 'コンテンツ',
    'pe_privacy' => 'プライバシー'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '表示する記事がありません',
    2 => 'この話題の記事はありません。',
    3 => '',
    4 => '今日の注目記事',
    5 => '次へ',
    6 => '前へ',
    7 => '最初',
    8 => '最後',
    9 => 'ページナビゲーション'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'メッセージを送信する際にエラーが発生しました。もう一度試してください。',
    2 => 'メッセージを送信しました。',
    3 => 'メールアドレスを正しく入力してください。',
    4 => '名前、メールアドレス、件名、内容をすべて入力してください',
    5 => 'エラー: 該当するユーザーはいません。',
    6 => 'エラーが発生しました。',
    7 => 'ユーザー情報',
    8 => '氏名',
    9 => 'URL',
    10 => 'メールの宛先',
    11 => '名前:',
    12 => 'メールアドレス:',
    13 => '件名:',
    14 => '本文:',
    15 => 'HTMLタグは使えません。',
    16 => '送信',
    17 => '友だちに記事を送信する',
    18 => '宛先の名前',
    19 => '宛先のアドレス',
    20 => '発信元の名前',
    21 => '発信元のEmail',
    22 => 'すべての項目を入力してから、送信ボタンをクリックしてください',
    23 => "この記事にあなたが興味を持つかもしれないと思った (%s) さんが {$_CONF['site_name']} ( {$_CONF['site_url']} )からメッセージを送ってきました。このメッセージを送るのに使用されているメールアドレスはデータベースに保存されていません。",
    24 => 'この記事に関するコメントは次の場所でできます。',
    25 => 'この機能を使用するためにはログインしてください。',
    26 => 'このフォームでメールを送ります。',
    27 => 'メッセージ',
    28 => '%s さんからのメッセージ: ',
    29 => "これは {$_CONF['site_name']} ( %s ) からのデイリーダイジェストです。以下の記事は、前回このメールが送られてきた後で更新された最新の記事です。",
    30 => ' 今日のニュースレターです。宛先: ',
    31 => 'タイトル',
    32 => '日付',
    33 => '以下の場所で記事全体を読むことができます。',
    34 => 'メッセージは以上です',
    35 => 'このユーザーはメールを受け付けていません。',
    36 => 'コピー:',
    37 => '自分宛にコピーを送信する',
    38 => "これはあなたが<{$_CONF['site_url']}>から %s へ送信したメールのコピーです:",
    39 => 'あなたはメッセージを ',
    40 => " 秒前に送信しています。少なくとも{$_CONF['speedlimit']}秒待って、次のメッセージを送信してください。",
    41 => 'このユーザーは存在しません。',
    42 => 'このユーザーのメールアドレスは存在しません。おそらくOAuthユーザーのアカウントでしょう。',
    43 => 'このユーザーのメールアドレスは無効です。',
    44 => 'このユーザーのステータスは、「アクティブ」または「新しいパスワード」以外に設定されているため、メールアドレスは無効とみなされます。',
    45 => "このメッセージは {$_CONF['site_name']} の %s さんからのメッセージです。返信は次のメールアドレスに送ってください: %s",
    46 => "デイリーダイジェストを解除するには、 {$_CONF['site_name']} の {$_CONF['site_url']} にログインしてください。その後、 {$_CONF['site_url']}/usersettings.php のユーザー設定のページへ行き、コンテンツタブの話題のチェックボックスを全て外してから保存すると、デイリーダイジェスト配信を解除できます。"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '検索オプション',
    2 => 'キーワード',
    3 => '話題',
    4 => 'すべて',
    5 => 'タイプ',
    6 => '記事',
    7 => 'コメント',
    8 => '投稿者',
    9 => 'すべて',
    10 => '検索',
    11 => '検索結果',
    12 => '件が該当',
    13 => '記事の検索結果: 該当なし',
    14 => '該当するものはありませんでした',
    15 => '他のキーワードで検索してください。',
    16 => 'タイトル',
    17 => '日付',
    18 => '投稿者',
    19 => " {$_CONF['site_name']} サイト内を検索します。",
    20 => '日付',
    21 => ' - ',
    22 => '(書式は YYYY-MM-DD)',
    23 => 'Views',
    24 => '%d件、見つかりました',
    25 => '次のキーワードについて検索:',
    26 => '件',
    27 => '秒',
    28 => '該当する記事・コメントは見つかりませんでした',
    29 => '記事・コメントの検索結果:',
    30 => '',
    31 => 'プラグインからは該当するものを見つかりませんでした',
    32 => '',
    33 => 'URL',
    34 => '場所',
    35 => '一日中',
    36 => 'キーワードの形式',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '検索文字列は3文字以上必要です。',
    42 => '日付の書式は、YYYY-MM-DD(年-月-日)としてください。',
    43 => '完全一致',
    44 => 'すべて含む',
    45 => 'いずれか含む',
    46 => '次',
    47 => '前',
    48 => '投稿者',
    49 => '日付',
    50 => '表示数',
    51 => '',
    52 => '場所',
    53 => '記事の検索結果',
    54 => 'コメントの検索結果',
    55 => '検索文字列',
    56 => 'AND',
    57 => 'OR',
    58 => '次の検索結果へ &gt;&gt;',
    59 => '1ページあたりの件数',
    60 => '件',
    61 => '検索条件の修正',
    62 => '#',
    63 => '詳細',
    64 => '検索結果 %1$d - %2$d / %3$d 件',
    65 => '記事',
    66 => 'コメント',
    67 => '検索結果 %d 件',
    68 => '並べ替え',
    69 => 'タイトルのみ',
    70 => 'ありません ...',
    71 => '昇順',
    72 => '降順',
    73 => '実行',
    74 => '件数'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'サイトに関する統計',
    2 => 'システム全体のアクセス数',
    3 => '記事数(コメント数)',
    4 => 'Site Statistic',
    5 => "Overall Site Statistics for {$_CONF['site_name']}",
    6 => '',
    7 => '記事(上位10件)',
    8 => '記事のタイトル',
    9 => '件',
    10 => 'このサイトには記事の投稿がないか、記事を表示した人がいません。',
    11 => 'コメントのあった記事(上位10件)',
    12 => '件',
    13 => 'このサイトには記事の投稿がないか、コメントした人がいません。',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'メールで紹介された記事(上位10件)',
    23 => 'メールアドレス',
    24 => 'メールで紹介された記事はありません。',
    25 => 'トラックバックのあった記事(上位10件)',
    26 => 'トラックバックはありません。',
    27 => 'アクティブユーザー数',
    28 => '',
    29 => '',
    30 => '表示回数',
    31 => '',
    32 => 'お気に入りの記事(上位10件)',
    33 => 'お気に入りの記事はありません。'
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '関連情報',
    2 => '友だちに記事をメールする',
    3 => '印刷用ページ',
    4 => '記事のオプション',
    5 => '',
    6 => '\'%s\'を購読する'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => ' %s を投稿する前にログインしてください。',
    2 => 'ログイン',
    3 => '新規登録',
    4 => '',
    5 => '',
    6 => '記事の投稿',
    7 => 'ログインが必要です',
    8 => '投稿',
    9 => 'このサイトに情報を投稿する際には、次のルールを守ってください。<ul><li>必要なすべての項目を入力してください。</li><li>正確かつ必要十分な情報を提供してください。</li><li>URLについては特に注意して確認してください。</li></ul>',
    10 => 'タイトル',
    11 => '',
    12 => '開始日',
    13 => '終了日',
    14 => '場所',
    15 => '詳細',
    16 => '',
    17 => '',
    18 => '',
    19 => 'はじめにお読みください',
    20 => '',
    21 => '',
    22 => '入力に不備があります',
    23 => 'すべてのフィールドに入力してください。',
    24 => '投稿を受け付けました',
    25 => '%s に関する投稿を受け付けました。',
    26 => '投稿間隔の制限',
    27 => 'ユーザー名',
    28 => '話題',
    29 => '記事',
    30 => '前回、あなたは、',
    31 => "秒前に投稿しています。投稿間隔を{$_CONF['speedlimit']}秒以上にしてください。",
    32 => 'プレビュー',
    33 => '記事のプレビュー',
    34 => 'ログアウト',
    35 => 'HTMLタグは使用できません',
    36 => '投稿モード',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => '住所1',
    45 => '住所2',
    46 => '市町村名',
    47 => '都道府県',
    48 => '郵便番号',
    49 => '',
    50 => '',
    51 => '場所',
    52 => '削除',
    53 => 'アカウント作成',
    54 => '記事冒頭文',
    55 => '記事本文'
);

###############################################################################
# LIKES feature since Geeklog 2.2.1

$LANG_LIKES = array(
    'like' => '気に入った!',
    'unlike' => '「気に入った!」を取り消す',
    'dislike' => '好きじゃない!',
    'undislike' => '「好きじゃない!」を取り消す',
    'likes' => '気に入った!',
    'unlikes' => '「気に入った!」を取り消した',
    'dislikes' => '好きじゃない!',
    'undislikes' => '「好きじゃあ位!」を取り消した',
    'i_like_this' => 'この記事が気に入った!',
    'i_dislike_this' => 'この記事は好きじゃない!',
    'thanks_for_action' => '投票に感謝します!',
    'likes_speedlimit' => 'あなたは %s 秒前にお気に入りを投票しました。このサイトでは次にお気に入りの記事を投票する前に少なくとも %s 秒待つ必要があります。',
    'likes_ip_error' => 'あなたのIPアドレスから既にお気に入りは投票されています。',
    'likes_uid_error' => 'あなたのアカウントを用いて既にお気に入りは投票されています。',
    'own_item_error' => '自分自身のアイテムに対してはお気に入りは実行できません。',
    'liked_by' => 'Liked by:',
    'disliked_by' => 'Disliked by:',
    'num_anon_users' => '<br' . XHTML . '>%s 名のゲストユーザー',
    'one_anon_users' => '<br' . XHTML . '>1 名のゲストユーザー',
    'num_more_users' => '<br' . XHTML . '>さらに %s 名のユーザー',
    'username_in_likes_list' => '<br' . XHTML . '>%s',
    'autotag_desc_likes_block' => "[likes_block:aid action:aid wrapper:wid class:likes-autotag type: subtype: time:604800 max:10 cache:3600 line:1 length:20]
\n	- Likesブロックを表示します。パラメーターは不要です。パラメーターを指定しない場合、コンフィギュレーションの既定値を使用します。 
\n	- action = 1 (Likesのみ), 2 (Dislikesのみ), または 3 (両方) 
\n	- wrapper = 0 (ラッパーなし), 1 (ブロックのラッパーとタイトル), divラッパーとCSSクラス), または両方
\n	- class = divラッパーが有効にする場合、ラッパーが使用するCSSクラス。そうでなければ、likes-autotagの既定値を使用 
\n	- type = 全てのタイプの場合は空白にし、それ以外の場合は 'article' や 'comment' などのタイプを1つ指定
\n	- subtype = 必要な場合、typeのサブタイプを指定
\n	- time = Likesブロックに表示するアイテムの公開期間。0を指定すると全てのアイテムを表示
\n	- max = 表示するアイテムの最大数
\n	- cache = Likesブロックをキャッシュする秒数。キャッシュを無効にする場合は0を指定
\n	- line = Likesのアイコンを改行してから表示
\n	- length = アイテムのタイトルをこの文字数にまで切り詰める",
    'num_likes_in_time_limit' => '指定期間内にこのアイテムが受け取ったLikesの最後の数。',
    'num_dislikes_in_time_limit' => '指定期間内にこのアイテムが受け取ったDislikesの最後の数。',
    'num_likes_total' => 'このアイテムが受け取ったLikesの総数。',
    'num_dislikes_total' => 'このアイテムが受け取ったDislikesの総数。',
    'likes_time_span' => '過去 %t 内に最も多くのLikesを集めたアイテム: %s',
    'dislikes_time_span' => '過去 %t 内に最も多くのDislikesを集めたアイテム: %s',
    'all_time_span' => '過去 %t 内に最も多くの人の興味を引いたアイテム: %s',
    'whats_liked' => 'Likeされたアイテム',
    'whats_recently_liked' => '最近、Likeされたアイテム',
    'whats_disliked' => 'Dislikeされたアイテム',
    'whats_recently_disliked' => '最近、Dislikeされたアイテム',
    'whats_popular' => '人気アイテム',
    'whats_recently_popular' => '最近の人気アイテム',
    'whats_liked_type' => 'Likeされた %s',
    'whats_recently_liked_type' => '最近、Likeされた %s',
    'whats_disliked_type' => 'Dislikeされた %s',
    'whats_recently_disliked_type' => '最近、Dislikeされた %s',
    'whats_popular_type' => '人気 %s',
    'whats_recently_popular_type' => '最近の人気 %s',
    'no_liked_items_in_time_limit' => '指定した期間内にLikesはありません。',
    'no_disliked_items_in_time_limit' => '指定した期間内にDislikesはありません。',
    'no_action_items_in_time_limit' => '指定した期間内にLikesもDislikesもありません。',
    'no_liked_items' => 'Likeされたアイテムはありません。',
    'no_disliked_items' => 'Dislikeされたアイテムはありません。',
    'no_action_items' => 'LikeされたアイテムもDislikeされたアイテムもありません。',
    'last_num_likes_by' => '最近の %s LikesとDislike by %s',
    'msg_no_likes' => 'ユーザーが見つけたLikesもDislikesもありません。',
    'total_num_likes' => 'LikesとDislikesの総数:',
    'title_liked' => '%s さんがLike: ',
    'title_disliked' => '%s さんがDislike: ',
    'articles' => '記事',
    'comments' => 'コメント'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'ログビューワー',
    'info' => 'Geeklog ログファイルを管理します。',
    'logs' => 'ログ',
    'view' => 'ログファイルを見る',
    'clear' => 'ログファイルを消す',
    'log_file' => 'ログファイル'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => '以下の問題を解決してください。解決したら、<b>再チェック</b>ボタンをクリックして環境チェックしてください。　',
    'current' => 'カレント',
    'current_php_settings' => 'PHPの現在の設定',
    'directory_permissions' => 'ディレクトリパーミッション',
    'enabled' => '有効',
    'env_check' => '環境チェック',
    'file_permissions' => 'ファイルパーミッション',
    'file_uploads' => "Geeklogの多くの機能がファイルのアップロードを要求するので有効にしてください。\n",
    'filesystem_check' => 'ディレクトリ / ファイルパーミッション',
    'gd_lib' => 'GDライブラリ',
    'gd_not_found' => 'GDライブラリ関数を利用できません。GDライブラリがPHPにコンパイルされているかどうか確認してください。あるいは代替のライブラリを選択してください。',
    'gd_ok' => 'GDライブラリv2 がインストールされています。',
    'gd_v1' => 'GDライブラリv1 がインストール - このバージョンは JPG 画像の処理すべてに対応していません。そのため何らかの不具合が生じることがあります。',
    'graphics' => 'グラフィックライブラリ',
    'libraries' => 'ライブラリ',
    'hosting_env' => 'ホスティング環境チェック',
    'imagemagick' => 'ImageMagick プログラム',
    'im_not_found' => 'ImageMagickの<strong>変換</strong>を有効にできません。',
    'im_ok' => '<strong>変換</strong>が有効です。',
    'memory_limit' => 'サイトでは少なくとも 48M のメモリーが必要です。',
    'not_writable' => '書き込み不可',
    'notes' => '注意',
    'not_found' => 'みつかりません',
    'netpbm' => 'NetPBMライブラリ',
    'np_ok' => 'NetPBMライブラリがインストール',
    'np_not_found' => 'NetPBMを有効にできません。',
    'fileinfo_library' => 'ファイル情報ライブラリ',
    'fileinfo_ok' => 'ファイル情報(Fileinfo)ライブラリがロードされています。このライブラリは記事の画像をアップロードする場合に必要です。アップロードされる画像ファイルのサムネイルを作成する際に、MIMEタイプを取得するために使用されます。',
    'fileinfo_not_found' => 'ファイル情報(Fileinfo)ライブラリがロードされていません。このライブラリは記事エディタで画像をアップロードする場合に<strong>のみ</strong>必要です。',
    'openssl_library' => 'OpenSSLライブラリ',
    'openssl_ok' => 'OpenSSLがロードされています。このライブラリはログインにOAuthを使用したり、メール送信にSMTPプロトコルを使用するために必要です。',
    'openssl_not_found' => 'OpenSSLライブラリがロードされていません。このライブラリはログインにOAuthを使用したり、メール送信にSMTPSプロトコルを使用する場合に<strong>のみ</strong>必要です。',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => '<strong>open_basedir</strong> の制限がこのサイトで有効な場合、インストールの際にパーミッションで問題が起きるかもしれません。以下のファイルシステムチェックを行ってください。',
    'database_settings' => 'データベース設定',
    'database_mysql_version' => 'MySQLバージョン',
    'database_mysql_req_version' => 'GeeklogにはMySQLバージョン4.1.2以降が必要です(MySQL 5推奨)。',
    'database_pgsql_version' => 'PostgreSQLバージョン',
    'database_pgsql_req_version' => 'GeeklogにはPostgreSQLバージョン9.1.7以降が必要です。',
    'database_dms' => 'データベース管理システム',
    'database_dms_notes' => 'データベース管理システムを判断できませんでした。GeeklogにはMySQLかPostgreSQLが必要です。',
    'php_req_version' => 'GeeklogにはPHP version 5.6.4以降が必要です。',
    'php_settings' => 'PHPの設定',
    'php_version' => 'PHPのバージョン',
    'php_warning' => '以下のリストで<span class="no">赤文字の箇所</span>があれば、あなたのGeeklogサイトで問題が発生するかもしれません。これらのPHP設定をホスティングプロバイダーの情報に照らし合わせてチェックしてください。',
    'post_max_size' => 'Geeklogはプラグインと画像、ファイルのアップロードを許可しています。アップロードファイル制限を少なくとも8M以上にしてください。',
    'recheck' => '環境を再チェック',
    'recommended' => '推奨',
    'setting' => '設定',
    'unable_mkdir' => 'ディレクトリ作成が可能',
    'upload_max_filesize' => 'Geeklogプラグインと画像、ファイルのアップロードが有効です。アップロードファイル制限を少なくとも8M以上にしてください。',
    'not_checked' => 'スキップ',
    'bypass_note' => 'open_basedir制限を検出したので、グラフィックライブラリのチェックをスキップしました。',
    'not_used_note' => 'Geeklogのグラフィックライブラリはセットされていません。',
    'location' => 'ロケーション',
    'status' => 'ステータス',
    'item' => 'アイテム',
    'jhead' => 'jheadプログラム',
    'jhead_not_found' => 'jheadを有効にできません。',
    'jhead_ok' => 'jheadはインストールされています。',
    'jpegtran' => 'jpegtranプログラム',
    'jpegtran_not_found' => 'jpegtranを有効にできません。',
    'jpegtran_ok' => 'jpegtranはインストールされています。',
    'showhide_phpinfo' => 'phpinfo 表示/非表示',
    'view_online' => 'オンライン表示はここ %s をクリック',
    'no_new_items' => '新アイテムはありません',
    'max_execution_time' => 'Geeklogは最少値として30秒を要求していますが、プラグインアップロードなどを行う場合、サーバー環境によってはそれ以上を要求します。php.iniで<b>max_execution_time</b> を増やすことで対応できます。',
    'phpinfo_disabled' => '現在のPHPの設定を見るには、ホスティング会社に連絡してphpinfo()関数を有効にする必要があります。'
);

###############################################################################
# For Demo Mode (since v2.2.1)

$LANG_DEMO = array(
    'header' => 'ヘッダー',
    'subject' => '件名:',
    'to' => '宛先:',
    'from' => '差出人:',
    'priority' => '優先度:',
    'body' => '本文',
    'notice' => '注意',
    'emails_disabled_msg' => 'デモモードではメールの送信は行われません。送られるメールは次の通りです:'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '管理権限が必要です',
    2 => 'ログインできません。もう一度入力してください',
    3 => 'パスワードが違います。ユーザー名:',
    4 => 'ユーザー名:',
    5 => 'パスワード:',
    6 => "このページは管理者のみ使用できます。管理ツールの使用はすべて記録・検査しています。<br" . XHTML . "><br" . XHTML . ">現在表示されているログインフォームはローカルアカウント専用です。リモートアカウントでログインする場合は、<a href=\"{$_CONF['site_url']}/users.php\">メイン・ログインフォーム</a>を使用してください。",
    7 => 'ログイン',
    8 => 'ログイン',
    9 => 'このページは管理者のみ使用できます。管理ツールの使用はすべて記録・検査しています。'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'ここを管理する権限がない',
    2 => 'このブロックを編集する権限がありません。',
    3 => 'ブロックの編集',
    4 => 'フィードの読み込みでエラーが発生しました。(error.logを参照してください。)',
    5 => 'はい',
    6 => 'いいえ',
    7 => 'すべて',
    8 => 'ブロックのセキュリティレベル',
    9 => '順序',
    10 => '',
    11 => 'ポータルブロック',
    12 => 'ノーマルブロック',
    13 => 'ポータルブロックのオプション',
    14 => 'フィードURL',
    15 => 'フィード更新日時',
    16 => 'ノーマルブロックのオプション',
    17 => 'コンテンツ',
    18 => 'ブロックのタイトル・セキュリティレベル・コンテンツを入力してください。',
    19 => 'ブロック管理',
    20 => '標準ブロック',
    21 => 'セキュリティ',
    22 => 'ダイナミックブロック',
    23 => '順序',
    24 => 'ダイナミック',
    25 => 'ブロックの編集・削除は編集アイコンを、ブロックの作成は上の「新規作成」をクリックしてください。ブロックの移動は、[↑][↓][R][L]をクリックしてください。 ',
    26 => 'レイアウト用ブロック',
    27 => 'PHPブロック',
    28 => 'PHPブロックのオプション',
    29 => '関数',
    30 => 'PHPを使用したブロックを使う場合に、その関数名を上に入力してください。関数名は"phpblock_"で始まる名前(例えば、phpblock_themetester)でなければなりません。この条件に合わない関数を呼び出すことは*ありません*。これは、Geeklogに不正侵入しようとする悪者が、システムに有害となるかもしれない好き勝手な関数の呼び出しを避けるためです。関数名の後に"()"を付けると、2つの引数と共に呼び出しします。第一引数は gl_blocksテーブルの配列です。第二引数は、2つの括弧の間に記述した、どのようなテキストであれ、それが文字列として渡ります。最後に、すべてのPHPブロックのコードは/path/to/geeklog/system/lib-custom.phpに記述することを推奨します。そうすることで、新しいバージョンのGeeklogにアップグレードしたときでも、コードを維持できるようになります。(訳注: 日本語版では、フォルダー system/customを作成し、その中にカスタム関数を入れて、よりアップグレードしやすい構成にしています。)',
    31 => 'PHPブロックにエラーがあります。関数%sが存在しません。',
    32 => 'エラー。未入力の項目があります',
    33 => 'ポータルブロックのフィードURLを入力してください',
    34 => 'PHPブロックにはタイトルと関数名を入力してください',
    35 => 'ノーマルブロックにはタイトルと内容を入力してください',
    36 => 'レイアウト用ブロックには内容を入力してください',
    37 => 'PHPブロックの関数名が不適切です',
    38 => 'PHPブロックの関数名は\'phpblock_\'で始まる名前(例: phpblock_themetester)でなければなりません。この条件は任意のコードの実行を防ぐセキュリティ上の理由で必要となっています。',
    39 => '表示場所',
    40 => '左',
    41 => '右',
    42 => 'ブロックのタイトルと表示順序を入力してください。',
    43 => 'ホームページのみ',
    44 => 'マルチプル',
    45 => "管理権限のないブロックを編集しようとしました。このアクセスを記録しました。<a href=\"{$_CONF['site_admin_url']}/block.php\">ブロックの編集</a>画面に戻ってください.",
    46 => '移動',
    47 => 'なし',
    48 => 'ブロックID',
    49 => '(スペース不可)',
    50 => 'ブロックIDを入力してください。',
    51 => 'ヘルプファイルがURLを含む場合は、http://かhttps://から始めてください',
    52 => 'この欄を空白にしておくと、このブロックのヘルプアイコンは表示されません。(ポップアップウィンドウを使用できるよう)HTMLファイルを指定する場合は、そのファイルを public_html/help ディレクトリ内の適切な言語のサブディレクトリ内に配置してください(この機能は多言語をサポートしません)。',
    53 => '有効',
    54 => '保存',
    55 => 'キャンセル',
    56 => '削除',
    57 => 'ブロックを下に',
    58 => 'ブロックを上に',
    59 => 'ブロックを右側に',
    60 => 'ブロックを左側に',
    61 => 'タイトルなし',
    62 => '表示件数',
    63 => 'ブロックのタイトルが不適切です',
    64 => 'タイトルは空欄にはできず、HTMLを含めてはなりません!',
    65 => '順番',
    66 => '自動タグ',
    67 => '自動タグの使用を許可',
    68 => 'このポータルブロックのフィードは長すぎて表示できません。ブロック設定画面でブロックに表示する記事の最大数を設定するか、コンフィギュレーションで標準の最大数を設定してください。',
    69 => 'プラグイン名',
    70 => 'CSS ID',
    71 => 'この項目はオプションです',
    72 => 'CSSクラス名',
    73 => 'この項目はオプションです。スペースで区切って複数指定できます。',
    'autotag_desc_block' => '[block:name class:block-autotag] - ブロックを表示します。Classはオプションです。ClassにCSSクラスを指定すると、ブロックはdivタグで包まれます。block-autotagクラスは常にそのdivタグに含まれます。',
    'newlines' => '改行',
    'convert_newlines' => '改行 (行末文字) をHTMLの&lt;br&gt;要素に変換する',
    'position' => '位置',
    'cache_time' => 'キャッシュ期間',
    'cache_time_desc' => 'このブロックは指定された秒数の間キャッシュされます。0 を指定するとキャッシュしません。(3600 = 1時間、86400 = 1日)',
    'block_type_gldefault' => 'システム',
    'block_type_normal' => 'ノーマル',
    'block_type_phpblock' => 'PHP',
    'block_type_portal' => 'ポータル',
    'block_type_dynamic' => 'ダイナミック'
);

###############################################################################
# Block Locations

$LANG23 = array(
    'blocks_article_footer_name' => '記事のフッター',
    'blocks_article_footer_desc' => '記事のフッター部にブロックを表示します。',
    'blocks_article_topic_list_name' => '記事の話題',
    'blocks_article_topic_list_desc' => '話題のX個目の記事の直後にブロックを表示します。'
);

###############################################################################
# admin/article.php

$LANG24 = array(
    1 => '前の記事',
    2 => '後の記事',
    3 => 'モード',
    4 => '投稿モード',
    5 => '記事の編集',
    6 => '記事がありません',
    7 => '投稿者',
    8 => '保存',
    9 => 'プレビュー',
    10 => 'キャンセル',
    11 => '削除',
    12 => '記事ID',
    13 => '',
    14 => '',
    15 => '日時',
    16 => '冒頭文',
    17 => '本文',
    18 => '表示回数',
    19 => 'コメント数',
    20 => 'ピング',
    21 => 'トラックバック・ピングを送る',
    22 => '記事の一覧',
    23 => '記事を修正/削除するには、該当記事の編集アイコンをクリックしてください。記事を閲覧するには、タイトルをクリックしてください。記事を作成するには上にある「新規作成」をクリックしてください<br' . XHTML . '><br' . XHTML . '>記事の編集・閲覧権は記事自体のアクセス権だけではなく、その記事が割り当てられている話題のアクセス権の最小値でも決定されます。<br' . XHTML . '><br' . XHTML . '>「編集権のみ」は編集権のある記事(とドロップダウンの話題)を表示します。これにチェックを入れて表示される記事が編集禁止になる場合は、記事に対する編集権はあるがその記事に割り当てられている話題に対する編集権がないということを意味します。',
    24 => '指定した記事IDは既に使われています。別の記事IDを入力してください。',
    25 => '記事の登録中にエラーが発生しました',
    26 => '記事のプレビュー',
    27 => '<p>自動タグ[imageX]のかわりに[unscaledX]を使うと、画像をオリジナルのサイズで表示します。</p>',
    28 => '<p><strong>プレビュー</strong>: 画像付きの記事をプレビューする場合はプレビューボタンをクリック*しないで*、いったんドラフトモードで保存してください。プレビューボタンは画像を含まない場合だけクリックしてください。</p>',
    29 => 'トラックバック数',
    30 => 'ファイルのアップロード時にエラーが発生しました',
    31 => 'タイトルと冒頭文を入力し、話題を少なくとも1つ選択してください',
    32 => '注目記事',
    33 => '注目記事は最後に指定した1つだけとなります',
    34 => 'ドラフト',
    35 => '○',
    36 => '－',
    37 => '同じ投稿者からの投稿:',
    38 => '同じ話題:',
    39 => 'メール紹介',
    40 => '',
    41 => "管理権限のない記事を編集しようとしました。このアクセスを記録しました。下記の記事は読み取り専用で見ることができます。読み終わったら、<a href=\"{$_CONF['site_admin_url']}/article.php\">記事の編集画面</a>に戻ってください。",
    42 => "管理権限のない記事を編集しようとしました。このアクセスを記録しました。<a href=\"{$_CONF['site_admin_url']}/article.php\">記事の編集画面</a>に戻ってください",
    43 => '',
    44 => '',
    45 => '',
    46 => '<strong>注意:</strong> 記事の日時を将来の日時に変更すると、その日まで記事を公開しません。これはフィードにも含めず、検索と統計情報にも反映しないことを意味します。',
    47 => '画像',
    48 => '画像',
    49 => '右',
    50 => '左',
    51 => '<p>記事に添付した画像は、自動タグで記述してください。書式は、[imageX]、[imageX_right]、[imageX_left](Xは添付した画像の番号)(例 [image1])。注意: 添付した画像は記事内ですべて使用しなければ記事を保存できません。<br' . XHTML . '><strong>プレビュー</strong>: 画像付きの記事の確認はいったんドラフト(下書き)として保存して表示してください。プレビューの機能は画像が無いときにのみ利用できます。</p>',
    52 => '',
    53 => 'を使用していません。保存する前に冒頭文または本文で、この画像を使用しなければなりません。',
    54 => '添付した画像を使用していません。',
    55 => '記事を保存する際に下記のエラーが発生しました。保存する前に修正してください。',
    56 => '話題アイコンの表示',
    57 => '元のサイズの画像を表示',
    58 => 'アーカイブ',
    59 => 'オプション',
    60 => '',
    61 => '自動アーカイブ',
    62 => '自動削除',
    63 => 'コメントの設定',
    64 => '',
    65 => '',
    66 => '',
    67 => '編集エリアの拡大',
    68 => '編集エリアの縮小',
    69 => '投稿日時と公開モードの設定',
    70 => 'ツールバーの選択',
    71 => '基本的なツールバー',
    72 => '一般的なツールバー',
    73 => '拡張ツールバー',
    74 => '拡張ツールバーその2',
    75 => '全機能',
    76 => '公開オプション',
    77 => 'アドバンストエディターを有効にするには、ブラウザーでJavaScriptを有効にする必要があります。このオプションはコンフィギュレーションの管理パネルで無効にできます。',
    78 => '<a href="%s/article.php?mode=edit&amp;sid=%s&amp;editopt=default">ノーマルエディターを使う場合</a>',
    79 => 'プレビュー',
    80 => 'エディター',
    81 => '公開オプション',
    82 => '画像',
    83 => 'アーカイブ',
    84 => 'パーミッション',
    85 => 'すべて表示',
    86 => 'アドバンストエディター',
    87 => '記事の情報',
    88 => 'Wikiスタイル',
    89 => '説明文のメタタグ',
    90 => 'キーワードのメタタグ',
    91 => '「プレビュー」ボタンをクリックすれば、いつでも有効期限を延長できます。',
    92 => '同じテーマの記事',
    93 => '#',
    94 => 'リサイズ',
    95 => 'オリジナル',
    96 => 'アップロード | 置き換え',
    97 => 'なし',
    'autotag_desc_story' => '[story: id 代替タイトル] - 記事へのリンクを表示します。同じ機能を果たすarticle自動タグを使用してください。',
    'autotag_desc_article' => '[article: id 代替タイトル] - 記事タイトルをタイトルとして使用して記事へのリンクを表示します。代替タイトルを指定できますが、必須ではありません。',
    'cache_time' => 'キャッシュ期間',
    'cache_time_desc' => 'この記事を指定した秒数の間キャッシュします。0 を指定すると、キャッシュしません。(3600 = 1時間、86400 = 1日)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '話題の編集',
    2 => '話題ID',
    3 => '話題名',
    4 => '話題アイコンのファイルを指定',
    5 => '(半角英数字とハイフン)',
    6 => '話題を削除すると、(削除する話題にだけ関連付けしている)記事、投稿、ブロックもすべて削除します。',
    7 => '話題IDと話題名を入力してください',
    8 => '話題の管理',
    9 => '話題の編集や削除をするには、以下の話題のアイコンをクリックしてください。新しい話題を作成するには上の「新規作成」をクリックしてください。括弧内はあなたの話題のアクセスレベルです。アスタリスク(*)はデフォルトの話題を示します。',
    10 => '順序',
    11 => '1ページあたりの記事数',
    12 => 'アクセスできません',
    13 => "管理権限のない話題を編集しようとしました。このアクセスを記録しました。<a href=\"{$_CONF['site_admin_url']}/topic.php\">話題の編集画面</a>に戻ってください",
    14 => '並べ替え方法',
    15 => 'アルファベット順',
    16 => '記事数のデフォルト:',
    17 => '新規話題',
    18 => '管理画面',
    19 => '保存',
    20 => 'キャンセル',
    21 => '削除',
    22 => 'デフォルト',
    23 => 'この話題を新しい項目と記事投稿の際のデフォルトに設定できます。',
    24 => '(*)',
    25 => 'アーカイブ',
    26 => 'この話題をアーカイブ記事用の話題にします。アーカイブ記事用の話題に設定できるのは1つだけです。',
    27 => '話題アイコンをアップロード',
    28 => '最大',
    29 => 'ファイルアップロード時にエラー発生しました',
    30 => 'この話題の記事数',
    31 => '制限しているトピックIDを使用しました。別のIDにしてください。',
    32 => '親の話題',
    33 => '継承',
    34 => '子の話題を継承',
    35 => '隠す',
    36 => '話題を隠して、直接には表示できないようにします。話題は継承だけに使用します。',
    37 => 'ルート',
    38 => 'すべて',
    39 => 'ホームページのみ',
    40 => '話題を少なくとも1つ割り当ててください。',
    41 => '「すべて」を選択すると、すべての話題に対する記事を表示します。「ホームページのみ」を選択すると、ホームページにしか表示しません。',
    'topic_control_select_topics' => 'または、この記事に割り当てる話題を少なくとも1つ選択してください。',
    'topic_control_select_topics_disabled' => 'または、編集権のある話題を少なくとも1つ選択してください。(薄い色で表示されています)。',
    'topic_control_no_topics' => '残念ながら、編集権のある話題がないので、話題を選択することができません。',
    42 => '継承の欄は割り当てられている話題のリストを含んでいます。話題を選択すると、その話題の親の話題に継承されます。',
    43 => 'デフォルトは、割り当てた話題のリストを含んでいます。これは、ユーザーが実際の話題をみつけられないときに、アイテムを表示する時に使用するデフォルトの話題です。',
    44 => '継承',
    45 => 'デフォルト',
    46 => '親の話題に、アーカイブの話題は設定できません。異なる親の話題を選んでください。',
    47 => 'アーカイブの話題には、子の話題を設定できません。アーカイブの話題に設定する前に子の話題を取り除いてください。',
    48 => '親の話題IDが見つかりません。',
    49 => 'この話題IDは既に使用しています。別の話題IDを使用してください。',
    50 => 'はい',
    51 => 'いいえ',
    52 => '記事',
    53 => '画像',
    54 => '選択',
    55 => '割り当て',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'ホーム',
    'autotag_desc_topic' => '[topic: id 代替タイトル] - IDをタイトルとして使用して話題へのリンクを表示します。代替タイトルを指定できますが、必須ではありません。',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - IDとプラグインタイプに基づいて関連話題のクリック可能な水平リストを作成します。',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - IDとプラグインタイプに基づいて関連アイテムのクリック可能なリストを作成します。',
    'no_related_items' => '関連アイテムがありません。',
    'topics:' => '話題:',
    'filed_under:' => '話題:',
    'topic_title' => '話題タイトル',
    'topic_title_desc' => '話題のページタイトルとして使用されます。 空の場合、話題名が使用されます。',
    'move_topic_up' => '話題のソート順位を上げる',
    'move_topic_down' => '話題のソート順位を下げる',
    'topics_edit_access_select' => '編集権のある話題(薄い色で表示されています)しか選択できません。',
    'topics_edit_access_listed' => '編集権のある話題しか一覧に表示されません。'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'ユーザーの編集',
    2 => 'ユーザーID',
    3 => 'ユーザー名',
    4 => '氏名',
    5 => 'パスワード',
    6 => 'セキュリティレベル',
    7 => 'メールアドレス',
    8 => 'ホームページ',
    9 => '(半角英数字とハイフン)',
    10 => 'ユーザー名・メールアドレスを入力してください。',
    11 => 'ユーザー管理',
    12 => 'ユーザーの編集や削除は、ユーザーの編集アイコンをクリックしてください。、ユーザーを表示するには、表示したいユーザー名をクリックしてください。ユーザーを作成するには、上の「新規作成」をクリックしてください。(訳註: ユーザーの一括登録(インポート)は「一括登録」をクリック、ユーザーの一括削除は「一括削除」をクリックしてください。)',
    13 => 'セキュリティ',
    14 => '登録日',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '保存',
    21 => '登録しようとしたユーザー名は既に存在します。',
    22 => 'エラー',
    23 => '一括登録',
    24 => 'ユーザーの一括登録',
    25 => 'ユーザーをGeeklogに一括登録できます。一括登録するファイルはタブ区切りのテキストファイルで、「氏名、ユーザー名、メールアドレス」の順序のフィールドでなければなりません。一括登録したユーザーには、無作為に選択したパスワードを含んだメールを送信します。1行に1ユーザーとしなければなりません。この手順で何らかのエラーを起こすと手作業による作業が必要となりますから、二重に各項目を検査してください!  (訳註: ファイルはかならず本サイトと同じ文字コードのテキスト形式で保存してください。)',
    26 => '',
    27 => '',
    28 => 'チェックした画像を削除します',
    29 => 'パス',
    30 => '実行',
    31 => '新規ユーザー',
    32 => '処理を完了しました。登録成功: %d 件 エラー: %d 件',
    33 => '検索',
    34 => 'エラー: 登録するファイルを指定してください。',
    35 => '最後のログイン日時',
    36 => '未',
    37 => 'ユーザーID',
    38 => 'グループ一覧',
    39 => 'パスワード(再入力)',
    40 => '登録日',
    41 => '最終ログイン',
    42 => '禁止',
    43 => '有効となるのを待機中',
    44 => '承認が通るのを待機中',
    45 => '有効',
    46 => 'ユーザーのステータス(状態)',
    'user_status_desc' => "ユーザーが取り得るすべてのステータスの説明: <ul>\n        <li><strong>有効となるのを待機中</strong> - 新規ユーザーがログインするのを待機中です。ユーザー宛にメールを送信していますが、まだメールアドレスを検証していません。このステータスは新規アカウント専用で自動的に設定されます(管理者が手動でこのステータスを設定することはできません)。</li>\n        <li><strong>承認が通るのを待機中</strong> - 管理者が承認するのを待っている新規アカウントです。承認すると、ユーザー宛にパスワードを記したメールを送信します。このステータスは新規アカウント専用で自動的に設定されます(管理者が手動でこのステータスを設定することはできません)。</li>\n        <li><strong>有効</strong> - 有効なアカウントです。</li>\n        <li><strong>禁止</strong> -  このアカウントは禁止されているか無効にされています。このユーザーがこのサイトで投稿したどのコンテンツでもユーザー名に取り消し線が引かれています。ユーザーはログインできず、メールは無効になっており、管理者以外のユーザーがプロフィールを閲覧することもできません。</li>\n        <li><strong>ロック中</strong> - このアカウントはロックされています。ユーザーはログインできず、メールは無効になっていますが、すべてのユーザーがプロフィールを閲覧することは可能です。</li>\n        <li><strong>メールアドレスを更新する必要あり</strong> - このアカウントのメールは無効になっています。ユーザーが次回ログインするときにメールアドレスを更新・確認しないと(このアカウントでは)サイトの他の部分にアクセスできません。メールアドレスを確認するまではこのステータスは変わりません。コンフィギュレーションの\"ユーザーに新しいメールアドレスを要求する\"が「はい」の場合は、(リモートアカウントを含めて)メールアドレスを登録していない全てのユーザーがログインしようとすると自動的にこのステータスになります。</li>\n        <li><strong>パスワードを更新する必要あり</strong> -  ユーザーがログインするときにパスワードを更新しないと、(このアカウントでは)サイトの他の部分にアクセスできません。このステータスが適用されるのはローカルアカウントのみでリモートアカウントは対象外です。</li>\n        </ul>\n    ",
    47 => '編集',
    48 => '管理者グループを表示',
    49 => '管理者グループ',
    50 => 'このグループを管理者グループとしてフィルタリングするには、チェックしてください。',
    51 => 'オンライン期間',
    52 => '<br' . XHTML . '>注: 「オンライン期間」とは、最初にアカウントを登録してから前回ログインした時までの日数です。',
    53 => '登録済み',
    54 => '一括削除',
    55 => 'この機能はコンフィギュレーションの管理パネルで「最終ログインを記録する」を有効に設定している場合にのみ動作します。',
    56 => '削除したいユーザーの種類を選択して「リスト更新」をクリックしてください。次に、削除したくないユーザーのチェックを外して、削除アイコンをクリックしてください。このリストがページをまたがっている場合、現在表示しているユーザーだけ削除しますので注意してください。.  The Contributed column also cannot be sorted and only lists the total number of items contributed for Articles, Comments and by any plugin items that support this feature.',
    57 => '幽霊ユーザー',
    58 => '一時的ユーザー',
    59 => '過去のユーザー',
    60 => '一度もログインしていない、',
    61 => 'ヶ月以前に登録したユーザーです。',
    62 => '登録して24時間以内にログインした後で一度もログインしていない、',
    63 => 'ヶ月以前に登録したユーザーです。',
    64 => '通常のユーザーでサイトを、',
    65 => 'ヶ月間、訪問していないユーザーです。',
    66 => 'リストを更新',
    67 => '登録して月数',
    68 => 'オンライン時間',
    69 => 'オフライン月数',
    70 => '削除できませんでした',
    71 => '削除しました',
    72 => '削除するユーザーを選択していません',
    73 => '削除すると元に戻せませんが、選択したユーザーをすべて削除してよいですか?',
    74 => '最近のユーザー',
    75 => '最近',
    76 => 'ヶ月に登録したユーザーです。',
    77 => '選択したユーザーにログインのリマインダーをメールで送信',
    78 => 'リマインダーを送信',
    79 => 'リマインダーを送信するユーザーを選択していません',
    80 => 'リマインダーを送信しました',
    81 => '%sのアカウントを検証するためのリマインダー',
    82 => "あなたの{$_CONF['site_name']}のアカウントは%sからアクセスしていません。今後30日以内にアクセスしないと無効になりますのでご注意ください。",
    83 => "あなたの{$_CONF['site_name']}のアカウントは作成後使用していません。このままアクセスしないと近日中に削除しますのでご注意ください。",
    84 => "あなたのログイン名: %s  サイト名: {$_CONF['site_url']}",
    85 => 'パスワードを紛失した場合には、以下のリンクをクリックしてください: ',
    86 => '含む',
    87 => 'リマインダー',
    88 => 'デフォルトグループ',
    89 => '新規登録ユーザーのデフォルトグループをチェック',
    90 => '登録済みユーザーアカウントにデフォルトグループを追加する',
    91 => 'パスワードをメールで送信する',
    92 => '新しいユーザーまたは既存のユーザーのパスワードを変更する場合のみ。',
    'convert_remote' => 'リモートアカウントをローカルアカウントに変換するにはここをチェックしてください。',
    'convert_remote_desc' => 'リモートアカウントをローカルアカウントに変換すると、パスワードが自動的に生成されます。アカウントに確認済みのメールアドレスがない場合、パスワードを取り出すことができないため変換後にアカウントをロックします。変換を行い、アカウントが有効でかつ有効なメールアドレスを登録している場合、ユーザーにメールでパスワードを送付しますが、ログインページからパスワード再設定のリンクを使用して、パスワードを請求することもできます。無効なアカウントや有効なメールアドレスを登録していないユーザーには手動でアカウントの変更とログイン方法をを通知する必要があります。',
    'contributed' => 'Contributed',
    'na' => 'NA',
    'nothing' => 'Nothing',
    'autotag_desc_user' => '[user: name 代替タイトル] - ユーザー名をタイトルとしてユーザーへのリンクを表示します。代替タイトルを指定できますが、必須ではありません。',
    'USER_ACCOUNT_LOCKED' => 'ロック状態',
    'USER_ACCOUNT_NEW_EMAIL' => 'メールアドレスの設定が必要',
    'USER_ACCOUNT_NEW_PASSWORD' => 'パスワードの設定が必要'
);

###############################################################################
# admin/moderation.php
# admin/index.php

$LANG29 = array(
    1 => '承認',
    2 => '削除',
    3 => '編集',
    4 => 'プロフィール',
    10 => 'タイトル',
    11 => '開始日',
    12 => 'URL',
    13 => '投稿',
    14 => '日付',
    15 => '話題',
    16 => 'ユーザー名',
    17 => '氏名',
    18 => 'メールアドレス',
    34 => '管理画面TOP',
    35 => '記事の投稿申請',
    36 => 'コメントの親',
    37 => 'Author',
    38 => '実行',
    39 => '現在のところ申請はありません',
    40 => 'ユーザーの登録申請',
    41 => 'コメントの投稿申請',
    42 => 'ユーザー名',
    43 => 'コメントを自動的に公開?',
    44 => '投稿の処理結果',
    45 => 'ユーザーが投稿している項目のうち %1$d 件を承認、%2$d 件を削除しました。',
    46 => 'ユーザーのプロファイル更新通知',
    'core' => 'コア',
    'plugins' => 'プラグイン',
    'tools' => 'ツール',
    'users' => 'ユーザー',
    'submissions_desc' => 'ユーザーの投稿を編集または削除するには、そのアイテムの編集アイコンをクリックしてください。投稿を一括して承認・削除するには、リストのラジオボタンを選択してから保存をクリックしてください。ほとんどの場合、アイテムは最も新しいものから順に並べ替えられます。',
    'max_invalid_login' => 'ログイン失敗最大回数',
    'max_invalid_login_msg' => "このユーザーは、指定時間内({$_CONF['invalidloginmaxtime']}秒)にログイン失敗最大回数({$_CONF['invalidloginattempts']}回)に達しました。最後にログインに失敗したIPは %s です。登録ユーザーがパスワードを忘れたのかもしれませんが、誰かがこのユーザーのアカウントのパスワードを推測しようとしているのかもしれません。"
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => 'メール送信',
    2 => '送信者名',
    3 => '返信先',
    4 => '件名',
    5 => '内容',
    6 => '送信先:',
    7 => 'すべてのユーザー',
    8 => '管理者',
    9 => 'オプション',
    10 => 'HTML',
    11 => '緊急!',
    12 => 'メールを送信する',
    13 => '入力しなおす',
    14 => 'ユーザーの受信許可設定を無視して送る',
    15 => '送信中にエラーが発生。宛先: ',
    16 => 'メッセージの送信を完了しました。宛先: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>別のメッセージを送る</a>",
    18 => '送信先',
    19 => '補足: 登録者全員に送信するには、送信先のドロップダウンメニューから「Logged-in Users」を選択してください。',
    20 => '<p><successcount> messages was sent successfully and <failcount> messages failed to send.</p><p>The details of the message attempts are below:</p>',
    21 => '送信に失敗',
    22 => '送信に成功',
    23 => '失敗した送信先はありません',
    24 => '成功した送信先はありません',
    25 => '-- グループを選択 --',
    26 => 'すべてのフィールドに入力してください。また、グループはドロップダウンメニューから選択してください。',
    27 => '次のテンプレート変数が<strong>件名</strong>と<strong>内容</strong>で使用できます: {uid}, {username}, {fullname}, {email}, {homepage}, {theme}, {language}, {location}, {lastgranted}, {lastlogin}, {site_url}, {site_name}, {site_slogan}, {owner_name}, {copyrightyear}, {site_mail}, {noreply_mail}',
    'email_divider' => '------------------------------------------------------------',
    'email_divider_html' => '<hr' . XHTML . '>',
    'sig_divider' => '---',
    'sig_divider_html' => '---<br' . XHTML . '>',
    'email_footer_msg_noreply' => 'このメールを送信するのに使用されたメールアドレスは監視されていません。このメールには返信しないでください。',
    'email_footer_msg_content' => 'Webサイトのコンテンツがこのメールに表示される場合、レイアウトが変更され、その結果問題が生じることもあります。',
    'ip_address_email' => 'このメールの送信元 IP アドレス:'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'プラグインのインストールはGeeklogに、最悪の場合はシステムに悪影響を与える可能性があります。Geeklogの公式サイトに登録してある、すべてのプラグインは様々なオペレーティングシステムで十分にテストしていますから、<a href="https://www.geeklog.net">Geeklogのホームページ</a>からダウンロードしたプラグインだけをインストールすることが重要です。プラグインのインストールの処理ではファイルシステムのコマンドの実行が必要となることを理解することが重要です。特に公式サイト以外が提供しているプラグインを使用する場合にセキュリティの問題を招く可能性があります。これらの警告をしていますが、Geeklogのプラグインのインストールできることを保証しませんし、プラグインをインストールしたことによる損傷に責任は持てません。言い換えれば、自己責任でインストールしてください。プラグインを手作業でインストールする方法の説明は各プラグインのパッケージに含まれています。',
    2 => 'プラグインのインストールに関する注意',
    3 => 'プラグインのインストールのフォーム',
    4 => 'プラグインのファイル',
    5 => 'プラグインの一覧',
    6 => '警告: プラグインは既にインストール済みです。',
    7 => 'インストールしようとしているプラグインは既に存在します。再インストールする前にいったん削除してください。',
    8 => 'プラグインの互換性チェックに失敗しました。',
    9 => 'このプラグインはより新しいバージョンのGeeklogに対応しています。<a href="https://www.geeklog.jp">Geeklog</a>をアップグレードしてください。(訳註: または、Geeklogに対応しているバージョンのプラグインを入手してください。)',
    10 => '<br' . XHTML . '><strong>インストールしているプラグインはありません。</strong><br' . XHTML . '><br' . XHTML . '>',
    11 => '<b>インストール済みプラグイン</b>で、作者のwebサイトなどの詳細を表示するには情報アイコンをクリックしてください。このリストでプラグインを読み込む順番を変えたり、有効化・無効化することができます。プラグインをアンインストールすると、データベースから関連データとともに削除されます。プラグインのファイルを更新し、データベースの情報をまだ更新していない場合は、プラグインのバージョンの列に更新するオプションが表示されます。現在インストールされているバージョンとプラグインのコードから読み取ったバージョンの両方が表示されます。<br' . XHTML . '><br' . XHTML . '><b>インストール可能なプラグイン</b>のリストでは、アップロード済みのプラグインをインストールすることができ(インストール権限を持っている場合)、アンインストールしたプラグインのファイルを削除することもできます(アップロード権限を持っている場合)。プラグインのファイルを削除しても、削除されるのは非公開領域/pluginsディレクトリ下のプラグインのディレクトリ、公開領域直下のプラグインのディレクトリ、公開領域/admin/pluginsディレクトリ下のプラグインのディレクトリとファイルだけです。この3つのディレクトリ以外にプラグインが持っているファイルは削除されません(手動で削除する必要があります)。',
    12 => 'plugineditor()にプラグイン名が渡されませんでした',
    13 => 'プラグイン情報センター',
    14 => 'インストール可能なプラグイン',
    'installed_plugins' => 'インストール済みのプラグイン',
    15 => '管理画面',
    16 => 'プラグイン名',
    17 => 'プラグインのバージョン',
    18 => 'Geeklogのバージョン',
    19 => '有効',
    20 => 'はい',
    21 => 'いいえ',
    22 => 'インストール',
    23 => '保存',
    24 => 'キャンセル',
    25 => '削除',
    26 => 'プラグイン名',
    27 => 'プラグインWebページ',
    28 => 'インストールしているバージョン',
    29 => 'Geeklogのバージョン',
    30 => 'このプラグインを削除しますか?',
    31 => 'このプラグインを本当に削除しますか?  削除するとプラグインが使用しているデータやデータ構造をすべて削除します。削除する場合は下の「削除」ボタンをもう一度クリックしてください。',
    32 => '<p><strong>自動タグのフォーマットエラーです。</strong></p>',
    33 => 'コードのバージョン',
    34 => 'アップデート',
    35 => '編集',
    36 => 'コード',
    37 => 'データ',
    38 => 'アップデートを実行!',
    39 => 'プラグインのアップロード',
    40 => 'プラグインの圧縮ファイル (.tar.gz, .tgz, .zip) を直接ここにアップロードできます:',
    41 => 'アップロード',
    42 => 'アップデート',
    43 => 'ロードの順番',
    44 => 'ロードの順番を上げる',
    45 => 'ロードの順番を下げる',
    46 => 'プラグインを削除する',
    47 => '%s プラグインを本当に削除してよいですか?',
    48 => 'プラグインを有効にする',
    49 => 'プラグインを無効にする',
    50 => '依存関係',
    51 => 'OK',
    52 => '未解決',
    53 => '無効',
    54 => '利用不可',
    55 => 'インストールしていない',
    56 => '誤ったバージョン',
    57 => '不明',
    58 => '依存関係を解決するため、プラグインをロードする順番を変更しました。',
    59 => '情報',
    60 => '閉じる',
    61 => '状態',
    62 => 'プラグインをインストールする',
    63 => 'プラグインをインストールできませんでした',
    64 => 'プラグインを有効にできませんでした',
    65 => 'プラグインアップロードの機能は以下のエラーのため無効にしています。:',
    66 => 'PHPの設定でファイルアップロードは無効となっています。',
    67 => 'ディレクトリ "%s" は書き込みできません。',
    68 => 'あなたにはプラグインをインストールする権限はありません。',
    69 => 'あなたにはプラグインをアップロードする権限はありません。',
    'delete' => '削除',
    'delete_plugin' => 'プラグインと関連するファイルを全て削除しますか?',
    'click_to_delete_msg' => 'プラグインのファイルを削除するにはココをクリック',
    'really_delete_msg' => '%s プラグインのファイルを本当に削除しますか?',
    99 => '不明なエラーが発生しました。',
    100 => 'Ok.',
    101 => 'アップロードしようとしたファイルのサイズが php.ini 内の upload_max_filesize の値を超えています。',
    102 => 'アップロードファイルのサイズがHTMLのフォームで指定していた MAX_FILE_SIZE の値を超えています。',
    103 => 'アップロードしたファイルは一部分だけでした。',
    104 => 'アップロードできませんでした。',
    105 => '(未定義のエラー)',
    106 => '一時フォルダーがありません。',
    107 => 'ディスクにファイルを書き込みできませんでした。',
    108 => 'ファイルの拡張子の制限のためアップロードを中止しました。'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'フィードの作成',
    2 => '保存',
    3 => '削除',
    4 => 'キャンセル',
    10 => 'フィード',
    11 => '新しいフィード',
    12 => '管理画面',
    13 => 'フィードを編集や削除するには下の編集アイコンをクリックしてください。フィードを作成するには上の「新規作成」をクリックしてください。',
    14 => 'タイトル',
    15 => 'タイプ',
    16 => 'ファイル名',
    17 => 'フォーマット',
    18 => '更新日',
    19 => '有効',
    20 => 'はい',
    21 => 'いいえ',
    22 => '<i>(フィードはありません)</i>',
    23 => 'すべての話題',
    24 => 'フィードの編集',
    25 => 'フィードタイトル',
    26 => '制限',
    27 => 'エントリの長さ',
    28 => '(0 = 本文なし、1 = 本文すべて、その他 = 指定した文字数に制限)',
    29 => '説明',
    30 => '更新日時',
    31 => '文字セット',
    32 => '言語',
    33 => 'コンテンツ',
    34 => 'エントリ数',
    35 => '時間',
    36 => 'フィードのタイプを選択してください。',
    37 => '',
    38 => 'エラー: 入力していない項目があります。',
    39 => 'フィードのタイトル、詳細、ファイル名を入力してください。',
    40 => 'エントリ数または、取得する時間を入力してください。',
    41 => 'リンク',
    42 => '',
    43 => 'すべて',
    44 => 'なし',
    45 => '話題にヘッダーリンク',
    46 => '表示件数',
    47 => '検索',
    48 => '編集',
    49 => 'フィードロゴ',
    50 => "本サイト({$_CONF['site_url']})からの相対URL",
    51 => '選択したフィード名は他のフィードで使用しています。異なる名前にしてください。',
    52 => 'エラー: このファイル名を既に使用しています',
    53 => 'トップページのすべての記事',
    54 => '新規作成するフィードのタイプを選んでください。',
    55 => '記事',
    'num_articles' => '%s 件の記事'
);

###############################################################################
# admin/language.php (since v2.1.2)

$LANG_LANG = array(
    'language_admin_title' => '翻訳言語書き換え',
    'language_manager' => '言語管理',
    'new_language_msg' => '言語の編集や削除は下の編集アイコンをクリックしてください。新しい言語の作成は上の「新規作成」をクリックしてください。',
    'language_editor' => '言語の編集',
    'id' => 'ID',
    'language' => '言語',
    'name' => '名前',
    'var_name' => '変数名',
    'name_tip' => '言語変数が配列の場合に限り必要です。',
    'var_name_tip' => '配列でも普通の変数でも指定できます。変数名の前のドル記号($)は入力しないでください。',
    'value' => '値'
);

###############################################################################
# admin/router.php

$LANG_ROUTER = array(
    1 => 'URLルーティング',
    2 => 'ルーティング管理',
    3 => 'ID',
    4 => 'メソッド',
    5 => 'ルール',
    6 => 'ルート',
    7 => '優先順位',
    8 => '優先順位を上げる',
    9 => '優先順位を下げる',
    10 => 'ルーティングの編集',
    11 => 'ルーティングの編集・削除は編集アイコンを、作成は上の「新規作成」をクリックしてください。優先順位の変更は、[↑][↓]をクリックしてください。プレースホルダー(@)を使用する場合は、ルールとそのルートに同じプレースホルダーを定義する必要があります。現在、URLルーティングは記事、話題、静的ページ、記事一覧、リンクプラグインのみをサポートしています。',
    12 => 'リクエストメソッドが不正です。',
    13 => 'ルールは必須項目です。',
    14 => 'ルートは必須項目です。',
    15 => 'ルールとルートで同じプレースホルダー(@)を定義しなければなりません。',
    16 => 'ルートの先頭を "/index.php/" とすることはできません。',
    17 => 'データベース操作でエラーが発生しました。',
    18 => '<strong>URLルーティングを有効にするには、コンフィギュレーションでURLリライトを有効にしてください。</strong>',
    19 => '<strong>URLルーティングを有効にするには、コンフィギュレーションでURLルーティングを有効にしてください。</strong>',
    20 => '<ul><li>プレースホルダー(@)はルールとルートで同じものを定義してください。</li><li>プレースホルダーは@で始まり、1文字目は英字、2文字目以降は英数字を使えます。</li><li>プレースホルダーは大文字・小文字を区別します。</li><li>ステータスコードは200にしてください。これを変更すると、予期しない問題が発生する可能性があります。</li></ul>',
    21 => 'ステータスコード',
    22 => '有効',
    23 => 'はい',
    24 => 'いいえ'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "パスワードをメールで送信しましたので確認してください。利用方法はメールを参照してください。{$_CONF['site_name']}",
    2 => "{$_CONF['site_name']} に記事を投稿していただきありがとうございます。記事はスタッフによる承認待ちとなっています。承認が済むと、記事はサイトに公開します。",
    3 => '',
    4 => '',
    5 => 'アカウント情報を保存しました。',
    6 => '表示を設定しました。',
    7 => 'コメントを設定しました。',
    8 => 'ログアウトしました。',
    9 => '記事を保存しました。',
    10 => '記事を削除しました。',
    11 => 'ブロックを保存しました。',
    12 => 'ブロックを削除しました。',
    13 => '話題を保存しました。',
    14 => '話題とその話題に属するすべての記事とブロックを削除しました',
    15 => 'あなたのコメントは投稿済みです。管理者の承認後に公開されます。',
    16 => 'あなたは登録を解除しました。今後、新たな通知を受けることはありません。',
    17 => 'あなたのアカウントはロックされており、そのアカウントへのアクセスは無効になっています。詳細については、管理者に連絡してください。',
    18 => '',
    19 => '',
    20 => '',
    21 => 'ユーザー情報を保存しました。',
    22 => 'ユーザー情報を削除しました。',
    23 => 'パスワードが一致しません。再度入力してください。パスワードは大文字と小文字が区別されます。',
    24 => 'メールアドレスが一致しません。再度入力してください。',
    25 => 'メールアドレスが無効です。再度入力してください。',
    26 => '入力したメールアドレスはすでに他のアカウントで使用されています。再度入力してください。',
    27 => 'メッセージを送信しました。',
    28 => 'プラグインを保存しました',
    29 => 'あなたはこの管理ページにアクセスできません。権限のない機能へのアクセスはすべて記録しています。',
    30 => 'アクセスできません',
    31 => '申し訳ありませんが、この機能はお使いのデータベースサーバーがサポートしていません。未サポート機能へのアクセスは全てログに記録されます。',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'システムからのメッセージ',
    41 => '',
    42 => '',
    43 => 'アカウントは存在しません。',
    44 => 'プラグインをインストールしました!',
    45 => 'プラグインを削除しました。',
    46 => 'ユーザー名またはメールアドレスが一致しません。再度入力してください。',
    47 => '申し訳ありませんが、現在アカウントのパスワードをリクエストできません。詳細については、管理者に連絡してください。',
    48 => "{$_CONF['site_name']}にご登録ありがとうございます。管理者の間で審査します。登録を承認すると、あなたの入力したメールアドレスにパスワードを送信します。",
    49 => 'グループを保存しました。',
    50 => 'グループを削除しました。',
    51 => '既に使用しているユーザー名です。別の名前を指定してください。',
    52 => '入力したメールアドレスは有効なメールアドレスではないようです。',
    53 => '新しいパスワードを登録しました。この新しいパスワードを使ってログインしてください。',
    54 => 'あなたの新規パスワード発行申請は期限が切れています。下のフォームから再申請してください。',
    55 => 'メールを送信しました。届いたメールの指示にしたがって新しいパスワードを設定してください。',
    56 => 'メールアドレスは別のアカウントが既に使用しています。',
    57 => 'アカウントの削除を完了しました。',
    58 => 'フィードを保存しました。',
    59 => 'フィードを削除しました。',
    60 => 'プラグインをアップデートしました。',
    61 => '%sプラグイン: メッセージのプレイスホルダーが不明です。',
    62 => 'トラックバックのコメントを削除しました。',
    63 => 'トラックバックのコメントを削除するときにエラーが発生しました。',
    64 => 'トラックバックのコメントを送信しました。',
    65 => 'Weblog ディレクトリサービスを保存しました。',
    66 => 'Weblog ディレクトリサービスを削除しました。',
    67 => '新しいパスワードが確認用パスワードと一致しません! パスワードは大文字と小文字が区別されます。',
    68 => '正しい現在のパスワードを入力してください。',
    69 => 'アカウントをロックしました。',
    70 => 'アカウントは管理者の承認待ちです。',
    71 => 'アカウントの確認を行いました、そして管理者の承認待ちです。',
    72 => 'プラグインをインストールしている間にエラーが発生しました。error.logを確認してください。',
    73 => 'プラグインをアンインストールしている間にエラーが発生しました。error.logを確認してください。',
    74 => 'ピングバックを送信しました。',
    75 => 'トラックバックはPOSTリクエストを使用して送信しなければなりません。',
    76 => 'この項目を削除してもよいですか?',
    77 => '警告:<br' . XHTML . '>エンコーディングのデフォルトをUTF-8に設定していますが、サーバーがマルチバイトのエンコーディングをサポートしていません。PHPにmbstringモジュールをインストールするか、UTF-8ではない文字セットや言語に変更してください。',
    78 => 'メールアドレスと確認用メールアドレスには同じものを入力してください。',
    79 => '開こうしたページは、このサイトにもはや存在していないアイテムを参照しています。',
    80 => 'このフィードを作成したプラグインは現在無効となっています。そのプラグインを再び有効にするまで、フィードの編集はできません。',
    81 => 'ログイン情報の入力が不正確だったようです。もう一度、ログインし直してください。',
    82 => 'ログインの試行回数を超えました。後ほどまたログインしてください。',
    83 => 'パスワード、メールアドレス、認証の保存期間を変更するには現在のパスワードを入力してください。',
    84 => 'アカウントを削除するには現在のパスワードを入力してください。',
    85 => 'メールの送信に問題がありました。',
    86 => 'OpenIDのサーバがログインを受け付けませんでした。',
    87 => 'OpenIDのログイン処理をユーザーが取り消しました。',
    88 => 'OpenIDのサーバがエラーを返しました。',
    89 => '指定した識別のURLに対するOpenIDのサーバのURLが見つかりません。',
    90 => 'OpenIDの識別を取り消しました。',
    91 => '無効な識別のURLを指定しました。',
    92 => "使用する前に<a href=\"{$_CONF['site_admin_url']}/sectest.php\">Webサイトのセキュリティチェックを行ってください</a>!",
    93 => 'データベースのバックアップしました。',
    94 => 'バックアップのエラー: ファイルサイズが1Kバイト未満です。',
    95 => 'エラーが発生しました。',
    96 => '',
    97 => '',
    98 => 'プラグインをアップロードしました。',
    99 => 'プラグインは既に存在します。',
    100 => 'アップロードしたファイルは GZip または Zip で圧縮したアーカイブではありませんでした。',
    101 => '(アクセスできる)話題はありません。記事を投稿するには少なくとも1つの話題が必要です。',
    110 => '認証用のURLを取得できません。',
    111 => '認証のエラーが発生しました。',
    112 => '証明書は取り消されています。',
    113 => 'アカウントをTwitter経由で作成しました。 {site_url}',
    114 => 'リモートアカウントの再同期に失敗しましたが、他のアカウント情報を保存しました。',
    115 => 'リモートサービスは無効となりました。',
    116 => '読み込み中...',
    117 => 'ヘルプが見つかりません。',
    118 => 'クリックして日付を選択してください',
    119 => 'More..',
    120 => 'この項目を送信しますか?',
    121 => 'URLルーティングのデータを保存しました。',
    122 => 'URLルーティングのデータを保存できませんでした。',
    123 => 'URLルーティングのデータを削除しました。',
    130 => '言語アイテムを削除しました。',
    131 => '言語アイテムを保存しました。',
    140 => 'コメントを削除しました。',
    141 => 'コメントを削除できませんでした。',
    142 => 'コメントを承認しました。',
    143 => 'ユーザーを禁止しました。',
    144 => 'IPアドレスをSpam-Xプラグインで禁止しました。',
    145 => 'BanプラグインでIPアドレスを禁止しました。',
    150 => 'インストール時に使用したすべてのファイルとディレクトリを削除しました。',
    151 => 'インストール時に使用したファイルとディレクトリを削除しようとしましたが、一部を削除できませんでした。お手数ですが、手動で削除してください。',
    152 => 'インストール時に使用したすべてのファイルとディレクトリはそのまま残っています。このまま残しておくのは危険なので、お手数ですが、手動で削除してください。',
    153 => 'あなたは %1$d 秒前に友だちに記事を送信しています。次に送信する前に %2$d 秒以上あけてください。',
    160 => 'プラグインのファイルを削除しました。',
    161 => '圧縮ファイルの中に不適切なファイル名を持つファイルが含まれています。',
    400 => '検証に通っていない必須のフィールドがあります。',
    401 => '氏名を入力してください。',
    500 => 'テンプレートのキャッシュを削除しました。',
    501 => '検証のメッセージがあなたのメールアドレスに送信されました。電子メールのリンクをクリックして、メールアドレスを検証し、アカウントを更新してください。 メールアドレスを検証する前に再度アカウントにログインすると、メールアドレスを再度尋ねられます。<br' . XHTML . '><br' . XHTML . '>あなたはこの検証を完了できるように、正常にログアウトされました。',
    502 => '新しいメールアドレスのリクエストが期限切れになりました。以下からもう一度お試しください。',
    503 => 'あなたのメールアドレスは正常に検証されました。',
    504 => 'パスワードは8文字以上で、少なくとも1つの数字と1文字を含める必要があります。パスワードは大文字と小文字が区別されます。',
    505 => "<em>現在設定されているサイトの規定のテーマ \"{$_CONF['theme_site_default']}\" は無効です。</em> Geeklog の規定テーマ \"{$_CONF['theme']}\" を使用します。<br" . XHTML . "><br" . XHTML . ">お使いのGeeklog (v2.2.1) がサポートしているテーマの最低バージョンは v{$_CONF['min_theme_gl_version']} です。<br" . XHTML . "><br" . XHTML . ">Geeklog のコンフィギュレーションで有効なテーマを選び直してから、保存してください。",
    506 => "<em>現在設定されているサイトの規定のテーマ \"{$_CONF['theme_site_default']}\" は無効です。</em> Geeklog の規定テーマ \"{$_CONF['theme']}\" を使用します。<br" . XHTML . "><br" . XHTML . ">お使いのGeeklog (v2.2.1) がサポートしているテーマの最低バージョンは v{$_CONF['min_theme_gl_version']} です。<br" . XHTML . "><br" . XHTML . ">Geeklog のコンフィギュレーションで有効なテーマを選び直してから、保存してください。"
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'アクセス',
    'ownerroot' => '所有者/Root',
    'group' => 'グループ',
    'readonly' => '読み取り専用',
    'accessrights' => 'アクセス権',
    'owner' => '所有者',
    'grantgrouplabel' => '上記のグループに編集権限を付与',
    'permmsg' => '注意: メンバーとはすべてのログインしているサイトのメンバーで、ゲストユーザーはログインせずにアクセスしているすべての利用者です。',
    'securitygroups' => 'セキュリティグループ',
    'editrootmsg' => "管理権限を持っていても、rootユーザーにならずにrootユーザーの編集はできません。rootを除いた他のすべてのユーザーを編集できます。不正にrootユーザーを編集しようする試みはすべて記録していることに注意してください。<a href=\"{$_CONF['site_admin_url']}/user.php\">ユーザー管理ページ</a>に戻る",
    'securitygroupsmsg' => 'ユーザーを所属させたいグループのチェックボックスにチェックを入れてください。チェックが入っているが選択不可になっているグループは、必要なコアグループかユーザーが直接所属しているグループから継承されているグループです。',
    'groupeditor' => 'グループの編集',
    'description' => '説明',
    'name' => '名前',
    'rights' => '権限',
    'missingfields' => '未入力の項目',
    'missingfieldsmsg' => '名前と説明を入力してください。',
    'groupmanager' => 'グループの管理',
    'newgroupmsg' => 'グループの編集や削除は下の編集アイコンをクリックしてください。新しいグループの作成は上の「新規作成」をクリックしてください。ただし、「コア(中核)グループ」はシステムで使用するため削除できません。',
    'groupname' => 'グループ名',
    'coregroup' => 'コアグループ',
    'yes' => 'はい',
    'no' => 'いいえ',
    'corerightsdescr' => "このグループは、{$_CONF['site_name']}の「コア(中核)グループ」です。そのため、このグループの権限を編集することはできません。このグループの権限リストを読み取り専用で以下に表示しています。",
    'groupmsg' => 'このサイトのセキュリティグループは階層構造になっています。このグループを下記のグループに追加すると、このグループに下記のグループが持つ権限を追加することになります。また、このグループに所属するメンバーは下記のグループにも継承されます。<br' . XHTML . '><br' . XHTML . '>可能な場合には、グループに権限を与える場合、(このグループではなく)下記のグループを使用することをお勧めします。特別な権限を持たせるためにこのグループが必要なら、下記の「権限」セクションで割り当てたい権限にチェックを入れてください。このグループを下記のグループに追加するには、希望するグループにチェックを入れてください。<br' . XHTML . '><br' . XHTML . '>チェックが入っているが無効になっているグループは、このグループ直属しているから他のグループから継承したグループです。無効でチェックの入っていないグループは、セキュリティグループの無限ループの原因となるため、追加できません。',
    'coregroupmsg' => "本グループは{$_CONF['site_name']}の「コア(中核)グループ」です。そのため、本グループの所属するグループは編集できません。このグループの権限リストを読み取り専用で以下に表示しています。",
    'rightsdescr' => '下記の権限は、任意のグループないし任意のグルプープが属している別のグループに直接与えることができます。(チェックが入っていて)選択できないチェックボックスのある権限は、その権限を持つ別のグループに属しているためにこのグループに与えられている権限です。下記のチェックボックスのある権限は、このグループに直接与えることができる権限です。',
    'lock' => 'ロック',
    'members' => 'メンバー',
    'anonymous' => 'ゲストユーザー',
    'permissions' => 'パーミッション',
    'permissionskey' => 'R = 表示, E = 編集, (編集権は表示権を含む)',
    'edit' => '編集',
    'none' => 'なし',
    'accessdenied' => 'アクセスできません',
    'storydenialmsg' => "この記事を表示する権限がありません。これは、あなたが{$_CONF['site_name']}のメンバーでないためだと思われます。メンバーとしてのアクセスを得るには{$_CONF['site_name']} の<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">メンバーになる</a>を使用してください。",
    'nogroupsforcoregroup' => 'このグループは他のどのグループにも所属していません',
    'grouphasnorights' => 'このグループにはサイトを管理する機能のどれにも権限はありません。',
    'newgroup' => '新しいグループ',
    'adminhome' => '管理画面',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'delete' => '削除',
    'canteditroot' => 'Rootグループに所属していないのにRootグループを編集しようとしたため、グループにアクセスできませんでした。これがエラーだと思う場合はシステムの管理者に連絡してください。',
    'listusers' => 'ユーザーの表示と編集',
    'listthem' => 'リスト',
    'usersingroup' => '"%s"に含まれるユーザーの一覧',
    'usersingroupmsg' => 'このグループに属するユーザーの一覧。ここに表示されているユーザーは、このグループに直接属しているユーザーかこのグループに追加された別のグループから継承されているユーザーです。',
    'usergroupadmin' => 'グループ管理',
    'add' => '追加',
    'remove' => '削除',
    'availmembers' => 'ユーザー一覧',
    'groupmembers' => 'グループメンバー',
    'inheritmembers' => '継承されたグループメンバー',
    'canteditgroup' => 'グループを編集するためには、グループのメンバーでなければなりません。これがエラーだと思う場合はシステムの管理者に連絡してください。',
    'cantlistgroup' => 'メンバーリストを見るには、グループのメンバーでなければなりません。これがエラーだと思う場合はシステムの管理者に連絡してください。',
    'editgroupmsg' => 'グループのメンバーを変更するには、メンバー名をクリックして「追加」・「削除」のボタンを使用してください。メンバーがこのグループに直接属しているメンバーの場合、メンバー名は右のパネルしか表示されません。操作が完了したら、<b>保存</b>をクリックすると、更新が行われて管理者ページのトップへ戻ります。<br' . XHTML . '><br' . XHTML . '>他のグループから継承されているメンバーは、情報提供のためにここに表示されているだけであり、削除するには直接所属しているグループを編集してください。ユーザーはあるグループのメンバーになることも、他のグループから継承されているグループのメンバーになることもできます。',
    'listgroupmsg' => 'グループ<strong>%s</strong>に含まれるユーザー:',
    'search' => '検索',
    'submit' => '実行',
    'limitresults' => '件数',
    'group_id' => 'グループID',
    'plugin_access_denied_msg' => 'このプラグインの管理権限がないのに管理画面にアクセスしようとしました。不正にこのページにアクセスする試みはすべて記録していることに注意してください。',
    'groupexists' => 'このグループ名は既に存在しています。',
    'groupexistsmsg' => '同名のグループがあります。グループ名は重複してはいけません。',
    'demo_mode_denied_msg' => 'サイトがデモモードになっている間、この機能は無効になっています。'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'database_admin' => 'データベース管理',
    'last_ten_backups' => 'バックアップしたファイル',
    'site_db_backup' => "{$_CONF['site_name']} のデータベースをバックアップ",
    'create_backup' => 'データベースのバックアップ',
    'do_backup' => 'バックアップの実行',
    'backup_successful' => 'データベースのバックアップを完了しました。',
    'backup_error' => 'データベースのバックアップに失敗しました。',
    'db_explanation' => 'サイトのデータベースのバックアップを新しく作成するには「バックアップの実行」をクリックしてください。バックアップファイルをダウンロードするには、下記の一覧でファイル名をクリックしてください。',
    'backup_instructions' => 'サイトのデータベースのバックアップを新しく作成するには下の「バックアップの実行」を選択してください。現在のGeeklogテーブルをバックアップします。データベース管理画面からバックアップしたファイルをダウンロードすることができます。',
    'zero_size' => 'バックアップ失敗: ファイルの大きさが0バイトです。',
    'path_not_found' => "{$_CONF['backup_path']} は存在しないか、ディレクトリではありません。",
    'no_access' => "エラー: {$_CONF['backup_path']} にアクセスできません。",
    'backup_file' => 'バックアップファイル',
    'size' => 'サイズ',
    'bytes' => 'バイト',
    'total_number' => 'バックアップファイルの総数: %d',
    'download' => 'クリックしてこのファイルをダウンロード',
    'convert_menu' => 'InnoDBへの変換',
    'convert_title' => 'InnoDBテーブルへの変換',
    'convert_myisam_menu' => 'MyISAMへの変換',
    'convert_myisam_title' => 'MyISAMテーブルへの変換',
    'convert_button' => '変換',
    'converting' => '変換中',
    'no_innodb' => 'あなたのMySQLのバージョンはInnoDBテーブルをサポートしていません。',
    'no_myisam' => 'あなたのMySQLのバージョンはMyISAMテーブルをサポートしていません。',
    'innodb_instructions' => 'InnoDBテーブルは大きなデータベースではより良い性能を発揮します。変換を実行する前に、変換の利点と欠点を <a href="http://dev.mysql.com/doc/refman/5.6/ja/converting-tables-to-innodb.html" target="_blank">こちらをご覧ください</a>。',
    'myisam_instructions' => 'MyISAMテーブルはより小さなデータベースではより良い性能を発揮します。',
    'already_converted' => 'すべてのテーブルは既にInnoDBに変換してあるようです。',
    'already_converted_myisam' => 'すべてのテーブルは既にMyISAMに変換してあるようです。',
    'conversion_message' => '注意: 変換には少々の時間が必要です。今しばらく、お待ちください。',
    'innodb_success' => 'InnoDBテーブルへの変換を完了しました。',
    'myisam_success' => 'MyISAMテーブルへの変換を完了しました。',
    'table_issues' => 'いくつかのテーブルで問題が発生した可能性があります。詳細については、error.logを確認してください。',
    'optimize_menu' => 'テーブルの最適化',
    'optimize_title' => 'テーブルの最適化',
    'optimize_button' => '最適化',
    'optimizing' => '最適化中',
    'optimize_explain' => 'テーブルの最適化はサイトの性能改善に役立つかもしれません。実際の効果はテーブルの利用状況に左右され、テーブルによっては比較的大きな効果が得られるかもしれません。性能に非常に大きな差が出ると期待しないでください。<a href="http://dev.mysql.com/doc/refman/5.6/ja/optimize-table.html">MySQLマニュアル</a>サイトは次のように述べています: <q>1週間または1ヶ月のうちに何回もこれを行う必要はないでしょう。</q>',
    'last_optimization' => '前回の最適化',
    'optimization_message' => '注意: 最適化には少々の時間を必要とします。今しばらく、お待ちください。',
    'optimize_success' => 'データベースのテーブルの最適化を完了しました。',
    'conversion_status' => '変換の状態',
    'optimization_status' => '最適化の状態',
    'backup_status' => 'バックアップの状態',
    'backingup' => 'バックアップを実行する',
    'backup_title' => 'Geeklogのデータベースをバックアップする',
    'backup_warning' => '注: データベースのテーブル構造のみのバックアップを行うよう、コンフィギュレーションで設定されています。データはバックアップされません。',
    'latest_backup' => '最新のバックアップ',
    'tables_to_backup' => 'バックアップするテーブル',
    'include' => '含まれるテーブル',
    'exclude' => '含まれないテーブル',
    'options' => 'オプション',
    'struct_only' => 'テーブル構造のみバックアップ(データなし)',
    'max_files' => '保持するバックアップファイルの最大数',
    'disable_purge' => '(無制限に保持するには"0"を指定)',
    'use_gzip' => '可能なら圧縮する(gzip)',
    'configure' => 'コンフィギュレーション',
    'config_instructions' => 'バックアップしたくないテーブルを選択してください。その他のオプションはコンフィギュレーションのGeeklog - データベースタブにあります。',
    'config_successful' => 'バックアップするテーブル一覧を保存しました。'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'ホーム',
    2 => 'メールを送る',
    3 => '記事公開',
    4 => '',
    5 => '',
    6 => '',
    7 => 'サイトの統計情報',
    8 => '個人設定',
    9 => '検索',
    10 => '検索オプション',
    11 => '記事管理'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => '<strong>%s</strong>は見つかりませんでした。',
    3 => "<p>指定したファイルは存在しません。<a href=\"{$_CONF['site_url']}\">メインページ</a>をチェックしたり、<a href=\"{$_CONF['site_url']}/search.php\">検索ページ</a>で探してみてください。",
    4 => "<p>リクエストされたページは見つかりません。<a href=\"%s\">関連ページ</a>に戻るか、<a href=\"{$_CONF['site_url']}/\">ホームページ</a>に戻る、あるいは<a href=\"{$_CONF['site_url']}/search.php\">検索ページ</a>で目的のページを探してください。"
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'ログインしてください',
    2 => "ここにアクセスするには、まず<a href=\"{$_CONF['site_url']}/users.php\">ログインしてください</a>。",
    3 => 'ログイン',
    4 => '新規登録'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'トラックバック',
    'from' => 'from',
    'tracked_on' => 'トラックバック オン',
    'read_more' => '続きを読む',
    'intro_text' => '\'%s\'について他のサイトでは次のように言及しています:',
    'no_comments' => 'この記事にはトラックバック・コメントがありません。',
    'this_trackback_url' => 'このエントリのトラックバックURL:',
    'num_comments' => '%d件のトラックバック',
    'send_trackback' => 'トラックバック・ピングを送信',
    'preview' => 'プレビュー',
    'editor_title' => 'トラックバック・コメントを送信',
    'trackback_url' => 'トラックバックURL',
    'entry_url' => 'エントリのURL',
    'entry_title' => 'エントリのタイトル',
    'blog_name' => 'サイト名',
    'excerpt' => '概要',
    'truncate_warning' => '注: 受信したサイト側で概要を切り詰めることがあります',
    'button_send' => '送信',
    'button_preview' => 'プレビュー',
    'send_error' => 'エラー',
    'send_error_details' => 'トラックバックの送信中にエラーが発生しました:',
    'url_missing' => 'エントリのURL',
    'url_required' => '少なくともエントリのURLを入力してください。',
    'target_missing' => 'トラックバックURLがありません',
    'target_required' => 'トラックバックURLを入力してください',
    'error_socket' => 'ソケットをオープンできませんでした。',
    'error_response' => '理解できない応答です。',
    'error_unspecified' => '詳細不目なエラーです。',
    'select_url' => 'トラックバックURLを選択してください',
    'not_found' => 'トラックバックURLが見つかりません',
    'autodetect_failed' => 'コメントを送ろうとした記事のトラックバックURLが見つかりませんでした。URLを下に入力してください。',
    'trackback_explain' => '以下のリンクからトラックバックを送りたいURLを選択してください。その記事の正しいトラックバックURLをGeeklogは見つけようとします。URLがわかっているなら<a href="%s">手作業で入力</a>もできます。',
    'no_links_trackback' => 'リンクが見つかりません。このエントリにトラックバック・コメントを送信できません。',
    'pingback' => 'ピングバック',
    'pingback_results' => 'ピングバックの結果',
    'send_pings' => 'ピングを送信',
    'send_pings_for' => '"%s"にトラックバック・ピングを送信',
    'no_links_pingback' => 'リンクが見つかりません。このエントリへのピングバックを送信できませんでした。',
    'pingback_success' => 'ピングバックを送信しました。',
    'no_pingback_url' => 'ピングバックURLが見つかりません。',
    'resend' => '再送信',
    'ping_all_explain' => 'あなたがリンクしたことを相手のサイトに知らせたり(<a href="http://en.wikipedia.org/wiki/Pingback">ピングバック</a>)、Webログディレクトリサービスにピングを送ってサイトの更新を知らせたり、誰かのサイトの記事について書いたときに<a href="http://ja.wikipedia.org/wiki/%E3%83%88%E3%83%A9%E3%83%83%E3%82%AF%E3%83%90%E3%83%83%E3%82%AF">トラックバック</a>を送ったり、といったことをできます。',
    'pingback_button' => 'ピングバック送信',
    'pingback_short' => '記事のすべてのリンク先にピングバックを送信します。',
    'pingback_disabled' => '(ピングバックは無効です)',
    'ping_button' => 'ピング送信',
    'ping_short' => '登録したWebログサイトにピングを一斉送信します。',
    'ping_disabled' => '(ピングは無効です)',
    'trackback_button' => 'トラックバック送信',
    'trackback_short' => '記事のリンク先にトラックバックを送信します。',
    'trackback_disabled' => '(トラックバックは無効です)',
    'may_take_a_while' => 'ピングバックやピングの送信には時間がかかることがあります。',
    'ping_results' => 'ピングの結果',
    'unknown_method' => '不明なピングメソッドです。',
    'ping_success' => 'ピングを送信しました。',
    'error_site_name' => 'サイト名を入力してください。',
    'error_site_url' => 'サイトのURLを入力してください。',
    'error_ping_url' => '正しいピングURLを入力してください。',
    'no_services' => 'Webログディレクトリサービスを設定していません。',
    'services_headline' => 'トラックバック管理',
    'service_explain' => 'ピング送信先のWebログディレクトリサービスの編集や削除をするには下の編集アイコンをクリックしてください。新しいWebログディレクトリサービスを追加する場合は「新規作成」をクリックしてください。',
    'service' => 'サービス',
    'ping_method' => 'ピングメソッド',
    'service_website' => 'Webサイト',
    'service_ping_url' => 'ピングのURL',
    'ping_standard' => '標準ピング',
    'ping_extended' => '拡張ピング',
    'ping_unknown' => '(不明なメソッド)',
    'edit_service' => 'Webログディレクトリサービスの編集',
    'trackbacks' => 'トラックバック',
    'editor_intro' => '<a href="%s">%s</a>へのトラックバック・コメントを準備してください。',
    'editor_intro_none' => 'トラックバック・コメントを準備してください。',
    'trackback_note' => '記事にトラックバック・コメントを送るには、記事一覧でその記事の"トラックバック・ピングを送る"をクリックしてください。 記事に関係のないトラックバックを送るには <a href="%s">ここをクリック</a>してください。',
    'pingback_explain' => 'ピングバックするURLを入力してください。ピングバックはサイトのホームページを指し示します。',
    'pingback_url' => 'ピングバックURL',
    'site_url' => 'このサイトのURL',
    'pingback_note' => '記事へのピングバックを送るには、記事の一覧で、記事の行の「トラックバック・ピングを送る」をクリックしてください。記事に関係しないピングバックを送るには、<a href="%s">ここをクリック</a>してください。',
    'pbtarget_missing' => 'ピングバックURLではありません。',
    'pbtarget_required' => 'ピングバックURLを入力してください',
    'pb_error_details' => '次のピングバックの送信中にエラー:',
    'delete_trackback' => 'このトラックバックを削除: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => '記事一覧',
    'title_year' => '%d年の記事一覧',
    'title_month_year' => '%d年%s月の記事一覧',
    'nav_top' => '記事一覧のトップに戻る',
    'no_articles' => '記事がありません。'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog セキュリティチェック',
    'results' => 'セキュリティチェックの結果',
    'okay' => 'すべて適正です。',
    'please_fix' => 'サイトを使用する前に上記の問題を修正してください!',
    'please_note' => '100%安全なサイトはありません。このスクリプトが検証するのは明らかなセキュリティ上の問題だけです。',
    'stay_informed' => 'Geeklogの新しい公開情報やセキュリティ問題の情報を継続してお知らせできるようにするために、(トラフィックの少ない) %s メーリングリストに参加と、アップデート可能かどうかを確認するためにときどき管理メニューの%sを実施、これらの両方または一方を行うことをお勧めします。',
    'public_html' => '"public_html"はあなたのサイトURLの一部に含めないようにしてください。もう一度 %s 内のpublic_htmlに関する部分を読んで、設定を変更してから次に進んでください。',
    'installation' => 'インストールの手順',
    'directory' => 'ディレクトリ',
    'failed_tmp' => '%sディレクトリに一時ファイルを作成できませんでした。ディレクトリのパーミッションを確認してください!',
    'fix_it' => 'これはセキュリティリスクで、修正すべきです!',
    'reachable' => 'あなたの %s はWebからアクセス可能です。',
    'not_reachable' => 'Good! あなたの %s はWebからアクセス不可能です。',
    'not_sure' => 'HTTPの応答コード%sを(%sのテストの実行時に)受信しました。この意味するところは不明です ...',
    'remove_inst' => 'いったんサイトが立ち上って正常に動き始めたら、必ずinstallディレクトリ%sを削除してください。',
    'remove_inst2' => 'そのままにしておくとインストールしたGeeklogを破壊、サイトの乗っ取っとり、重要な情報を読み出すといったことを悪意のあるユーザーに許してしまいます。',
    'inst_removed' => 'Good! あなたは既にinstallディレクトリを削除しています。',
    'fix_password' => 'あなたはまだRootユーザーアカウントの<strong>パスワード</strong>を初期値のままで使用しています。',
    'password_okay' => 'Good! Rootユーザーアカウントのパスワードをデフォルトから変更しています。'
);

###############################################################################
# "What's New" Time Strings
# 
# This here determines the order of the sentence "No new articles in 2 hrs"
# order it so it makes sense in your language:
# %i    item, "Articles"
# %n    amount, "2", "20" etc
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '新着%i %n件(%t%s)',
    'new_last' => '新着(%t%s)',
    'minutes' => '分',
    'hours' => '時間',
    'days' => '日',
    'weeks' => '週',
    'months' => 'ヶ月',
    'years' => '年',
    'minute' => '分',
    'hour' => '時',
    'day' => '日',
    'week' => '週',
    'month' => '月',
    'year' => '年'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => ' 1月',
    2 => ' 2月',
    3 => ' 3月',
    4 => ' 4月',
    5 => ' 5月',
    6 => ' 6月',
    7 => ' 7月',
    8 => ' 8月',
    9 => ' 9月',
    10 => '10月',
    11 => '11月',
    12 => '12月'
);

###############################################################################
# Short Month names

$LANG_MONTH_SHORT = array(
    1 => ' 1月',
    2 => ' 2月',
    3 => ' 3月',
    4 => ' 4月',
    5 => ' 5月',
    6 => ' 6月',
    7 => ' 7月',
    8 => ' 8月',
    9 => ' 9月',
    10 => '10月',
    11 => '11月',
    12 => '12月'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => '日曜日',
    2 => '月曜日',
    3 => '火曜日',
    4 => '水曜日',
    5 => '木曜日',
    6 => '金曜日',
    7 => '土曜日'
);

###############################################################################
# Short Weekday Names

$LANG_WEEK_SHORT = array(
    1 => '日',
    2 => '月',
    3 => '火',
    4 => '水',
    5 => '木',
    6 => '金',
    7 => '土'
);

###############################################################################
# AM/PM

$LANG_AMPM = array(
    'am_pm' => array('am' => 'am', 'pm' => 'pm'),
    'AM_PM' => array('am' => 'AM', 'pm' => 'PM')
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => '検索',
    'limit_results' => '件数',
    'submit' => '実行',
    'edit' => '編集',
    'edit_adv' => 'アドバンストエディター',
    'admin_home' => '管理画面',
    'create_new' => '新規作成',
    'create_new_adv' => '新規作成(アドバンスト)',
    'enabled' => '有効',
    'disabled' => '無効',
    'title' => 'タイトル',
    'page_title' => 'ページタイトル',
    'type' => 'タイプ',
    'topic' => '話題',
    'info' => 'インフォメーション',
    'help_url' => 'ヘルプURL',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'install' => 'インストール',
    'delete' => '削除',
    'deleteitem' => 'Delete',
    'delete_sel' => '削除選択',
    'copy' => 'コピー',
    'no_results' => '- 見つかりませんでした -',
    'data_error' => '送信データに問題があります。データをチェックしてください',
    'preview' => 'プレビュー',
    'records_found' => '件数',
    'addchild' => '子を追加',
    'list' => 'リスト',
    'list_all' => 'すべてのリスト',
    'meta_description' => '説明文のメタタグ',
    'meta_keywords' => 'キーワードのメタタグ',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => '%s までに編集してください。その時刻を過ぎると、このページに埋め込まれたセキュリティトークンは期限切れとなって、編集内容を失うことになります。',
    'token_expired' => 'この操作のセキュリティトークンは期限切れになりました。続けるには再度認証してください。',
    'reauth_msg' => 'この操作のセキュリティトークンは期限切れになりました。続けるには下の認証を行ってください。そうすれば今回の編集作業を失うことはありません。',
    'token_expired_remote_user' => 'この操作のセキュリティトークンは期限切れになりました。リモートユーザーの再認証はできないため、編集内容は失われました。',
    'token_re_authentication_error' => '再認証後にエラーが発生しました。あなたが行おうとしていた操作が実行されたかどうかは不明です。',
    'authenticate' => '認証する',
    'approve' => '承認する',
    'device' => 'デバイス',
    'device_desc' => 'このアイテムを表示するデバイス',
    'for_all' => '全て',
    'for_mobile' => 'モバイル用',
    'for_computer' => 'コンピューター用',
    'all' => '全て',
    'mobile' => 'モバイル',
    'computer' => 'コンピューター',
    'edit_access_only' => '編集権のみ'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'コメント機能を有効にする',
    -1 => 'コメント機能を無効にする',
    1 => 'コメントの受付を停止する(表示のみ)'
);

$LANG_commentmodes = array(
    'flat' => '一覧',
    'nested' => '入れ子',
    'threaded' => 'ツリー',
    'nocomment' => '表示しない'
);

$LANG_cookiecodes = array(
    0 => '受け付けない',
    3600 => '1時間',
    7200 => '2時間',
    10800 => '3時間',
    28800 => '8時間',
    86400 => '1日',
    604800 => '1週間',
    2678400 => '1ヶ月'
);

$LANG_dateformats = array(
    0 => 'システムのデフォルト'
);

$LANG_featurecodes = array(
    0 => '通常の記事',
    1 => '注目記事'
);

$LANG_frontpagecodes = array(
    0 => '該当する話題にのみ表示',
    1 => 'トップページに表示'
);

$LANG_postmodes = array(
    'plaintext' => 'テキスト',
    'html' => 'HTML'
);

$LANG_sortcodes = array(
    'ASC' => '古い順に',
    'DESC' => '新しい順に'
);

$LANG_statuscodes = array(
    0 => 'Normal',
    1 => 'Refreshing',
    10 => 'Archive'
);

$LANG_trackbackcodes = array(
    0 => 'トラックバックを受け付ける',
    -1 => 'トラックバックを受け付けない'
);

$LANG_structureddatatypes = array(
    'none' => 'なし',
    'core-webpage' => 'Webページ',
    'core-article' => '記事',
    'core-newsarticle' => 'ニュース記事',
    'core-blogposting' => 'ブログ記事'
);

$LANG_STRUCT_DATA = array(
    'lang_structured_data_type' => '構造化データタイプ',
    'autotag_desc_structureddata' => '[structureddata:schema_property]Property Value[/structureddata] - この自動タグを埋め込むコンテンツの構造化データにプロパティ値を追加します。'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'ホーム',
    'admin_home' => 'サイト管理',
    'sections' => 'コンフィギュレーション',
    'restore' => '復元',
    'add_element' => '要素を追加',
    'save_changes' => '変更を保存',
    'reset_form' => 'リセット',
    'changes_made' => '変更が完了しました',
    'title' => 'コンフィギュレーション管理',
    'disable' => 'クリックしてこのオプションを無効にする',
    'enable' => '有効にする',
    'default_tab_name' => 'メイン',
    'search_configuration_label' => 'コンフィギュレーションの検索',
    'error_validation_occurs' => '正しくない設定値があります。これらのフィールドを修正してください。(エラーの欄を示す設定変数をクリックしてください)'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklogの設定'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTMLパス',
    'site_url' => 'サイトのURL',
    'site_admin_url' => '管理画面のURL',
    'site_mail' => 'サイトのメールアドレス',
    'noreply_mail' => 'No-Replyメールアドレス',
    'mail_cc_enabled' => 'CC(カーボンコピー)を許可',
    'mail_cc_default' => 'CC(カーボンコピー)をデフォルトで使用',
    'mail_charset' => 'メールの文字セット',
    'site_name' => 'サイト名',
    'site_slogan' => 'スローガン',
    'path_site_logo' => 'サイトのロゴ',
    'owner_name' => '管理者名',
    'microsummary_short' => 'マイクロサマリ接頭子',
    'path_log' => 'ログ',
    'path_language' => '言語',
    'backup_path' => 'バックアップ',
    'path_data' => 'データ',
    'path_images' => '画像',
    'path_editors' => 'アドバンストエディター',
    'mail_settings' => 'メール設定',
    'dbdump_filename_prefix' => 'バックアップファイル名の接頭子',
    'dbdump_tables_only' => 'テーブル構造のみのバックアップを行う',
    'dbdump_gzip' => '可能なら圧縮ファイル(GZip)を使用する',
    'dbdump_max_files' => 'バックアップファイルの最大保持数',
    'theme' => 'テーマ',
    'doctype' => 'DOCTYPE宣言',
    'menu_elements' => 'メニュー項目',
    'path_themes' => 'テーマのパス',
    'cache_templates' => 'テンプレートをキャッシュする',
    'cache_mobile' => 'モバイル用のコンテンツを別にキャッシュする',
    'cache_resource' => 'CSSとJavaScriptファイルを結合・圧縮しキャッシュする',
    'disable_new_user_registration' => '新規ユーザー登録を停止する',
    'allow_user_themes' => 'テーマ選択を許可する',
    'allow_user_language' => '言語選択を許可する',
    'switchlang_homepage' => '言語切り替えブロックからトップページへリダイレクトする',
    'new_item_set_current_lang' => '現在の言語IDを追加する',
    'allow_user_photo' => '写真登録を許可する',
    'allow_username_change' => 'ユーザー名変更を許可する',
    'allow_account_delete' => 'アカウント削除を許可する',
    'hide_author_exclusion' => '所有者の非表示を許可する',
    'show_fullname' => 'ユーザー名の代わりに氏名を表示する',
    'show_servicename' => 'サービス名を表示する',
    'require_user_email' => 'ユーザーに新しいメールアドレスを要求する',
    'custom_registration' => 'カスタム登録を有効にする',
    'user_login_method' => 'ログイン方法',
    'facebook_login' => 'FacebookのOAuthを有効にする',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => ' LinkedInのOAuthを有効にする',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'TwitterのOAuthを有効にする',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'GoogleのOAuthをを有効にする',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'MicrosoftのOAuthを有効にする',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'YahooのOAuthを有効にする',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'github_login' => 'GitHubのOAuthを有効にする',
    'github_consumer_key' => 'GitHub OAuth Consumer Key',
    'github_consumer_secret' => 'GitHub OAuth Consumer Secret',
    'spamx' => 'Spam-X',
    'sort_admin' => 'リンクを並べ替える',
    'language' => '言語',
    'locale' => 'ロケール',
    'date' => '日時のフォーマット',
    'daytime' => '日時の短縮フォーマット',
    'shortdate' => '日付の短縮フォーマット',
    'dateonly' => '月日だけのフォーマット',
    'timeonly' => '時刻だけのフォーマット',
    'week_start' => '週の始まり',
    'hour_mode' => '時間制',
    'thousand_separator' => '千単位の区切り文字',
    'decimal_separator' => '小数点',
    'decimal_count' => '小数点以下の桁数',
    'language_files' => '言語ファイル[多言語モード]',
    'languages' => '言語名[多言語モード]',
    'timezone' => 'タイムゾーン',
    'site_disabled_msg' => 'サイト停止のメッセージまたはURL',
    'rootdebug' => 'Rootデバッグ',
    'cookie_session' => 'セッションのクッキー名',
    'cookie_name' => '永続的なクッキー名',
    'cookie_password' => 'パスワードのクッキー名',
    'cookie_theme' => 'テーマのクッキー名',
    'cookie_language' => '言語のクッキー名',
    'cookie_tzid' => 'タイムゾーンのクッキー名',
    'cookie_anon_name' => 'ゲストユーザー名のクッキー名',
    'cookie_ip' => 'クッキーにIPアドレスを埋め込む',
    'default_perm_cookie_timeout' => '永続的なクッキーの有効期限',
    'session_cookie_timeout' => 'セッションの有効期限',
    'cookie_path' => 'クッキーのパス',
    'cookiedomain' => 'クッキーのドメイン',
    'cookiesecure' => 'セキュア(HTTPS)なクッキーを使用する',
    'lastlogin' => '最終のログインを記録する',
    'num_search_results' => '表示件数のデフォルト',
    'loginrequired' => 'すべてにログインを必要とする',
    'submitloginrequired' => '投稿にログインを必要とする',
    'commentsloginrequired' => 'コメント投稿にログインを必要とする',
    'statsloginrequired' => '統計の参照にログインを必要とする',
    'searchloginrequired' => '検索にログインを必要とする',
    'profileloginrequired' => 'プロフィールの表示にログインを必要とする',
    'emailuserloginrequired' => 'メールの送信にログインを必要とする',
    'emailstoryloginrequired' => '記事のメール送信にログインを必要とする',
    'directoryloginrequired' => '記事の一覧表示にログインを必要とする',
    'storysubmission' => '記事の投稿を審査する',
    'usersubmission' => 'ユーザーの登録を審査する',
    'listdraftstories' => 'ドラフト記事の一覧を表示する',
    'notification' => '通知',
    'postmode' => '投稿モードのデフォルト',
    'speedlimit' => '投稿間隔の制限',
    'skip_preview' => 'プレビューしないで投稿する',
    'advanced_editor' => 'アドバンストエディターを使用する',
    'advanced_editor_name' => 'アドバンストエディター名',
    'wikitext_editor' => 'Wikiテキストエディターを使用する',
    'remove_4byte_chars' => '4バイトのutf-8文字を除去する',
    'cron_schedule_interval' => 'Cronのスケジュール間隔',
    'sortmethod' => '話題の並べ替え',
    'showstorycount' => '記事数を表示する',
    'showsubmissioncount' => '承認待ちの記事数を表示する',
    'hide_home_link' => 'Homeへのリンクを表示しない',
    'whosonline_threshold' => 'セッションのしきい値',
    'whosonline_anonymous' => 'ゲストユーザーに表示しない',
    'whosonline_photo' => '写真のサムネイルを表示する',
    'emailstories' => 'デイリーダイジェストの送信する',
    'emailstorieslength' => '記事の長さ',
    'emailstoriesperdefault' => 'ユーザー新規登録で有効をデフォルトにする',
    'allow_domains' => '自動的に許可するドメイン',
    'disallow_domains' => '自動的に拒否するドメイン',
    'newstoriesinterval' => '記事を"新着"とする期間',
    'newcommentsinterval' => 'コメントを"新着"とする期間',
    'newtrackbackinterval' => 'トラックバックを"新着"とする期間',
    'hidenewstories' => '記事の新着表示をしない',
    'hidenewcomments' => 'コメントの新着表示をしない',
    'hidenewtrackbacks' => 'トラックバックの新着表示をしない',
    'hidenewplugins' => 'プラグインの新着表示をしない',
    'title_trim_length' => 'タイトル最大長',
    'whatsnew_cache_time' => 'キャッシュ期間の最大値',
    'trackback_enabled' => 'トラックバックを有効にする',
    'pingback_enabled' => 'ピングバックを有効にする',
    'ping_enabled' => '更新ピングを有効にする',
    'trackback_code' => '新着記事のデフォルト',
    'multiple_trackbacks' => 'マルチプルトラックバック',
    'trackbackspeedlimit' => 'トラックバックの間隔制限',
    'check_trackback_link' => 'トラックバックの検査',
    'pingback_self' => '自身へピングバックする',
    'pingback_excerpt' => 'ピングバックを要約する',
    'link_documentation' => 'ドキュメントのリンクを表示する',
    'link_versionchecker' => 'バージョン確認のリンクを表示する',
    'maximagesperarticle' => '記事に配置する画像の最大数',
    'limitnews' => '1ページあたりの記事の表示数',
    'minnews' => '記事の最小表示件数',
    'contributedbyline' => '所有者を表示する',
    'hideviewscount' => '表示回数を表示しない',
    'hideemailicon' => 'メールアイコンを表示しない',
    'hideprintericon' => '印刷アイコンを表示しない',
    'allow_page_breaks' => '改ページの使用を許可する',
    'page_break_comments' => '改ページ時のコメント表示位置',
    'article_image_align' => '話題アイコンの表示位置',
    'show_topic_icon' => '話題アイコン表示のデフォルト',
    'structured_data_type_default' => '構造化データタイプのデフォルト',
    'structured_data_article_topic' => '記事の構造化データタイプ',
    'draft_flag' => 'ドラフトモードをデフォルトにする',
    'frontpage' => 'トップページ配置をデフォルトにする',
    'hide_no_news_msg' => '記事がない場合のメッセージを表示しない',
    'hide_main_page_navigation' => 'ページナビゲーションを表示しない',
    'onlyrootfeatures' => 'Rootユーザーだけが注目記事を設定する',
    'aftersave_story' => '記事保存後の画面遷移',
    'related_topics' => '関連話題',
    'related_topics_max' => '表示する関連話題の最大数',
    'whats_related' => '関連情報',
    'whats_related_max' => '表示する関連情報の最大数',
    'whats_related_trim' => '関連情報のタイトルの最大長',
    'default_cache_time_article' => '記事のキャッシュ期間のデフォルト',
    'blocks_article_topic_list_repeat_after' => '話題リストブロックを続けて配置する',
    'aftersave_user' => 'ユーザー保存後の画面遷移',
    'show_right_blocks' => '右ブロックを常に表示する',
    'showfirstasfeatured' => '最初の記事を注目記事として表示する',
    'template_comments' => 'テンプレートコメントを表示する',
    'backend' => 'フィードを有効にする',
    'rdf_file' => 'フィードの出力ファイル',
    'rdf_limit' => 'フィードの最大数',
    'rdf_storytext' => 'フィードに含める記事の長さ',
    'rdf_language' => 'フィードの言語',
    'syndication_max_headlines' => 'インポートする記事の最大数(ポータルブロック)',
    'comment_feeds_article_tag' => '記事のタグ',
    'comment_feeds_article_tag_position' => '記事のタグの位置',
    'comment_feeds_article_author_tag' => '記事の投稿者のタグ',
    'comment_feeds_comment_author_tag' => 'コメントの投稿者のタグ',
    'copyrightyear' => 'Copyrightの年の設定',
    'image_lib' => '画像処理ライブラリ',
    'path_to_mogrify' => 'mogrifyのパス',
    'path_to_netpbm' => 'netpbmのパス',
    'debug_image_upload' => '画像のアップロードをデバッグする',
    'keep_unscaled_image' => '元の画像を保持する',
    'allow_user_scaling' => 'ユーザーに画像のサイズ変更を許可する',
    'jpeg_quality' => 'JPEGの画質',
    'max_image_width' => '幅の最大値',
    'max_image_height' => '高さの最大値',
    'max_image_size' => 'ファイルサイズの最大値',
    'max_topicicon_width' => '幅の最大値',
    'max_topicicon_height' => '高さの最大値',
    'max_topicicon_size' => 'ファイルサイズの最大値',
    'max_photo_width' => '幅の最大値',
    'max_photo_height' => '高さの最大値',
    'max_photo_size' => 'ファイルサイズの最大値',
    'generate_user_icon' => 'ユーザーのアイコンを自動作成する',
    'use_gravatar' => 'Gravatarを使用する',
    'gravatar_rating' => 'Gravatarの評価',
    'gravatar_identicon' => 'Gravatarのデフォルト画像',
    'force_photo_width' => '写真の幅を固定',
    'default_photo' => '写真のデフォルト',
    'commentspeedlimit' => 'コメントの投稿間隔の制限',
    'comment_limit' => '表示件数',
    'comment_mode' => '表示モード',
    'comment_order' => '表示する順序',
    'comment_code' => '新規作成時のデフォルト',
    'comment_edit' => 'コメントの編集を許可する',
    'comment_edittime' => 'コメントの編集時間(秒)',
    'commentsubmission' => '承認待ちリストに入れる',
    'likes_enabled' => 'Likesを有効にする',
    'likes_articles' => '記事のLikes',
    'likes_comments' => 'コメントのLikes',
    'likes_speedlimit' => 'Likesの実行制限間隔(秒)',
    'likes_users_listed' => 'ツールチップに表示するユーザー数',
    'likes_block_cache_time' => 'キャッシュする時間',
    'likes_block_include_time' => 'likesブロックに表示する期間',
    'likes_block_max_items' => '表示するアイテムの最大数',
    'likes_block_displayed_actions' => '表示するアクション',
    'likes_block_title_trim_length' => 'タイトルの文字数の最大値',
    'likes_block_likes_new_line' => '改行後にlikesを表示する',
    'likes_block_type' => 'タイプ',
    'likes_block_subtype' => 'サブタイプ',
    'likes_block_enable' => '有効',
    'likes_block_isleft' => 'ブロックを左側に表示するLeft',
    'likes_block_order' => 'ブロックの順序',
    'likes_block_topic_option' => '話題のオプション',
    'likes_block_topic' => '話題',
    'likes_block_group_id' => 'グループ',
    'likes_block_permissions' => 'パーミッション',
    'passwordspeedlimit' => 'パスワードの取得制限間隔',
    'login_attempts' => 'ログイン試行最大回数',
    'login_speedlimit' => 'ログイン試行制限間隔',
    'invalidloginattempts' => 'ログイン失敗最大回数',
    'invalidloginmaxtime' => 'ログイン失敗警告メール送信待機時間',
    'enable_twofactorauth' => '2段階認証を有効にする',
    'pass_alg' => 'パスワードのハッシュアルゴリズム',
    'pass_stretch' => 'ハッシュストレッチカウント',
    'user_html' => 'ユーザーHTML',
    'admin_html' => '管理者HTML',
    'advanced_html' => 'アドバンストエディター用に追加のHTML',
    'skip_html_filter_for_root' => 'RootユーザーにHTMLフィルターを適用しない',
    'allowed_protocols' => '許可するプロトコル',
    'disable_autolinks' => '自動タグを無効にする',
    'clickable_links' => 'URLをクリッカブルにする',
    'linktext_maxlen' => 'クリッカブルURLの長さ',
    'compressed_output' => 'HTMLの出力を圧縮して送信する',
    'frame_options' => '"クリックジャッキング"を防止する',
    'page_navigation_max_pages' => 'ページナビゲーションの最大ページ数',
    'page_navigation_mobile_max_pages' => 'モバイル用のページナビゲーションの最大ページ数',
    'default_cache_time_block' => 'ブロックのキャッシュ期間のデフォルト',
    'titletoid' => 'タイトルからIDを自動的に作成する',
    '404_log' => '404エラーログを有効にする',
    'censormode' => '語句の検査を行う',
    'censorreplace' => '置き換える単語',
    'censorlist' => 'バッドワード',
    'ip_lookup' => 'IPアドレス検索',
    'url_rewrite' => 'URLリライト',
    'url_routing' => 'URLルーティング',
    'cdn_hosted' => 'CDNのjQueryとUIkitを使用する',
    'meta_tags' => 'メタタグ',
    'meta_description' => 'サイトの説明文のメタタグ',
    'meta_keywords' => 'キーワードのメタタグ',
    'default_permissions_block' => 'パーミッション',
    'default_permissions_story' => 'パーミッション',
    'default_permissions_topic' => 'パーミッション',
    'atom_max_stories' => 'フィードの最大記事数',
    'disable_webservices' => 'Webサービスを無効にする',
    'restrict_webservices' => 'Webサービスを制限する',
    'article_comment_close_enabled' => '自動的にコメントの受付を停止(デフォルト)',
    'article_comment_close_days' => '受付停止までの日数(デフォルト)',
    'comment_close_rec_stories' => 'コメント可能な記事の最大数',
    'allow_reply_notifications' => '返信のメール通知を許可する',
    'comment_on_same_page' => '同じページでコメントを投稿する',
    'show_comments_at_replying' => '返信時にコメントリストを表示する',
    'search_style' => '検索結果の表示スタイル',
    'search_limits' => '表示件数の選択肢',
    'search_show_num' => '検索順の番号を表示する',
    'search_show_type' => '検索のタイプを表示する',
    'search_show_sort' => 'ユーザーに並べ替えを許可する',
    'search_show_limit' => '表示件数の選択肢を表示する',
    'search_separator' => 'グループのセパレータ',
    'search_def_keytype' => '検索条件のデフォルト',
    'search_def_sort' => '並べ替え基準のデフォルト',
    'search_use_topic' => '現在表示中の話題を使用する',
    'autotag_permissions_story' => '[article: ] パーミッション',
    'autotag_permissions_user' => '[user: ] パーミッション',
    'autotag_permissions_topic' => '[topic: ] パーミッション',
    'autotag_permissions_related_topics' => '[related_topics: ] パーミッション',
    'autotag_permissions_related_items' => '[related_items: ] パーミッション',
    'autotag_permissions_block' => '[block: ] パーミッション',
    'autotag_permissions_structureddata' => '[structureddata: ] パーミッション',
    'autotag_permissions_likes_block' => '[likes_block: ] パーミッション',
    'multiple_breadcrumbs' => 'パンくずリストの複数表示を許可する',
    'disable_breadcrumbs_topics' => '話題のパンくずリストを無効にする',
    'disable_breadcrumbs_articles' => '記事のパンくずリストを無効にする',
    'disable_breadcrumbs_plugins' => 'プラグインのパンくずリストを無効にする',
    'breadcrumb_root_site_name' => 'サイト名をパンくずリストのルートにする',
    'filemanager_disabled' => 'ファイルマネージャーを無効にする',
    'filemanager_browse_only' => '閲覧のみ',
    'filemanager_default_view_mode' => '表示モードの初期値',
    'filemanager_show_confirmation' => '確認メッセージを表示する',
    'filemanager_search_box' => '検索ボックスを表示する',
    'filemanager_file_sorting' => 'ファイルの並べ替え方法',
    'filemanager_chars_only_latin' => 'ファイル名にラテン文字だけを許可する',
    'filemanager_date_format' => '日付のフォーマット',
    'filemanager_logger' => 'ロガーを有効にする',
    'filemanager_show_thumbs' => 'サムネイル画像を表示する',
    'filemanager_generate_thumbnails' => 'サムネイル画像を作成する',
    'filemanager_upload_overwrite' => '既存のファイルを上書きする',
    'filemanager_upload_file_size_limit' => 'アップロードするファイルサイズの上限',
    'filemanager_images_ext' => '画像ファイルの拡張子',
    'filemanager_show_video_player' => '動画プレーヤーを表示する',
    'filemanager_videos_ext' => '動画ファイルの拡張子',
    'filemanager_videos_player_width' => '動画プレーヤーの幅',
    'filemanager_videos_player_height' => '動画プレーヤーの高さ',
    'filemanager_show_audio_player' => 'オーディオプレーヤーを表示する',
    'filemanager_audios_ext' => 'オーディオファイルの拡張子',
    'cookie_consent' => 'Cookie Consent(クッキー使用通知)を有効にする',
    'terms_of_use_link' => '「利用規約」のリンク',
    'privacy_policy_link' => '「プライバシーポリシー」のリンク',
    'about_cookies_link' => '「クッキーについて」のリンク',
    'ip_anonymization' => 'IP匿名化'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'サイト',
    'sg_stories' => '記事とトラックバック',
    'sg_theme' => 'テーマ',
    'sg_blocks' => 'ブロック',
    'sg_users' => 'ユーザーと投稿',
    'sg_images' => '画像',
    'sg_locale' => '言語とロケール',
    'sg_misc' => 'その他',
    'sg_filemanager' => 'ファイルマネージャー'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'サイト',
    'fs_paths' => 'パス',
    'fs_theme' => 'テーマ',
    'fs_mail' => 'メール',
    'fs_database_backup' => 'データベースのバックアップ',
    'fs_users' => 'ユーザー',
    'fs_misc' => 'その他',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => '管理者ブロック',
    'fs_locale' => 'ロケール',
    'fs_language' => '言語',
    'fs_multilanguage' => '多言語コンテンツ',
    'fs_debug' => 'デバッグ',
    'fs_cookies' => 'クッキー',
    'fs_login' => 'ログイン',
    'fs_search' => '検索',
    'fs_user_submission' => 'ユーザー登録',
    'fs_submission' => '投稿',
    'fs_topics_block' => '話題ブロック',
    'fs_whosonline_block' => 'オンラインユーザーブロック',
    'fs_daily_digest' => 'デイリーダイジェスト',
    'fs_whatsnew_block' => '新着情報ブロック',
    'fs_trackback' => 'トラックバック',
    'fs_pingback' => 'ピングバック',
    'fs_story' => '記事',
    'fs_theme_advanced' => 'テーマの拡張設定',
    'fs_syndication' => 'フィード',
    'fs_syndication_comment' => 'コメントのフィード',
    'fs_imagelib' => '画像処理ライブラリ',
    'fs_upload' => 'アップロード',
    'fs_articleimg' => '記事の画像',
    'fs_topicicon' => '話題アイコン',
    'fs_userphoto' => 'ユーザーの写真',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'コメント',
    'fs_likes' => 'Likes',
    'fs_likes_block_settings' => 'Block Settings',
    'fs_likes_block_permissions' => 'Block Permissions',
    'fs_htmlfilter' => 'HTMLフィルター',
    'fs_censoring' => 'バッドワードチェック',
    'fs_iplookup' => 'IPアドレス検索',
    'fs_perm_story' => '記事のパーミッションのデフォルト([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_perm_topic' => '話題のパーミッションのデフォルト([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_perm_block' => 'ブロックのパーミッションのデフォルト([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_webservices' => 'Webサービス',
    'fs_autotag_permissions' => '自動タグのパーミッション ([0]所有者 [1]グループ [2]メンバー [3]ゲスト)',
    'fs_breadcrumbs' => 'パンくずリスト',
    'fs_pass' => 'パスワード設定',
    'fs_filemanager_general' => '全般',
    'fs_filemanager_upload' => 'アップロード',
    'fs_filemanager_images' => '画像',
    'fs_filemanager_videos' => 'ビデオ',
    'fs_filemanager_audios' => 'オーディオ'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'サイト',
    'tab_paths' => 'パス',
    'tab_theme' => 'テーマ',
    'tab_mail' => 'メール',
    'tab_database' => 'データベース',
    'tab_users' => 'ユーザー',
    'tab_misc' => 'その他',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => '管理者ブロック',
    'tab_locale' => 'ロケール',
    'tab_language' => '言語',
    'tab_debug' => 'デバッグ',
    'tab_cookies' => 'クッキー',
    'tab_login' => 'ログイン',
    'tab_search' => '検索',
    'tab_user_submission' => 'ユーザー登録',
    'tab_submission' => '投稿',
    'tab_topics_block' => '話題ブロック',
    'tab_whosonline_block' => 'オンラインユーザーブロック',
    'tab_daily_digest' => 'デイリーダイジェスト',
    'tab_whatsnew_block' => '新着情報ブロック',
    'tab_trackback' => 'トラックバック',
    'tab_pingback' => 'ピングバック',
    'tab_story' => '記事',
    'tab_theme_advanced' => '拡張設定',
    'tab_syndication' => 'フィード',
    'tab_imagelib' => '画像処理ライブラリ',
    'tab_upload' => 'アップロード',
    'tab_articleimg' => '記事の画像',
    'tab_topicicon' => '話題アイコン',
    'tab_userphoto' => 'ユーザーの写真',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'コメント',
    'tab_likes' => 'Likes',
    'tab_htmlfilter' => 'HTMLフィルター',
    'tab_censoring' => 'バッドワードチェック',
    'tab_iplookup' => 'IP検索',
    'tab_permissions' => 'パーミッション',
    'tab_webservices' => 'Webサービス',
    'tab_topics' => 'パンくずリスト',
    'tab_filemanager_general' => '全般',
    'tab_filemanager_upload' => 'アップロード',
    'tab_filemanager_images' => '画像',
    'tab_filemanager_videos' => 'ビデオ',
    'tab_filemanager_audios' => 'オーディオ'
);

$LANG_configselects['Core'] = array(
    0 => array('はい' => 1, 'いいえ' => 0),
    1 => array('はい' => true, 'いいえ' => false),
    2 => array('拒否する' => 0, '最後に送信されたものだけ保持する' => 1, '複数送信を許可する' => 2),
    3 => array('トラックバックを受け付ける' => 0, 'トラックバックを受け付けない' => -1),
    4 => array('何も検査しない' => 0, 'サイトのURLを検査する' => 1, '完全なURLを検査する' => 2, 'サイトのURLと完全なURLを検査する' => 3, 'IPアドレスとサイトのIPアドレスを検査する' => 4, 'IPアドレスとサイトのURLを検査する' => 5, 'IPアドレスと完全なURLを検査する' => 6, 'IPアドレス、完全なURL、サイトのURLを検査する' => 7),
    5 => array('テキスト' => 'plaintext', 'HTML' => 'html', 'Wikiスタイル' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('最後のページ' => 'last', '最初のページ' => 'first', '各ページ' => 'all'),
    8 => array('右' => 'right', '左' => 'left'),
    9 => array('作成したページを表示する' => 'item', '一覧を表示する' => 'list', 'ホームを表示する' => 'home', '管理画面のトップを表示する' => 'admin'),
    10 => array('なし' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'GDライブラリ' => 'gdlib'),
    11 => array('一覧' => 'flat', '入れ子' => 'nested', 'ツリー' => 'threaded', '表示しない' => 'nocomment'),
    12 => array('アクセス不可' => 0, '表示' => 2, '表示・編集' => 3),
    13 => array('スキップする' => 0, '許可する(間隔制限あり)' => 1, '許可する(間隔制限なし)' => 2),
    14 => array('日曜日' => 'Sun', '月曜日' => 'Mon'),
    15 => array('番号順' => 'sortnum', 'アルファベット順' => 'alpha'),
    16 => array('いいえ' => 0, '検索オプションのみ要求' => 1, 'すべての検索機能で要求' => 2),
    17 => array('コメント機能を有効にする' => 0, 'コメント機能を無効にする' => -1),
    18 => array('検査しない' => 0, '検査する(完全一致)' => 1, '検査する(前方一致)' => 2, '検査する(部分一致)' => 3),
    19 => array('Google風' => 'google', 'テーブルレイアウト' => 'table'),
    20 => array('完全一致' => 'phrase', 'すべてのキーワードを含む' => 'all', 'いずれかのキーワードを含む' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('フレーム内表示を許可しない' => 'DENY', '同一オリジンのみフレーム内表示を許可する' => 'SAMEORIGIN', 'フレーム内表示を制限しない' => ''),
    23 => array('無効にする' => 0, '有効にする' => 1, '有効にする(トップページにのみデフォルトを使用する)' => 2),
    24 => array('記事投稿' => 'contribute', 'ホーム' => 'home', '検索オプション' => 'search', '記事一覧' => 'directory', 'Login' => 'login', 'マイアカウント' => 'prefs', 'プラグインエントリ' => 'plugins', 'カスタムエントリ' => 'custom', 'サイト情報' => 'stats'),
    25 => array('新着記事' => 'article', '新着コメント' => 'comment', '新着トラックバック' => 'trackback', '新着ピングバック' => 'pingback', '新着ユーザー' => 'user', 'ユーザー情報更新' => 'user_update'),
    26 => array('G (一般向け)' => 'G', 'PG (保護者の指導が望ましい)' => 'PG', 'R (保護者同伴制限付き' => 'R', 'X (17歳未満利用禁止)' => 'X'),
    27 => array('表示回数 (昇順)' => 'hits|asc', '表示回数 (降順)' => 'hits|desc', '日付 (昇順)' => 'date|asc', '日付 (降順)' => 'date|desc', 'タイトル (昇順)' => 'title|asc', 'タイトル (降順)' => 'title|desc', '所有者 (昇順)' => 'uid|asc', '所有者 (降順)' => 'uid|desc'),
    28 => array('アクセス不可' => 0, '利用する' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('最初' => 'start', '最後' => 'end', 'なし' => 'none'),
    31 => array('新しいものから' => 'DESC', '古いものから' => 'ASC'),
    32 => array('表示しない' => 0, '記事のページにのみ表示する' => 1, '記事と話題の両方で表示する' => 2),
    33 => array('無効にする' => 0, '有効にする' => 1, '有効にする(リンクなし)' => 2, '有効にする(外部リンクなし)' => 3),
    34 => array('グリッド' => 'grid', 'リスト' => 'list'),
    35 => array('デフォルト' => 'default', '名前(昇順)' => 'NAME_ASC', '名前(降順)' => 'NAME_DESC', '種類(昇順)' => 'TYPE_ASC', '種類(降順)' => 'TYPE_DESC', '変更日時(昇順)' => 'MODIFIED_ASC', '変更日時(降順)' => 'MODIFIED_DESC'),
    36 => array('いいえ' => 'false', 'トップページのみ' => 'frontpage', 'トップページと話題ページ' => 'frontpage_topics'),
    37 => array('無効' => 0, '有効(index.phpあり)' => 1, '有効(index.phpなし)' => 2),
    38 => array('Mystery Man' => 'mm', 'Identicon' => 'identicon', 'MonsterId' => 'monsterid', 'WAvatar' => 'wavatar', 'Retro' => 'retro'),
    39 => array('なし' => '', 'Webページ' => 'core-webpage', '記事' => 'core-article', 'ニュース記事' => 'core-newsarticle', 'ブログ記事' => 'core-blogposting'),
    40 => array('無効' => 0, 'ログインユーザーとゲストユーザー' => 1, 'ログインユーザーのみ' => 2),
    41 => array('無効' => 0, 'LikesとDislikes' => 1, 'Likesのみ' => 2),
    42 => array('なし' => 0, '個々の記事の設定を使用する' => 1),
    43 => array('全て' => 'all', 'トップページのみ' => 'homeonly', '選択した話題のみ' => 'selectedtopics'),
    44 => array('No access' => 0, 'Read-Only' => 2),
    46 => array('LikesとDislikes' => 3, 'Likesのみ' => 1, 'Dislikesのみ' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'このフィールドは許可していない値を含んでいます',
    'notEmpty' => 'このフィールドの入力は必須です',
    'alphaNumeric' => 'このフィールドは半角英数です。',
    'alphaNumericOrEmpty' => 'このフィールドは半角英数字を入力するか空でなければなりません',
    'between' => 'このフィールドは特定の範囲内の値を入れなければなりません',
    'blank' => 'このフィールドは空でなければなりません',
    'comparison' => 'このフィールドは比較操作に適合していません',
    'date' => 'このフィールドはdateフォーマットで入力してください',
    'year' => 'このフィールドはyearフォーマットで入力してください',
    'yearOrRange' => 'このフィールドは年のフォーマットで入力してください。(例: 2010 または 2010 - 2012)',
    'time' => 'このフィールドはdateフォーマットで入力してください',
    'datetime' => 'このフィールドはdatetimeフォーマットで入力してください',
    'boolean' => 'このフィールドはbooleanフォーマットで入力してください',
    'decimal' => 'このフィールドはdecimalフォーマットで入力してください',
    'email' => 'このフィールドにはemailアドレスフォーマットで入力してください',
    'equalTo' => 'このフィールドは同じではありません',
    'extension' => 'このフィールドには許可している拡張子のファイルのみ入力できます',
    'ip' => '正しいフォーマットでIPアドレスを入力してください',
    'minLength' => 'このフィールドは短すぎます',
    'maxLength' => 'このフィールドは長すぎます',
    'numeric' => 'このフィールドには数値を入力してください',
    'phone' => 'このフィールドは電話番号のフォーマットで入力してください',
    'range' => 'このフィールドは指定範囲内の数値を入力してください',
    'url' => 'このフィールドは正しいフォーマットのURLを入力してください',
    'inList' => 'このフィールドは特定のリストの要素を含まなければなりません',
    'mail_settings_backend' => 'このフィールドは \'smtp\', \'smtps\', \'sendmail\', \'mail\'のどれか1つだけです',
    'mail_settings_sendmail_path' => 'このフィールドにはsendmail binaryへのパスを入力してください',
    'mail_settings_host' => 'このフィールドには正しいホスト名を入力してください',
    'mail_settings_port' => 'このフィールドには0から65535の数値を入力してください',
    'rdf_limit' => 'このフィールドには数値で入力してください',
    'path' => 'パスがありません',
    'file' => 'ファイルがありません',
    'fileName' => 'このフィールドには適切なファイル名を入力してください',
    'search_limits' => 'このフィールドにはコンマで区切られた数値を入力してください',
    'num_search_results' => 'このフィールドには下の\'search_limits\'の数値を入力してください',
    'theme' => 'テーマディレクトリがありません',
    'path_themes' => 'テーマパスは絶対パスでなければならず、最後にディレクトリセパレータが必要です',
    'path_to_mogrify' => '画像処理ライブラリimagemagickのセットアップを行い、このフィールドにmogrifyの実行ファイルのパスを入力してください',
    'path_to_netpbm' => '画像処理ライブラリnetpbmのセットアップを行い、このフィールドにnetpbmのパッケージのバイナリのあるディレクトリのパスを入力してください',
    'language' => '言語ファイルがありません',
    'timezone' => '無効なタイムゾーンです',
    'single_char' => 'このフィールドには半角1文字を入力してください',
    'page_navigation_max_pages' => 'このフィールドには2から21の数値を入力してください',
    'hash' => 'このフィールドにはあなたの使用しているPHPのバージョンでサポートしているhash関数を入力しなければなりません',
    'config_setting_lang_array' => 'それぞれのキーには他と異なるユニークな言語ショートカット(\'en\', \'de\', \'ja\'など)を指定し、対応するフィールドには言語ファイル名から .php を除いたものを指定してください',
    'config_setting_lang_array_element_req' => '少なくとも1つキーを指定してください。それぞれのキーには他と異なるユニークな言語ショートカット(\'en\', \'de\', \'ja\'など)を指定し、対応するフィールドには言語ファイル名から .php を除いたものを指定してください'
);
