#GLF 1.0
#D This is a Fermat prime calculator, rigged to self-destruct and stop
#D growing if any Fermat primes over 65537 turn up. Since the
#D existence of such primes is an unsolved problem in mathematics,
#D it is unknown if this pattern grows to infinite population.
#D
#D The tubs in a row represent the known Fermat primes, starting
#D with 5. The other three represent 17, 257, and 65537. A tub gets
#D destroyed whenever a Fermat prime is found. In the unlikely event
#D that an additional Fermat prime exists, the pond will eventually be
#D destroyed, followed by the puffers and breeders.
#D
#D A number N is tested at about generation 120N - 550, so the tubs
#D will be destroyed at about generations: 50; 1,490; 30,290; and
#D 7,863,890.
#D
#D The next-smallest Fermat number that is not known to be composite
#D is 2^2^31+1. Therefore, the pond (and the breeders) will survive at
#D least 10^640,000,000 generations. So don't expect to see anything
#D interesting happen by watching this pattern. Remove the tubs if you
#D want to see the destruction.
#D
#D The careful observer may notice that actually every number of the
#D form 2^N+1 is tested for primality, while Fermat numbers are of the
#D form 2^(2^N)+1. However, numbers of the form M^N+1 can never be
#D prime unless N is a power of 2, so the only primes of the form
#D 2^N+1 are in fact the Fermat primes.
#D
#D The "Primer" and "Caber Tosser" patterns used here are by Dean
#D Hickerson. The beehive puffer is by Hartmut Holzwart.
#D
#D Jason Summers, 7 Jan 2000
x = -419, y = -368, width = 838, height = 736
46b3o12b3o$46bobbo10bobbo$46bo16bo$46bo3bo8bo3bo$46bo6b4o6bo$47bobobo
bboobbobobo$51bo6bo$51bo6bo$50boboobboobo$50bo3boo3bo$51bo6bo$51boo4b
oo$54boo$49bo3bobbo3bo$53bobbo$50b4obb4o$52boobboo$53b4o$52bo4bo$$52bo
boobo$51bo6bo$51bo6bo$53b4o$49boobobooboboo$48bobboobooboobbo$47boobb
8obboo$47bo3bobboobbo3bo$46boo5bobbo5boo$46boo3b3obb3o3boo$47bobboobo
bboboobbo$48boobob4oboboo$53bobbo$48bo12bo82b3o15b3o$48bo4bobbo4bo81bo
3bo13bo3bo$50boo6boo82boo4bo11bo4boo$44bo5b3o4b3o81bobobooboo3b3o3boob
oobobo$43b3o8boo84boobo4boboob3oboobo4boboo$43boboo4bobobbobo75bo4bo4b
o3bo4bobo4bo3bo4bo$44b3obboboo4boobo69boob3o15bo5bo$39b3obb3obbo10bo
67boobo3boobboo7boo9boo7boo$38bobbo4bo77b5o4bobboo$41bo9bo6bo61booboob
obobo5bobbo$41bo4b3o4b4o7b3o15b3o33boobo3bo3bo8bo$38bobo4b3o15bo3bo13b
o3bo28b5o4bo$45b3o14boo4bo11bo4boo23booboobobobo3bo$48bo5boo5boboboob
oo3b3o3booboobobo20boobo3bo3bo$48boo3bobbo3boobo4boboob3oboobo4boboo
15b5o4bo$45bobbo5boo3bo4bo3bo4bobo4bo3bo4bo4bo5booboobobobo3bo$48bo22b
o5bo15b3obboobo3bo3bo$44bo3bo5boo3boo7boo9boo7boobb3ob3o4bo$44bo3bo4bo
bbo34boo5bobo3bo$48bo5boo33bobbo6bo$45bobo42bo$54boo52bo13bo$53bobbo
50b3o11b3o$54boo51boboo4bo5boboo14bo13bo$108b3o3b3o5b3o13b3o11b3o$54b
oo52boo3boobbo4boo13boobo5bo4boobo$53bobbo58b3o19b3o5b3o3b3o$54boo82b
oo4bobboo3boo$144b3o$54boo$53bobbo64b3o$54boo64bobbo$123bo14b3o$54boo
67bo14bobbo$53bobbo63bobo15bo$54boo56boo24bo$112boo25bobo$54boo92boo$
53bobbo49bo41boo$54boo49b3o7bo$104boobo5booboo37bo$54boo48b3o6booboo
28bo7b3o$53bobbo48boo6booboo26booboo5boboo$54boo59boo4bo5bo16booboo6b
3o$120b3o3b3o15booboo6boo$54boo63boobo3boboo4bo5bo4boo$53bobbo62b3o5b
3o3b3o3b3o$54boo64boo5boo3boobo3boboo$132b3o5b3o$54boo57boo9bo8boo5boo
$53bobbo57boo7b3o$54boo57bo8bo3bo10bo9boo$122bo3bo9b3o7boo$54boo33b3o
11b3o29bo3bo8bo$53bobbo31bobbo10bobbo12boobbo3bo8bo3bo$54boo35bo4b3o6b
o13boobo3bo29b3o11b3o$91bo4bobbo5bo12bo3booboo8bo3bobboo12bobbo10bobbo
$54boo32bobo4bo3bobbobo18bobo9bo3boboo13bo6b3o4bo$53bobbo38boboboo23bo
10booboo3bo12bo5bobbo4bo$54boo40booboo35bobo18bobobbo3bo4bobo$97b3o37b
o23boobobo$54boo34bo70booboo$53bobbo32b3o70b3o$54boo32boobo6bo72bo$88b
3o6boo26bo44b3o$54boo33boo7bo24booboo35bo6boboo$53bobbo38bo27booboo8bo
26boo6b3o$54boo37b4obo18bo6b3o7booboo24bo7boo$94bobbo18b3o15booboo27bo
$54boo39b3o18boboo15b3o6bo18bob4o$53bobbo60b3o23b3o18bobbo$54boo49b3o
9b3o22boobo18b3o$70bo13bo19bobbo9boo23b3o$54boo13b3o11b3o21bo34b3o9b3o
$53bobbo11boobo5bo4boobo21bo35boo9bobbo$54boo12b3o5b3o3b3o19bobo47bo$
69boo5boboo3boo69bo$54boo99bobo18b3o11b3o$53bobbo45bo7b3o3b3o56bobbo
10bobbo$54boo47boo5bobbobobbo59bo4b3o6bo$79bo22boo6bo7bo24b3o3b3o7bo
18bo4bobbo5bo$54boo21boo4b3o24bo7bo24bobbobobbo5boo16bobo4bo3bobbobo$
53bobbo26bobbo24bobobobo25bo7bo6boo22boboboo$54boo24bobbo59bo7bo31boob
oo$75bo7bo30bo29bobobobo33b3o$54boo18bo3boo4bobo26b3o8boo51bo$53bobbo
17bo37booboo7bobo20bo28b3o$54boo19bo36booboo8boo9boo8b3o26boobo6bo$85b
3o3b3o19bobo19bobo7booboo25b3o6boo$54boo12bo9bo5bobbo3bobbo19bo20boo8b
ooboo26boo7bo$53bobbo10b3o6b3o8bo3bo54bobo33bo$54boo11boboo5bo10bo3bo
55bo32b4obo$68b3o5bobo5bobo5bobo17booboo7boo43bo5bo5bobbo$54boo12boo7b
oo28bo3bo5bo5bobbo41b3o3b3o5b3o$53bobbo31b3o17boobbo3bo7boo10boo7boob
oo17boobo3boboo14b3o$54boo32b3o16boo4b3o19bobbo5bo5bo3bo12b3o5b3o14bo
bbo$88bobo22bobo20boo7bo3bobboo14boo5boo15bo$54boo33bo24bo31b3o4boo37b
o$53bobbo32bo24bo31bobo23bo20bobo$54boo19bo71bo23b3o$75boo20bo49bo22bo
3bo$54boo18bobo10bo3bo4b3o71bo3bo$53bobbo30booboo4boboo64bo$54boo32bob
o6b3o63b3o4bo3bo11b3o$80bo16boo63boobo4bo3bo11bo$54boo24boo7bo72b3o5b
ooboo12bo$53bobbo22bobo7bo73boo6bobo$54boo33bo82bo$112bo68b3o$54boo29b
o27boo66bo$53bobbo28boo25boo35bo32bo$54boo28bobo60boo$148boo$54boo26bo
93b3o$53bobbo24b3o6bo85bo$54boo25boboo5boo32boo51bo$82b3o4bobo22boo8bo
bo$54boo26b3o29boo9boo9boo48b3o11b3o$53bobbo25boo51bobo8boo23b3o11bobb
o10bobbo$54boo79boo9boo23bo16bo4b3o6bo$172bo15bo4bobbo5bo$54boo129bobo
4bo6bobo$53bobbo57bobo7boo71bo$54boo58bobo6bobbo64bo4bo$113bo10boo10b
oo7bobo43bo$54boo57b3o19bobbo6bobo39bo5bo$53bobbo52boo3b3obo17boo10bo
37b3o3b3o$54boo53boo6boo27b3o36boobo3b3o$117boo24bob3o3boo20boo10b3o4b
oo$54boo49bo37boo6boo20boo11boo5b5o$53bobbo48boo36boo34bo15b3o$54boo
48bobo71b3o$177boobo4bo6bo$54boo100b3o18b3o4b3o5bo$53bobbo99bo20b3o4bo
boo6bo7b3o$54boo101bo19b3o5b3o6boo6bobbo$178boo5boo6boo7bo$54boo137bo
8bo$53bobbo125bo20bobo$54boo125b3o$180bo3bo$54boo$53bobbo$54boo104bo
13bo5booboo$113boo5bo38b3o11b3o6bo12b3o$54boo57boo5boobboo33boboo4bo5b
oboo18bo$53bobbo62bobobbobo20boo11b3o3b3o5b3o19bo$54boo69boo9boo9boo
11boo3boobbo4boo4bo3bo$135bobo3b3o23b3o9bobobobo$54boo79boo4bo38b5o5b
3o$53bobbo85bo37booboo5bo$54boo125bobo7bo$173b3o5b3o$54boo116bobbo$53b
obbo118bo9b3o$54boo119bo9bo$172bobo11bo$54boo108boo$53bobbo107boo23bo$
54boo132b3o$158bo24boo3boboo$54boo101b3o7bo15b3o3b3o$53bobbo99boobo5b
ooboo19b3o$54boo100b3o6booboo19boo$157boo6booboo$54boo111boo$53bobbo$
54boo$$54boo80boo32b3o$53bobbo80boo31bo$54boo80bo28boo4bo4bo$125boo39b
oo7b3o$54boo68bo3bo36bo9boboo$53bobbo56boo8bo5bo7bo38b3o$54boo57boo8bo
3boboo4bobo38boo$123bo5bo3boo12boo21boo$54boo68bo3bo4boo12boo22boo$53b
obbo68boo6boo35bo$54boo79bobo$137bo$54boo$53bobbo$54boo$151boo$54boo
96boo$53bobbo94bo$54boo$$54boo$53bobbo$54boo88bo$144boo$54boo87bobo$
53bobbo$54boo$170boo$54boo114bo$53bobbo111bobo$54boo80boo30boo$137boo$
54boo80bo$53bobbo68boo$54boo68bo3bo$113boo8bo5bo7bo$54boo57boo8bo3bob
oo4bobo$53bobbo66bo5bo3boo12boo10bo$54boo68bo3bo4boo12boo10boo$125boo
6boo23bobo$54boo79bobo$53bobbo80bo$54boo$$54boo$53bobbo94boo$54boo96b
oo$151bo$54boo$53bobbo$54boo$$54boo88bo$53bobbo87boo$54boo87bobo$$54b
oo$53bobbo113boo$54boo114bo$168bobo$54boo80boo30boo$53bobbo80boo$54boo
80bo$125boo$54boo68bo3bo$53bobbo56boo8bo5bo7bo$54boo57boo8bo3boboo4bob
o$123bo5bo3boo12boo10bo$54boo68bo3bo4boo12boo10boo$53bobbo68boo6boo23b
obo$54boo79bobo$137bo$54boo$53bobbo$54boo$151boo$54boo96boo$53bobbo94b
o$54boo$$54boo$53bobbo$54boo88bo$144boo$54boo87bobo$53bobbo$54boo$170b
oo$54boo114bo$53bobbo111bobo$54boo80boo30boo$137boo$54boo80bo$53bobbo
68boo$54boo68bo3bo$113boo8bo5bo7bo$54boo57boo8bo3boboo4bobo$53bobbo66b
o5bo3boo12boo10bo$54boo68bo3bo4boo12boo10boo$125boo6boo23bobo$54boo79b
obo$53bobbo80bo$54boo$$54boo$53bobbo94boo$54boo96boo$151bo$54boo$53bo
bbo$54boo$$54boo88bo$53bobbo87boo$54boo87bobo$$54boo$53bobbo113boo$54b
oo114bo$168bobo$54boo80boo30boo$53bobbo80boo$54boo80bo$125boo$54boo68b
o3bo$53bobbo56boo8bo5bo7bo$54boo57boo8bo3boboo4bobo$123bo5bo3boo12boo
10bo$54boo68bo3bo4boo12boo10boo$53bobbo68boo6boo23bobo$54boo79bobo$
137bo$54boo$53bobbo$54boo$151boo$54boo96boo$53bobbo94bo$54boo$$54boo$
53bobbo$54boo88bo$144boo$54boo87bobo$53bobbo$54boo$170boo$54boo114bo$
53bobbo111bobo$54boo80boo30boo$137boo$54boo80bo$53bobbo68boo$54boo68bo
3bo$113boo8bo5bo7bo28bo$54boo57boo8bo3boboo4bobo26bobo$53bobbo66bo5bo
3boo12boo10bo5boo$54boo68bo3bo4boo12boo10boo$125boo6boo23bobo$54boo79b
obo$53bobbo80bo$54boo$$54boo$53bobbo94boo$54boo96boo$151bo$54boo$53bo
bbo151boo$54boo152bobo$208bo$54boo88bo$53bobbo87boo$54boo87bobo$$54boo
$53bobbo113boo$54boo114bo$168bobo$54boo80boo30boo$53bobbo80boo$54boo
80bo$125boo$54boo68bo3bo124boo$53bobbo56boo8bo5bo7bo115bobo$54boo57boo
8bo3boboo4bobo115bo$123bo5bo3boo12boo10bo$54boo68bo3bo4boo12boo10boo$
53bobbo68boo6boo23bobo$54boo79bobo$137bo$54boo$53bobbo$54boo$151boo$
54boo96boo$53bobbo94bo$54boo$298boo$54boo242bobo$53bobbo241bo$54boo88b
o$144boo$54boo87bobo$53bobbo$54boo$170boo$54boo114bo$53bobbo111bobo$
54boo80boo30boo$137boo$54boo80bo$53bobbo68boo662bobbo$54boo68bo3bo214b
oo448bo$113boo8bo5bo7bo205bobo443bo3bo$54boo57boo8bo3boboo4bobo205bo
446b4o13b4o$53bobbo66bo5bo3boo12boo10bo646bo3bo$54boo68bo3bo4boo12boo
10boo649bo$125boo6boo23bobo645bobbo$54boo79bobo646bo$53bobbo80bo644bob
o19boo$54boo727boo18b5o$796bob3obbo4bo21bo$54boo738boo3bo3b3obbo21b4o$
53bobbo94boo626bo14bobo7bobboo23boo$54boo96boo623bobo14boboo7boo28bo$
151bo613b3o10boo15boo35b4o$54boo708b5o27bo39bo$53bobbo331boo374b3oboo
62bobb3o$54boo155bo176bobo376boo5bo25boo5b4o23b3o$209bobo176bo383bobo
17boo4booboo3bo3bo24bo$54boo88bo65boo561boo16b4o3b4o8bo19bob3o$53bobbo
87boo635bo9booboo3boo5bobbo20boobbo$54boo87bobo622boo11bo11boo36b3o$
768boo7bobboo4bobo42bo$54boo721bo7bobboo43bo$53bobbo113boo605bobboo4bo
bo19boo5b4o12bobo$54boo114bo610bo11boo11booboo3bo3bo15bo$168bobo610bo
9booboo10b4o8bo12bobo$54boo80boo30boo621b4o12boo5bobbo15bo$53bobbo80b
oo653boo37bo$54boo80bo665boo9bo17b3o$125boo673b5o8b3o14boobbo$54boo68b
o3bo304boo365boo4bo5bo3bo13bob3o$53bobbo56boo8bo5bo7bo295bobo323bo40b
oo5b5o4bo18bo$54boo57boo8bo3boboo4bobo295bo323bobo42boo4b4oboboo17b3o$
123bo5bo3boo12boo10bo598boo45b3oboo3bo17bobb3o$54boo68bo3bo4boo12boo
10boo650bobo22bo$53bobbo68boo6boo23bobo671b4o$54boo79bobo653bo43bo$
137bo651boo24b4o13boo$54boo734boo22bo3bo9bob4o$53bobbo740b4o17bo9bobo$
54boo740bo3bo13bobbo9boo$151boo623bo23bo27boo$54boo96boo620boo20bobbo
27bobbo$53bobbo94bo623boo11bobbo39bo$54boo736bo38bo$478boo300bo7bo3bo
36b3o$54boo422bobo263bo33b3o3bo4b4o37bo$53bobbo421bo263bobo33boo5boo
42boo$54boo88bo598boo32bo6b3o41bobo$144boo632boo5boo39bobboo$54boo87bo
bo632b3o3bo4b4o34bobo$53bobbo723bo7bo3bo$54boo736bo35boo$788bobbo34bo
bbo$54boo769bobbo$53bobbo721boo46b3o$54boo80boo593bo44booboo46bo$137b
oo590boo45b4o46boo$54boo80bo593boo22boo5b4o12boo46bobo$53bobbo68boo
625booboo3bo3bo58bobboo$54boo68bo3bo394boo41b4o182b4o8bo59bobo$113boo
8bo5bo7bo385bobo39bo3bo159bo23boo5bobbo$54boo57boo8bo3boboo4bobo385bo
45bo157bobo95boo$53bobbo66bo5bo3boo12boo416bobbo159boo18boo9bo63bobbo$
54boo68bo3bo4boo12boo430boo165b5o8b3o60bobbo$125boo6boo443b4o164boo4bo
5bo3bo60b3o$54boo79bobo428bo11booboo163boo5b5o4bo61bo$53bobbo80bo426b
oobo3bobbo5boo166boo4b4oboboo60boo$54boo506b5o4bo3bo175b3oboo3bo61bobo
$562bobbo4bo4boo180bobo60bobboo$54boo506b5o4bo3bo245bobo$53bobbo507boo
bo3bobbo5boo104bo50bo$54boo510bo11booboo101boo49boo24b4o57boo$578b4o
103boo49boo22bo3bo17boo5b4o27bobbo$54boo523boo162b4o17bo15booboo3bo3bo
26bobbo$53bobbo151boo358boo17boo153bo3bo13bobbo16b4o8bo27b3o$54boo152b
obo357bobo15b4o124bo7bo23bo34boo5bobbo29bo$208bo359bo17booboo14boo105b
obo5boo20bobbo74boo$54boo532boo14b4o105boo6boo11bobbo41bo39bobo$53bobb
o547booboo129bo39boo8boo27bobboo$54boo527boo21boo109boo15bo3bo38bo9bo
bbo27bobo$582boo133b3o4boo9b4o39b5o4bobbo$54boo663bo3boo5b3o46b4o3boob
oo28boo$53bobbo524boo136b3o6booboo49bo4boo28bobbo$54boo547boo114bo3boo
5b3o83bobbo$597b3o3bobo111b3o4boo9b4o26bobo49b3o$54boo538b3o6boboo34bo
50bo23bobboo13bo3bo27b3o49bo$53bobbo537bo9boo33boo49boo24bo3bo17bo27b
3o20b4o24boo$54boo538b3o7bo35boo49boo24bo16bobbo50bo3bo23bobo$717b3o
51b4o17bo21bobboo$54boo668boo27bo16bo3bo13bobbo23bobo$53bobbo199bo348b
oo92bo22booboo24boo21bo$54boo198bobo339b4o4b4o89bobo22b4o26boo16bobbo
42boo$255boo338bo3bo4booboo89boo23boo37bobbo48bobbo$54boo543bo6boo158b
o46bobbo$53bobbo538bobbo139bo23bo3bo47b3o$54boo680boo14boo9b4o48bo$
737boo12boo5b3o53boo$54boo691b3o6booboo52bobo$53bobbo590boo102boo5b3o
50bobboo$54boo199bo29bo29bo29bo29bo29bo29bo29bo29bo29bo29bo29bo29bo30b
obo103boo9b4o8boo35bobo$255b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o
27b3o27b3o27b3o8bo18b3o28boboo112bo3bo6bo4bo$54boo202bo29bo29bo29bo29b
o29bo29bo29bo29bo29bo29bo29bo5boo22bo28b3o116bo12bo33boo$54bobo200boo
28boo28boo28boo28boo28boo28boo28boo28boo28boo28boo28boo6boo20boo28boob
o79b4o28bobbo7bo5bo31bobbo$55bobo590boo79b6o39b6o30bobbo$56boo671b4ob
oo16boo57b3o$259b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o
122bo48boo15booboo57bo$259b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o
27b3o27b3o120bobo65b4o29b4o24boo$258bo3bo25bo3bo25bo3bo25bo3bo25bo3bo
25bo3bo25bo3bo25bo3bo25bo3bo25bo3bo25bo3bo120boo66boo29bo3bo23bobo$
778bo7bo21bobboo$257boo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3b
oo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo129bo79b7obbobbo23bobo$
590boo28boo28boo28boo9boo17boo22b3o3b3o3b3o3b3o3b3o3b3o5bobb3oboo$590b
obo27bobo27bobo27bobo9boo16bobo60b7obbobbo24boo$591boo28boo28boo28boo
28boo65bo7bo21bobbo$782bo3bo20bobbo$261b3o27b3o27b3o27b3o27b3o27b3o27b
3o27b3o27b3o27b3o27b3o219b4o21b3o$258boo28boo28boo28boo28boo28boo28boo
28boo28boo28boo28boo202bobbo43bo$258boo28boo28boo28boo28boo28boo28boo
28boo28boo28boo28boo206bo41boo$257boo28boo28boo28boo28boo28boo28boo28b
oo28boo28boo28boo178boo10boo11bo3bo7b6o27bobo$258bobo27bobo27bobo27bob
o27bobo27bobo27bobo27bobo27bobo27bobo27bobo177boo11bo11b4o6bo5bo25bobb
oo$259boo28boo28boo28boo28boo28boo28boo28boo28boo28boo28boo143b4o29bo
8bo7boobb3o18bo26bobo$693bo9bo3bo37bo8boobb3o12bo4bo$590boo28boo22bo5b
oo22bo19boo11bo38bo7boobb3o14boo30boo$259boo3boo23boo3boo23boo3boo23b
oo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo
24bobo27bobo20bobo4bobo21bo4bo11b3o5boobbobbo35boo7bo11b4o38bobbo$259b
oo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo
23boo3boo23boo3boo23boo3boo25boo28boo20bobo5boo21bo3bobo10boo6b3o41boo
4boo11bo3bobbobbo31bobbo$253bo29bo29bo29bo29bo29bo29bo29bo29bo29bo120b
o33bobbo9b3o5boobbobbo12boo5b4o12bo23bo6bo6boo23b3o$251boo8b3o17boo8b
3o17boo8b3o17boo8b3o17boo8b3o17boo8b3o17boo8b3o17boo8b3o17boo8b3o17boo
8b3o27b3o114bobbo10boo13bo9booboo3bo3bo7b3o22bobbo3bo3bo4booboo23bo$
252boo7b3o18boo7b3o18boo7b3o18boo7b3o18boo7b3o18boo7b3o18boo7b3o18boo
7b3o18boo7b3o18boo7b3o27b3o115boo11boo9bo3bo9b4o8bo6b5o29b4o4b4o23boo$
262bo29bo29bo29bo29bo29bo29bo29bo29bo29bo29bo130boo9b4o10boo5bobbo7b3o
boo5boo30boo23bobo$694bo44boo7boo52bobboo$671boo6b5o40bo22bo55bobo$
647bo8bo12booboo4bo4bo35bo3bobbo33bobo12b4o$646b3o7bo8bo3b4o10bo14b3o
17boo7bo30b3oboo11bobboo24boo$244bobo27bobo27bobo27bobo27bobo27bobo27b
obo27bobo27bobo27bobo68boo53b3obo3b4o8boobbobo3boo6bo3bo17bo18boo6bo
24boo4b3ob3o11bobboo21bobbo$244boo16boo10boo16boo10boo16boo10boo16boo
10boo16boo10boo16boo10boo16boo10boo16boo10boo16boo10boo16boo28boo20bob
o5boo28boo19b4obb4o6bobboo3bo12bo18bo20boo4boo25boo4booboo12bobbo21bo
bbo$245bo16boo11bo16boo11bo16boo11bo16boo11bo16boo11bo16boo11bo16boo
11bo16boo11bo16boo11bo16boo28boo22bo5boo28boo16bobbo4b4o8boobbobo3boo
32bobo18bo26bo7b3o3boo9boo23b3o$641boboob3o7bo8bo3b4o31bobbo14boo37bo
4boo35bo$641b3obo10bo12booboo128boo$640bobbo6b3o18boo32b3o93bobo$486b
4o4b4o142boobboo4bo75b4o50boo17bobboo$238bo29bo29bo29bo29bo29bo29bo29b
o36bo3bo3bo3bo4bobbo136b4o5bo56bobbo13bo3bo32boo14booboo17bobo$236boo
28boo28boo28boo28boo28boo28boo28boo41bo7bo8bo137bo33boo32bo16bo31b4o
13b4o$237boo28boo28boo28boo28boo28boo28boo28boo36bobbo4bobbo5bo3bo134b
o34booboo27bo3bo12bobbo32booboo13boo20boo$503b4o133bobo22b3o8b4o16boo
11b4o50boo34bobbo$572boo65boo3bo20bo11boo15booboo99bobbo$563b4o4b4o50b
oo13bo3boo20bo27b4o101b3o$484b3o3boo70bo3bo4booboo48b4o17bo49boo103bo$
477bo5bo3bobboo9boo63bo6boo39bo9booboo12bo3bo153boo$229bobo27bobo27bob
o27bobo27bobo27bobo27bobo27bobo36bo3bo5bo11bobboo57bobbo34boo12bo11boo
14bobo38boo113bobo$229boo28boo28boo28boo28boo28boo28boo28boo35b3o9bo
10b3obbo94bobo8bobboo4bobo55b3o3boo9bo101bobboo$230bo29bo29bo29bo29bo
29bo29bo29bo41bo5bo10bo4bo96bo8bo7bobboo24b4o26b3o14boo101bobo$484bob
oo11b5o19bobbo36boo45bobboo4bobo24bo3bo25bo3bo12boboo$472bo27boo25bo
35bo7boo41bo11boo22bo25b4o13bobo102boo$463boo8bo49bo3bo35bobbo5boo31b
oo7bo9booboo3boo5bobbo3bobbo27b3o13boo101bobbo$460b3oboo5b3o21boo5bobb
o18b4o36b3o4boo31bobo17b4o3b4o8bo151bobbo$223bo29bo29bo29bo29bo29bo29b
o56b5o29b4o8bo43bo15boo3bo34bo18boo4booboo3bo3bo152b3o$221boo28boo28b
oo28boo28boo28boo28boo58b3o30booboo3bo3bo43bo49boo31boo5b4o41bobbo108b
o$222boo28boo28boo28boo28boo28boo28boo63bo21boo5boo5b4o43bobo44b3oboo
86bo6boo98boo$468bo9bo8booboo59bo20boo23b5o8boo73bo3bo4booboo96bobo$
466b3o7bobo4bo3b4o60bo19b4o23b3o8bobo24boo48b4o4b4o95bobboo$475bobbo5b
o3boo64boo15booboo35bo15boo3b3o4bo55boo97bobo$475bo6bobbo51bo15b4o16b
oo11b4o33boo6b5o4boo$475bobbo5bo3boo46bo16booboo27bo3bo12bobbo18b3o4bo
boo6bo153boo$214bobo27bobo27bobo27bobo27bobo27bobo27bobo79bobo4bo3b4o
45b3o16boo32bo16bo8boo8bo4boo9bo151bobbo$214boo28boo28boo28boo28boo28b
oo28boo82bo8booboo93bobbo13bo3bo7bobo13boo5bobbo151bobbo$215bo29bo29bo
29bo29bo29bo29bo93boo12boo98b4o9bo13boo6bo154b3o$503bo4bo13bo25boo244b
o$509bo11bo15bo8booboo28bo59bobbo150boo$509bo11b3o11bobo4bo3b4o30bo18b
obo41bo148bobo$185boo28boo28boo28boo28boo28boo28boo28boo28boo28boo28b
oo14bo32bobbo5bo3boo29b3o12b3oboo3bo36bo3bo146bobboo$184bobbo26bobbo
20bo5bobbo20bo5bobbo20bo5bobbo20bo5bobbo20bo5bobbo26bobbo26bobbo27boo
28boo15bobbobobo3boo19bo6bobbo12bo32boo4b4oboboo18b4o13b4o147bobo$184b
o29bo21boo6bo21boo6bo21boo6bo21boo6bo21boo6bo29bo29bo77bobb3obo3boo19b
obbo5bo3boo6bo3bo28boo5b5o4bo17bo3bo$184bo29bo22boo5bo22boo5bo22boo5bo
22boo5bo22boo5bo29bo29bo27bo50bobobbo26bobo4bo3b4o10bo13bo13boo4bo5bo
3bo21bo165boo$184bobo27bobo27bobo27bobo27bobo27bobo27bobo27bobo27bobo
26bo49boo32bo8booboo4bo4bo14bo12b5o8b3o18bobbo164bobbo$184bobo27bobo
27bobo27bobo27bobo27bobo27bobo27bobo27bobo24b3o94boo6b5o12b3o14boo9bo
187bobbo$185bo29bo29bo29bo29bo29bo29bo29bo29bo364b3o$581b4o10boo5bobbo
185bo$580bo3bo9b4o8bo183boo$182boo3boo10bobo10boo3boo10bobo10boo3boo
10bobo10boo3boo10bobo10boo3boo10bobo10boo3boo10bobo10boo3boo23boo3boo
23boo3boo146boo7bo9booboo3bo3bo182bobo$182bo5bo10boo11bo5bo10boo11bo5b
o10boo11bo5bo10boo11bo5bo10boo11bo5bo10boo11bo5bo23bo5bo23bo5bo78bo29b
o36b4obbobbo12boo5b4o180bobboo$200bo29bo29bo29bo29bo29bo103boo28boo20b
obo5boo20bobo5boo27bo3boo209bobo$183bo3bo25bo3bo25bo3bo25bo3bo25bo3bo
25bo3bo25bo3bo25bo3bo25bo3bo25bobo27bobo20bobo4bobo20bobo4bobo18b3o7b
4obbobbo$184b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o26boo28boo22bo
5boo22bo5boo17booboo8boo7bo204boo$559bo20bo3bo202bobbo$581b4o201bobbo$
193bo29bo29bo29bo29bo473b3o$191boo28boo28boo28boo28boo475bo$88boo102b
oo28boo28boo28boo28boo473boo$89bo696bobo$89bobo5boo89bo29bo29bo29bo29b
o29bo29bo29bo29bo150b4o201bobboo$90boo5bobbo85bobo27bobo27bobo27bobo
27bobo27bobo27bobo27bobo27bobo128bo20bo3bo202bobo$81boo18bo9bobo73boo
28boo28boo28boo28boo28boo28boo28boo28boo22boo28boo22bo5boo22bo5boo17b
ooboo8boo7bo$81boo18bo7bo3bo337bobo27bobo20bobo4bobo20bobo4bobo18b3o7b
4obbobbo204boo$67bo10boo21bo7bo73bo29bo29bo29bo29bo29bo29bo29bo29bo28b
oo28boo20bobo5boo20bobo5boo27bo3boo207bobbo$67bobo7b3o17bobbo7bo4bo8b
oo58b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o80bo29bo36b4obbobbo12b
oo5b4o178bobbo$70boo6boo17boo10bo12boo57b5o25b5o25b5o25b5o25b5o25b5o
25b5o25b5o25b5o147boo7bo9booboo3bo3bo179b3o$56boo12boo9boo5boo19bo3bo
48bo17boo3boo23boo3boo23boo3boo23boo3boo23boo3boo23boo3boo8bo14boo3boo
8bo14boo3boo8bo14boo3boo151bo3bo9b4o8bo180bo$56boo12boo9boo5bobo9bobo
8bobo46b3o18b5o25b5o25b5o25b5o25b5o25b5o10bo14b5o10bo14b5o10bo14b5o
153b4o10boo5bobbo180boo$67bobo20bo9boo57bo21bo3bo25bo3bo25bo3bo25bo3bo
25bo3bo25bo3bo8b3o14bo3bo8b3o14bo3bo8b3o14bo3bo357bobo$67bo11bo10boo9b
o57boo21bobo27bobo27bobo27bobo27bobo27bobo14boo11bobo27bobo27bobo121b
oo6b5o12b3o14boo9bo181bobboo$77bobo67bo35bo29bo29bo29bo29bo29bo15boo
12bo29bo29bo24boo51boo32bo8booboo4bo4bo14bo12b5o8b3o180bobo$78boo66bob
obooboo294boo50bobobbo26bobo4bo3b4o10bo13bo13boo4bo5bo3bo$147bo3bobobo
bo290bo51bobb3obo3boo19bobbo5bo3boo6bo3bo28boo5b5o4bo180boo$151bo4boo
25boo28boo28boo28boo28boo28boo28boo17bo10boo28boo28boo28boo15bobbobobo
3boo19bo6bobbo12bo32boo4b4oboboo178bobbo$152bo30boo28boo28boo28boo28b
oo28boo28boo16bobo9boo18bo9boo28boo28boo14bo32bobbo5bo3boo29b3o12b3ob
oo3bo179bobbo$106bo46bo227bo29bobo93bo11b3o11bobo4bo3b4o30bo18bobo181b
3o$105boo45boo227boo29boo93bo11bo15bo8booboo28bo204bo$105bobo308bo65bo
bbo15bo4bo13bo25boo233boo$414bo3bo67bo14boo98b4o175bobo$95boo21boo264b
oo33bo49boo11bo3bo96bobbo13bo3bo173bobboo$96bo21bobo28boo229b4oboo27bo
4bo51bo11b4o47b3o16boo32bo16bo174bobo$96bobo9bo4boo6bo7boo17bobbo4boo
222b6o29b5o46bo7boobb3o53bo16booboo27bo3bo12bobbo$97boo8bobobbobbobbo
bbo7boo17bobbo4bobo222b4o80bo8boobb3o54bo15b4o16boo11b4o192boo$107boob
ob3o6bo27boo8bo297bo8bo7boobb3o71boo15booboo204bobbo$107booboo6bobo39b
o295bo14bo11b4o62bo19b4o204bobbo$107boobo7boo41bo295bo5boo4boo11bo3bo
bbobbo56bo20boo206b3o$107bobo35bo16bo301boo20bo6bo6boo46bobo228bo$108b
o35bobo16bo293b3o3bo18bobbo3bo3bo4booboo45bo229boo$145bo14b3o293b5o29b
4o4b4o46bo15boo3bo207bobo$159bo296b3oboo37boo21b4o36b3o4boo81b3o120bo
bboo$141bo18bo298boo7boo51bo3bo35bobbo5boo79b5o120bobo$140bobo18bo307b
oo20bo33bo35bo7boo80b3oboo28boo$141bo20bo305bo20bo4bo3bo22bobbo36boo
91boo20b4o4b4o89boo$163bo317booboo3bo3bo4boo175bo3bo4booboo86bobbo$
137bo26bo316bobbo8bo5boo178bo6boo86bobbo$136bobo26bo307boo7b3o13boo60b
obbo102boobbo4bobbo96b3o$137bo28bo307boo11bobbo73bo6boo91boo5bo104bo$
167bo305bo14boo70bo3bo4booboo89bo3bo3boo9bo92boo$133bo34bo392b4o4b4o
90boboo14b4o89bobo$132bobo34bo400boo91booboobo6b8obo86bobboo$133bo36bo
329boo164bo8bo9boo86bobo$165boo4bo310boo14booboo168bo3boo4bob3o$165bob
obobo3bo305b4o13b4o165bo3bo10b3o89boo$168booboobobo304booboo13boo168bo
9bo92bobbo$175bo307boo156bo33bo95bobbo$640bo32bo3bo7boo85b3o$116bo523b
3o35bo5b4o85bo$117bo555bo4bo5booboo83boo$115b3o9bobbo36bobbo36bobbo36b
obbo36bobbo36bobbo36bobbo36bobbo36bobbo36bobbo36bobbo36bobbo36bobbo37b
obbo22b5o7boo83bobo$126bo39bo39bo39bo39bo39bo39bo39bo39bo39bo39bo39bo
39bo23b3o19bo116bobboo$126bo3bo35bo3bo35bo3bo35bo3bo35bo3bo35bo3bo35bo
3bo35bo3bo35bo3bo35bo3bo35bo3bo35bo3bo35bo3bo19bobo15bo3bo13bobbo100bo
bo$126b4o36b4o36b4o36b4o36b4o36b4o36b4o36b4o36b4o36b4o36b4o36b4o36b4o
20b3o16b4o17bo$94boo570bo3bo100boo$93bobo534boo12b3o20b4o98bobbo$93bo
536boo12b3o121bobbo$92boo27bobobo115bobobo117bo150b4o111bo13bobo123b3o
$513bo3bo12bobbo96boo138bo$121bo123bo115bo3bo151bo16bo104bo20bo4boo
102boo$22boo489bobbo13bo3bo104boo16b4o3booboo99bobo$22boo97bobo119bo
119bobo165b4o94b5o4bobo15b5o4bobbo97bobboo$508bo119bo4bo21bo9bobbo98bo
bo$125bo115bo123bo143bo123bo22boo8boo$507b3o118bo3bo11bo12bo110boo$
121bobo117bo120bobo159bo4boo99bo13boo120bobbo$521b4o3booboo110bobo13b
oo5bobbo95bobbo$35boboo94boo368bo16b5o4bobbo125b4o8bo95b3o$14boo14bobb
oboboo94bo89boo28boo28boo28boo28boo28boo28boo28boo28boo28boo9bo14bo9bo
bbo125booboo3bo3bo12boo82bo$14boo13bo3bobbo97b3o86bo29bo29bo29bo29bo
29bo29bo29bo29bo29bo8b3o15boo8boo117bo10boo5b4o3b4o4b4o80boo$30bo6bobo
96bo87b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o27b3o24bo127boo22bo3b
o4booboo78bobo$31bo5bo188bo29bo29bo29bo29bo29bo29bo29bo29bo29bo151bobo
26bo6boo77bobboo$29bo493boo5bobbo139bobbo87bobo$29bo12bo479b4o8bo$44b
oo456bobbo16booboo3bo3bo119bo16boo92boo$41booboo460bo17boo5b4o119boo
15boo8boo84bo$6boo35bo458bo3bo146bobo14bo3bo5bobbo83bo$6boo36boo457b4o
8bo155bo3bo4bobboo82bo$515boo25b4o125bo4bobbobboo79bobbo$43boo469bobo
14bo9bo3bo113bo13bobo3b4o81boo$532boo11bo113boo102boo$41bo487b3o5boobb
obbo113bobo103bobo$42bobo475bo7b3o6b3o143boo79bob4o$39boobbo477bo7b3o
5boobbobbo137b4o82boo$520bo11boo11bo136booboo84bo$531bo9bo3bo12boo107b
oo15boo82b4o$542b4o3b4o4b4o104booboo102bo$b3o521bo22bo3bo4booboo103b4o
99bobb3o$3bo16boo496boo5boo25bo6boo105boo102b3o$bo19boo492b3oboo3bobo
21bobbo219bo$3bo16bo494b5o246bob3o$b3o512b3o247boobbo$boo527bo18boo
216b3o$bbo58boboo465boo17bo7boo208bo$b3o52bobboboboo464bobo17bobbo5boo
209bo$o3b3o48bo3bobbo487b3o4boo208bobo$5boo49bo6bobo470bo15boo3bo212bo
$5boo50bo5bo472bo230bobo$bbo21bobo28bo12boo466bobo230bo$bbo22boboo3boo
21bo12boo467bo20boo207bo$bbo18boo3boob5o503boo18b4o206b3o$21boo3bobob
oobo523booboo204boobbo$20bobboobo4b3o10bo497boo15boo205bob3o$21bobobo
7bo9bobo494booboo226bo$21bobo18bo3bo493b4o226b3o$42bobbo495boo225bobb
3o39bo$42bobbo14boo710bo38bo3bo$42bobo15boo706b4o44bo$13b3o755bo13bobb
3o20bo4bo$13b3o752boo12boobboboobo20b5o$15bo750b4o8bob4o3b3oboo13boo$
16bobbooboo742bo10b5obobbobob4o6boobb5obo$10b3o3b4o3bo751bo4bo4b4obo3b
o5b4o7bo$16boboobobo3b3o216boo528bo6bo4bobbobboo4bo10bo$15bo13bo15bo6b
oo192bobo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bobbo3b5o3bo
bbob3oboo7b3o$27bo16b3o5boo193bobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobo
bobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobb
obbo6bo5boo9b3obbo3bo$29bo14bobbo200boobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobobob
obobbobbo6bo5boo9b3obbo3bo$27b3o16bo205bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3b
o3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo3bo
3bo3bo3bo3bo3bo3bobbo3b5o3bobbob3oboo7b3o$27boo15b3o729bo6bo4bobbobboo
4bo10bo$28bo15b3o728bo4bo4b4obo3bo5b4o7bo$27b3o15bo719bo11b5obobbobob
4o6boobb5obo$26bo3b3o11boo717bo6bo7bob4o3b3oboo13boo$31boo12boo723bo
11boobboboobo20b5o$31boo730bo6bobb3o9bobb3o20bo4bo$28bo735b6o3b3o40bo$
28bo744boo3boo31bo3bo$28bo747booboo32bo$774b6o$772bo3b3o$776bo$772bo3b
o$773b4o!
