/*****
 NAME
 	perror.h - protocols for error operation
 VERSION
 	$Id$
 CHANGELOG
 	$Log$
 */

#if !defined(PERROR_H_INCLUDED)
#define PERROR_H_INCLUDED

#include <coconut/pobject.h>

@protocol PError <PObject>
  - set: (error_code_t) code ;
  - (error_code_t) code ;

  - setValue: (int) value ;
  - (int) value ;

  - (exit_code_t) exitCode ;
@end

@protocol PErrorFactory
  + (id <PError>) can_not_close ;
  + (id <PError>) can_not_continue ;
  + (id <PError>) can_not_happen ;
  + (id <PError>) can_not_open ;
  + (id <PError>) can_not_read ;
  + (id <PError>) can_not_write ;
  + (id <PError>) exit: (int) no ;
  + (id <PError>) illegal_arg ;
  + (id <PError>) illegal_parameter ;
  + (id <PError>) illegal_range ;
  + (id <PError>) illegal_format ;
  + (id <PError>) no_arg ;
  + (id <PError>) not_exist ;
  + (id <PError>) not_matched ;
  + (id <PError>) not_supported ;
  + (id <PError>) not_serious ;
  + (id <PError>) overflow ;
  + (id <PError>) unknown ;
  + (id <PError>) system: (int) no ;
@end

@protocol PDebug <PObject>
    /* this stream is a object protocol PIndentStream. The protocol can not
       be used here. So you must take care of the type of the parameter. */
  - print: (id) stream ;
@end

#endif /* !defined(PERROR_H_INCLUDED) */

