/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.prefs.PropertiesFile;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends PreferencePanel
implements PreferenceNames,
ItemListener {
    public static final String MODULE = "GeneralPa";
    JLabel icon = new JLabel(GRI18n.getString("GeneralPa", "icon"));
    List locales = null;
    boolean defaultLocale = false;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTextField thumbnailWidth = new JTextField();
    JLabel jLabel2 = new JLabel();
    JTextField thumbnailHeight = new JTextField();
    JPanel jPanel2 = new JPanel();
    JCheckBox savePasswords = new JCheckBox();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabel3 = new JLabel();
    JComboBox logLevel = new JComboBox<String>(new String[]{GRI18n.getString("GeneralPa", "logLevel0"), GRI18n.getString("GeneralPa", "logLevel1"), GRI18n.getString("GeneralPa", "logLevel2"), GRI18n.getString("GeneralPa", "logLevel3")});
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JCheckBox updateCheck = new JCheckBox();
    JCheckBox updateCheckBeta = new JCheckBox();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jPanel5 = new JPanel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JCheckBox showThumbnails = new JCheckBox();
    JLabel jLabel4 = new JLabel();
    JComboBox jLocale = new JComboBox();
    JLabel jLabel5 = new JLabel();
    JPanel jPanel9 = new JPanel();
    JLabel jTranslator = new JLabel();

    public JLabel getIcon() {
        return this.icon;
    }

    public void readProperties(PropertiesFile props) {
        this.showThumbnails.setSelected(props.getBooleanProperty("showThumbnails"));
        this.thumbnailWidth.setText("" + (int)props.getDimensionProperty("thumbnailSize").getWidth());
        this.thumbnailHeight.setText("" + (int)props.getDimensionProperty("thumbnailSize").getHeight());
        this.savePasswords.setSelected(props.getBooleanProperty("savePasswords"));
        this.logLevel.setSelectedIndex(props.getIntProperty("logLevel"));
        this.updateCheck.setSelected(props.getBooleanProperty("updateCheck"));
        this.updateCheckBeta.setSelected(props.getBooleanProperty("updateCheckBeta"));
        this.locales = GRI18n.getAvailableLocales();
        Vector<String> localeStrings = new Vector<String>();
        Iterator it = this.locales.iterator();
        while (it.hasNext()) {
            Locale l = (Locale)it.next();
            StringBuffer localeDisplay = new StringBuffer(l.getDisplayLanguage(l));
            if (l.getCountry() != null && l.getCountry().length() > 0) {
                localeDisplay.append(" (").append(l.getDisplayCountry(l));
                if (l.getVariant() != null && l.getVariant().length() > 0) {
                    localeDisplay.append(", ").append(l.getDisplayVariant(l));
                }
                localeDisplay.append(")");
            }
            localeStrings.add(localeDisplay.toString());
        }
        int selectedLocale = this.locales.indexOf(GRI18n.parseLocaleString(GalleryRemote._().properties.getProperty("uiLocale")));
        if (selectedLocale == -1) {
            localeStrings.add(0, "Default");
            selectedLocale = 0;
            this.defaultLocale = true;
        }
        this.jLocale.setModel(new DefaultComboBoxModel(localeStrings));
        this.jLocale.setSelectedIndex(selectedLocale);
        this.setTranslator();
    }

    public void writeProperties(PropertiesFile props) {
        props.setBooleanProperty("showThumbnails", this.showThumbnails.isSelected());
        try {
            Dimension d = new Dimension(Integer.parseInt(this.thumbnailWidth.getText()), Integer.parseInt(this.thumbnailHeight.getText()));
            props.setDimensionProperty("thumbnailSize", d);
        }
        catch (Exception e) {
            Log.log(1, MODULE, "Thumbnail size should be integer numbers");
        }
        props.setBooleanProperty("savePasswords", this.savePasswords.isSelected());
        props.setIntProperty("logLevel", this.logLevel.getSelectedIndex());
        props.setBooleanProperty("updateCheck", this.updateCheck.isSelected());
        props.setBooleanProperty("updateCheckBeta", this.updateCheckBeta.isSelected());
        Locale selectedLocale = this.getSelectedLocale();
        if (selectedLocale != null) {
            props.setProperty("uiLocale", selectedLocale.toString());
        }
    }

    public void buildUI() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.jLabel1.setText(GRI18n.getString(MODULE, "thumbS"));
        this.jPanel1.setLayout(this.gridBagLayout4);
        this.thumbnailWidth.setMinimumSize(new Dimension(25, 21));
        this.thumbnailWidth.setPreferredSize(new Dimension(25, 21));
        this.thumbnailWidth.setToolTipText(GRI18n.getString(MODULE, "thumbW"));
        this.jLabel2.setText(GRI18n.getString(MODULE, "label2"));
        this.thumbnailHeight.setMinimumSize(new Dimension(25, 21));
        this.thumbnailHeight.setPreferredSize(new Dimension(25, 21));
        this.thumbnailHeight.setToolTipText(GRI18n.getString(MODULE, "thumbH"));
        this.jPanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "thumb")));
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.savePasswords.setToolTipText(GRI18n.getString(MODULE, "savePwdTip"));
        this.savePasswords.setText(GRI18n.getString(MODULE, "savePwd"));
        this.jPanel2.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "log_priv")));
        this.jLabel3.setText(GRI18n.getString(MODULE, "logLevel"));
        this.logLevel.setToolTipText(GRI18n.getString(MODULE, "logLevelTip"));
        this.logLevel.setActionCommand("comboBoxChanged");
        this.logLevel.setSelectedIndex(-1);
        this.jPanel4.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "versionCheck")));
        this.jPanel4.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanel4.setLayout(this.gridBagLayout3);
        this.updateCheck.setToolTipText(GRI18n.getString(MODULE, "updateCheckTip"));
        this.updateCheck.setText(GRI18n.getString(MODULE, "updateCheck"));
        this.updateCheckBeta.setToolTipText(GRI18n.getString(MODULE, "updateBetaCheckTip"));
        this.updateCheckBeta.setText(GRI18n.getString(MODULE, "updateBetaCheck"));
        this.showThumbnails.setToolTipText(GRI18n.getString(MODULE, "showThumbTip"));
        this.showThumbnails.setText(GRI18n.getString(MODULE, "showThumb"));
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel4.setText(GRI18n.getString(MODULE, "langWarn"));
        this.jLabel5.setText(GRI18n.getString(MODULE, "lang"));
        this.jPanel7.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), GRI18n.getString(MODULE, "langTitle")));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.thumbnailWidth, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.thumbnailHeight, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel6, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.showThumbnails, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.savePasswords, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel2.add((Component)this.logLevel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel4, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.updateCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.updateCheckBeta, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jPanel5, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel7, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel4, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLocale, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jTranslator, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel7.add((Component)this.jPanel9, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel8, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jLocale.addItemListener(this);
    }

    public void setTranslator() {
        Locale locale = this.getSelectedLocale();
        Properties p = GRI18n.getLocaleProperties(locale);
        if (p != null) {
            String translator = p.getProperty("Common.translator");
            if (translator != null) {
                this.jTranslator.setText(GRI18n.getString(MODULE, "langTranslatedBy", new Object[]{translator}));
            }
        } else {
            this.jTranslator.setText("");
        }
    }

    private Locale getSelectedLocale() {
        int selectedLocale = this.jLocale.getSelectedIndex();
        if (this.defaultLocale) {
            if (selectedLocale != 0) {
                return (Locale)this.locales.get(selectedLocale - 1);
            }
            return null;
        }
        return (Locale)this.locales.get(selectedLocale);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.setTranslator();
        }
    }
}

