/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.transform;

import gnu.xml.libxmlj.transform.GnomeTransformer;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GnomeTransformerFactory
extends TransformerFactory {
    private URIResolver uriResolver;
    private ErrorListener errorListener;
    private Map attributes;

    public Source getAssociatedStylesheet(Source source, String media, String title, String charset) throws TransformerConfigurationException {
        String href = null;
        String base = source.getSystemId();
        if (source instanceof DOMSource) {
            Document doc;
            Node node2 = ((DOMSource)source).getNode();
            Document document = doc = node2.getNodeType() == 9 ? (Document)node2 : node2.getOwnerDocument();
            if (base == null) {
                base = doc.getDocumentURI();
            }
            node2 = doc.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 7 && "xml-stylesheet".equals(node2.getNodeName())) {
                    String data = node2.getNodeValue();
                    if ((media == null || media.equals(this.parseParameter(data, "type"))) && (title == null || title.equals(this.parseParameter(data, "title")))) {
                        href = this.parseParameter(data, "href");
                    }
                }
                node2 = node2.getNextSibling();
            }
        } else {
            XMLReader parser = null;
            try {
                InputSource input;
                if (source instanceof SAXSource) {
                    SAXSource sax = (SAXSource)source;
                    input = sax.getInputSource();
                    parser = sax.getXMLReader();
                } else {
                    StreamSource stream = (StreamSource)source;
                    InputStream in = stream.getInputStream();
                    input = new InputSource(in);
                }
                input.setSystemId(base);
                if (parser == null) {
                    parser = this.createXMLReader();
                }
                AssociatedStylesheetHandler ash = new AssociatedStylesheetHandler();
                ash.media = media;
                ash.title = title;
                parser.setContentHandler(ash);
                parser.parse(input);
                href = ash.href;
            }
            catch (SAXException e) {
                throw new TransformerConfigurationException(e);
            }
            catch (IOException e) {
                throw new TransformerConfigurationException(e);
            }
        }
        if (href == null) {
            return null;
        }
        if (base != null) {
            base = XMLJ.getBaseURI(base);
        }
        href = XMLJ.getAbsoluteURI(base, href);
        return new StreamSource(href);
    }

    private final XMLReader createXMLReader() throws TransformerConfigurationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            return parser.getXMLReader();
        }
        catch (FactoryConfigurationError e) {
            throw new TransformerConfigurationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new TransformerConfigurationException(e);
        }
        catch (SAXException e) {
            throw new TransformerConfigurationException(e);
        }
    }

    String parseParameter(String data, String name) {
        char delim;
        int end;
        int start = data.indexOf(name + '=');
        if (start != -1 && (end = data.indexOf(delim = data.charAt((start += name.length() + 2) - 1), start)) != -1) {
            return data.substring(start, end);
        }
        return null;
    }

    public synchronized void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public synchronized Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public boolean getFeature(String name) {
        boolean bl = false;
        if ("http://javax.xml.transform.stream.StreamSource/feature".equals(name) || "http://javax.xml.transform.stream.StreamResult/feature".equals(name) || "http://javax.xml.transform.dom.DOMSource/feature".equals(name) || "http://javax.xml.transform.dom.DOMResult/feature".equals(name)) {
            bl = true;
        }
        return bl;
    }

    public void setFeature(String name, boolean value) throws TransformerConfigurationException {
        throw new TransformerConfigurationException(name);
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        return this.newTransformer(null);
    }

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        return new GnomeTransformer(source, this.uriResolver, this.errorListener);
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        return new GnomeTransformer(source, this.uriResolver, this.errorListener);
    }

    public static native void freeLibxsltGlobal();

    private final /* synthetic */ void this() {
        this.attributes = new HashMap();
    }

    public GnomeTransformerFactory() {
        this.this();
    }

    static {
        XMLJ.init();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AssociatedStylesheetHandler
    extends DefaultHandler {
        String media;
        String title;
        String href;

        public void processingInstruction(String target, String data) throws SAXException {
            if ("xml-stylesheet".equals(target)) {
                if (this.media != null && !this.media.equals(GnomeTransformerFactory.this.parseParameter(data, "type"))) {
                    return;
                }
                if (this.title != null && !this.title.equals(GnomeTransformerFactory.this.parseParameter(data, "title"))) {
                    return;
                }
                this.href = GnomeTransformerFactory.this.parseParameter(data, "href");
            }
        }

        AssociatedStylesheetHandler() {
        }
    }
}

