/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.cli;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class UseModality<OptionType> {
    private static final String MODE_FLAG_NAME = "mode";
    private final Map<String, Class<? extends UseModality<OptionType>>> registeredModes = new Object2ObjectOpenHashMap();
    private boolean junitMode;
    private String[] originalArgs;
    private UseModality<OptionType> executedModality;

    public UseModality<OptionType> getExecutedModality() {
        return this.executedModality;
    }

    protected UseModality() {
    }

    public void defineOptions(JSAP jsap) throws JSAPException {
        if (jsap.getByID("help") == null) {
            Parameter helpFlag = new Switch("help").setShortFlag('h').setLongFlag("help").setHelp("This message.");
            jsap.registerParameter(helpFlag);
        }
    }

    public void process(String[] args, OptionType options) throws JSAPException, IllegalAccessException, InstantiationException {
        Class<UseModality<OptionType>> modalityClass;
        JSAP jsap = new JSAP();
        this.originalArgs = args;
        FlaggedOption modeFlag = new FlaggedOption(MODE_FLAG_NAME).setStringParser((StringParser)JSAP.STRING_PARSER).setDefault(JSAP.NO_DEFAULT).setRequired(true).setShortFlag('m').setLongFlag(MODE_FLAG_NAME);
        modeFlag.setHelp(this.getHelpString(this.registeredModes));
        jsap.registerParameter((Parameter)modeFlag);
        JSAPResult result = jsap.parse(args);
        String mode = result.getString(MODE_FLAG_NAME);
        this.defineOptions(jsap);
        if (mode == null) {
            System.out.println(jsap.getHelp());
            System.exit(0);
        }
        if ((modalityClass = this.registeredModes.get(mode.toLowerCase())) != null) {
            UseModality<OptionType> modality = modalityClass.newInstance();
            modality.setOriginalArgs(args);
            modality.defineOptions(jsap);
            result = jsap.parse(args);
            this.executedModality = modality;
            if (!result.success()) {
                Iterator errors = result.getErrorMessageIterator();
                while (errors.hasNext()) {
                    String errorMessage = (String)errors.next();
                    System.out.println(errorMessage);
                }
            }
            if (UseModality.checkPrintHelp(jsap, result)) {
                return;
            }
            modality.interpretArguments(jsap, result, options);
            modality.process(options);
        } else if (StringUtils.isBlank((String)mode)) {
            this.printHelp(jsap);
        } else {
            System.err.println("Mode \"" + mode + "\" is not defined for this utility.");
            if (!this.junitMode) {
                System.exit(10);
            }
        }
    }

    public abstract void interpretArguments(JSAP var1, JSAPResult var2, OptionType var3);

    public abstract void process(OptionType var1);

    protected void printHelp(JSAP jsap) {
        System.out.print(jsap.getHelp());
    }

    public void registerMode(String modeName, Class<? extends UseModality<OptionType>> modalityActor) {
        this.registeredModes.put(modeName.toLowerCase().intern(), modalityActor);
    }

    private String getHelpString(Map<String, Class<? extends UseModality<OptionType>>> modes) {
        StringBuilder builder = new StringBuilder("Mode of execution, one of: ");
        int count = 0;
        for (String mode : modes.keySet()) {
            if (count > 0) {
                builder.append(", ");
            }
            builder.append(mode);
            ++count;
        }
        return builder.toString();
    }

    public void addHelpFlag(JSAP jsap) throws JSAPException {
        Switch helpFlag = new Switch("help").setShortFlag('h').setLongFlag("help");
        jsap.registerParameter((Parameter)helpFlag);
    }

    public static boolean checkPrintHelp(JSAP jsap, JSAPResult jsapResult) {
        if (!jsapResult.success() || jsapResult.contains("help") && jsapResult.getBoolean("help")) {
            System.out.println(jsap.getHelp());
            return true;
        }
        return false;
    }

    public void setTestingMode(boolean testing) {
        this.junitMode = testing;
    }

    public String[] getOriginalArgs() {
        return this.originalArgs;
    }

    public void setOriginalArgs(String[] args) {
        this.originalArgs = args;
    }
}

