/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_CORE_U64_H
#define VATOMIC_CORE_U64_H
/*******************************************************************************
 * @file core_u64.h
 * @brief Atomic functions for vatomic64_t variables.
 *
 * This file declares and documents the core atomic functions operating on
 * vatomic64_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/core.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#ifndef VATOMIC_CORE_H
    #error "File included directly. Include <vsync/atomic/core.h> instead!"
#endif

/**
 * Initializes the atomic variable a with value v.
 *
 * The initialization is equivalent to an vatomic64_write().
 *
 * @param a atomic variable
 * @param v initial value
 * @memord seq_cst
 */
static inline void vatomic64_init(vatomic64_t *a, vuint64_t v);

/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_read(const vatomic64_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
static inline vuint64_t vatomic64_read_acq(const vatomic64_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_read_rlx(const vatomic64_t *a);

/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
static inline void vatomic64_write(vatomic64_t *a, vuint64_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
static inline void vatomic64_write_rel(vatomic64_t *a, vuint64_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
static inline void vatomic64_write_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_xchg(vatomic64_t *a, vuint64_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_xchg_acq(vatomic64_t *a, vuint64_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_xchg_rel(vatomic64_t *a, vuint64_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_xchg_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint64_t vatomic64_cmpxchg(vatomic64_t *a, vuint64_t e,
                                          vuint64_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint64_t vatomic64_cmpxchg_acq(vatomic64_t *a, vuint64_t e,
                                              vuint64_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint64_t vatomic64_cmpxchg_rel(vatomic64_t *a, vuint64_t e,
                                              vuint64_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint64_t vatomic64_cmpxchg_rlx(vatomic64_t *a, vuint64_t e,
                                              vuint64_t v);

/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_max(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_max_acq(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord release
 */
static inline vuint64_t vatomic64_get_max_rel(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_max_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_max_get(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord acquire
 */
static inline vuint64_t vatomic64_max_get_acq(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord release
 */
static inline vuint64_t vatomic64_max_get_rel(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_max_get_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord seq_cst
 */
static inline void vatomic64_max(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord release
 */
static inline void vatomic64_max_rel(vatomic64_t *a, vuint64_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord relaxed
 */
static inline void vatomic64_max_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_and(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_and_acq(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_and_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_and_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_and_get(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_and_get_acq(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint64_t vatomic64_and_get_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_and_get_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic64_and(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic64_and_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic64_and_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_or(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_or_acq(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_or_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_or_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_or_get(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_or_get_acq(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint64_t vatomic64_or_get_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_or_get_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic64_or(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic64_or_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic64_or_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_xor(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_xor_acq(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_xor_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_xor_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_xor_get(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_xor_get_acq(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint64_t vatomic64_xor_get_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_xor_get_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic64_xor(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic64_xor_rel(vatomic64_t *a, vuint64_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic64_xor_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_add(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_add_acq(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_add_rel(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_add_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_add_get(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_add_get_acq(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord release
 */
static inline vuint64_t vatomic64_add_get_rel(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_add_get_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord seq_cst
 */
static inline void vatomic64_add(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord release
 */
static inline void vatomic64_add_rel(vatomic64_t *a, vuint64_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord relaxed
 */
static inline void vatomic64_add_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_inc(vatomic64_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_inc_acq(vatomic64_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_inc_rel(vatomic64_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_inc_rlx(vatomic64_t *a);

/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_inc_get(vatomic64_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_inc_get_acq(vatomic64_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord release
 */
static inline vuint64_t vatomic64_inc_get_rel(vatomic64_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_inc_get_rlx(vatomic64_t *a);

/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic64_inc(vatomic64_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic64_inc_rel(vatomic64_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic64_inc_rlx(vatomic64_t *a);

/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_sub(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_sub_acq(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_sub_rel(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_sub_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_sub_get(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_sub_get_acq(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord release
 */
static inline vuint64_t vatomic64_sub_get_rel(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_sub_get_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord seq_cst
 */
static inline void vatomic64_sub(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord release
 */
static inline void vatomic64_sub_rel(vatomic64_t *a, vuint64_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord relaxed
 */
static inline void vatomic64_sub_rlx(vatomic64_t *a, vuint64_t v);

/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_get_dec(vatomic64_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint64_t vatomic64_get_dec_acq(vatomic64_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint64_t vatomic64_get_dec_rel(vatomic64_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_get_dec_rlx(vatomic64_t *a);

/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
static inline vuint64_t vatomic64_dec_get(vatomic64_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
static inline vuint64_t vatomic64_dec_get_acq(vatomic64_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
static inline vuint64_t vatomic64_dec_get_rel(vatomic64_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
static inline vuint64_t vatomic64_dec_get_rlx(vatomic64_t *a);

/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic64_dec(vatomic64_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic64_dec_rel(vatomic64_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic64_dec_rlx(vatomic64_t *a);

#endif
