/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform.sax;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SAXSource
implements Source {
    public static final String FEATURE = "http://javax.xml.transform.sax.SAXSource/feature";
    private XMLReader xmlReader;
    private InputSource inputSource;

    public void setXMLReader(XMLReader reader) {
        this.xmlReader = reader;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void setSystemId(String systemId) {
        if (this.inputSource != null) {
            this.inputSource.setSystemId(systemId);
        }
    }

    public String getSystemId() {
        if (this.inputSource != null) {
            return this.inputSource.getSystemId();
        }
        return null;
    }

    public static InputSource sourceToInputSource(Source source) {
        InputSource in = null;
        if (source instanceof SAXSource) {
            in = ((SAXSource)source).getInputSource();
        } else if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            InputStream inputStream = streamSource.getInputStream();
            if (inputStream != null) {
                in = new InputSource(inputStream);
            } else {
                Reader reader = streamSource.getReader();
                if (reader != null) {
                    in = new InputSource(reader);
                }
            }
            String publicId = streamSource.getPublicId();
            if (publicId != null && in != null) {
                in.setPublicId(publicId);
            }
        }
        String systemId = source.getSystemId();
        if (systemId != null) {
            if (in == null) {
                in = new InputSource(systemId);
            } else {
                in.setSystemId(systemId);
            }
        }
        return in;
    }

    public SAXSource() {
    }

    public SAXSource(XMLReader reader, InputSource inputSource) {
        this.xmlReader = reader;
        this.inputSource = inputSource;
    }

    public SAXSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }
}

