package Alien::SDL::ConfigData;
use strict;
my $arrayref = eval do {local $/; <DATA>}
  or die "Couldn't load ConfigData data: $@";
close DATA;
my ($config, $features, $auto_features) = @$arrayref;

sub config { $config->{$_[1]} }

sub set_config { $config->{$_[1]} = $_[2] }
sub set_feature { $features->{$_[1]} = 0+!!$_[2] }  # Constrain to 1 or 0

sub auto_feature_names { sort grep !exists $features->{$_}, keys %$auto_features }

sub feature_names {
  my @features = (sort keys %$features, auto_feature_names());
  @features;
}

sub config_names  { sort keys %$config }

sub write {
  my $me = __FILE__;

  # Can't use Module::Build::Dumper here because M::B is only a
  # build-time prereq of this module
  require Data::Dumper;

  my $mode_orig = (stat $me)[2] & 07777;
  chmod($mode_orig | 0222, $me); # Make it writeable
  open(my $fh, '+<', $me) or die "Can't rewrite $me: $!";
  seek($fh, 0, 0);
  while (<$fh>) {
    last if /^__DATA__$/;
  }
  die "Couldn't find __DATA__ token in $me" if eof($fh);

  seek($fh, tell($fh), 0);
  my $data = [$config, $features, $auto_features];
  print($fh 'do{ my '
	      . Data::Dumper->new([$data],['x'])->Purity(1)->Dump()
	      . '$x; }' );
  truncate($fh, tell($fh));
  close $fh;

  chmod($mode_orig, $me)
    or warn "Couldn't restore permissions on $me: $!";
}

sub feature {
  my ($package, $key) = @_;
  return $features->{$key} if exists $features->{$key};

  my $info = $auto_features->{$key} or return 0;

  require Module::Build;  # XXX should get rid of this
  foreach my $type (sort keys %$info) {
    my $prereqs = $info->{$type};
    next if $type eq 'description' || $type eq 'recommends';

    foreach my $modname (sort keys %$prereqs) {
      my $status = Module::Build->check_installed_status($modname, $prereqs->{$modname});
      if ((!$status->{ok}) xor ($type =~ /conflicts$/)) { return 0; }
      if ( ! eval "require $modname; 1" ) { return 0; }
    }
  }
  return 1;
}


=head1 NAME

Alien::SDL::ConfigData - Configuration for Alien::SDL

=head1 SYNOPSIS

  use Alien::SDL::ConfigData;
  $value = Alien::SDL::ConfigData->config('foo');
  $value = Alien::SDL::ConfigData->feature('bar');

  @names = Alien::SDL::ConfigData->config_names;
  @names = Alien::SDL::ConfigData->feature_names;

  Alien::SDL::ConfigData->set_config(foo => $new_value);
  Alien::SDL::ConfigData->set_feature(bar => $new_value);
  Alien::SDL::ConfigData->write;  # Save changes


=head1 DESCRIPTION

This module holds the configuration data for the C<Alien::SDL>
module.  It also provides a programmatic interface for getting or
setting that configuration data.  Note that in order to actually make
changes, you'll have to have write access to the C<Alien::SDL::ConfigData>
module, and you should attempt to understand the repercussions of your
actions.


=head1 METHODS

=over 4

=item config($name)

Given a string argument, returns the value of the configuration item
by that name, or C<undef> if no such item exists.

=item feature($name)

Given a string argument, returns the value of the feature by that
name, or C<undef> if no such feature exists.

=item set_config($name, $value)

Sets the configuration item with the given name to the given value.
The value may be any Perl scalar that will serialize correctly using
C<Data::Dumper>.  This includes references, objects (usually), and
complex data structures.  It probably does not include transient
things like filehandles or sockets.

=item set_feature($name, $value)

Sets the feature with the given name to the given boolean value.  The
value will be converted to 0 or 1 automatically.

=item config_names()

Returns a list of all the names of config items currently defined in
C<Alien::SDL::ConfigData>, or in scalar context the number of items.

=item feature_names()

Returns a list of all the names of features currently defined in
C<Alien::SDL::ConfigData>, or in scalar context the number of features.

=item auto_feature_names()

Returns a list of all the names of features whose availability is
dynamically determined, or in scalar context the number of such
features.  Does not include such features that have later been set to
a fixed value.

=item write()

Commits any changes from C<set_config()> and C<set_feature()> to disk.
Requires write access to the C<Alien::SDL::ConfigData> module.

=back


=head1 AUTHOR

C<Alien::SDL::ConfigData> was automatically created using C<Module::Build>.
C<Module::Build> was written by Ken Williams, but he holds no
authorship claim or copyright claim to the contents of C<Alien::SDL::ConfigData>.

=cut


__DATA__
do{ my $x = [
       {
         'additional_cflags' => '-I/usr/pkg/include/smpeg -I/usr/pkg/include -I/usr/X11R7/include -I/usr/include -I/usr/pkg/include -I/usr/pkg/include/smpeg',
         'additional_libs' => '-Wl,-rpath,/usr/pkg/lib -L/usr/lib -L/usr/pkg/lib -Wl,-rpath,/usr/lib -Wl,-rpath,/usr/X11R7/lib -L/usr/X11R7/lib',
         'build_arch' => 'aarch64eb-netbsd-thread-multi',
         'build_cc' => 'gcc',
         'build_os' => 'netbsd',
         'build_params' => {
                             'buildtype' => 'use_config_script',
                             'prefix' => '/usr/pkg',
                             'script' => '/usr/pkg/bin/sdl-config',
                             'title' => 'Already installed SDL ver=1.2.15 path=/usr/pkg
    SDL(v1.2.15) SDL_image(v1.2.12) SDL_mixer(v1.2.12) SDL_ttf(v2.0.11) SDL_gfx(v2.0.26) SDL_Pango(v1.3) '
                           },
         'build_prefix' => 'sharedir/1.446_94d15703',
         'config' => {
                       'ld_paths' => [],
                       'ld_shared_libs' => [
                                             '/usr/lib/libpthread.so',
                                             '/usr/lib/libz.so',
                                             '/usr/pkg/lib/libjpeg.so',
                                             '/usr/pkg/lib/libtiff.so',
                                             '/usr/pkg/lib/libpng16.so',
                                             '/usr/pkg/lib/libogg.so',
                                             '/usr/pkg/lib/libvorbis.so',
                                             '/usr/pkg/lib/libvorbisfile.so',
                                             '/usr/pkg/lib/libfreetype.so',
                                             '/usr/pkg/lib/libpangoft2-1.0.so',
                                             '/usr/pkg/lib/libpango-1.0.so',
                                             '/usr/pkg/lib/libgobject-2.0.so',
                                             '/usr/pkg/lib/libgmodule-2.0.so',
                                             '/usr/pkg/lib/libglib-2.0.so',
                                             '/usr/pkg/lib/libfontconfig.so',
                                             '/usr/lib/libexpat.so'
                                           ],
                       'ld_shlib_map' => {
                                           'expat' => '/usr/lib/libexpat.so',
                                           'fontconfig' => '/usr/pkg/lib/libfontconfig.so',
                                           'freetype' => '/usr/pkg/lib/libfreetype.so',
                                           'glib' => '/usr/pkg/lib/libglib-2.0.so',
                                           'gmodule' => '/usr/pkg/lib/libgmodule-2.0.so',
                                           'gobject' => '/usr/pkg/lib/libgobject-2.0.so',
                                           'jpeg' => '/usr/pkg/lib/libjpeg.so',
                                           'ogg' => '/usr/pkg/lib/libogg.so',
                                           'pango' => '/usr/pkg/lib/libpango-1.0.so',
                                           'pangoft2' => '/usr/pkg/lib/libpangoft2-1.0.so',
                                           'png' => '/usr/pkg/lib/libpng16.so',
                                           'pthread' => '/usr/lib/libpthread.so',
                                           'tiff' => '/usr/pkg/lib/libtiff.so',
                                           'vorbis' => '/usr/pkg/lib/libvorbis.so',
                                           'vorbisfile' => '/usr/pkg/lib/libvorbisfile.so',
                                           'z' => '/usr/lib/libz.so'
                                         }
                     },
         'script' => '/usr/pkg/bin/sdl-config'
       },
       {},
       {}
     ];
$x; }