<?php

declare(strict_types=1);

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace TYPO3\CMS\Adminpanel\ModuleApi;

/**
 * AdminPanel ConfigurableInterface
 *
 * Used to indicate that an adminpanel module can be enabled or disabled via configuration
 *
 * Usual implementation is done via user tsconfig
 * @see \TYPO3\CMS\Adminpanel\ModuleApi\AbstractModule::isEnabled()
 */
interface ConfigurableInterface
{
    /**
     * Module is enabled
     * -> should be initialized
     * A module may be enabled but not shown
     * -> only the initializeModule() method
     * will be called
     */
    public function isEnabled(): bool;
}
