#GLF 1.0
#D A Turing Machine in Conway's Game of Life
#D
#D I put this pattern together mainly using patterns that I created in the
#D 1980's. The basic design has a Universal Turing Machine in mind so design
#D expands easily to 16 states and 8 symbols. I have a design for a Universal
#D Turing Machine which fits in that size. This is the first fully working
#D Turing machine so I made it small, just 3 states and 3 symbols.  It takes
#D 11040 generations for one cycle.
#D
#D The program I chose is one that duplicates a pattern of 1's. With 2 1's on
#D the tape to the right of the reading position it takes 16 cycles to stop with
#D 4 1's on the tape. This takes over one hour on my computer.
#D
#D The numbers for each state transition are  State,Symbol,Direction
#D
#D State, Input, Symbol 0, Symbol 1, Symbol 2
#D 0, Find next 1, 20R,  12R,  02L
#D 1, Write 2*2, 02L, -, 12R
#D 2, Convert 2 to 1, Halt, -, 21R
#D
#D A P240 gun has been placed to insert the instruction "Next State = 0,
#D Symbol = 0, Direction = R" when the blocking glider is deleted. This starts
#D up the Turing Machine.
#D
#D I have put an extra fanout in the addressing of the finite state machine to
#D give a trace of the operation.
#D
#D Paul Rendell 02/03/00
#D http://rendell.server.org.uk/gol/tm.htm
x = -857, y = -824, width = 1714, height = 1647
247boo$248bo$248bobo$249boo6$257boo$256boo$258bo5$265bo$264boo$264bobo
6$272boo$271boo$273bo5$280bo$279boo$279bobo6$287boo$286boo$288bo3$244b
oo$242bobbo$241bo15bobo35bo$233boo6bo10b3obbo3bo32boo$233boo6bo19bo32b
obo$242bobbobboo7bo4bo4boo$244boobbobbobo7bo5boo$249b3o5bo3bo$257bobo
$$302boo34boo$242bo58boo36bo$241bo61bo35bobo9bo$241b3o96boo8bobo$349bo
3boo6boo$349bo3boboo4bobo$349bo3bob3o4b3o$272boo36bo39boboboobbo4b3o$
272bo36boo40bo4boo4b3o$234bo34boobo36bobo49bobo6boo$234bobo34bo89boo7b
obo$234boo31bo104bo$269bo102boo$268bo$$317boo$227bo88boo$226bo91bo$
226b3o31boo$259bobo13boo19boo$261bo14bo19bo58bo$276bobo8boo5bobo57boo$
277boo8boo5boo29bo21bo6bobo$103bo180boo38boo19b3o$103b3o113bo63b3o38bo
bo17bo27bo$106bo112bobo62boo58boo26b3o$105boo112boo31b3o32boo8b3o75bo$
254bo32boo9bo56bo18boo$108bo144bo44bo54b3o6boo$258bobbo4bobbo27b3o42bo
9bo8boo$256b3obb6obb3o60boo7b3o8boo9bo$212bo45bobbo4bobbo27b3o31boo8b
3o$211bo85b3o33bo$211b3o31boo92boo3boo3b3o$115bo128bobo26bo23b3o39boo
3boo3b3o$114boo130bo25b3o23bo49bo3bo17bo5b3o$114bobo154bobobo22bo58bo
11boo4bo3bo$271bobobo21b3o39boo6boo3boo3b3o9bobobbo5bo$272b3o63bobo19b
o14bo3bo$204bo68bo63boo20boo15b3o$204bobo131boo36b3o$204boo31b3o98boo
22bo$122boo115bo33bo67b3o3b3o11b3o$121boo115bo33b3o76boo7bo3bo14boo$
123bo147bobobo75boo6bob3obo6boo5bo$271bobobo76boo6b5o6bobo6b3o$197bo
74b3o75bobo20bo8bo$196bo76bo50bo12boo3boo6boo$196b3o31boo92bo$130bo98b
obo13boo19boo55b3o12bo3bo$129boo100bo14bo19bo72b3o3boo3boo$129bobo114b
obo8boo5bobo24b3o45b3o3boo3boo$247boo8boo5boo26bo30b3o31bo6b3o$254boo
36bo31bo22b3o8boo6bo$189bo63b3o35b3o30bo12boo8b3o7boo6bo$189bobo62boo
68bo13bo9bo$189boo31b3o32boo8b3o21b3o30bo10b3o$137boo85bo32boo9bo22b3o
29b3o9bo22b3o$136boo85bo44bo89b3o$138bo89bobbo4bobbo27b3o21b3o51boo5bo
4bo3bo5boo$226b3obb6obb3o50bo30b3o20bo4bo4bo5bo3boo$182bo45bobbo4bobbo
27b3o22bo31bo18b3o5b3o3bo3bo6bo$181bo85b3o21b3o30bo18bo14b3o$183bo31b
oo$145bo33bo34bobo26bo23b3o58bobboboobobbo$144boo32boboo34bo25b3o23bo
58boobbo4bobboo$144bobo31bo62bobobo22bo59bobboboobobbo35bo$177boo62bob
obo21b3o74bo29boo$242b3o64bobo32bobo27bobo$243bo65bobbo31boo$121bo190b
oo47boo$121b3o83b3o100bo3boo45bo$124bo27boo55bo33bo68boo48b3o$123boo
26boo22boo31bo33b3o57boo5bobbo6boo43bo$153bo21bo65bobobo55bobo5bobo7bo
bo15bo44boo$163boo8bobo65bobobo55bo19bo14bo44boo$161bo3bo7boo67b3o55b
oo19boo13b3o44bo$152bo7bo5bo76bo50bo$125b3o24bobo4boobo3bo33boo92bo$
124bo3bo26boo3bo5bo32bobo13boo19boo55b3o$141boo12boo4bo3bo25boo8bo14bo
19bo$123bo5bo11boo12boo6boo26bo24bobo8boo5bobo24b3o126bo34boo$123boo3b
oo22bobo28boo3boobo25boo8boo5boo26bo30b3o33bo59boo35bo$152bo29bo3bo3bo
33boo36bo31bo34bobo57bobo34bobo8bo$166boo13bo41b3o35b3o30bo34boo96boo
8bobo$128boo36boo13bo3bobbo35boo68bo143bobo7bo$128bobo38boo10bo5bo4b3o
32boo8b3o21b3o30bo143bobbo6boo$130bo10boo26b3o10bo3bo7bo32boo9bo22b3o
29b3o142bobobboo4boo$129boo9boo27boo12boo8bo44bo120boo76bobo3boo4b3o$
126bo15bo16boo5boo9bobo18bobbo4bobbo27b3o21b3o58bo36bo37boo38bo5boo4b
oo$126bobbo28bobo5boo10boo16b3obb6obb3o50bo30b3o25bo35bobo36boo50boo7b
oo$126bo31bo19bo19bobbo4bobbo27b3o22bo31bo26b3o33boo39bo49bo8bobo$157b
oo78b3o21b3o30bo59boo79boo22bo$185boo5bo160bobo78bo24boo$125booboboo
17bo16boo16bobo5b4o17bo23b3o58bobboboobobbo45bo$148boo17bo18bo6b4o15b
3o23bo58boobbo4bobboo125bo$125bo5bo16bobo16bobo5bobo15bobbo14bobobo22b
o59bobboboobobbo95bo$168boo5bobbo14b4o14bobobo21b3o74bo89boo28boo$126b
ooboo47boo12b4o4boo10b3o64bobo32bobo87bobo$128bo47bo3boo10bo7bobo10bo
65bobbo31boo$178boo22bo79boo62b3o13boo19boo$175bobbo8boo13boo76bo3boo
62bo14bo19bo$130boo24boo17bobo8boo25bo68boo63bo15bobo8boo5bobo58boo$
130bo24boo23bo7bo23b3o57boo5bobbo6boo73boo7bobo5boo51bo6boo$131b3o23bo
21bo31bobobo55bobo5bobo7bobo15bo64b3o37boo18b3o8bo$133bo45b3o29bobobo
55bo19bo14bo64b3o37boo18bo27bo$212b3o55boo19boo13b3o63b3o9b3o26bo17boo
26b3o$213bo50bo74boo32bobo86bo$195bo68bo73bobo33boo7bo3bo54bo18boo$
164bo29boo67b3o74bo5boo6boo27bo3bo52b3o7bo$163boo29bobo148bobbo4bobbo
82bo9boo$163bobo6bo58b3o110b6obb6o26b3o33bo8bo9boo8bobo$151boo19bobo
57bo30b3o33bo45bobbo4bobbo62boo7b3o$152bo19boo58bo31bo34bobo44boo6boo
63bobo5b5o$152bobo8bo67b3o30bo34boo83b3o39bobobobo$153boo8bobo98bo66b
3o92boo3boo3b3o$164bobo35boo27b3o30bo68bo26bo22bo3bo47booboo$164bobbo
33boo28b3o29b3o66bo26b3o21bo3bo47booboo4bo12boobboo3boo$164bobo36bo
154b5o63boo7b5o4b3o9boo5b3o$163bobo4boo59b3o58bo91b3o39boo6boo3boo6bo
10bo3bo3bo$163bo6bobo59bo30b3o25bo133bo20boo15bobo$172bo59bo31bo26b3o
131b3o36bo$172boo57b3o30bo59boo103bo6boo$210bo112bobo99b5o5b5o8b3o$
209boo57bobboboobobbo45bo101boo6bo12b3o15boo$209bobo55boobbo4bobboo77b
5o74b3o7bo3bo14bo$268bobboboobobbo79b3o77bo18b3o6b3o$284bo75bo63boo3b
oo6boo7boo3boo7bo8bo$249bobo32bobo138b5o7boo20bo$249bobbo31boo125bo13b
ooboo$252boo62b3o13boo19boo55b3o12booboo$217boo31bo3boo62bo14bo19bo24b
3o28bobobo12b3o3boo3boo$216boo34boo63bo15bobo8boo5bobo55bobobo18bobobo
bo$218bo23boo5bobbo6boo73boo7bobo5boo24bo3bo28b3o20b5o5bobo5boo$241bob
o5bobo7bobo15bo64b3o32bo3bo29bo22b3o7boo4bobo$241bo19bo14bo64b3o80boo
9bo8bo7bo$240boo19boo13b3o63b3o9b3o21b3o44bo$309boo32bobo65bo10b3o$
225bo82bobo33boo7bo3bo52b3o9bo23bo$224boo84bo5boo6boo27bo3bo20b3o28bob
obo31bobo$224bobo88bobbo4bobbo82bobobo18boo5bo4bo3bo6bo$314b6obb6o26b
3o20bo3bo28b3o20bo5bobo3b3o6boo$269bo45bobbo4bobbo50bo3bo29bo18b3o6boo
bboo3boo4bobo$269bobo44boo6boo104bo$269boo83b3o21b3o$266boo33b3o111bo
bbo4bobbo$232boo31bobo35bo26bo22bo3bo55b3obb6obb3o$231boo32bo36bo26b3o
21bo3bo57bobbo4bobbo5bo$233bo30boo62b5o98bo30boo$354b3o39boo33b3o27boo
$396boo65bo$208bo190boo47boo$208b3o83boo103b3o46bo$211bo28bo52bobo103b
oo48b3o$210boo27boo21boo31bo93boo5boo8boo43bo$239bobo20bo65b5o55bobo5b
oo8bobo15bo45bo$250bo9bobo66b3o56bo19bo15bobo42boo$249bobo8boo68bo56b
oo19boo14boo43bobo$238bo8boo3bo$233bo4b4o5boo3bo128bo$212b3o18bo5b4o4b
oo3bo33b3o13boo19boo55b3o$211bo3bo12boo9bobbo6bobo26boo8bo14bo19bo24b
3o28bobobo$210bo5bo11boo9b4o7bo27bo8bo15bobo8boo5bobo55bobobo33bo94boo
$210booboboo21b4o29bo4bobo25boo7bobo5boo24bo3bo28b3o33bo60boo34bo$238b
o31bobo3boo34b3o32bo3bo29bo34b3o57boo35bobo6bobo$253boo14bo3boo36b3o
164bo35boo6bo3bo$216bo36bobo13bo3boo37b3o9b3o21b3o175bo7bo$215boo37b3o
12bo3boo4boo32bobo65bo140bo4bo4b4o$229bo25b3o12bobo5bobo33boo7bo3bo52b
3o143bo4boboboo$214boboo10boo24b3o7bo6bo8bo5boo6boo27bo3bo20b3o28bobob
o62boo74bo3bo3bobbob3o$213bobboo10bobo15boo5bobo9boo18bobbo4bobbo82bob
obo25bo36bo38bo36bobo6boboboo$213b4o28bobo5boo9boo18b6obb6o26b3o20bo3b
o28b3o26bobo32bobo37boo46b4o8boo$245bo39bobbo4bobbo50bo3bo29bo27boo33b
oo38bobo47bo9bobo$244boo40boo6boo227bo22bo$212boo3boo53bo5boo44b3o21b
3o89b3o79boo22boo$215bo37boo16bobo4b3o104bobbo4bobbo45bo$212bo5bo17boo
16bo19bo5boobo16bo22bo3bo55b3obb6obb3o42bo80bobo$213booboo17boo17bobo
5boo7boo7bobbo15b3o21bo3bo57bobbo4bobbo5bo118boo$214bobo20bo17boo5boo
16boobo14b5o98bo90boo29bo$215bo49boo11b3o6boo35b3o39boo33b3o87boo$215b
o49b3o10boo7bobo76boo125bo$265boo22bo79boo62boo14boo19boo$262boo11bo
13boo78b3o60bobo15bo19bo$217boo25bo17boo10boo93boo63bo15bobo9bo5bobo
59bo$217bo25boo22bo6bobo82boo5boo8boo73boo8boo5boo51bo7boo$218b3o22bob
o21bobo28b5o55bobo5boo8bobo15bo65boo38bo18b3o7bobo$220bo46boo30b3o56bo
19bo15bobo62b3o37boo17bo27bo$300bo56boo19boo14boo64boo3boo32bobo16boo
26b3o$461boo8b3o75bo$351bo73b3o34bo7bo3bo54bo18boo$282boo66b3o74bo6bo
6bo28bo3bo52b3o$251boo7bo20boo35b3o28bobobo72bo6boo6boo28b3o52bo10boo$
250boo7bo23bo65bobobo33bo44b3o6b3o82boo8boo$238boo12bo6b3o55bo3bo28b3o
33bo46boo6boo64boo7bo21bo$239bo77bo3bo29bo34b3o45bo6bo64boo7b3o$239bob
o6bobo257bo5b5o$240boo6bo3bo65b3o97boo51b3o39boo3boo3b3o22booboboo$
252bo37bo60bo65bobo50bo3bo$248bo4bo35boo59b3o66bo27bo22bo3bo48bobo5bo
13bobbo5bo$252bo36bobo26b3o28bobobo92b3o22b3o39boo7b5o4b3o10boo$248bo
3bo4boo90bobobo25bo65booboo62bo8boo3boo6bo9bobobbooboo$248bobo6bobo57b
o3bo28b3o26bobo62b3ob3o64bo5boo3boo5boo16bo$259bo57bo3bo29bo27boo63b3o
b3o61bobbo$259boo183b3ob3o61booboo$318b3o89b3o31b3ob3o63boo7boo$297boo
56bobbo4bobbo45bo32booboo72booboo8b3o15boo$296boo55b3obb6obb3o42bo34b
3o74bobbo7booboo14bo$298bo56bobbo4bobbo5bo74bo63boo3boo5bo10booboo6boo
7b3o$371bo139boo3boo8bo7b5o5bobo9bo$336boo33b3o138b5o7boo7boo3boo6bo$
336boo175bobo$339boo62boo14boo19boo56bo$305bo33b3o60bobo15bo19bo56b3o
13b3o3boo3boo$304boo33boo63bo15bobo9bo5bobo24b3o28b5o19b5o5bo$304bobo
22boo5boo8boo73boo8boo5boo24bo3bo52b3o7boo$328bobo5boo8bobo15bo65boo
32bo3bo53bo7boo5b3o$328bo19bo15bobo62b3o33b3o43boo26bo$327boo19boo14b
oo64boo3boo75bo25bo$431boo8b3o65b3o$395b3o34bo7bo3bo64bo$312boo83bo6bo
6bo28bo3bo51b5o26bo5bo$311boo83bo6boo6boo28b3o21b3o29b3o19boo5bo4boob
oo$313bo43bo44b3o6b3o50bo3bo29bo21bo5b3o13boo$356bo46boo6boo51bo3bo48b
3o10bo5bo4boo$84boo270b3o45bo6bo53b3o49bo25bo$85bo417boo6boo17booboboo
$85bobo6bo23boo233boo33boo51b3o58bobbo4bobbo$86boo4bobo23bo201bo31bobo
32bobo50bo3bo56b6obb6o$90boo18boo3boobo200boo31bo36bo27bo22bo3bo57bobb
o4bobbo5bo$90boo17bo3bo3bo201bobo29boo63b3o22b3o59boo6boo6bobo28bo$90b
oo16bo306booboo63boo34boo28boo$92bobo4bo8bo3bobbo298b3ob3o62bobo63bobo
$94bo3bo9bo5bo180bo118b3ob3o63b3o48boo$98b3obbo5bo3bo181b3o116b3ob3o
64b3o47bo$110boo186bo81b3o31b3ob3o63b3o49b3o$297boo28boo20boo31bo32boo
boo56boo5bobo7boo17bo25bo$102bo223boo21bo31bo34b3o56bobo5boo8bobo15bo$
101boo225bo9bo8bobo67bo57bo19bo15b3o43boo$101bobo232bobo8boo125boo19b
oo59boo$82bo235bo5boo9bobo220bo$82b3o231bo3bo3b3o7bobbo$85bo234bo5boob
o5bobo35boo14boo19boo56bo$84boo213b3o13bo5bo4bobbo6bobo26boo5bobo15bo
19bo56b3o$298bo3bo12boo9boobo8bo26bo8bo15bobo9bo5bobo24b3o28b5o33bo94b
oo$109boo186bo5bo20b3o30bo5bobo25boo8boo5boo24bo3bo65bobo58bo34bo$86b
3o19boo187bo5bo20boo31bobo3boo35boo32bo3bo65boo58boo34bobo5bobo$86b3o
21bo229bo17bobo38b3o33b3o126bobo34boo5bobbo$85bo3bo213bo36boo16bobbo
38boo3boo204boo8bo$84bo5bo211boo32boo3boo15bobo40boo8b3o195bo3boo5bobo
$85bo3bo212boo37b3o13bobo5b3o34bo7bo3bo196boo6boboo$86b3o211bobboo11b
oo23boo7bobo4bo9bo6bo6bo28bo3bo51b5o26bo35boo73bobbo6booboo$117bo183bo
bo11boo16boo5boo9boo13bo6boo6boo28b3o21b3o29b3o26bo36bo74bobo8boboo$
116boo183boo14bo14bobo5bo10bo20b3o6b3o50bo3bo29bo27b3o32bobo38boo46bob
o8boo125boo$116bobo213bo40boo6boo51bo3bo92boo38boo38bo9bo9bobo125bo$
331boo41bo6bo53b3o135bo36bo22bo125bobo7bo$299boo3boo59boo106boo6boo44b
oo81b3o20boo125boo4b4o$299boo3boo34boo17boo4bobbo42b3o58bobbo4bobbo42b
obo236b4o16bo$324bo16bo16boobo7bo40bo3bo56b6obb6o43bo81bo154bobbo8boo
5bobo$89boo210b3o19boo16bobo5boo10bo7bo17bo22bo3bo57bobbo4bobbo5bo119b
oo154b4o14bo3boo$89bo34boo175b3o19bobo16boo5bobo8bo8bo16b3o22b3o59boo
6boo6bobo88bo28bobo154b4o3boobobo4bo3boo$90b3o30boo177bo47b3o12bobbo5b
oo9booboo63boo34boo88boo188bobbo3boo5bo3boo$92bo32bo225b3o11boo7bobo7b
3ob3o62bobo123bobo191bo10bobo3boo$350b3o23bo7b3ob3o63b3o79boo19boo214b
obbo8bo4bobo$349bobo24boo6b3ob3o64b3o61b3o15bo19bo234bo$304boo43boo4bo
6boo20b3ob3o63b3o64bo15bobo10bo4bobo234boo$304bo26boo21bo6boo22booboo
56boo5bobo7boo17bo37bo17boo9b4ob3o51bo8boo$132bo172b3o22boo22b3o6bo22b
3o56bobo5boo8bobo15bo66booboboo51b3o7boo$131boo174bo24bo54bo57bo19bo
15b3o63b3obobbo32boo16bo12bo14bo$131bobo310boo19boo81boobobo32boo17boo
26b3o$549b4o35bo47bo$512boo9b4o23bo7b3o55bo18boo135boo$370bo67bo72bobo
8b6o29bo3bo52b3o154boo$339bo7bo21boo66b3o73bo7b8o27bo5bo50bo11bo147bo$
338boo7bobo19bobo33b3o28b5o33bo45boo6boo83boo9boo$139boo184boo11bobo6b
oo55bo3bo65bobo44b8o26bo7bo31bo28bobo$138boo186bo77bo3bo65boo46b6o27bo
7bo30boo7bo$140bo185bobo5bobo68b3o115b4o67bobo5b3o30boo3boo150bo$327b
oo5bobbo218bo5bo38b5o32bo141bo11b3o$337boo165b3o50bo3bo38boo3boo3b3o
22bo5bo137boo14bo$335bo3boo36boo127bo51b3o40b5o3bo3bo4bo17booboo134bo
3bobo12boo$337boo37boo58b5o26bo37bo27b3o65b5o12b3o11boo3bobo133b3o$
147bo186bobbo6boo32bo26b3o29b3o26bo66bobo65bobbo3bo5bo6bo9boo5bo133bo$
146boo186bobo7bobo57bo3bo29bo27b3o64b3o64bo3bo3boo3boo5boo11bo4bo133b
oo$146bobo197bo57bo3bo124b3o64bo195b3o$346boo57b3o125b3o64boboo191boob
oo$106boo335boo6boo44boo34b3o65bo9bo175boo6booboo$106boo277bo56bobbo4b
obbo42bobo34bobo73boobo9b3o15boo144boo7b5o$384boo55b6obb6o43bo34b3o76b
o27bo147bo5boo3boo$384bobo55bobbo4bobbo5bo138boo3boo3bo3bo9bobo16b3o
123boo3boo3bo$154boo287boo6boo6bobo136bo5bo3bobbo9b5o5b3o9bo123boo3boo
3b3o$153boo268boo34boo146b5o8boo3boo6bo146bo$105b3o47bo267bobo173bo3bo
3b5o8boo3boo5bo136b3o7boo$105b3o316b3o79boo19boo71b3o3boo3boo156b3o23b
o$104bo3bo316b3o61b3o15bo19bo57bo21b5o158bo23boo$392boo30b3o64bo15bobo
10bo4bobo56b3o21b3o5bobo175bobo$103boo3boo8bo272boo23boo5bobo7boo17bo
37bo17boo9b4ob3o25b3o28booboo21bo7boo5bo174boo$117bobo42bo230bo21bobo
5boo8bobo15bo66booboboo26bo3bo26b3ob3o28bo7bo173bo$116bo3bo40boo252bo
19bo15b3o63b3obobbo25bo5bo25b3ob3o9boo23bobbo152boo3boo14b3o$116bo3bo
40bobo250boo19boo81boobobo58b3ob3o10bo23bobo156bo19bo$116bo3bo398b4o
26bo7bo24b3ob3o7b3o173bo6bo5bo$103b3o10bo3bo361boo9b4o23bo7b3o18bo7bo
25booboo8bo176boo5booboo$107boo7bo3bo37boo240bo80bobo8b6o29bo3bo52b3o
27bo5bo151boo7bobo3boo$107boo7bo3bo37bo240boo82bo7b8o27bo5bo17bo5bo28b
o20boo6bobo3bo161bo3bobo$108boo7bobo36bobo240bobo42bo45boo6boo51bo3bo
51bo6boo3bobo8bo136b3o12bo5bo$106bobo9bo37boo11boo273bobo44b8o26bo7bo
18b3o49b3o11booboo6boo135bo3bo$106boo60boo274boo46b6o27bo7bo70bo12bo5b
o5bobo133bo5bo$170bo322b4o94bo6bo21bo144bo5bo5bo$440boo84bo5bo57boo6b
oo17boo3boo144bo7bo$101boo3boo331bobo32b3o50bo3bo57b3o6b3o6bo158bo3bo
5b3o6bo$101boo3boo299boo30bo36bo51b3o59boo6boo6bo162bo14boo$113bo12boo
278boo30boo35bo27b3o85bo6bo7b3o156bobbo15bobo$103b3o8boo11bo49bo230bo
94bobo64bo66boo126bo$103b3o7boo12bobo6bo7bo31boo325b3o64boo64boo128bo$
104bo23boo4bobo5b4o30bobo203bo120b3o60boo3boo49boo14bo124b3o$132boo8b
oobbobboo231b3o118b3o65b3o48bo140bo5bo6boo3boo$132boo10b3obboo234bo81b
oo34b3o65boo50b3o143bobo5b5o$132boo11bo6boo230boo29bo20boo28bobo34bobo
57boo5boo8boo17bo25bo143boo6booboo10boo$134bobo15b3o259boo20bo31bo34b
3o56bobo5bo9bobo16bobo175booboo9boo$120bobo6bo6bo4bobo8boo260bobo8bobo
6bobo125bo19bo16boo44bo132b3o12bo$104boo15boo7bo11boo5boo7boo24boo237b
o3bo6boo125boo19boo60boo$104boo15bo6b3o14bo3boo7bobo22boo226boo10bo
220bobo$113bo29bobo14bo24bo225bobbo7bo4bo334bo$112boo30bo15boo241b5o7b
o7bo52boo19boo262bo14boo$111boo4boo283bo5bo6bo7bo3bo24boo5b3o15bo19bo
57bo36bo168b3o13bo22bo$110b3o4boo267b3o5bobboo3bo3boo7bo9bobo24bo8bo
15bobo10bo4bobo56b3o34bo182b3o22boo$111boo4boo3bo262bo3bo13bo7bobbo27b
obo5bobo7bo17boo9b4ob3o25b3o28booboo33b3o180bo24bobo$103boo7boo7b3o13b
o54bo191bo5bo20boo29bo3bo3boo36booboboo26bo3bo26b3ob3o93boo125boo$102b
obo8bo6bo3bo12boo52boo192bo3bo36bo19bo40b3obobbo25bo5bo25b3ob3o92boo
126bobo$102bo16bob3obo10bobo52bobo192b3o35b4o14bo4bo40boobobo58b3ob3o
94bo113bo12b3o$101boo17b5o261bobbo33boboboo4bo12bo42b4o26bo7bo24b3ob3o
195bo9b4o3boo8b3o6boo$387b3o32bobbob3o5boobo3bo3bo5boo9b4o23bo7b3o18bo
7bo25booboo196bobo6b4o3boo8b3o7boo$387boobo13bo17booboboo5b4obobbobo6b
obo8b6o29bo3bo52b3o27bo35boo132boo7bobbo3booboboobbobo25boo$388bobo12b
oo15b3ob4o6boobboo13bo7b8o27bo5bo17bo5bo28bo28bobo33bo142b4o4boboboobb
oo25boo$112bo276bo13bobo13bobo4bo33boo6boo51bo3bo58boo32bobo39bo97boo
4b4o3boboo33bo$109b4o4bo11boo68boo218bo41b8o26bo7bo18b3o93boo39boo96bo
bo7bo$101boo5b4o5bo12boo66boo218boo42b6o27bo7bo155bobo95bo$101boo5bobb
o17bo70bo185boo3boo59boo9b4o94bo6bo178bo8boo$108b4o274bobobobo34boo23b
obo41bo5bo57boo6boo43b3o130bo34bo$109b4o274b5o36bo16bobo7bo41bo3bo57b
3o6b3o6bo37bo130b3o33boo31bo$112bo275b3o20boo15bobo5bo7boboboobbobbo
42b3o59boo6boo6bo37bo166boo31boo$389bo20boo17boo5boo6bobo8bo17b3o85bo
6bo7b3o235bobo$122bo84bo204bo24boo13bobo6boo10bobo64bo126boo$122boo82b
oo229b3o12boo7bobo9b3o64boo124boo$110bobo8bobo82bobo223boo3boo24bo9b3o
60boo3boo80boo19boo22bo106boo$110bo3bo321boo25boo8b3o65b3o62boo16bo19b
o94bo34bobo$114bo10boo264boo43bo5bo7bo22b3o65boo62bobo16bobo10bo4bobo
94bobo34bo$110bo4bo7bobbo264bo27bo22bobo4boo22bobo57boo5boo8boo17bo37b
o17boo9bobo3boo51bo43boo81boo$114bo7bo269b3o23boo22boo5bobo21b3o56bobo
5bo9bobo16bobo64boobo53b3o125boo$102boo6bo3bo7bo271bo23bobo111bo19bo
16boo65booboo34bo16bo130bo$101bobo6bobo9bo91boo315boo19boo82boobo34boo
16boo$101bo21bobbo5boo79boo421bobo35bobo$100boo23boo5bobo80bo421bo8bo
85bo34b3o$134bo300bo162b3o44bobo83bo37bo$134boo298bo22boo66bo36bo37bo
7b8o28bo3bo82b3o34bo61bo$426boo6b3o19boo66b3o34bo37bo8bob4obo28bo3bo
180boo$412boo11boo31bo33b3o28booboo33b3o44b8o28bo3bo180bobo$222bo190bo
13bo63bo3bo26b3ob3o115bo3bo33boo$221boo190bobo5boo67bo5bo25b3ob3o92bo
22bo3bo32boo$221bobo190boo5boo99b3ob3o92bo22bo3bo34bo4b5o67boo$424boo
63bo7bo24b3ob3o62boo52bobo39bob3obo30bo34bobo$424b3o38bo23bo7bo25boob
oo62bobo28bo24bo41bo3bo31bobo34bo$424boo38boo58b3o27bo37bo27bobo66b3o
32boo111boo$421boo8boo31bobo23bo5bo28bo28bobo133bo125bo19boo$421boo8bo
bo57bo3bo58boo64b3o65boo124b3o21bo$229boo202bo58b3o192bobo123bo$228boo
203boo252bobo123boo$230bo300bo6bo81b3o65bo28bo$530boo6boo43b3o130bo$
472boo55b3o6b3o6bo37bo34bobo93b3o87bo38bo$471boo57boo6boo6bo37bo36bo
63booboboo113bo38boo$473bo57bo6bo7b3o136bo5bo113b3o36bobo$237bo272bo
110bo64bo3bo119b3o$236boo272boo109bo65b3o79bo39bo3bo$236bobo267boo3boo
80boo19boo129boo19b4o$511b3o62boo16bo19bo94bo34bobo10bo7b4o39bo5bo$
480bo30boo62bobo16bobo10bo4bobo56b3o35bobo34bo9bobo6bobbo39boo3boo$
479boo22boo5boo8boo17bo37bo17boo9bobo3boo26bo30bobo35boo44bo3boo4b4o
83boo$479bobo20bobo5bo9bobo16bobo64boobo29bobo29b3o81bo3boo5b4o6boo73b
oo$502bo19bo16boo65booboo27bo3bo28b3o11boo68bo3boo8bo6bobo74bo$244boo
255boo19boo82boobo28bo3bo28b3o12bo59boo8bobo19bo$243boo361bobo29bo3bo
28b3o9b3o59bobo9bo20boo69boo$245bo361bo8bo21bo3bo28bobo9bo18bo34b3o5bo
20bobo39boo39bo$568b3o44bobo20bo3bo28b3o27bo37bo4boo21boo40bo31bo5bobo
$487boo43bo37bo7b8o28bo3bo19bo3bo58b3o34bo28bo38b3o32bobo3boo11bo$486b
oo43bo37bo8bob4obo28bo3bo20bobo164bo17bo17bobo14boo$488bo42b3o44b8o28b
o3bo21bo183boo16bobbo13bobo$252bo361bo3bo61b4o136boo3boo15bobo$251boo
338bo22bo3bo60b6o140b3o13bobo$251bobo273boo62bo22bo3bo59b8o44boo42bo
50boo7bobo4bo$526bobo32boo52bobo59boo6boo7bo34bobo43boo40boo5boo9boo$
495bo30bo33bobo28bo24bo61b8o8bobo34bo42boo40bobo5bo10bo$494boo29boo35b
o27bobo86b6o9boo120bo50boo$494bobo159bo23b4o131boo49boo$590b3o61b4o
210bo$259boo208bo183boboboo$258boo209b3o180bobbob3o182bo$260bo211bo
117b3o59booboboo28bo155boo$471boo50boo28b3o94b3ob4o9boo17bo155boo$502b
oo19bo31bo34bobo56bobo4bo10bobo16b3o94boo90bo$501boo10bobo5bobo30bo36b
o57bo19bo113bo90boo$503bo8bobbo5boo125boo19boo94bo18b3o87bobo$267bo
230boo11boo78bo173b3o18bo$266boo230bobo8boo3bo76bo176bo$266bobo224boo
6bo9boo50boo19boo129boo50boo80bobo$481boo6boobobbobbobbo10bobbo23boo5b
oo16bo19bo94bo34bobo133boo$480b6o3boobboo6bo11bobo23bo5bobo16bobo10bo
4bobo56b3o35bobo34bo133bo$471boo3boo4boboo12bobo27bobo6bobo7bo17boo9bo
bo3boo26bo30bobo35boo201boo$473b3o22boo28bobbo5boo37boobo29bobo29b3o
126bo110boo$472bo3bo36bo6bo10boo43booboo27bo3bo28b3o126bo112bo$274boo
197bobo36bobo5bo8bo3boo41boobo28bo3bo28b3o125bobo$273boo199bo36boboo6b
o9boo43bobo29bo3bo28b3o124booboo84bo$275bo234booboo9boobbobbo45bo8bo
21bo3bo28bobo28bo34b3o57bo5bo84boo$475b3o33boboo5b3obbobbobo7b3o44bobo
20bo3bo28b3o27bo37bo60bo86boo$475b3o13boo14boo3bobo7b4o14bo7b8o28bo3bo
19bo3bo58b3o34bo58boo3boo116bo$490boo14bobo4bo9boo14bo8bob4obo28bo3bo
20bobo277boo$492bo13bo41b8o28bo3bo21bo244boo32bobo$282bo222boo77bo3bo
61b4o201bo$281boo190boo3boo58boo21bo22bo3bo60b6o187bo10bobo$281bobo
190b5o35boo15bo4bo3bo20bo22bo3bo59b8o44boo139bobo9boo$475b3o37bo16bobb
o5bo43bobo59boo6boo7bo34bobo65boo62boo7boboo$476bo22bo15bobo4bo8b5obo
3bo19bo24bo61b8o8bobo34bo66bo61bobo6booboo$498boo16b3ob4o11bo5bo18bobo
86b6o9boo99b3o61bo6b3oboboo53boo$498bobo17booboboo11bo3bo7boo76bo23b4o
111bo63bobbobbobbobbobo52boo$518bobbob3o12boo8bobo9b3o61b4o201bo6boo4b
o55bo$289boo228boboboo25bo72boboboo193boo6bobo26boo$288boo230b4o6bo19b
oo70bobbob3o191bobo7boo26boo11bo$290bo187boo42bo6bo30b3o59booboboo28bo
163bo51boo$478bo50b3o5boo81b3ob4o9boo17bo163boo21bobo3bo9bo12boo$479b
3o24boo28boo22bobo56bobo4bo10bobo16b3o185boo3boo7bobo44bo$481bo23boo
31bo22bo57bo19bo204bo3bobo7bobbo42boo$507bo110boo19boo54bobboo159bobbo
41bobo$297bo263bo132bo3boobboo119boo$296boo263bo132bo7boo120bo34bobbo$
296bobo223bo162boo8b4o125bobo6bo7bo17boo18bobo$522bobo20bo103bo34bobo
138boo4bobo5b4o37boo$514bo7boo20boo65b3o35bobo34bo142boo8boobbobboo32b
o$499boo12boo29bobo33bo30bobo35boo178boo11boobboo64boo$500bo12bobo63bo
bo29b3o215boo7bo10boo6boo52boo$500bobo5boo68bo3bo28b3o217bobo4bo10b3o
5boo54bo$304boo195boo5bobo67bo3bo28b3o219bo4bo10boo$303boo204b3o66bo3b
o28b3o232boo39bo$305bo204b3o65bo3bo28bobo28bo34b3o166boo40boo$509b3o
40boo24bo3bo28b3o27bo37bo207boo$508bobo7boo31boo25bo3bo58b3o34bo241bo$
508boo8bobo32bo25bobo337boo$520bo59bo304boo32bobo$312bo207boo98b4o261b
o$311boo306b6o247bo10bobo$311bobo304b8o44boo199bobo9boo$560bo56boo6boo
7bo34bobo189boo7boboo$559boo57b8o8bobo34bo188bobo6booboo12boo$559bobo
57b6o9boo223bo6b3oboboo13boo38boo$596bo23b4o226boo7bobbobbobbobbobo12b
o39boo$594b4o252boo7bo6boo4bo55bo$319boo272boboboo261bobo26boo$318boo
272bobbob3o261boo25bobbo10bo$320bo271booboboo28bo260bo14boo$567boo21b
3ob4o9boo17bo246bobo12bo13boo$566boo21bobo4bo10bobo16b3o245boo12boboo
43bo$568bo20bo19bo60bobo201bo15boo42boo$588boo19boo58bo207boo55bobo$
327bo336boobbo4bo179boo22boo$326boo336boobobboboo180bo34boo$326bobo
266boo58boo11boo184bobo6bo7bo17boo18bobo$575bo19bo23bo34bobo125boo71b
oo4bobo5b4o37boo$574boo10boo5bobo23bobo34bo123bo3bo74boo8boobbobboo32b
o$574bobo9boo5boo24boo158bo5bo13boo58boo11boobboo64boo9boo$569boo12boo
193bobbo3bo13boo58boo7bo10boo6boo52boo9bobo$567bo3bo10b3o200bo10boo63b
obo4bo10b3o5boo47bo6bo7b3o4boob3o$334boo230bo5bo10boo30boo159bo3bo3bo
10b3o65bo4bo10boo54bobo12b3o4bobb4o$333boo230bobbo3bo13boo28bo158boboo
3boo12boo78boo55boo3bo12b3o4boo$335bo236bo13boo25b3o31b3o125bo11bobo9b
oo5boo68boo55boo3bo13bobo$563bo3bo3bo41bo35bo124boo11boo10boo5bobo124b
oo3bo14boo$562boboo3boo37bo39bo139bo19bo121boo3bobo$562bo44bobo198boo
119bobo4bo$561boo27boo14bo3boo3boo298boo12bo$342bo247bobo13bo3boo3boo
298bo12boo$341boo248b3o12bo3boo290bo10bobo$341bobo248b3o12bobo30boo
139bo119bobo9boo$591b3o7bo6bo30bobo137boo110boo7boboo21boo$583boo5bobo
9boo37bo138boo108bobo6booboo21bo$582bobo5boo9boo14boo270bo6b3oboboo22b
3o$582bo33bobbo260boo7bobbobbobbobbobo24bo$581boo36bo260boo7bo6boo4bo$
349boo268bo270bobo26boo$348boo266boobo271boo24bobbo$350bo265boo154bobo
$578boo192boo129bobo3bo7bobbo$579bo193bo130boo3boo7bobbo$579bobo6bo7bo
20boo203boo80bo3bobo8bobo$580boo4bobo5b4o19boo20b4o132boo46bo96bo$357b
o226boo8boobbobboo31boo7bo132bo46bobo7bo49boo$356boo226boo11boobboo31b
oobboo3bo132bobo10bo34boo7b4o47bo34boo$356bobo225boo7bo10boo19boo11boo
bbo123bo10boo9b4o42b4o46bobo6bo7bo17boo$586bobo4bo10b3o17bobo137boo21b
oob4o5boo33bobbo5boo40boo4bobo5b4o$588bo4bo10boo20bo138boo19b3oboo3bo
3bobbo31b4o5boo44boo8boobbobboo$601boo8boo174booboo3bo7bo29b4o52boo11b
oobboo$601boo8bobo174b5o3bo6bo29bo55boo7bo10boo6boo$613bo175bo3b3o7bo
87bobo4bo10b3o5boo$364boo247boo156boo26bobbo5boo83bo4bo10boo$363boo
406boo26boo7bobo95boo$365bo251b3o190bo27boo66boo$619bo152bo14bo22boo
27bo$618bo152bobo11boo52bobo5boo$770bobbo11b3o52boo5boo$769bobbo10b3o
64boo10bo$372bo410boo22boo41b3o7bobo$371boo396bobbo34bo42boo6boo$371bo
bo236boo139bo19boo16boo9bo4bobo39boo9boo$609bobo137boo37b4o7bobo3boo
40boo9boo$611bo138boo31bobobbobb3o5boobo57bobo7boo$782bobbobboo9booboo
46bo11bo7bobo$773boo6boo9bo6boobo47bobo19bo$773boo4boo3bo8bo5bobo48boo
20boo$379boo400boo10bo6bo$378boo277boo123bobbo$380bo221b3o52bo84bobo
38bobo85boo$604bo41bobo6bobo84boo127bo$603bo42bobbo5boo86bo99bo14bo10b
obo$649boo191bo13b4o9boo$647bo3boo92boo95b3o10boboboo$387bo261boo95bo
107bobbob3o$386boo250boo6bobbo96bobo10bo94booboboo$386bobo206boo40bobo
6bobo87bo10boo9b4o90b3ob4o$594bobo40bo96boo21boob4o5boo80bobo4bo$596bo
39boo97boo19b3oboo3bo3bobbo78bo$757booboo3bo7bo76boo$758b5o3bo6bo6boo
53boo$759bo3b3o7bo6boo30boo22bo$394boo345boo26bobbo40bo19b3o$393boo
346boo26boo42bobo10bo6bo$395bo74bo116b3o224boo9b4o30bo$470b3o116bo161b
oo4bo66boobobo27boo$473bo114bo153boo6boo3boo66b3obobbo27boo$472boo266b
oboo8bo3boo66booboboo4boo$740bo84b4ob3o3bo$402bo337bo36boo38bobo6bo4bo
bobbobo5boo$401boo337bobbo33bo40boo13bo3boo5bobbo$401bobo70b3o103boo
159boo16boo9bo4bobo40bo14boo13bo$473booboo101bobo176b4o7bobo3boo71bo$
473booboo103bo171bobobbobb3o5boobo36boo37bo$473b5o170boo40boo60bobbobb
oo9booboo34bobo33bobbo6boo11boo$472boo3boo169bo41bo52boo6boo9bo6boobo
37bo33boo8bobo11bo$614boo23boo5bobo33boo3boobo52boo4boo3bo8bo5bobo53bo
30bo11bobo7bo$409boo204bo22b3o5boo33bo3bo3bo61boo10bo6bo55boo28boo11b
oo7b4o$408boo68bo136bobo8bo8boboo26boo13bo71bobbo69boo52b4o$410bo66bob
oo91b3o41boo8bobo6bobbo26boo13bo3bobbo24bobo38bobo123bobbo$477bo11boo
83bo52bobo5boboo29boo10bo5bo25boo157bo7b4o$488boo83bo53bobbo7b3o27b3o
10bo3bo27bo87b3o68boo4b4o4boo$477boobo9bo136bobo9boo27boo12boo119bo67b
oo5bo7bobo$475bobbo147bobo29boo5boo9bobo36boo85bo85bo$417bo57bobo148bo
9bo20bobo5boo10boo37bo115bobo53boo$416boo219boo18bo19bo38bobo10bo74bo
28boo$416bobo146boo69boo18boo59boo9b4o72b3o26bo$497bo66bobo85bo38bo13b
oo7bo12boob4o5boo66bo38bo41bo$496boo68bo56boo26b4o10boo24b4o11bo6boo
11b3oboo3bo3bobbo63boo36b3o15b3o13bobo5b3o$476b3o17bobo56boo67bo25boob
obo10bo25b4o7b3o7bobo11booboo3bo7bo99bo20bo14boo4bo$475bo3bo75bo68bobo
8bo13b3obobbo9bobo5boo16bobbo7bo24b5o3bo6bo6boo91boo18bo15bo5boo$474bo
5bo65boo5bobo69boo8bobo12booboboo10boo5boo16b4o33bo3b3o7bo6boo$424boo
49bo3bo64bobbo5boo81bobo12b4ob3o18boo12b4o4boo10boo26bobbo65b3o26bo44b
3o$423boo51b3o52bobo9bo92bobbo12bo4bobo17b3o11bo7bobo9bobbo24boo66boob
oo24bo45b3o$425bo50b3o52bo3bo7bo13b3o76bobo20bo17boo22bo105booboo24b3o
$504boo29bo7bo15bo75bobo21boo13boo25boo8bobbo12bo69bo9b5o43boo$479boo
22boo26bo4bo7bobbo10bo76bo38boo34bobbo11boo59b3o8bo8boo3boo41bobo$479b
o25bo29bo10boo162bobo12b3o60bo7bobo57bo23boo3boo$480b3o40boo6bo3bo175b
o11b3o61bo9bo42b3o38b5o$432bo49bo39bobo6bobo8bobo178boo22boo21bo26bo
11boo28bo3bo38b3o$431boo89bo20boo21boo57bo85boo34bo20b3o26bo9b5o17bo8b
o5bo38bo$431bobo87boo20bo6boo14bo58b3o83boo16boo9bo4bobo19bo29bo13bo
17bobo6bo5bo$512bo36bobo7bo4bobo61bo99b4o7bobo3boo20boo27bobo8b3o19boo
10bo$511boo17boo19bo6bobo3boo61boo94bobobbobb3o5boobo36boo16bo9bo31bo
3bo3b3o$511bobo17bo26boobo160bobbobboo9booboo34bobo16bo10boo6bo25bo6bo
17bo59bobo$531bobo8bo15booboo150boo6boo9bo6boobo37bo27boo6b3o19bobbo6b
o18bobo49b3o5bo3bo$532boo8bobo13boobo151boo4boo3bo8bo5bobo77bo18bo28b
oo11boo32boobbobbobo7bo$439boo102bobo12bobo69bo90boo10bo6bo77boo19bo
41bo30bobbobboo7bo4bo$438boo103bobbo12bo70bo91bobbo82boo3boo21b3o39b3o
30bo19bo$440bo102bobo4boo77bobo91bobo82bobobobo21bo41bo32bo10b3obbo3bo
3boo$519boo21bobo4boo77booboo163boo3bobo5b5o26boo69bo15bobo5bobo$518b
oo22bo8bo75bo5bo129b5o3b3o22boo3boo7b3o26bobo18bo44boo5bobbo21bo$520bo
109bo131bob3obo4bo28bo8bo29bo17bo36b3o5bobo7boo21boo$543bo83boo3boo
129bo3bo4bo86b3o36bo5bo$447bo94bo221b3o130bo5boo$446boo94b3o220bo84boo
$446bobo109bo63boo60boo145bo18bo$527bo29boo63bo62bo133b5o8boo5boo7bobo
$526boo29bobo49bo10bobo62bobo8bo65boo54bob3obo6b3o5boo7boo$526bobo79bo
bo9boo10boo52boo8bobo64bo6bo39boo7bo3bo11bo6boo8bo36boo$606boo3bo20bo
66boo59b3o6boo39boo8b3o12bo6b3o7bobo33bobo$515boo18bo70boo3bo21b3o63b
oo59bo8bobo29bo19bo20boo8boo36bo$454boo60bo18bobo68boo3bo23bo63boo98b
4o28boo6boo$453boo61bobo8boo6boo66boo3bobo85bobo4boo93boboboo19boo5bob
o6boo$455bo61boo7bo3bo34boo35bobo4bo86bo6bobo91bobbob3o18bo6bo$525bo5b
o32boo36bo102bo92boboboo20b3obboo$525bo3boboo33bo34boo102boo85b3o4b4o
8boo13bo18bo$525bo5bo245boo13b3o6bo9bobo30bo36b3o$526bo3bo3boo240boo
13bo3bo17bo30b3o36bo$462bo64boo5bobo241bo34boo67bo$461boo73bo253boo3b
oo$461bobo72boo35bo239boo$572boo239bo$572bobo220boo5boo7bobo195boo$
785bo7bo4bo3b3o6boo24bo36boo134bo$784boo12bo5boobo29bobo33bobo134bobo
7bo22boo$784bobo5bo6bo4bobbo29boo36bo135boo7bobo20bo$469boo321bobo9boo
bo215boo6boo8bobo$468boo332b3o218boo4bo3bo7boo$470bo109boo46boo48boo
122boo8bo210boo3bo5bo$579boo47boo47bobo130b3o9bo197bobo4boobo3bo$581bo
49boo38boo3b3o130bo12b3o5bo189bo7bo5bo$631b3o28boo7boobb3o114boo15boo
14bo3bo36b3o160bo3bo$631boo28bobo5b3o4b3o39boo71boo31boo3b3o36bo162boo
$477bo143boo5boo8boo20b3o4b4o6bobo5boo30bobo73bo73bo153bo$476boo142bob
o5boo8bobo18b3o5bo3bo6boo5bobo28bo6boobboo99bo190boo$476bobo109bo31bo
19bo19b3o4b4o16bo28bobbobbobboboo99bo191boo$587boo30boo19boo11boo6bobo
5boo16boo27bo6boo102bo$587bobo62bobo7boo44boo7bobo$652bo54bobo8boo80bo
58boo$651boo35bo18bo91boo3boo3boo13boo3boo4bo22bobo$688b3o15boo91bobo
22bo5bo5boo22bo$484boo190b3o12bo113bo3bo25boo175bobo$483boo191bo13boo
114b3o16bo3bo182boo$485bo109boo72bo7bo128b3o17b3o184bo$594boo71b3o$
596bo69bo$666boo5bo131bo45b3o$673b3o45bo82b3o46bo$492bo183bo7boo35b3o
79bo3bo21boo21bo11boo140bo$491boo151boo29boo7bobo5b3o29bo37boo41bo23bo
34bo139boo$491bobo109bo40bo18b3o10b3o5bo6bo3bo27boo37bo39bo5bo21b3o21b
o7bobo140boo$602boo6boo23boo5bobo32bobo10bo5bo63bobo39bo5bo23bo19bobo
7boo$602bobo6bo22bobo5boo19bobo10bo3bo9bo5bo63boo41bo3bo42boo123bo$
611bobo5bobo11bo28b5o9b5o123b3o43boo123b3o$612boo5bobbo10bobbo24boo3b
oo7boo3boo8bo159boo126bo$622boo9bo27boo3boo8b5o9boo153boo5bobo122boo$
499boo119bo3boo8bobo40b3o10boo34bo117bobo7bo142bobo$498boo122boo11boo
41bo10boobbo31b3o116bo152boo$500bo109boo7bobbo8bo31boo25bobo17bo13b5o
114boo153bo$609boo8bobo10boo28booboo24boo17b3o10boo3boo$611bo19boo30bo
bbo46bo93boo$663bo15bo32boo93bo$666bo9boo10boo3boo113b3o169bo$507bo
156boo10b3o9boo3boo30b3o82bo168b3o9bo$506boo169boo299b5o6boo$506bobo
109bo58bo12b3o21b3o9bo250boo3boo6boo$617boo19bobo18boo3boo10bobo11b3o
20booboo7b3obo248b5o$617bobo19boo19b5o11boo13bo21booboo7bo4bo247bo3bo$
639bo21b3o6bo42b5o12bo248bobo$662bo49boo3boo10bo250bo$672boo3booboboo$
514boo172boo500boo$513boo162bo5bo5bo28bo259bo211boo$515bo109boo19bo39b
3o5boo21boboo28bo226booboo$624boo21boo29booboo3bo7boo21bo10b3o17bobo$
626bo19boo32bo46bo3bo15bo3boo222bo5bo$659boo42bo13boobo5bo5bo14bo3boo$
660bo42b3o9bobbo8bo3bo15bo3boo222booboboo$522bo134b3o46bo8bobo10b3o6b
oo9bobo3boo$521boo134bo47boo21b3o5bobo10bo4bobo$521bobo109bo27bobo15b
oo12b3o10b3o27bo19bo$632boo19bobo5boo7boobbo4boo26bobo16boo7boo19boo$
632bobo19boo6bo3boobboo3bo17bobo10bo3bo16bo459boo3boo$654bo11boo7bo16b
5o9b5o5b3o5b3o$671b4o16boo3boo7boo3boo3bo3bo4bo250boo211bo3bo$691boo3b
oo8b5o3bo5bo255bo212b3o$529boo176b3o5bo3bo253b3o213b3o$528boo178bo7b3o
254bo$530bo109boo19bo31boo21b3o$639boo21boo28booboo$641bo19boo30bobbo
22boo170bo$693bo15bo9bo171b3o$696bo9boo12b3o171bo293bo5bo$537bo156boo
10b3o13bo170boo292b3o5bo$536boo169boo478b3o3b3o$536bobo109bo58bo$647b
oo19bobo18boo3boo10bobo476boo3boo$647bobo19boo19b5o5bo5boo477boo3boo$
669bo21b3o7boo$692bo7boo187bo3boo3boo$707booboboo173b3o3bobobobo302bo$
544boo340bo7b5o301bobo$543boo155bo6bo5bo172boo7b3o303boo$545bo109boo
19bo21boo24boo170bo288boo$654boo21boo20boo7booboo11boo460bo$656bo19boo
32bo472b3o$689boo42bo443boo4bo$690bo42b3o442bo30bo$552bo134b3o46bo144b
ooboboo290bobo29bo$551boo134bo47boo144bo5bo291boo27b3o$551bobo109bo33b
obo9boo12b3o10b3o143bo3bo6bobo$662boo36bo8boo26bobo143b3o7boo$662bobo
31bo4bobboo17bobo10bo3bo153bo$696boobobboboo16b5o9b5o429boo$700boo19b
oo3boo7boo3boo424b4o4boo$721boo3boo8b5o156b3o266b3oboobboo41bo$559boo
176b3o156bo3bo260boo8bo43bobo$558boo178bo156bo5bo259boo53boo$560bo109b
oo51boo171bo3bo283bo$669boo51booboo170b3o282b3o$671bo51bobbo170b3o281b
o$723bo15bo421bo19boo$726bo9boo162boo258b3o61bo$567bo156boo10b3o161bo
258bo3bo61bo$566boo169boo145boo3boo10b3o254bob3obo58b3o$566bobo109bo
58bo146boo3boo12bo255b5o$677boo19bobo18boo3boo10bobo146b5o193boo21boo$
677bobo19boo19b5o11boo148bobo195bo21boo70b3o$699bo21b3o6bo353bobo6bo4b
o10boo66bo3bo$722bo163b3o196boo4bobo4bo10b3o88b3o$732boo3booboboo345b
oo7bo10boo53b3o9bo5bo17bo31bo$574boo513boo11boobboo7boo49bo9boo3boo18b
o28bobo$573boo162bo5bo345boo8boobbobboo7bobo47bo65boo$575bo109boo19bo
182boo200bobo5b4o14bo$684boo21boo29booboo74boo70bo203bo7bo15boo57boo$
686bo19boo32bo77bo71b3o282bobo$719boo97bobo6bo64bo195boo85bo32boo$720b
o98boo4bobo56bo204bo85boo31bobo28bo$582bo134b3o81bo22bobo55b3o204bobo
8boo6bobo68bo28bo31bo$581boo134bo83bobo19bobbo54bo208boo6bobbo7boo51b
3o11bobbo58b3o$581bobo109bo45boo43bo17bobo19bobo54boo214bo11bo51bo3bo
13bo$692boo33b4o8boo43boo16bobbo19bobo8boo259bo62bo5bo$692bobo31bo7boo
44boo3boo15bobo22bo8bobo258bo62booboboo$726bo3boobboo49b3o13bobo3boo
29bo259bobbo5boo65booboboo19boo$727bobboo53boo7bobo4bo5bobo28boo260boo
5bobo86boobboobboo$777boo5boo9boo12bo286bo12bo6bo57bo5bo15boobbobbobo
41bo$589boo185bobo5bo10bo13boo61bo221bobo12boo6boo72boo9b3o40bobo$588b
oo186bo93b3o213boo7boo19boo57booboo11boo9boo42boo$590bo109boo19boo52b
oo92bo8b3o187bo18boo76boo10bo36bo$699boo20bobo145boo6bo3bo184b3o17bo
22bo55bo46b3o$701bo21bo152bo5bo182bo41b3o56b3o42bo$723boo77bo74bo3bo
183boo39bo61bo22bo19boo10boo$803boo73b3o225boo82b3o9boo19bobo28bo$597b
o204boo11boo61b3o181bo113boo11bo3bo7bobo19bo31bo$596boo190boo24bobo
245bo16bo96boo10bob3obo8bo49b3o$596bobo109bo80bo23b3o51bo195bo15boo
108b5o$707boo80bobo9bo10b3o51b3o209bobo$707bobo8bobo69boo8bobo10b3o49b
5o248bo80boo7b3o$716bo3bo78bo3boo9bobo5boo40boo3boo9b3o177boo3boo51boo
79bobo5bo3bo$704boo10bo82bo3boo10boo5bobo25bo24bo3booboo176bo5bo50bobo
79bo30b3o$704bobbo7bo4bo78bo3boo19bo25bobo20boo4booboo310b3o9bo5bo17bo
31bo$604boo102bo7bo83bobo21boo25bobo20boo3b5o177bo3bo28bo51bo49bo9boo
3boo18bo28bobo$596bo6boo103bo7bo3bo6boo72bo49bobbo11b3o9boo3boo177b3o
6boo19boo8b5o36bobb3o46bo65boo$594b3o8bo102bo9bobo6bobo121bobo12b3o
203boo19boo6bob3obo33b3o5bo$593bo103boo5bobbo21bo109boo9bobo3boo213bo
30bo3bo33bo7boo56boo$593boo101bobo5boo23boo107bobo9bo5bobo244b3o4boo
28boo63bobo$696bo141bo19bo245bo6boo92bo32boo$695boo140boo19boo200boo
48bo94boo31bobo28bo$612bo448bo39boo106bo28bo31bo$611boo270boo173b3o3bo
20bobo14bo29bo59b3o11bobbo58b3o$611bobo269bo174bo5boo19boo12b3o30bobo
bb3o10b3o38bo3bo13bo$870bo13b3o176bobo20bo12bo32boo15bo3bo36bo5bo$869b
3o14bo216bo33bobo8bo5bo35booboboo$588booboboo273b5o230boo31b5o7boobob
oo49booboboo19bo$867boo3boo228bobo30boo3boo84boobboob3o9b3o$588bo5bo
540boo3boo62bo5bo15boo4b4o3b3o3bo31bo$619boo458bo71bo69boo7boo9bo4bo
28bobo$589booboo24boo249bo186boo19boo36bo34bobo52booboo11boo17bo35boo$
591bo28bo248bo172bo14boo19boo35b3o32bobo42boo10bo36bo$1040b3o13bo61bo
32boo42bo46b3o$872boo165bo55boo20boo34bo42b3o42bo$588boo282bo166boo55b
oo37boo15b3o43bo22bo19boo10boo$589bo283b3o219bo40bo14bo3bo64b3o30bobo
28bo$586b3o38bo247bo244bo12b3o14bob3obo49boo11bo3bo29bo31bo$586bo39boo
421bo20bobo46bobo11bo12bo4b5o50boo10bob3obo54bo3b3o$626bobo420boo19boo
46bo3bo21boo73b5o53b3o$1048bobo20bo47b3o23boo129bo$1034boo3boo47bo28b
oo3boo114b3o35boo$1034bobobobo47boo147bo3bo$1035b5o47bobo170b3o$1036b
3o125boo58b3o9bo5bo17bo31bo$634boo401bo26bo99boo60bo9boo3boo18bo28bobo
$633boo418bo8boo73bobo85bo65boo$635bo417b3o7boo72boo16boo114boo3boo$
1056bo81bo16bo9bo70boo33bobobobo$1055boo99b3o5b3o68bobo34b5o$1117boo
39bo4bo3bo67bo32boo3b3o$1034boo82bo46bo69boo31bobo3bo24bo$642bo392bo
79b3o13boo29bo5bo70bo28bo31bo$641boo389b3o22b3o55bo14bobo29bo5bo53b3o
11bobbo58b3o$641bobo388bo24b3o5bo64bo32bo3bo53bo3bo13bo$1043b3o10bo3bo
bbobo63boo33b3o53bo5bo$1043bo20boo7bo146booboboo$1044bo10boo3boo11boo
12boo145booboboo$1072bobo12bo20boo$1078boo5bobo20bo125bo5bo30b3o33bo$
649boo426bobo5boo11boo6bobo161booboo30bobo$648boo426b3o17bobbo6boo127b
ooboo30booboo31boo$650bo400boo22b3o17bo129boo10bo32b5o$1051bobo22b3o
16bo6bo64boo56bo43boo3boo$1051bo16boo7bobo15bo7boo14bo47bo58b3o$1060b
oo5bobo8boo9boo5bobbo6boo11b3o46b3o57bo5boo$1060bo6bo20bobo7boo6bobo
13bo47bo64bo78bo$657bo403b3obboo20bo17bo14boo109b3o80bo$656boo405bo23b
oo143bo80b3o$656bobo$1058b3o63bo144boo$1058bo63booboo143bo$1059bo207b
3o26boo$1113b3o5bo5bo139bo28bo$1113bo173bo6bobo25bo$664boo448bo6boobob
oo159bobo4boo24bobo$663boo623bobo30boo$665bo400boo89bo130bobbo$895bo
170bobo22bo65b3o128bobo$893b3o170bo22boo69bo24bo91boo8bobo$892bo197boo
29boo30bo5boo24b3o88bobo8bo$875boo15boo227bobo27b3o34bo87bo19boo31bo$
672bo201boo245bo28bo11bo24boo86boo19bobo31bo$671boo203bo249boo22boo9bo
bo132bo31b3o$671bobo188boo262bo33bo3bo$862bo5b3o202b3o51b3o31b3o$851b
oo7bobo7bo202bo8bobo44bo29boo3boo195boo$851boo7boo7bo191boo11bo7boo
278bo$838bo4bo10boo27bo178bo20bo278bobo9boo$751bo84bobo4bo10b3o25boo3b
oo3boo168bobo7bo41boo29boo3boo151b3o31bo25boo8bo3bo$679boo70b3o80boo7b
o10boo26bobo178boo7bobo40boo28bo5bo151bo31bobo34bo5bo$678boo74bo79boo
11boobboo35bo3bo182boo37bo49bo23b5o111bo31boo34bo3bobbo$680bo72boo79b
oo8boobbobboo8boo26b3o183boo69bo3bo13bo22bob3obo178bo$830boo4bobo5b4o
12bobo26b3o183boo70b3o10b3obo23bo3bo180bo3bo3bo$798bo30bobo6bo7bo15bo
209bobo5boo107b3o176bo5boo3boobo$796b3o30bo242bo7bobo76bo30bo175bobo
13bo12bo$795bo32boo58bo193bo24bo51boobo181bo22boo13boo11b3o$687bo107b
oo64bo25b3o192boo23boo52boo166boo14bo52bo$686boo67b3o5bo73boo14bobo4bo
bo23bo3bo215bobo163bobo54boo12b3o12boo37boo$686bobo65bo3bo4b3o72bo15b
oobboo3bo24bo155bobo18bo126bo79boo85boo$753bo5bo6bo71bobo7boo4bo3boo3b
o21bo5bo142boo6b3ob3o14bobo85bo9boo3boo24bo80bo84bo$753booboboo5boo49b
oo21boo6b3o8boo3bo21bo5bo142bo6bo7bo11boo18boo66bobo9boo3boo17bo5bobo
181bo$817bo26boboo12bobo8boo13bo3bo109boo21bobo6bobo6boo5boo5boo4boo
17bo3bo65boobbo7b5o18bobobbooboo63boo116bo$800bo16bobo6bobo15bobbo7boo
4bo9bobo13b3o111bo19bo3bo6boo21boo4boo16bo5bo67bo9bobo19boobbo5bo63bo
69b3o26bo15b3o$645bo16bobo91bo43b3o15boo6bobbo14boboo5bo19bo127bobo9bo
7bo16b3o22bobo4bo8bo3bobbo12boo45bo6b3o36bo66bobo67b3o20bo3b4o37boo3b
oo$644bobo13b3ob3o27boo59bobo32boo3boo6bo25boo16b3o4bobo16boo127boo8b
4o4bo4bo12b3o24bo3bo9bo20boo43b3o15b3o23boo3boo64boo4bo61bo3bo17bobobb
oboboo36boo3boo$627boo14bo3boo10bo7bo25boo60bobo9b3o32boo23bo3boo15boo
5bo155boobobo4bo15bo3bo8b3o16b3obbo5bo3bo3bo10bo44b5o115boo76boo7boobo
bbob3o$627bobo13bo3boo3boo5boo5boo27bo59boo9bo3bo20bo3bo23bobo7boo179b
3obobbo3bo3bo10bo5bo38boo3boobo41boo10boo3boo8bo106boo60boo3boo6bo3bo
10boboboo38b3o$628b3o12bo3boo3boo100bo37b3o26bo4bobbo5boo174boobobo6bo
bo11bo3bo8bobo36bo41boo11b5o10bo18bo160bo5bo10b4o8boo29b3o$34boo6bo
586b3o12bobo23bo82b3o9bo5bo20b3o25boo4bobo6bobo24boo148b4o22b3o8b5o35b
oo53bo3bo8b3o17bo101bo58bobbo3bo12bo9bobo12bo16bo$34bo5b3o585b3o7bo6bo
11bo12bo81bo3bo8boo3boo65bo23boo27boo121bo34boo3boo68bo21bobo18boo9b3o
99b3o63bo24bo10bobo$24bo7bobo4bo580boo5bobo9boo14booboo91bob3obo79boo
8bo15bo26bo133bo23boo3boo37bo28b3o22bo19bo22boo76b3o12bo43boo8bo3bo3bo
25boo10boo$22bobo7boo5boo578bobo5boo9boo62bo49b5o4bo85bobo41b3o128bobo
37bo29boo26bo11bo34b3o20bo76bo13boo43bobo6boboo3boo5bobo$12boo6boo597b
o34bo5bo5boo3boo28boo59boo4bo78boo31bo12bo129boo37bobo26bobo26boo9bobo
35bo17b3o78bo57bo8bo13boo5b3o20boo$11bo3bo4boo596boo47b5o29bobo57boo4b
obo58bo51b3o168bo10boo7boo6boo49bo3bo11boo39bo146boo14bo5bo22bo$10bo5b
o3boo632booboboo7b3o76boo18bobo21bo5bo5b5o3boo16bo53bo166bobo11bo5bobb
o4bobbo49b3o12boo7boo93bo106bo9bo9bobo18bo$10bo3boboo4bobo644bo77bo20b
o21b3o5bo3bob3obo3boo13b3o40bo11boo168boo10boo3b6obb6o46boo3boo15boo4b
4o9bo78b4o73bo39bobo8boo11bo5boo$10bo5bo7bo688boo24bo5bobo42b3o3b3o4bo
3bo3bo57boo174boo5boo10boo4bobbo4bobbo69boobboob3o9bobo75boobobo100bob
o8boboo22bo5boo$bboo7bo3bo21bo607bobo66bo24bobo3boo57b3o33bo28bobo159b
o12bobo4b3o17boo6boo74bo14boo75b3obobbo20boo77bobbo6booboo20b3o$bobo8b
oo22b3o607boo52boo12bobo5bo17bobo45boo3boo10bo33bo192bo10bo71boo3boo
126boobobo21bobo5b3o57bo13boo6boboo32b3o$bo21bo11b5o587bobboboobobbo7b
o8boo42bobo7boo4boo5boo16bobbo44boo3boo44b3o188b3o10bobbo4bo63bo5bo
117boo8b4o3boo17bo6bo3bo54boo12bo3boo5bobo31bo3bo$oo22boo8boo3boo586b
4oboob4o60bo8boo13boo15bobo8boo12bo277bo90bo103bobo9bo5bobo22bo5bo39b
3o12boo13boo8bo31bo5bo$11bo11boo602bobboboobobbo23boo34boo10bo12b3o13b
obo10bo11b3o39boo4boo230bobo69bo3bo13bo103bo19bo22bo5bo38bo3bo16boo5bo
bbo41bo5bo$11b3o648boo54boo3boo7bobo4bo9b3o12b3o31bobo5bobo4bo70b3o
158boo70b3o10b3obo102boo19boo65bo5bo14bobo5bobo45bo$14bo650boo55boo9b
oo14bo48boo6bo6bobo5bo55boo4bo3bo135boo256bo43bo5bo14bo53bo3bo$13boo
21b3o626b3o54bo10bo28boo3boo30bo14boo3bobo54boo4bo5bo134bo105bo151boo
18boo25bo16boo54bo$36b3o612boo12boo95boo3boo19boo28bobo57bo3bo5bo123bo
8bobo6bo8bo37bo51boobo148boo19boo22bo3bo71bobbo$16bo634boo9boo53bo71bo
27bobbo64bo126b4o5boo7b3o4bobo37boo52boo147boobbo16bo27bo4bobo68bo$15b
obo9bobobbo6bo622boo52boo68b3o29bobo20boo40bo3bo125b4o16bo4boo36bobo
202bobo41bobbo5boo68bo$14bo3bo13bo5bobo675bobo67bo32bobo19bobo40b3o
126bobbo15boo248boo41bo9bo69b3o$15b3o13boo4bo3bo698bo51bo8b3o9b3o5bo
21bo41bo127b4o104bo9boo3boo188bo80bo$13boo3boo8bobobo5b3o700boo47boo8b
o3bo8bo29boo159boo6b4o18b3o82bobo9boo3boo17bo167b3o$31bo4boo3boo697boo
20boo27boo6bo5bo8bo20b3o49boo114bobo6bo21b3o83boo10b5o18bobo121boo3boo
8bo28bo$31bobo729bo36bo3bo30bo44b3o4bo115bo29bo3bo8bo86bobo19boo122boo
3boo8boo$31boo727b3o38b3o32bo45bo5b3o111boo28bo5bo8bo21boo45bo176bobo
32bo$724boo34bo40b3o77bo8bo142bo3bo7b3o22boo43b3o15b3o145b3o42boo$19b
oo702boo309b3o32bo44b5o162b3o43boo$20boo703bo73boo20boo4boo22bobo165bo
81boo10boo3boo162bo$19bo727bobo50bo20bobo4bo14b3o5bo3bo163b3o79boo11b
5o29bo$748boo9bo23boo12b3o21bo6bobo7boobbobbobo7bo166bo91bo3bo28bo$
748bo8b3o24bo12bo10b8o13boo5bobbobboo7bo4bo16boo146boo70bo21bobo18boo
9b3o$41boo713bo24b3o24bob4obo19bo19bo16bobo179bo7bo28b3o22bo19bo142boo
$41bo690bo23boo23bo26b8o19bo10b3obbo3bo3boo13bo177bobo7boo26bo11bo34b
3o140bo38bobo$29bobo10b3o686boo102bo15bobo5bobo191boo6bobo11boo13boo9b
obo35bo137b3o39boo$32bo11bo686bobo102bobbo21bo213bo24bo3bo11boo159bo
42bo$18bo13bo795b3o7boo21boo86bo115bobo5bobo25b3o12boo7boo$17b3o9bobbo
715bo79bo120boo70boo3boo36bobbo5boo24boo3boo15boobboobboo9bo$16b5o9b3o
714bo5b3o73bo114boo4boo13boo54boo3boo9b3o23boo56bobobbobboo9bobo$15boo
3boo648bo76b3obbooboo61boo21bo23b3o72boobboo4b3o11b3o70b3o21boo3bo55b
3o15boo$668bobo81booboo62bo21boo24bo72boobboo4boo9boboo58b3o3b3o4bo3bo
22boo20boo3boo31boo188bo$669boo13bo39boo13boo11b5o62bobo8bo5boo4boo22b
o82boo10bobbo58b3o5bo3bo5bo14boo6bobbo17bo5bo219boo$19bo662b3o40bo12b
oo11boo3boo62boo8bobo3boo4b3o104bo11boboo59bo5bo5bo3bo14bobo7bobo36bo
207boo$19bo661bo43bobo5bo6bo90bobobboo4boo109bo10b3o5boo24boo37b3o15bo
30bo3bo13bo$681boo43boo5boo55bo40bobbo6boo7boo86boo15bo9boo5bobo24bo
54boo31b3o10b3obo$15boo717boo51b4o10boo28bobo7bo8bobo85boo11bobbo19bo
21b3o$16bo467bobo21boo224b3o49b4o11boo27bobo19bo5boo90bo23boo20bo102bo
171boo$13b3o468bo3bo19bo220boo3boo50bobbo40bo21boo3bobo90bo148boobo
169boo$13bo474bo7bo9bobo224boo8boo41b4o69bo77b3o11bo73b3o73boo168bo32b
obo$31bobo450bo4bo4b4o8boo225bo9bobo5boo34b4o125bo20boo86b3o276boo$30b
o457bo4boboboo246bo6bo37bo23bobboo4boobbo88b3o21boo4bo77bo3bo276bo$30b
o445boo6bo3bo3bobbob3o245boobb3o61bo3b3obb3o3bo90bo19b3o3bo89boo9boo
43bo9boo3boo$30bobbo441bobo6bobo6boboboo250bo55b3o6bobboo4boobbo90boo
18bobo4b3o10bobbo8bo52boo3boo6bo9boo41bobo9boo3boo$30b3o442bo18b4o307b
o132boo18bo10bobo61b3o54boobbo7b5o157bo$474boo20bo309bo43b3o101bobbo3b
oo5bo3boo3boo54bo59bo9bobo158boo$485bo21bo275b3o66bo77bo20b4o3boobobo
4bo3boo3boo107bo6b3o167bobo32bo$485bobo17b3o274bo3bo64bo78b3o17b4o14bo
3boo111b3o15b3o190boo$55bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobb
o26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo6boo17bo374b
oo52bo16bobbo8boo5bobo112b5o208boo$39b4o11bo14b4o11bo14b4o11bo14b4o11b
o14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o
11bo14b4o11bo14b4o11bo14b4o11bo30bo275bo5bo46boo43bo41bo10boo16b4o16bo
112boo3boo8bo$39bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo
10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo
10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo10bo3bo
10bo3bo10bo3bo23bobbo275boo3boo6b5o14boo19bo35boo5bobo40b3o21boo5b4o
129b5o10bo18bo$39bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o
11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b4o11bo14b
4o11bo14b4o12bo10bo291bob3obo13bobo9boo5bobo34bobo5boo40b5o19bobo8bo
73boo54bo3bo8b3o17bo$40bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo
26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo26bobbo25boo9bo3bo
289bo3bo14bo10b3o5boo9boo10bo12b3o47boo3boo18bo84bo14booboboo35bobo18b
oo9b3o$489bobo10bo292b3o11bo11boboo17bobo10b4o8b3o72boo85b3o54bo19bo$
499bo5bo290bo12boo10bobbo19bo11b4o8b3o160bo11bo5bo57b3o179bobo$484bo
14bo5bo154boo138boobboo4boo9boboo31bobbo9bobo237bo179boo$105boo377boo
14bo3bo156boo123boo5boo5boobboo4b3o11b3o29b4o10boo48b3o121booboo37boo
202bo$105boo376bobo15b3o156bo125bo7bo9boo4boo13boo20boo6b4o8bo52b3o56b
o66bo39boo8bo$97boo688b3ob3o15boo35bobo6bo12bo110boo110b3oboobboo9bo$
98bo398boo148boo140bobo17bo36bo19b3o50bo54boo4boo13boo94b4o4boo9bobo$
98bobo6bobo360boo24boo147bobbo186b3o7boo71bobo49boobboo4b3o11b3o98boo
13boo$99boo4bo3bo359b3o3boobo19bo137boo6bo7b3o3bo178bo79bo3bo48boobboo
4boo9boboo48boo238bo$95boo8bo360boboo5bo3bobbo153boo6bo6bo3b5o176bo81b
3o58boo10bobbo49bo236boo$95bo8bo4bo356bobbo4bo4bobboo160bo7bo3booboo9b
oo244boo3boo4bo51bo11boboo46b3o238boo$57bo3boo24boo3boobo9bo360boboo4b
4o5boo160bobbo3bo3boob3o8boo253bobo55bo10b3o5boo37bo24bo37boo$55b3o4bo
23bo3bo3bo10bo3bo7boo342boo6b3o3bo7b3o161boo5b4oboo214bo50boo40boo13bo
bo9boo5bobo61b3o34bobo$54bo7bobo5boo13bo21bobo7bobo340bobo7boo11boo
171b4o213bobo92boo13boo19bo64bo33bo$54boo7boo5boo13bo3bobbo26bo340bo
21boo7boo7bo157bo169boo44boo92boo34boo62boo32boo123boo12boo$73boo10bo
5bo4b3o6bo13boo338boo21bo8bobo5b3o325bobo122boo14bo128bo129boo13boo$
73b3o10bo3bo7bo7boo385bo5b3o327bo122bobo12bobo127b3o141bo32bobo$60bo
12boo12boo8bo7boo386boo439bo17bo14boboo129bo173boo$60b3o7boo9bobo413b
oo3boo431bo163bo127b3o45bo$63bo6boo10boo413boo3boo378bo33boo15b3o163bo
bbo125boo$62boo18bo800bo33bo50boo18bobbo8bo67booboboo28bo121boo$881b3o
30b3o51boo18bo10bobo28bobo35bo5bo25bo3bo120b3o6bo$89boo5bo723b3o91bo
69bobbo3boo5bo3boo3boo21bobbo35bo3bo28bo123bobo5boo76boo$70boo16bobo5b
4o722bo136b3o19b4o3boobobo4bo3boo3boo6bo6bo10boo35b3o26bo5bo121boo4bob
o32bo43bo$71bo18bo6b4o720bo137bo20b4o14bo3boo10bobo5bo8bo3boo62bo5bo
160boo33boo7bobo$71bobo5bobo15bobbo24bo371boo443bo17bo19bobbo8boo5bobo
11boboo6bo9boo65bo3bo162boo32bobbo5boo$62boo3boo3boo5bobbo14b4o22b3o
372bo441bobo25bo11b4o16bo11booboo9boobbobbo5boo60b3o14bo168bobo15bo$
62boo3boo13boo12b4o4boo16bo372b3o392bo50boo25bobo3boo5b4o28boboo5b3obb
obbobo6bobo74b3o166bo3bobb3o10bo$80bo3boo10bo7bobo15boo371bo392bobo77b
oo3bobo8bo24boo3bobo7b4o13bo73bo169bo19bo$64b3o15boo22bo706boo74boo82b
o34bobo4bo9boo14boobbo69boo167bo4bo7boobbobbo$64b3o12bobbo8boo13boo
704bobo152boo3boo34bo36b3o25boo194b3o13bo7bobobbobboo$65bo13bobo8boo
23bo698bo152bobo37boo39bo24bo185bobo8bo9boo3bo3bo5b3o$84bo7bo21bo834bo
17bo79boo25b3o182boo9bo8bobo5bobo$83bo30b3o833bo82bo42bo183bo8b3o7bo$
83b3o33b3o775bo50b3o58bo24boo242boo$118bo3bo775bo110boo22boo75boo3boo
152b3o32bo$896b3o105boo4boo13boo72bo13bo155b3o33bo$67bo31bo17bo5bo681b
3o192boobboo4b3o11b3o71b3o5boobbo5bo186b3o$68boo28boo17boo3boo683bo
192boobboo4boo9boboo72bo3bo4bobobbooboo137bo15b3o$67boo29bobo705bo202b
oo10bobbo71bob3obo3bo5bobo136boo17bo$76bo880bo51bo11boboo22boo3boo43b
5o11bo138boo16bo$62b3o11bobo876bobo55bo10b3o5boo6bobo70bo155b3o$61bo3b
o10boo20bo806bo50boo40boo15bo9boo5bobo6boo5bo3bo$60bo5bo31bobo802bobo
91bobo11bobbo19bo6bo7b3o224boo6boo26bo$60bo5bo32bobo15boo114boo563boo
104boo90b3o11bo23boo13b3o145boo12boo61bo4bobbo4bo22bobo$63bo10bobo22bo
bbo15bo115bo562bobo182boo12boo12bo100bo85boo13boo60bo4bobbo4bo23boo$
61bo3bo9boo22bobo13b3o116bobo4bo25boo530bo182bobo14boo10bo98b3o98bo32b
obo27bo4bobbo4bo$64bo4boo4bo11boo9bobo4boo8bo119boo3bobo24bo696bo17bo
15b3o108bo3bo130boo13bo16boo6boo$60bobbo4bobo15bobo9bo6bobo130boo3bo
14boo5bobo697bo40bo30boo69bob3obo81boboo45bo13b3o$60bo9bo15bo20bo130b
oo3bo13bobo5boo645bo50b3o39bo31bo63boo6b5o82bobo63bo$61bo23boo20boo
129boo3bo12b3o654bo5boo77boo5b3o10bobbo8bo4bobo63bo95bo63boo56bo$58b3o
179bobo12b3o653b3o6bo77boo18bo10bobo3boo65b3o92boo5bo115bo$58bo182bo6b
o7b3o531b3o127bobo8bo21boo59bobbo3boo5bo3boo70bo92boo5boo112b3o$246boo
9bobo532bo128boo7boo21bo35b3o19b4o3boobobo4bo3boo163boo4bobo32bo$247b
oo9boo531bo137boo11boo7bobo35bo20b4o14bo3boo202boo$61b3o104boo758b3o7b
o3b3o6boo19bo17bo19bobbo8boo5bobo205boo24b3o$63bo42bo61boo759boo5b4o4b
oobo22bobo37b4o16bo13boo3boo$62bo42bobo80bo731bo9boobbo4bo4bobbo23boo
31boo5b4o82bo165bobo$36bo149b3o729bobo10bobbo3bo5boobo55bobo8bo30bo3bo
47b3o8boo152b5o60bo$36b3o129b3o14bo597boo134boo14boboo3b3o58bo42b3o51b
o8bo34bo116boo3boo57bobo$39bo49bobo13b3o60b3o14boo52bobo540bobo157boo
53boo3boo42b3o50boo5b3o33b3o94b3o19boo3boo58boo$38boo50boo13b3o131boo
543bo143bo68bobo106bo34bo87bobo8bo$54boo34bo15bo133bo687bo50bo17bo143b
oo86boo9bo$53bobo100b3o770bo50bo63boo93b3o88bo8b3o$55bo110boo3boo755b
oo48b3o64bo92bobo$106bo48bo3bo7b5o754b4o112b3o92bo3bo97b3o92bo$105b3o
47bo3bo8b3o9boo3boo739bo115bo56boo3boo31b5o97b3o19boo72bo$38boo3boo22b
oo36b3o61bo10bo5bo46bo541b3o321boo3boo30boo3boo119bo70b3o$38boo3boo22b
obo86b3o30boo40boo544bo93bo132b3o93b5o13bo18b5o81bo15b3o17b3o$62boo6bo
14bo95bo3bo4bo41boo542bo92b3o132bo96bobo12b3o19b3o80boo17bo18bo$40b3o
3b3o9boobobbobbobbo14b3o17bobo74b3o5bobo8boo20boo636boo5bo118bo17bo
109bo23bo82boo16bo57bobbo4bobbo$40b3o5bo9boobboo6bo17bo17bo49b3o32boo
7bo22bo637bo6boo63boo50bobo113b3o11boo122b3o54b3obb6obb3o$41bo5bo19bob
o8b3o6boo110bo12boo7bobo12boo615boo3boobo71bobo50boo44bo265bobbo4bobbo
6bo$67boo86bo3bo39bo7bo4boo7boo14bo614bo3bo3bo74bo94b3o213boo6boo58b3o
25bo$78bobo28bo45bo3bo8bo30bo8boo5boo17b3o531boo66boo13bo83boo92bo137b
oo12boo61bo4bobbo4bo55bo26bobo27boo$77b5o8bo16bobo56boo32bo4boobbo5b3o
6bobo7bo515bo5boo9bobo66boo13bo3bobbo153boo15boo136bobo12boo60bo4bobbo
4bo55boo26boo28bo$76boo3boo5booboo15boo46b3o8boo32boob5o6boo7boo522bo
3bo3b3o10bo69boo10bo5bo154bobo30bo53bo68b3o10bo32bobo27bo4bobbo4bo15bo
bbo4bobbo86bobo5bo$58boo16boo3boo103bo20bo4boo11bo526bo5boobo11bo65b3o
10bo3bo137bo17bo32b3o50bobo68boo43boo13bo16boo6boo15b3obb6obb3o85boo3b
4o$42b3o14bo27bo5bo90bobo25boo533bo5bo4bobbo10boo65boo12boo11bo128bo
52bo49bobo3b3o29boo28boo47bo13b3o41bobbo4bobbo91boboboo$42b3o14bobo6bo
37bo78boo560boo9boobo9boo4boo50boo5boo9bobo15b3o125b3o51boo50bo4bo7b3o
22bo28b3o63bo142bobbob3o$41bo3bo14boo4bobo18booboboo11bobo48bobo40bo
207bo133bo133bo80b3o11b3o4boobboo45bobo5boo10boo14b5o236bo5bo3bo18b3o
94boo116bo26boboboo$64boo50bo39boboo8boo3boo6bo16bo208b3o131b3o131b3o
78boo13boo4boobboo45bo19bo14boo3boo240bo5bo17bo39bo133boo3boo35bo26b4o
8boo$40boo3boo17boo51bo39bo3bo8b3o7b3o15b3o17bo191bo133bo133bo93boo53b
oo35b5o155booboboo19bo19boo24boo3boo8bo3bo51boo5boo132bo5bo33b3o20bo7b
o9bobo$64boo27boo10b3o7b3o41boo8bo3bo5b5o32boo191boo132boo132boo94bo
64bo25bo3bo150b3o27b3o19bo24bobobobo9b3o52boo4bobo32bo162boo18bo12bo$
66bobo23bobo10b3o52bo9bobo5boo3boo8bo23boo619b3o24bobo151bo4bo5bo17bo
3bo18bobo9bo13b5o9bobbo91boo101bo3bo56bobo18boo11b3o$68bo24bo12bo64bo
7b5o10bo646bo24bo135bo17bo26bob3obo18boo8b4o12b3o10b3o93boo24b3o74b3o
67bo26bo$61boo17bo11boo85bo3bo8b3o645boo13bo144bobo22booboo18b5o28boob
obo12bo10boboo74bo192bo24boo$61boo17bo11b3o85bobo24boo647boo143boo24bo
52b3obobbo22bobo76bo43bobo143b3o$80bo12boo11bo72b3o23booboo645boo11bo
212boobobo24bo75b3o42b5o120bo$91bo13b3o16bo45boo6boo25b4o657booboo211b
4o3boo140boo3boo117bobo$40boo19bo43b3o14bobo45boo7bo17bo8boo561boo90bo
163bo57bo5bobo117b3o19boo3boo118boo5boo$41bo18bobo60boo31bo5bobo11b3o
6boo10boo570bobo88bo4bo5bo152bobo64bo9boo5boo3boo84bobo8bo102boo49boo
6bo35b3o$38b3o18bo3bo8b3o80bobbo3bobbo10bo8boo9bobo572bo71bo7boo7b3o
146bo13bo3bo63boo8bo6bobobobo84boo9bo102bo29boo18bo7bobo33bo3bo$38bo
20b5o10bo17bo12bobo50bo6boo21boo12boo16bo550boo69b3o7boo11booboboo138b
o12b5o74b3o4b5o86bo8b3o102b3o27bo25bo3boo12bo$58boo3boo8bo17b3o12bo47b
oo3bo3bo3boo19b3o10bo3bo14b3o618b5o5bo156b3o11boo3boo47bo27bo5b3o177b
oo6boo16bo27bobo9bo13bo3boo10bobo17bo5bo$59b5o26b5o70boo21boo10bo5bo
16bo616boo3boo176b5o19boo25b3o34bo97b3o77bobbo4bobbo44boo8b4o11bo3boo
11boo17boo3boo$60b3o26boo3boo35bo30bobbo5boo5boo5boo13bo3bobbo14boo
312b3o485b3o21bo24bo85bo49b3o19boo56bobbo4bobbo27bo25boobobo11bobo3boo
$61bo28b5o37bo29bobo6bobo3bobo5boo13bo89boo110b3o265b3o352bo19b3o25boo
84boo14boo55bo56bobbo4bobbo25b3o24b3obobboboo8bo4bobo$90bo3bo35b3o40bo
3bo23bo3bo3bo49bo30bo110bo3bo129bo3bo131bo173boo198bo112bobo14b3o15bo
15b3o17b3o58boo6boo25bo28boobobobbobo14bo29bo$65boo24bobo56boo3boo16b
ooboo24boo3boobo48boo19bobo5bobo110bo3bo129bo3bo131bo175bo10bobo308boo
bbobbobo12boo17bo18bo74b3o18boo28b4o3bo16boo27boboo$64bobo8bo16bo57bob
obobo53bo47bobo11b3o5bo3bo3boo112b3o265b3o171bo12bo7boo150bo95boo54boo
bboobboo12b3o16bo57bobbo4bobbo43b3o30bo38bo12bo$66bo7b3o49boo23b5o54b
oo55boobbobbobo7bo251b3o305bobbo9bo8bo148bobo95bo59boo8boo4b3o17b3o54b
3obb6obb3o21bo3bo15boo63boo6bo11bo3bo$126bo25b3o110bobbobboo7bo4bo384b
3o170booboo9bobbobb3o150boo53bo42b3o65bobo3bobo77bobbo4bobbo6bo16bo3bo
14bobo63bo5b3o12bobbo$92boo20bo9bobo26bo12bo97bo19bo385b3o171boo11b3o
3bo206b3o43bo43bo20b3o4bo27boo6boo58b3o69bo13boo8bo5bobo20b5o$74b3o15b
oo19bobo8boo13bo25b4o95bo10b3obbo3bo251b3o488boo41b3o78boo7b3o18boo4b
oo25bo4bobbo4bo55bo20b3o47boo14bobbo6bobo3boo21b5o$103boo7boboo21bo26b
oobobo3boo89bo15bobo119b3o265b3o354bo124boo9bo5boo10boo31bo4bobbo4bo
55boo70boo8boobbo3bo7bobo24boo3boo$74bobo25bobo6booboo22bobbo21b3obobb
obboo76boo5boo5bobbo132bo3bo129bo3bo131bo170boo3boo179b3o37boo3boo76bo
10boo5bobo10bobo29bo4bobbo4bo15bobbo4bobbo109b3obboobbo7bobbo24b5o$74b
obo24bo6b3oboboo25bo22boobobo82boo3bobo7boo132bo3bo129bo3bo131bo170boo
3boo175bo5bo37boo3boo94bo13bo15bo16boo6boo15b3obb6obb3o47b3o54boboo16b
obo26b3o$62b3o36bobbobbobbobbobo24bo24b4o82bo5bo144b3o265b3o170b5o177b
o173b3o41bobbo4bobbo60boo44bobbo8b3o4bobo28bo$61bo3bo8b3o24bo6boo4bo
26b3o22bo89boo278b3o305bobo176b3o139bo36bo100bo3bo8boo43boboo15bo12boo
$94boo6bobo38bo1020b3o13boo3boo14boo100bo3bo7bo40boo6b3o26bo$60bo5bo
26bobo7boo739b3o297bo18bo3bo7boo3boo3boo91boo3boo62bobo5bobo7boo15boo
7bobo$60boo3boo7b3o16bo1050boo16bob3obo6boo101bo5bo19b3o40boo6bo26b3o
6boo$75bo16boo150bo823boo73bobo17b5o14b3o163bo5boo12bo15boobo$244boo
610bobo210bo112b3o94bo3bo82bobo4b3o8bobbo$63bo35bo143bobo596boo15bo
172bo33b3o114bo19b3o74b3o82bobo16boobo25boo$62bobo32bobo743bo15bo170bo
bo33bo283b3o11bobbo7bobboobb3o28bo$62bobo24boo4boo601boo140b3o13bobbo
171boo170bobo144b3o12bobo7bo3bobboo30b3o$62bo26boo4boo11boo588bobo139b
o16b3o308b3o31b5o134bo9bo9boo3bobo6bobbo37bo$62bo32boo11boo590bo435boo
32bo30boo3boo131boo10bo8bobo5bo8boo$62bobbo31bobo600boo435boo30bo31boo
3boo132boo9bo8bo$63boo34bo23boo100boo9boo12boo114boo131bobo130bobo501b
o43b3o13bo86boo65bobo6boo$114b3o6bo101bobo9boo11bo115boo4b3o123bobbo4b
o123bo3bo404bo140b3o11b3o86bo$114bo9b3o99b3o7bo6bo4bobo101bo10boo6b5o
112bo8boo5boo116bo7bo409bo138bo3bo9bo90b3o13boo84bo$115bo10bo100b3o12b
obo3boo102bobo7b3o5bo3bobo110bobo5boo3bo8boo110b4o4bo4bo8boo393b3o152b
oo65boo6boo16bo14boo47bobo31bobo$226b3o12bo3boo108boo6boo6bo3boo110boo
bo6boo10boo109boobobo4bo12boo533boo3boo74bobbo4bobbo29bo50bo33boo$218b
oo5bobo13bo3boo94boo12boo9boo107boo10booboo6bobbo107boo8b3obobbo3bo3bo
494bo71boo56bobbo4bobbo61bobo16bo$130bobo84bobo5boo14bo3boo94boo12boo
9boo107boo10boobo8bobo107boo9boobobo6bobo494boo35b3o33bo56bobbo4bobbo
61boo17bo$122b3o5bo3bo82bo24bobo107bobo132bobo131b4o503bobo34bo3bo29b
3o58boo6boo63bo16b3o$103boo3boo7boobbobbobo7bo5boo74boo25bo108bo11bo
123bo9bo123bo235bobo303bo5bo28bo74b3o73b3o$105b3o7bobbobboo7bo4bo4boo
220bobo134bo133bo223bo189bo116booboboo67bobbo4bobbo43bo99bo$104bo3bo5b
o19bo228boo132b3o131bobo223bo187bobo188b3obb6obb3o21bo3bo15boo61bobbob
oobobbo26bo$105bobo6bo10b3obbo3bo497boo223bobbo185boo190bobbo4bobbo6bo
16bo3bo14bobo61b4oboob4o24b3o$106bo7bo15bobo724b3o318boo9b5o60b3o69bo
29bobboboobobbo$115bobbo1002boo56bo8bob3obo58bo20b3o47boo14bo$117boo
1003boo52b3o10bo3bo59boo70boo13b3o$371bo749bo47boo5bo13b3o20bobbo4bobb
o118bo$105boo265bo133bo133bo413bo114bo21bo19b3obb6obb3o47b3o65boo$105b
oo263b3o131bobo134bo413bo114b3o40bobbo4bobbo60boo114bo$97boo282boo122b
oo8boo122b3o7boo402b3o116bo100bo3bo8boo111bobo$98bo282bobo131bobo131bo
bo621bo3bo7bo114boo$98bobo7bobo272bo133bo133bo462bo74bo58boo3boo62bobo
$99boo6bobbo272boo132boo132boo461boo73bo58bo5bo19b3o40boo25b3o$95boo9b
oo1005bobo72bobo5bo121bo24booboo$95bo8boo3bo237boo30bo101boo30bo101boo
239bobo328booboobbobo52bo3bo89booboo$61boo25bo4bobo10boo240bo28bobo
102bo31bo101bo31bo210bo202bo123bo5bobboo53b3o90b5o60bo$62bo24bobo3boo
12bobbo6boo229bobo6bo20boo102boboo5boo19b3o101bobo6boo19bobo210bo200bo
bo126bo130b3o19boo3boo60bo$62bobo5boo14bo3boo16bobo6bobo220bo8boo6boo
115bo8bo7bobo114bo8boo6boo20boo207bobbo201boo123boo3boo127b3o84b3o$63b
oo5bobo13bo3boo27bo218b3o11boo4boo112b3o12bo4b3o111b3o19boo227b3o451bo
9bo$71b3o12bo3boo4boo6bobo12boo216bo14boo4b3o110bo13bobbo4b3o109bo15bo
6b3o475boo201boo10bo$72b3o12bobo5bobo7boo230boo13boo4boo111boo13boo4b
3o19bo90boo14bo6boo462bo14boo94bo106boo9bo$60bo10b3o7bo6bo8bo7bo251boo
8boo114bo7bobo7boo11boo109boo8boo453b3o13bo97bo48boo65bobo$60b3o7bobo
9boo273bo9bobo113boo6boo8bobo9bobo109boo8bobo431bo19bo112b3o48bo$63bo
6boo9boo286bo16boo94bobo18bo16boo115bo16boo414bo18boo95boo66b3o13boo
70boo72bo$62boo305boo15bo116boo15bo116boo15bo413b3o116bo42boo6boo16bo
14boo47bobo20bo70bobo$387b3o131b3o131b3o526b3o42bobbo4bobbo29bo50bo18b
3o72boo$89bo5boo15bo276bo102bo30bo133bo441bo84bo44bobbo4bobbo61bobo16b
o18bo$70boo16bobo4b3o15boo217booboboo154bo147bo457boo128bobbo4bobbo61b
oo17bo57bobboboobobbo$71bo19bo5boobo11boo377b3o12boo94b3o5bo30boo455bo
bo110bo18boo6boo63bo16b3o55boobbo4bobboo$71bobo5boo7boo7bobbo24bo206bo
5bo127boo3boobboo30boo92bo3bo4boo28bobo215bobo223boo3boo118bobo32b3o
73b3o56bobboboobobbo6bo$62boo3boo3boo5boo16boobo22b3o342b3o5boo28bo93b
o5bobbobo245bo219bo6bo5bo119boo51bo131b3o25bo$62bobobobo13boo11b3o6boo
16bo210booboo46boo81bo3bo3bo42boo81bo3bo46boo203bo217bobo25bo139bo3bo
15boo61bobboboobobbo56bo29bo26boo$63b5o14b3o10boo7bobo15boo211bo48bo
83bobo47bo83b3o47bo204bobbo215boo7bo3bo11b3o139bo3bo14bobo61b4oboob4o
56boo26b3o27bo$64b3o15boo22bo265bo9bobo84bo36bo9bobo83b3o36bo8bobo204b
3o226b3o11bo195bo29bobboboobobbo16bobboboobobbo86bobo6bo$65bo13boo11bo
13boo240boo21bobo8boo98boo16bo3b4o8boo98boo23boo7boo439boo7boo142b3o
47boo14bo42boobbo4bobboo86boo6boo$79boo10boo22bo233bo20boboo109bo14bob
obboboboo108bo18boo4boo448boo124bo76boo13b3o41bobboboobobbo90boo4boo$
84bo6bobo21bobo214boo15bobo4bo12booboo92boo15boboo3boo7boobobbob3o90b
oo15bobo5boo9boo4b3o446bo127bo14bo78bo142boo4b3o$84bobo28boo216bo16boo
3bobo12boboo93bo16bo3bo3bo10boboboo92bo16boo5bobo8boo4boo440bo132b3o
14b3o7b3o65boo142boo4boo$84boo244b3o20boo3bo12bobo90b3o6b3o17bo10b4o
90b3o27bo12boo440bo153bo17boo132boo3boo35bo29boo7boo$119b3o208bo22boo
3bo13bo91bo8bo12bobbo3bo12bo91bo26bobbo12bo441boo151boo5bo3bo8boo131b
oo3boo33bobo20boo7bo8bobo$118bo3bo230boo3bo115bo12bo5bo134bo454bobo
157bo3bo7bo134b5o35boo21boo17bo12bo$66bobo48bo5bo231bobo130bo3bo132bob
o455boo5boo195bobo101bobo58bo19boo11b3o$67boo48booboboo232bo133boo5bob
o125boo5bo5boo450bobo146bo4b3o40boo25b3o171bo$67bo9bo293boo124boo5b3o
123boo6bobo449bo4boo3boo124bo12bo48bo24booboo73b3o68bo24boo$76bo294bob
o124bo5bo126boo5bo217bobo238b3o124bobo11bobo72booboo142bobo$76b3o292bo
11bo97boo22bo9bo133bo209bo215bobo3boo3boo8bo3bo124boo10booboo6bo64b5o
120bo22boo$62b3o31bobo282bobo97bobo30bobo130b4o208bo215boo4bobobobo9bo
bo136bo5bo5boo40b3o19boo3boo120bo5bo$61bo3bo30bo3bo267boo9boo12boo86bo
20bobo8boboo10boo108bobo6boboboo9boo193bobbo216bo5b5o11bo140bo7bobo5bo
34b3o144b3o5boo42b3o$60bo5bo7bo25bo16boo114boo133boo9boo12boo107bobbo
6booboo10boo108bo3bo3bobbob3o8boo194b3o223b3o150boo3boo10b3o25bo9bo
102boo48bobo5boo$61bo3bo9boo19bo4bo16bo115bo100boo34boo6boo88boo20bo
13boo6boboo86boo36bo4boboboo432bo10b3o154bo26boo10bo102bo29boo25bo3bo
33bobo$62b3o9boo24bo14b3o116bobo5bo24boo67bo34b3o7bobo86bo18boo12bo3b
oo5bobo87bo32bo4bo4b4o410bo33b3o135bo18boo19b3o4boo9bo103b3o27bo24bo5b
o12bo18b5o$62b3o22boo7bo3bo4boo8bo119boo3bobo24bo68bobo10bo21boo10bo
86bobo9bo7boo13boo8bo88bobo8boo24bo7bo411b3o170bo15b3o20bo16bobo78boo
6boo16bo27bobo8bo13bo3bobbo12bo16boo3boo$68b3o15bobo7bobo6bobo131bobo
17bo5bobo69boo9b4o9boo5boo101boo8boo12boo5bobbo99boo7bobo12boo6bo3bo
422bo167b3o14bobo22bo94bo4bobbo4bo43boo7boo13bo17b3o16boo3boo$60boo8bo
15bo20bo130bobbo16boo5boo80boobobo7bobo5boo110boo4boo6bobo5bobo108b3o
4boo6bobo6bobo423boobbo172boo6bo3bo59boo55bo4bobbo4bo26bo24boo4boboo7b
o3bo3bo$61bo7bo15boo20boo130bobo15boo87b3obobbo6bo118b3o4boo6bo117b3o
4bobbo5bo440bo16boo5boo3boo141boo5b5o37bobo20bo55bo4bobbo4bo24b3o23b3o
4bob3o7boo3boobo$58b3o179bobo13b3o88boobobo6boo119boo4boo5boo118b3o4bo
6boo438b3o16bo7b5o141bo6boo3boo37bo18b3o58boo6boo25bo27boo4bo19bo29boo
$58bo22bobo158bo4bobo7boo3boo84b4o3boo124boo6boo123bobo7bo462b3o5b3o
150b5o38bo18bo95boo27boo23boo26booboo$82boo163boo9boo89bo5bobo124bo6bo
bo123boo5boobo463bo6bo152b3o39bo57bobboboobobbo24b3o48bo51bobbo$82bo
165bo10bo97bo133bo133bo604bobo17bo39b3o55boobbo4bobboo24bo17bo64boo6bo
13bo$61boo105boo187boo132boo132boo231bobo369boo3b3o32boo18b3o56bobbob
oobobbo6bo18bo82bo5bobo10bo$60bobo105boo687bo205boo3boo161bo13boo24bo
93b3o17b3o62bobbo8bo4bobo6boo11boo$62bo43bo81bo668bo208bo9bo158bobo7bo
bo20b3o25bobboboobobbo56bo70bobo12bo10bobo3boo$36bo68b3o78b3o668bobbo
202bo5bo4bobo157b5o6bo22bo27b4oboob4o56boo19b3o47boo9bobbo3boo5bo3boo$
36b3o50bo79bo15bo55bo615b3o204booboo6boo16boo138boo3boo22bo33bobboboob
obbo16bobboboobobbo49b3o48bo6b4o3boobobo4bo3boo23boo3boo$39bo50boo76bo
bo14boo52boo824bobo26bo138boo3boo20b3o17bo42boobbo4bobboo60bo44b4o14bo
3boo24b5o$38boo49boo14b3o59bo3bo68boo824bo24b3o130bo34bo20b3o41bobbob
oobobbo49b3o9boo43bobbo8boo5bobo27b3o$167b5o894bo24bo121bo8boo35boo22b
o102bo9bobo43b4o16bo11boo16bo$53b3o49bobo58boo3boo1040b3o7boo57boo102b
o50boo4b4o27bo$55bo49bobo48b3o8b5o911bo132bo142boo3boo19b3o41bo6bobo7b
o17bo7bobo$54bo100bo3bo8b3o897boo14bo130boo30b3o109boo3boo61boo7bo27b
4o4boo$105b3o47bo3bo9bo10booboboo881bo13b3o153boo6bo3bo109b5o63boo5boo
11bo16b4o$38boo3boo21boo88b3o21bo5bo45bobo834b3o166bo122bobo83bobo5boo
8bobbo$38bobobobo19bo3bo112bo3bo3boo41boo837bo167b3o3bo5bo32b3o102boo
41bo12boo3bo14b4o25boo$39b5o19bo5bo15bo19b3o74b3o5bo42bo983b3o21bo3boo
3boo5bo25booboo73b3o26boo40bo12boo3bo4boboboo3b4o26bo$40b3o3boo10boobb
oobo3bo15b3o18bo63bo19bobo9bo20boo631bobo358b3o5bo30b3o24booboo101bo
55boo3bo5boo3bobbo30b3o$41bo3bobo10boo3bo5bo18bo78boo22boo8bobo19bo
635bo356bo3bobbobo29b5o23b5o144bo9boo3bobo10bo36bo$47bo16bo3bo18boo67b
3o8b3o30bo3boo6boo7bobo12boo621bo231bo132boo28boo3boo21boo3boo131bobo
8bobo7bobo4bo8bobbo$66boo10b3o74bo3bo8boo30bo3boboo4bobo6boo14bo618bo
bbo229bobo123boo3boo33b5o160boo19bo$77bo3bo73bo3bo8bo31bo3bob3o4b3o10b
o7b3o620b3o230boo163bo3bo104boo55bo9b3o6boo$90bo65b3o8bobo31boboboobbo
4b3o7boo8bo1010boo9bobo105bo17bo$76bo5bo7bo9bo66boo16bo16bo4boo4b3o9b
oo1019bo10bo107b3o14boo83bo$58boo16boo3boo6bobo8boo84bo25bobo1017bo10b
3o95boo6boo16bo13bobo47b3o34bo$59bo28booboo6bobo82b3o25boo1019bo9bo95b
o4bobbo4bo113b3o$42b3o14bobo7bo17bo5bo74booboboo923bo132b3o21bo26boo
55bo4bobbo4bo61bo16bobo$41booboo14boo4b4o20bo15bo92bo899bo153booboo25b
o55bo4bobbo4bo59boo18bo$41booboo19b4o18boo3boo11b3o8bo44bo6bo5bo24bobo
895b3o120boo40bo17b3o58boo6boo62boo$41b5o19bobbo45bobo35bo6boo38boo16b
obo1000bo31bo5bo4bo16bo151bo$40boo3boo18b4o4boobboo36boo35bobo5boo7boo
boo5b5o33boo1002b3o37b3o55bobboboobobbo24b3o16boo56bo$66b4o5bo16b3o10b
3o44boo17bo6bob3obo8bo24bo1004bo28booboboo59boobbo4bobboo24bo18boo59b
oo3bobbo3boo25bo$25boo42bo22boboo83bo3bo7bobo664bobo379bo78bobboboobo
bbo6bo18bo17bo61b5o4b5o23bobo$25bo35boo31boo9bobo72b3o9boo11boo650bo
380bobo94b3o17b3o78boo3bobbo3boo24boo$13boo8bobo35boo17boo11boo10bobo
73bo22b4o649bo248bo132boo93bo70bobo13bo$13boo8boo55boo9bobo29bo80boob
oo648bobbo243bobo227boo19b3o47boo14b3o$16boo71boobbo11b3o16bo45boo6boo
26boo649b3o245boo163bo23bobboboobobbo49b3o48bo17bo$16b3o21boo80b3o45b
oo7bo589boo497bobo22boobbo4bobboo60bo55boo$16boo23bo19bo100boo12b3o6b
oo9boo571bobo497boo23bobboboobobbo49b3o9boo113bo$6boo5boo23b3o5bo13b3o
9boo31b3o54boo12bo8bobo9boo572bo475bo108bo9bobo114bo$5bobo5boo23bo5b3o
12bo3bo7bobo32bo47b5o6boo19b3o7bo6bo16bo550boo475bo5boo100bo124b3o$5bo
37bo14bob3obo8bo78bo6bo5b3o19b3o12bobo15b3o890bo132b3o5boo73boo3boo19b
3o41bo25b3o$4boo37boo14b5o26b5o57bo4boo6boo19b3o12bo3boo16bo890bo214b
oo3boo61boo26b3o$89bob3obo35bo30boo7boo5boo5bobo13bo3boo15boo446b3o
439b3o162bo52b5o63boo24bo3bo$90bo3bo34bobo30boo7bobo3bobo5boo14bo3boo
83boo244b3o739bo52bobo$91b3o36boo41bo3bo24bobo3boo80bo111b3o130bo3bo
129bo3bo602b3o80boo41bo20boo3boo$75bo16bo57boo3boo16booboo25bo4bobo47b
oo19bobo6bobo110bo3bo129bo3bo129bo3bo657b3o26boo40bo87bo$64b3o8bo75b5o
54bo48boo13boo3bobbo5boo110bo5bo129b3o317bobo500bo128bobo$38boo3boo21b
o7b3o49boo24b3o55boo46bo8boobboob3o5boo386b3o186bo233boo307bo86boo$41b
o23bo60bo26bo112bobo3bo3bo3bo3boo113bo7bo451bo234bo19bo115boo158bobo8b
obo$38bo5bo47boo22bo7bobo11bo27bo98bo8bobo5boo115bo7bo448bobbo234bobo
5boo10boo115bo158boo$39booboo30b3o15boo20bobo7boo13bo25bobo97bobbo6boo
bbobbo387b3o184b3o235boo5boo9bobo115bobo7bo43bo48boo55bo9b3o$40bobo32b
o28boo6boo23b3o25boobo4boo90bo13bobo118bo5bo129b3o566boo12boo111boo4b
4o3boboo34bobo48bo17bo$41bo33bo27bo3bo4boo51booboo3boo76bo6boo6bobo
132bo3bo129bo3bo129bo3bo431b3o10bo3bo114b4o4boboboobboo29boo49b3o14boo
69boo72bo$41bo33bo26bo5bo3boo26boo23boobo82boo4bobo7boo133b3o130bo3bo
129bo3bo431boo10bo5bo113bobbo3booboboobbobo55boo6boo16bo13bobo47b3o20b
o73bo$75bo26bo3boboo4bobo23bo24bobo82bobo4bo278b3o563boo13bo3bobbo112b
4o3boo8b3o52bo4bobbo4bo98b3o72b3o$62b3o9b3o25bo5bo7bo24b3o22bo89boo
412b3o429boo13bo120b4o3boo8b3o51bo4bobbo4bo61bo16bobo17bo$61bo3bo28boo
7bo3bo35bo974bo3bo3bo114bo12b3o52bo4bobbo4bo59boo18bo56bobboo4boobbo$
39bo6b3o11bo5bo26bobo8boo1013boo3boobo125bobo6boo28bo18boo6boo62boo73b
o3b3obb3o3bo$38b3o5bo13booboboo7b3o16bo21bo1011bo125boo7bobo28bo108bo
56bobboo4boobbo5bo$37bo3bo5bo27bo16boo22boo1009boo135bo26b3o31b3o16boo
56bo73b3o$36bob3obo32bo39boo126boo1019boo60bo18boo59boo3bobbo3boo55bo
29bo26boo$37b5o21bo36bo143boo612bobo465bo17bo61b5o4b5o55boo26bobo27bo$
62bobo32b4o142bo613bo467b3o78boo3bobbo3boo14bobboo4boobbo56boo27boboo
5boo$62bobo24boo5b4o12boo584boo157bo517bobo13bo41bo3b3obb3o3bo85bo7bob
o$54boo7bo25boo5bobbo13boo583bobo156bobbo464b3o47boo14b3o40bobboo4boo
bbo90bo4b3o$54bobo39b4o12bo587bo156b3o440bo14bo9b3o48bo17bo141bobbo4b
3o$54bo8boo32b4o599boo596bobo14b3o19bo55boo142boo4b3o$63boo35bo22boo
100bo10bo13boo114boo132boo131bobo663boo17bo6b3o9boo173bo21bo7bobo6boo$
115boo6bo101boo9boo12bo114bobo132boo4b3o123bobbo4bo676boo7bo9bobo131b
oo3boo36bo20boo6boo7bobo$115bobo6b3o94boo3boo7bobo4bo5bobo100bo12b3o4b
oo113bo10boo6b5o112bo8boo5boo686bo144b5o35b3o19bobo17bo12bo$41boo72bo
10bo99b3o13bobo3boo96bo4b4o8b3o4bobb4o109bobo7b3o5bo3bobo110bobo5boo3b
o8boo680b3o41bo25b3o73booboo77boo11b3o$41bo184boo15bobo100bo5b4o8b3o4b
oob3o112boo6boo6bo3boo110boobo6boo10boo675bo46boo26b3o73booboo93bo$42b
3o16b3o154boo5boo16bobbo94boo9bobbo9bobo107boo12boo9boo107boo10booboo
6bobbo671bo10booboo45boo24bo3bo73b3o68bo24boo$44bo16bo41booboboo19bobo
85bobo5bo17bobo95boo9b4o10boo107boo12boo9boo107boo10boobo8bobo672bo
235bo$62bo61boo3bobbo84bo24bobo106b4o8bo122bobo132bobo682b3o8bo5bo5boo
41bo20boo3boo142b3o$103bo5bo7boobboob3o5boo6boo74boo24bo108bo12bo121bo
11bo123bo9bo697boo40bo147bo5boo$116bobo3bo3bo3bo3boo4boo220b3o131bobo
134bo222bobo458booboboo5bo6bo181bobo6boo41b3o$104booboo6bo8bobo5boo
363boo132b3o225bo474b3o35bo102boo42boo5bo5boo35booboo$106bo8bobbo6boo
bbobbo726bo473bo26bobo8bobo101bo29boo24bobo35booboo$69boo20boo22bo13bo
bo724bobbo473boo25boo114b3o27bo23bo38b5o$69bobo19bo24bobo738b3o455bo
45bo9b3o104bo27bobo7boo12bobbo17bo16boo3boo$57boo10bo11bo7bobo25boo
1194bobo6bo7bo120bobboboobobbo44boo6bobo12bo18bobo$58bo20bobo7boo280bo
133bo808boo6boo6bo62boo56b4oboob4o27bo23b3o5bo8bobo5boo9boo$58bobo5boo
9boo26boo262bobo134bo133bo680bobo47b3o20bo56bobboboobobbo25b3o22b3o5bo
bobo6boo5bobo29boo$59boo5boo9boo26boo263boo132b3o131bobo750b3o93bo26b
3o4b4o16bo27b5o$69boo6boo18boo282boo132boo122boo8boo677boo3boo36bobo
17bo74b3o18boo26bobo23boo30bo$69b3o7bobo16bo282bobo131bobo131bobo677b
5o20bo17bo56bobboo4boobbo23b3o47boo51b3o$69boo10bo16bobo8boo272bo133bo
133bo660bo17b3o95bo3b3obb3o3bo23bo82boo6bo10bo$66boo31boo8boo272boo
132boo132boo657boo4b3o12bo19boo19bo56bobboo4boobbo5bo18bo82bo8bo10boo$
66boo27boo9boo6bo263bo932boobbooboo5b3o24bo19bo73b3o18bo74boo3boobo6b
3o10boo$95bo9b3o6bo232boo30bo101boo30bo101boo30bo667booboo5bo23b3o24b
oo3bobbo3boo55bo20bobo48bo12b3obbo5bo3bo3bo$61boo24bo5bobo10boo240bo
28b3o102bo28bobo102bo31bo209bobo454b5o6bo22bo26b5o4b5o55boo68boo9bo3bo
9bo$62bo24bobo3boo14boo6boo229bobo5bo125bobo6bo20boo102boboo5boo19b3o
208bo456boo3boo22bo32boo3bobbo3boo14bobboo4boobbo98boo6bobo4bo8bo3bobb
o22boo3boo$62bobo5bo17bobo18boo6bobo220bo8boo3b4o116bo8boo6boo115bo8bo
7bobo229bo483b3o17bo41bo3b3obb3o3bo47bobo9boo42boo16bo5bo23bobobobo$
63boo5boo16bobbo12bo14bo218b3o12boboboo113b3o11boo4boo112b3o12bo4b3o
228bobbo479bo20b3o40bobboo4boobbo49bo11boo41boo17bo3bo25b5o$71boo15bob
o14boo12boo216bo14bobbob3o111bo14boo4b3o110bo13bobbo4b3o227b3o434bo8bo
bo34boo22bo102bo10bo43boo18boo11boo15b3o$71b3o13bobo5b3o6boo231boo14bo
boboo112boo13boo4boo111boo13boo4b3o665b3o6boo58boo102bo50boo4bobo28bo
17bo$60bo5boo3boo7bobo4bo9bo256b4o9boo122boo8boo10boo110bobo7boo660bo
6bo23b3o135b3o48bobo6bo19bo6bobo$60b3o7boo9boo13bo259bo10bobo112boo7bo
9bobo10boo109boo8bobo658boo142boo3boo19b3o39bobo6bo28bobo4boo$63bo6bo
10bo287bo16boo95boo18bo9bo6boo115bo16boo663boo7bobo110b5o62boo6boo11b
oo18boo$62boo305boo15bo95bo20boo15bo116boo15bo664bo7b5o33b3o73booboo
25bo37bo17bo3bo17boo$387b3o131b3o131b3o641bo20b3o3boo3boo5bo26b3o73boo
boo25boo53bo5bo16boo24boo$66bo28boo14bobo218boo3boo50bo102bo30bo102bo
30bo640b3o21bo3boo3boo4b3o24bo3bo73b3o25bobo52bobbo3bo8bo4bobo26bo$66b
o3boo17boo4bobbo13boo221bo130booboboo17bobo134bo669bo3bo4bo29b5o191bo
9bo3bo29b3o$71bo16boobo7bo12bo219bo5bo152boo13bo118b3o12boo654bob3obo
4bo27boo3boo21boo3boo153bo3bo3bo5bobb3o35bo$71bobo5boo10bo7bo25bo207b
ooboo128bo5bobbo30boo92boo3boo34boo654b5o3b3o194bo9b3o7boboo3boo$62boo
3boo3boo5bobo8bo8bo23b3o208bobo3boo133boo28bobo94b3o35bo215bobo641boo
10bobo7bo$63b5o12b3o12bobbo5boo16bo212bo5boo41boo81booboobbobo41boo81b
o3bo46boo205bo585boo54boo9b3o6boo$64b3o14b3o11boo7bobo15boo211bo4bo43b
o84bo48bo83bobo47bo206bo466boo9b3o105bo17boo47b3o$65bo14b3o23bo267bo7b
obo114bo6bo9bobo84bo36bo9bobo203bobbo467bo9b3o106b3o15boo46b3o$79bobo
24boo8bo231boo22bobo7boo98boo16bo4bobo8boo98boo20b4o8boo205b3o464b3o
121bo14bo48b3o34bo$79boo4bo29bo233bo20boo111bo14b3o3boboo109bo19bobob
oo671bo9bo11bo84bobboboobobbo79bobo32bobo$84bo30b3o214boo15bobo5bo12b
oo94boo15bobo4bo12booboo92boo15boboo3boo10bobbob3o668bobo20bobo25boo
56b4oboob4o79b3o33boo$84b3o246bo16boo3bobo12boo95bo16boo3bobo12boboo
93bo16bo3bo3bo10boboboo670boo19bo3bo25bo56bobboboobobbo60bobo$330b3o
21bobo15bobo89b3o7boo11boo3bo12bobo90b3o26bo10b4o659boo32b3o23b3o129b
oo$330bo22bobbo17bo89bo9bobo10boo3bo13bo91bo21bobbo3bo12bo660bo31boo3b
oo4bo16bo74b3o17bo37bo$66bo52b3o232bobo117bo12boo3bo128bo5bo674b3o37bo
bo54bobboo4boobbo23b3o17boo$67boo49bo3bo232bobo131bobo7bo122bo3bo677bo
38boo53bo3b3obb3o3bo23bo17bobo62bobobbobo28bo$66boo32bo7bo8bo5bo233bo
132bo6boo125boo5bobo687bo77bobboo4boobbo5bo18bo78boobobbobbobboboo25bo
$77bo21boo7bobo6bo5bo374boo5boo124boo5b3o681bo93b3o18bo82bobobbobo27b
3o$77bobo19bobo6boo10bo250b3o131bobo124bo5bo681b3o92bo20bobo48bo14bo$
77boo39bo3bo248bo12bo120bo11bo121bo9bo208bobo554boo68boo15b3o$95bobo
23bo226boo22bo8b4o96b3o31bobo130bobo206bo493bo22bobboo4boobbo98boo17bo
$60boo3boo28bobbo18bobbo227bobo17boo10b4o9boo86bo20boo9boo12boo107bobo
8boboo10boo194bo494bo20bo3b3obb3o3bo47bobo9boo54boo$62b3o8bobo22boo17b
o115boo113bo19bobo9bobbo9boo87bo19boo9boo12boo107bobbo6booboo10boo194b
obbo489b3o21bobboo4boobbo49bo11boo$61bo3bo8boo20bo3boo16bo115bo100boo
32b3o8b4o5bo79boo19bobo12boo6boo88boo34boo6boboo206b3o577bo10bo115bo$
62bobo9bo23boo15b3o116bobo5bobo22boo67bo33b3o8b4o4bo80bo19boo13b3o7bob
o86bo32bo3boo5bobo678bo5boo100bo69bo54bobo$63bo23boo6bobbo6boo8bo119b
oo3bo3bo22bo68bobo10bo19b3o12bo85bobo10bo7bo13boo10bo86bobo9bo22boo8bo
677bobo5boo99b3o67b3o54boo$68boo16bobo6bobo7bobo132bo19bo4bobo69boo9bo
bo10boo5bobo100boo9b4o9boo5boo101boo8boo12boo5bobbo688boo80boo3boo19b
3o39bobo24bo3bo$60boo5bobo16bo20bo131bo4bo14b4ob3o81boobo8bobo5boo111b
oobobo7bobo5boo110boo4boo6bobo5bobo772b5o62boo24bob3obo$61bo7bo15boo
20boo131bo12bo4booboboo83booboo7bo119b3obobbo6bo118b3o4boo6bo730bo51b
ooboo25bo37bo25b5o$58b3o20bo158bo3bo3boboo5b3obobbo83boobo7boo120boobo
bo6boo119boo4boo5boo728bobo51booboo25boo$58bo23boo158bobobbob4o5boobob
o84bobo4boo125b4o3boo124boo6boo733boo52b3o25bobo128bo$81boo164boobboo
6b4o86bo5bobo125bo5bobo124bo6bobo946bo$260bo96bo133bo133bo944b3o$168b
oo187boo132boo132boo684boo159bo9b3o$60b3o43bo61boo686bobo453bo157boo
10bobo$62bo43bo81bo670bo452bobo6bo7bo36bo48boo54boo9b3o$36bo24bo43b3o
78b3o670bo453boo4bobo5b4o36bo47bo17boo47b3o$36b3o49bobo94bo54bobo613bo
bbo457boo8boobbobboo29b3o48b3o15boo46b3o19boo$39bo49boo78bo16bo53boo
615b3o457boo11boobboo82bo14bo48b3o20bo73bo$38boo49bo15b3o60b3o12bobbo
54bo1075boo7bo10boo52bobboboobobbo79bobo17b3o72bobo$106bo60bo3bo10bo
1136bobo4bo10b3o51b4oboob4o79b3o17bo75boo$42bo10boo51bo59bob3obo8bo3bo
1135bo4bo10boo52bobboboobobbo60bobo78bo4bo$42bo9bobo51bo60b5o11bo1150b
oo7boo118boo77boob4oboo$54bo51bo49b3o21bo5bo1147boo7bobo28bo31b3o17bo
37bo79bo4bo9bo$96bo8b3o47bo3bo20bo5bo47bo1110bo26bobo31b3o17boo129b3o$
38boo3boo21bo30boo55bo5bo20bo3bo46boo1111boo26boo32bo17bobo62bobobbobo
58bo29bo26boo$39b5o21bobo28boo84b3o4boo42boo1172bo78boobobbobbobboboo
54boo29bo26bo$40b3o20boo3bo16bo19b3o45bo7bo28bo1216bo82bobobbobo21bo4b
o60b3o26bobo6boo$41bo16boo3boo3bo16b3o18bo46bo7bo6bobboo17bobo8bo21boo
1181bobo48bo14bo44boob4oboo88boo6boo$45b3o10boo3boo3bo19bo17bo61bobo
20boo8bobo19bo634bobo594boo15b3o44bo4bo101boo$47bo17bobo19boo65bo5bo6b
oo33bobo7bo8bobo12boo619bo523bo14bo59boo17bo143bo6b3o$46bo19bo41bo46bo
3bo6boo17bo16bobbo6boo7boo14bo619bo524bo13b3o7bobo9boo54boo143bo6boo$
78b3o25bobo47b3o7boobo32bobobboo4boo10bobo6b3o620bobbo519b3o16bo7bo11b
oo194b3o5boo7boo$77bo3bo25boo58b3o31bobo3boo4b3o9boo7bo622b3o538boo7bo
10bo175bo21boo5boo7bobo$76bo5bo7bo94bo15bo5boo4boo11bo1180bo69bo73boo
3boo34bobo20bo18bo12bo$58boo16booboboo6b3o7boo82bobo26boo1187bo4b3o67b
3o114boo39boo11b3o$59bo29b3o8boo66boo3boo9boo26bo1187bobo3b3o39bobo24b
o3bo72bo3bo93bo$42b3o14bobo7boo28bo6bo64bo28bo1198bo3bo44boo24bob3obo
72b3o93boo$60boo6b3o16boo3boo12bo61bo5bo24bo1189bo10b3o8bo37bo25b5o73b
3o69bo$42bobo20boboo5bo12boo3boo11b3o52bobo6booboo25b3o17bo1167bobo8b
oo3boo6boo195bo14bobo$41b5o19bobbo4bo3bobo80boo8bobo5boo3boo32boo1169b
oo20bobo188bo6boo14boo25b3o$40boo3boo18boboo5b4o83bo9bo20bo25boo1197bo
184bo4bobo41b3o$40boo3boo21b3o4b3o14boo11b3o63bo7bo3bo9bo1221b3o138boo
42b3o10boo35bo3bo$69boo21bobo11bo73b3o8b3o1220bo27bo9b3o101bo29boo23bo
bbo$61boo16bo14boo10bo73b3o673bobo555boo24boo10bobo102b3o27bo22bo38boo
3boo$61boo14boobo12boo11bo98boo652bo536bo44boo9b3o104bo27bobo7boo11bo
21bo$77b5o11boo11bo16bo30bo48booboo651bo537bo5boo47b3o76boo3bobbo3boo
43boo7boo11bo22bo$77b3obo7b3o13b3o13bobo21bo6boo16boo6boo23b4o649bobbo
535b3o6boo46b3o19boo55b5o4b5o26bo22boo15bobbo5boo9b3o$40boo38bo41boo
21bobo5boo15boo7bo24boo563boo86b3o543bo48b3o20bo55boo3bobbo3boo24b3o
21b3o6bobo8boo5bobo$41bo103boo15boo12b3o6bo10bo572bobo680bobo17b3o73bo
19bo25boo6boboo16bo30b3o$18bo19b3o19b3o42b3o54bobo11bo8boo9boo573bo
637boo3boo36b3o17bo75bo19boo27boo4b3o16boo26boo$18b3o17bo21b3o8b3o32bo
50boo4b3o15boo3boo7bobo4bo17bo550boo636bobobobo98bo4bo77boo51boo$21bo
37bo3bo9bo15boo3boo10bo46bobbobbo4b3o19b3o13bobo15b3o1174b3o10b5o97boo
b4oboo26bo82boo16boo$20boo50bo57bo21bobooboo4b3o20boo15bobo17bo1167bob
o3b3o6boo3b3o18boo80bo4bo9bo17bobo81bo8bo9bobo$58boo3boo25bo3bo36bo19b
o3bo6bobo6boo5boo5boo16bobbo15boo1167boo3bo3bo5bobo3bo20bo93b3o81boo9b
oo5bobo6bobo10boo$91b3o35b3o19b5o6boo7bobo3bobo5bo17bobo464b3o719bo13b
o23b3o27bobobbobo58bo20b3o61bobo7bobo5boo8boo$91b3o56boo3boo16bo3bo24b
obo3boo193bo132b3o130bo3bo721boo3boo28bo25boobobbobbobboboo54boo68bobo
6bo5bo8bo$151b5o17booboo24bo5bobo47bo20boo121bobo130bo3bo129bo3bo750bo
35bobobbobo21bo4bo65bo35boo6bobo13bobbo27boo3boo$23bo40boo9bo76b3o55bo
47boo14bo4boo120bo3bo128bo5bo129b3o749b3o17bo44boob4oboo50b3o10boo35bo
5boboo13bo30boo3boo$22b3o38bobo8b3o49boo25bo56boo45bobo8boob5o6boo117b
o3bo452bobo560bo20b3o44bo4bo64bobo40booboo14bobo$21b5o39bo7bobobo48bo
140bo4boobbo5b3o116bo3bo127bo7bo315bo517bo9bo35boo22bo101bobo53boboo
15boo12boo15b3o$20bobobobo46bobobo14boo23bo6bobo11bo25bo101bo8boo5boo
117bo3bo127bo7bo315bo517b3o5boo59boo102bo50boo3bobo29bo16b3o$20boo3boo
47b3o15boo20b4o6boo10bobo25bobo99bo7bo4boo7boo111bo3bo451bobbo517bo5b
oo23b3o186bobo4bo23bo4bobo17bo$65bo9bo29bo7b4o20boo28boo4boo91bo12boo
7bobo110bo3bo128bo5bo129b3o184b3o517boo29booboo135bo41bo7bo29bobo3boo$
104bobo6bobbo50boo4boo83boo7bo22bo111bobo130bo3bo129bo3bo726boo6booboo
34bo73boo3boo20bo39boo7boo12boo15boobo$23bo79bo3boo4b4o23boo25boo81boo
5bobo8boo20boo111bo132b3o130bo3bo706bo19bo7b5o6bo26b3o103boo35boo20bob
o14booboo$22bobo50bo27bo3boo5b4o22bo23bobo84boo4bo412b3o706bobo19b3o3b
oo3boo4b3o24bo3bo72bo3bo26boo59bo13boobo24boo$21boobo49b3o26bo3boo8bo
23b3o20bo85bo5boo1120bo3bo20bo13b5o22bob3obo72b3o26bo58bobbo13bobo25bo
$21b3o38b3o8bobobo16boo8bobo36bo1234b5o33bobobobo22b5o73b3o88bo8bo5bo
27b3o$20bobbo37bo3bo7bobobo15bobo9bo1271boo3boo4bo27boo3boo171bo9boo5b
obo7bobo35bo$20b3o37bo5bo7b3o16bo21bo1262b5o3bobo204b3o7bobo5boo9boo$
19bo3bo36bo5bo8bo16boo1285b3o5boo192bobo8booboo6bo$18bo5bo38bo53bo125b
o1136bo38bo106boo17bo35boo8b3ob3o4boo$19bo3bo5bo31bo3bo34boo15bo125boo
1162boo9bobo105bo18boo35bo8b3ob3o$20b3o7bo31b3o34b3o140bobo611bobo549b
o8boobo106b3o14bobo44b3ob3o$28b3o32bo25boo5boboo598boo159bo545b3o9b3o
109bo61b3ob3o32bo$89boo5bobbo9bo588bobo158bo535bo9bo10bobbo81boo3bobbo
3boo77booboo34bo$96boboo8boo590bo155bobbo536bo19b3o25boo55b5o4b5o78b3o
33b3o$63boo34b3o598boo155b3o534b3o18bo3bo25bo55boo3bobbo3boo60bo18bo$
63boo35boo21boo99bo25boo115bo132boo132boo746boo30bo5bo21b3o73bo54boo$
123bo98b4o6boobboo12bo115boo131bobo132boo4b3o739bo32bo3bo5bo16bo75bo
18boo35boo$37bo77b3o6b3o94boboboo5b4obobbobo5bobo93bo5boo13boo4boo112b
o12b3o4boo113bo10boo6b5o739b3o30b3o7bo57bo4bo48boo$18boo15bobo77bo10bo
93bobbob3o5boobo3bo3bo3boo92bo3bo3b3o11b3o4boobboo103bo4b4o8b3o4bobb4o
109bobo7b3o5bo3bobo740bo38b3o55boob4oboo26bo18bo63b8o$19bo16boo78bo
103booboboo4bo12bo101bo5boobo9boo4boobboo103bo5b4o8b3o4boob3o112boo6b
oo6bo3boo839bo4bo9bo17bobo81bob4obo29bo$16b3o84boo3boo108b3ob4o14bo4bo
95bo5bo4bobbo10boo107boo9bobbo9bobo107boo12boo9boo767bo93b3o101b8o27bo
bo$16bo89bo22boo86bobo4bo19bo96boo9boobo11bo107boo9b4o10boo107boo12boo
9boo765bobo92bo20b3o63bo53boo$103bo5bo14bo4boo86bo22bo3bo105b3o10bo
121b4o8bo122bobo779boo92boo68bobo14b3o$104booboo9boob5o6boo6boo74boo
22bobo107boo9bobo121bo12bo121bo11bo826bo4bo65bo35boo18bo$44bo60bobo9bo
4boobbo5b3o5boo220boo132b3o131bobo800bo23boob4oboo50b3o10boo35bo17boo$
45bo60bo9bo8boo5boo497boo225bobo570bobo25bo4bo64bobo$43b3o60bo9bo7bo4b
oo726bo574boo83bobo68bo56bo$73boo6boo33bo12boo726bo552bo5boo100bo68bob
o56bo$53bo19bo7boo34bo739bobbo550bo4boo168bo3bo53b3o$51bo3bo7boo6bobo
44boo250bo486b3o549b3o106bo41bo25b5o$51bo3bo7boo6boo298bo133bo133bo
851boo3boo20bo39boo25boo3boo$53boo5boo43boo262b3o131bobo134bo799bo81b
oo35boo25b5o$59b3o6bo36boo397boo132b3o800bo50bo3bo26boo62b3o$60boo6bo
13bo298boo132boo132boo788b3o51b3o26bo65bo$46bo16boo5b3o7booboo296bobo
131bobo131bobo841b3o157bo$45bobo15boo5boo311bo133bo133bo912bo86bobo$
38bo7bo25bo6bo5bo297boo132boo132boo739boo169b3o86boo$37bobo338bo133bo
880bo157bobo8booboo$38bo12b3o25booboboo261boo27bobo102boo30bo101boo30b
o745bobo4bo9boo84boo17bo35boo8b3ob3o$51bobbo293bo28boo103bo28b3o102bo
28bobo746boo3bobo7b4o35bo47bo18boo35bo8b3ob3o$51bo10bo285bobo5bo125bob
o5bo125bobo6bo20boo208bobo539boboo5b3obbobbobo28bobo48b3o14bobo44b3ob
3o17boo$44b3o4bo3bo6bobo13boo260bo8boo4bobo116bo8boo3b4o116bo8boo6boo
232bo537booboo9boobbobbo28boo50bo61b3ob3o18bo73bo$45bo5bo10boo14bobo
257b3o13boboo114b3o12boboboo113b3o11boo4boo231bo538boboo6bo9boo51boo3b
obbo3boo77booboo16b3o75bo$38b3o4bo6bobobboo20bo257bo15booboo113bo14bo
bbob3o111bo14boo4b3o227bobbo539bobo5bo8bo3boo49b5o4b5o78b3o17bo41b6o
28b3o$39bo39boo256boo15boboo113boo14boboboo112boo13boo4boo229b3o540bo
6bo10boo51boo3bobbo3boo60bo18bo59bo6bo$39bo29bo8b3o274bobo9boo119b4o9b
oo122boo8boo10boo766bobbo5boo62bo54boo78bo8bo$35boo5boo16bobo5bobo7boo
276bo10bobo120bo10bobo121bo9bobo10boo765bobo6bobo28bo32bo18boo35boo78b
o6bo8bo$37bo22bobo4bo3boo8bo287bo16boo115bo16boo115bo9bo6boo770bo29bo
51boo115b6o7b3o$61bo5bo3boo296boo15bo116boo15bo116boo15bo771boo26b3o
31bo18bo63b8o58bo$46bo20bo3boo314b3o131b3o131b3o829bobo81bob4obo21b6o
31boo29bo$45bobo20bobo261boo3boo50bo76boo3boo50bo133bo913b8o20bo6bo59b
obo$38bo7bo10bo11bo10bo251boo3boo130bo130booboboo880b3o63bo44bo8bo59b
oo$37bobo17b3o19b3o384bo5bo1063bobo14b3o43bo6bo$38bo12b3o6bo17b5o251b
3o34bo95booboo33boo93bo5bo870bo22bo35boo18bo43b6o$50bobbo5boo11bo4boo
3boo250b3o34boo95bobo35boo955bo13b3o7b3o10boo35bo17boo$53bo6b3o7booboo
3b5o252bo34bobo11boo83bo35bo12boo81booboo46boo82boo120bobo600bobo16bo
18bobo$53bo7bobo14bo3bo301bo84bo48bo84bo48bo84bo119bo604boo15boo6bobo
68bo116bo$50bobo7bo3bo4bo5bo3bobo293bo6bobo123bo7bobo121bo9bobo84bobo
6bo110bo630bo68bobo116bo$60b5o15bo267boo22b4o6boo98boo22bobo7boo98boo
21bobo8boo86boo6boo109bobbo620b3o72bo3bo72b5o36b3o$59boo3boo3booboboo
273bo21b4o108bo20boo111bo20boboo99boo4boo108b3o621b3o4bo41bo25b5o71bob
3obo$60b5o267boo15bobo5bobo11bobbo91boo15bobo5bo12boo94boo15bobo4bo12b
ooboo99boo4b3o730bo3bo3bo39boo25boo3boo71bo3bo$44boo15b3o15boo252bo16b
oo3bo3bo11b4o92bo16boo3bobo12boo95bo16boo3bobo12boboo99boo4boo721bo8bo
5bo6boo35boo25b5o73b3o$44boo16bo16boo249b3o22bo16b4o88b3o21bobo15bobo
89b3o7boo11boo3bo12bobo104boo8boo713bo8bo3bo8boo62b3o75bo$330bo23bo4bo
15bo88bo22bobbo17bo89bo9bobo10boo3bo13bo105bo9bobo710b3o9b3o8bo65bo$
355bo10bo121bobo117bo12boo3bo131bo739bo184bo$355bo3bo4boo123bobo6bobo
122bobo132boo736b3o35bo102boo42bobo$63bo293bobo5boo124bo6boo124bo870bo
37b3o101bo44boo$60boo437bo139boo854boo24bobo8booboo101b3o$43b3o5b3o6b
3o8boo299boo131b3o131bobo843bo35boo8b3ob3o102bo$51bobbo6boo8boo299bobo
9boo119bo12bo120bo11bo826bo6boo35bo8b3ob3o77bobobbobo$43bobo5bo9bo310b
o10b3o96boo22bo8b4o130bobo204bobo617bobo5bobo44b3ob3o17boo54boobobbobb
obboboo25bo$42b5o4bo8bobo305bo11boboo9boo87bobo17boo10b4o9boo107boo9b
oo12boo196bo617boo52b3ob3o18bo58bobobbobo27b3o37bo$41boo3boo4bobo5boo
306boo10bobbo4bo5bo87bo19bobo9bobbo9boo107boo9boo12boo196bo672booboo
16b3o93bo41bo$41boo3boo287boo27boo3boo9boboo5bo79boo32b3o8b4o5bo79boo
19bobo12boo6boo207bobbo630boo3boo36b3o17bo41b6o48boo38b3o$336bo32b3o
11b3o3bo3bo76bo33b3o8b4o4bo80bo19boo13b3o7bobo205b3o619bo10boo3boo37bo
59bo6bo$61booboboo268bobo8bo21boo13boo5bo78bobo10bo19b3o12bo85bobo10bo
7bo13boo10bo826b3o112bo8bo60boo$46boo289boo8bobo11boo5boo101boo9bobo
10boo5bobo100boo9b4o9boo5boo168bo666bo3bo3bo4b3o3b3o18boo79bo6bo8bo17b
3o32boo$46boboo11bo5bo282boo8bobo5bo113boobo8bobo5boo111boobobo7bobo5b
oo166b3o664boo3bob3obo3bo5b3o19bo80b6o7b3o17bobo$49bo300boo8bo121boob
oo7bo119b3obobbo6bo174bo668boo3b5o5bo5bo17b3o27b8o58bo20b3o$62booboo
283boo7boo121boobo7boo120boobobo6boo174boo706bo29bob4obo21b6o31boo19b
3o32b3o32bo$44bob3o8bo6bo282bobo5boo125bobo4boo125b4o3boo880bo35b8o20b
o6bo51b3o10boo20b3o30bobo$44bo11boo289bo7bobo125bo5bobo125bo5bobo877b
3o17bo44bo8bo50b3o11boo53boo$44bo11bobo298bo133bo133bo876bo20b3o43bo6b
o51bobo10bo$66boo289boo132boo132boo829bo45boo22bo43b6o52b3o$66bo733b3o
653b3o5bobo23b3o32boo134boo3boo$67b3o729bo3bo54bobo598bo4boo24b3o169b
5o$69bo787bo600boo5bo23bo3bo34bo134b3o39bo$43boo3boo748bo5bo52bo623boo
17bo26bobo104bo29bo41bo$45b3o16boo9boo621bo99boo3boo52bobbo599b3o18bo
6boo3boo4b3o24bo3bo72b5o26boo68b3o$44bo3bo14boo9bobo619b3o158b3o600b3o
19b3o14b3o24b5o71bob3obo24bobo$45bobo10bo6bo7b3o4boob3o609bo788bo40boo
3boo71bo3bo$46bo10bobo12b3o4bobb4o609boo104bo695boo3boo22b5o73b3o$50b
oo3boo3bo12b3o4boo718boboo665bo27boo3boo23b3o75bo$50boo3boo3bo13bobo
723bo657boo3boo5bo57bo181boo$55boo3bo14boo723bo3bo654b5o4b3o192bo46bo$
46boo9bobo741bobbo655b3o36boo106boo17boo33boo48b3o$46boo10bo742b5o655b
o26boo9bobo105bo19boo33boo49bo$801b5o683bo8bobboo105b3o15bo$800boo3boo
679b3o11boo108bo$801b5o680bo13boo83bobobbobo$692b3o99bobo5b3o51bobo
618bo23bo23boo54boobobbobbobboboo$691bo3bo98boo7bo55bo615bobo48bo58bob
obbobo70boo3boo$690bo5bo98bo63bo603boo11boo17bo5bo21b3o93bo34bobo8b3o$
691bo3bo160bobbo603bo31bo5bo21bo41b6o48boo33boo8bo3bo$692b3o162b3o604b
3o29bo3bo6bo56bo6bo46bobo34bo9bobo$692b3o771bo30b3o5bobo55bo8bo93bo$
1506boo56bo6bo8bo17b3o$779boo7bo695bo80b6o7b3o17bobo$690boo86bobo5boo
17boo678bo91bo20b3o$691bo86bo8boo16bo677b3o54b6o31boo19b3o47bo16boo$
688b3o86boo27b3o730bo6bo51b3o10boo33boo17boo$688bo119bo705bo23bo8bo50b
3o11boo33boo$1515bo23bo6bo51bobo10bo$1513b3o24b6o52b3o$1497boo$779bobo
76bobo631bo4boo$779boo76bo632bobo$780bo76bo633boo111bo34bobo$857bobbo
712b5o26boo33boo$857b3o662bo49bob3obo24bobo34bo$782bo737bobo50bo3bo$
756boo22b3o738boo51b3o$756bobo14bo5bo795bo$758bo12boo6boo692boo$758boo
12boo700bo158bo$1474bobo4bo95boo17boo33boo$1475b3ob4o6boobboo34bo47bo
19boo33boo$777bo699booboboo5b4obobbobo30bo47b3o15bo$776b3o698bobbob3o
5boobo3bo3bo26b3o49bo$776b3o699boboboo4bo12bo53bobobbobo$856bobo620b4o
14bo4bo48boobobbobbobboboo$774boo3boo78bo621bo19bo53bobobbobo$774boo3b
oo78bo637bo3bo3boo82bo34bobo$751bo104bobbo637bobo5bobo81boo33boo$751b
3o103b3o647bo29bo50bobo34bo$754bo9bo12boo728boo26bobo$753bo9b3o10bobo
757boo30b3o$753bobbo5boobo9boobbo788bobo$757bo4b3o11boo790b3o$754bo3bo
4boo11boo790b3o47bo$756bo19bo781bo9b3o10boo33boo$753bo5bo784bo13b3o7b
3o11boo33boo$753bo5bo16bo5bo762bo15bo6bobo10bo$754bo3bo17bo5bo760b3o
14bo7b3o$755b3o12bo6bo3bo778bobbo$770bobo5b3o77bobo703bo$760boo8boo85b
o703bo3bo$761boo94bo705bo10bo34bobo$760bo96bobbo699bo5bo7boo33boo$421b
oo5bo19boo105boo5bo19boo105boo5bo18bobo139b3o692bo7bo5bo6bobo34bo$421b
oo5b3o16bobo105boo5b3o17boo105boo5b3o15bobbo48boo782bobo8bo3bo$431bo
14b3o12bo103bo13boo10bo4bo102bo13boo10bo6bo33bobo782boo9b3o14bo$430boo
5boo6b3o8boo3b4o99boo5boo5b3o10bo4bobo99boo5boo4boo3bo8bo5bobo32bo14b
oo794b3o$437boo7b3o8boo3b4o105boo6boo10bo7boo104boo6boo9bo6boobo46bo
794bo$447bobobbooboboo3bobbo5boo109boobboo11boo4boo107bobbobboo9booboo
22bo23b3o791boo25bo$448boobboobobo4b4o5boo109boobbobboo8boo4boo81b3o
24bobobbobb3o5boobo22b3o24bo781boo33boo$420b3o31boobo3b4o89b3o30b4o5bo
bo89b3o29b4o7bobo3boo18b3o799bo7boo33boo$461bo91booboo30bo7bo90bo3bo9b
o19boo9bo4bobo820bo5bo$420bobo130booboo9bo132b3o36bo15boo3boo11b3o782b
3o$419b5o9bo119b5o8b3o117boo3boo6b5o35boo14boo3boo11bo$418boo3boo7b3o
12bo104boo3boo6b5o128bobobobo69bo23boo56bobo701bo10boo3boo$418boo3boo
6b5o9boo117boo3boo8bobo116boo3boo9bo83bo60bo699bobo12bo$430boo3boo9boo
131boo131boo11boo37boo21boo7bobo60bo698bo3bo4boobbo5bo$431b5o144bo132b
oo8bo4bo36bo16bo4boo7boo58bobbo698b5o4bobobbooboo17boo$421bo9bo3bo153b
6o106bo20bo6bo35bobo8boob5o6boo65b3o692bobobboo3boo3bo5bobo19bo$422boo
8bobo20bo4bo95boo8b3o19bo6bo104bobo18bo8bo29boo4boo7bo4boobbo5b3o759b
oo4b5o11bo17b3o$433bo19boob4oboo103b3o18bo8bo103bobo18bo8bo29bo13bo8b
oo5boo761bo5b3o12bo17bo$424bobbo27bo4bo102bo24bo6bo101bo3bo19bo8bo30b
3o10bo7bo4boo771bo25bo$424bobbobo132bobo8bo15b6o101b5o21bo6bo33bo10bo
12boo795b3o$420bo9boo130boobo5boo122boobobo11bo10bo4bo46bo807bo$423bo
6boo6bo123booboo5boo120b3obobbo10bobo10boo49boo759bo34bo10boo$420boo8b
oo6bo123boobo129boobobo11boo823b3o6bo24b3o$427bobo8bo123bobo131b4o840b
o3boo24bo3bo$427bo135bo133bo841bo5boo22bob3obo5bo$1539bobbo19boo6b5o6b
o$858bobo682bo18bo17bobo$571bo285bo683bobo19b3o13booboo$571bobo283bo
684bo22bo12bo5bo$571boo284bobbo720bo$857b3o718boo3boo$1539boo3boo5bo$
418boo132boo132boo851bobobobo3bobo$419bo133bo133bo852b5o5boo27b4o$419b
obo8bo122bobo131boboo850b3o25boo8bobboo$420boo8bobo121boo132bo853bo27b
o9boboo$430boo125boo133bo874b3o$423b3o131bobo130bo876bo13boo$423bo133b
o133bo866bo23bo$424bo1134bo$1544boo11b3o$856bobo685bo31booboboo$859bo
685b3o28bo5bo5bo$698boo159bo687bo29bo3bo7bo$431boo131b3o131bobo155bobb
o718b3o6b3o$431bobo130bo133bo158b3o$431bo133bo1000bo$1564bobo$1565boo$
501boo132boo132boo$501bo133bo133bo826bo$489bo9bobo70boo48bo10bobo69b3o
48boo9bobo824bobo$398bobo86bobo9boo32bobo36bobo46bobo9boo34bo35bo48bo
3bo8boo809boo15boo$398bobbo84bobo44bo3bo34bo46boo3bo44bobo34bo46bo5bo
813bo4boo$401boo82bobbo23bo24bo81boo3bo21bo23bobo5bo73bobbo3bo20bo793b
o$399bo3boo5bo75bobo23b3o18bo4bo4b3o73boo3bo21b3o21bobbo3b3o79bo20b3o
789b3o$401boo6bobo70boo3bobo6bo18bo21bo5b3o70boo3bobo6bo18bo20bobo3bo
3bo69bo3bo3bo24bo74bobo$391boo5bobbo6bo3bo68bobo5bo6bobo15boo9boo6bo3b
o4bo3bo68bobo4bo6bo18bo10boo8bobo6bo70boboo3boo24boo73bo745bo$390bobo
5bobo8b3o69bo14boo26bobo6bobo5bo5bo67bo13b3o16bobbo6bobo8bo5bo5bo31boo
34bo107bo746bo$390bo16boo3boo32boo32boo34b3o5bo17bo3bo67boo36bo5bo16bo
5bo31bobo32boo107bobbo741b3o$389boo55bobo67b3o4boo18b3o104bobo4boo17bo
3bo32bo71boo70b3o$446bo192bo11bo25b3o92boo780boo$505boo131boo131boo
782bo$489bo14boo132bobo132bo781bobo5bo10bo$488bo17bo7boo3boo101bo25boo
3boo101bo25boo3boo767boo5boo9boo$488b3o24b5o102bobo23bobobobo100bo26b
oo3boo775boo7bobo4bo30bo$437bo6bo15bo6bo9bo38b3o51boo6boo13boo6boo8bo
10boo25b5o91bo9b3o806b3o13bobo26bobo$436boo6boo7b3o3boo6boo8b3o17bo19b
o51bobbo4bobbo11bobbo4bobbo7b3o17bo18b3o50bobbo4bobbo11bobbo4bobbo7b3o
17bo18b3o772boo3boo15bobo26boo$407boo26b3o6b3o6bo4b3o6b3o10bo16b3o41b
oo25b6obb6o9b6obb6o9bo16b3o17bo5boo16boo24b3obb6obb3o7b3obb6obb3o8bo
16b3o12bo3b3o4boo770boo16bobbo$408bo27boo6boo8bo4boo6boo10boo19bo12bo
28bo26bobbo4bobbo11bobbo4bobbo9boo19bo11boo9boo17bo26bobbo4bobbo11bobb
o4bobbo9boo19bo10boo4bo5boo49bo720bo17bobo$405b3o29bo6bo15bo6bo31boo
11boo25b3o28boo6boo13boo6boo30boo10boo26b3o91boo10bobo60b4o734bobo3boo
$405bo106bobo24bo107bo25bo169b4o9bobo721bo5bobo$486bo356bobbo5boo5bo
728bo29bo$487boo228bo32bo86bo5b4o5boo5bo728boo29bo$448bo37boo31boo61b
oo32bo36boo62boo31bo36boo48bo4b4o10bobbo757b3o$448boo32bo36bo63boo30b
3o35bo62bobo30bobo17b3o15bo54bo14b3o$447bobo31b3o36b3o59bo32b3o17b3o
16b3o71bo19booboo15bo3bo15b3o$461bo18b5o16b3o18bo71boo38bo3bo17bo70boo
18bo5bo24boo10bo35bo$460boo17bobobobo14bo3bo4boo7bo74boo18boo3boo13bo
5bo3b3o6bo74bobo20bo16bo5bo3bobo6bo37b3o$434boo24bobo16boo3boo13bo5bo
bbobo5b3o49bo26bo17boo3boo13booboboo5bo4b3o48bo7bo37boo3boo13boo3boo5b
o4b3o36bo6b5o17boo$433b3o3boobo50bobo3bo5bo4bo4bo49b4o3boboo68bo4bo49b
obo5b4o72bo39boo4bob3obo16bo773bo$423boo5boboo5bo3bobbo47boo6bo12boo
40boo5b4o4boboboobboo67boo40boo4boo8boobbobboo46bobo18boo45bo3bo6bo8bo
bo771bobo$423boo5bobbo4bo4bobboo34bo11bo5bo3bo23bo28boo5bobbo3booboboo
bbobo53bo54boo4boo11boobboo47boo66b3o7boo7boo773boo$430boboo4b4o5boo
32bobo17b3o22b3o35b4o3boo8b3o32boo18bo60boo7bo10boo44bo6boo9bo50bo3boo
4boo$433b3o3bo7b3o33bo18bo10bo11bo39b4o3boo8b3o17bo34bo9bo51bobo4bo10b
3o49bobbo7bobo53boo4b3o$434boo11boo19boo9bobbo19bo10bo11boo41bo12b3o
17boo32boo8booboo51bo4bo10boo52boo6bo3bo52boo4boo$446boo7boo10boo10bo
19booboo8bobo65bobo6boo10bobo9boo22bo76boo7boo22boo22bo8b3o33b3o22boo
15bobo$446bo8bobo11bo10bo17bo5bo6booboo64boo7bobo22bo14bo5boo7bo5bo63b
oo7bobo22bo29boo3boo33bo22bo15bo$457bo19b3o18bo11bo5bo74bo19b3o14bo96b
o19b3o14bo54bo31boo6bo775boo$338boo52boo63boo18bo21boo12bo77boo18bo16b
3o13booboboo74boo18bo16bobo84boo6bobbo772bobo$338boo50bobbo116boo3boo
245boo93b3o775bo$377bobo9bo7b5o118boo3boo216bo23bo867boo$377bo3bo7bo6b
o5bo46bo26bo43boo3boo56boo24boo22bo9boo73boo22boo22b3o8boo$381bo7bo7b
oo3bo45bobo24boo22bo9b3o9b5o46boo7bo3bo22boo22b3o8bobo61boo9bobo21bobo
20b5o6boo31boo$367boo8bo4bo7bobbo7bo44boo3bo23bobo10bo9b3o7boobo10bobo
46bobbo5bo5bo23bo20b5o8bo62boo12bo42bobobobo7bo29bobo$367boo12bo10boo
43bo8boo3bo35bo9b5o6boo61boboo4boobo3bo34bo8boo3boo7boo67bo4bobbo33bo
8boo3boo39bo21boo16bo$377bo3bo37b4o14boo7boo3bo35b3o6boo3boo6boo11b3o
45booboo4boo5bo34bobo19b3o75bo32bo77bobo5boo7b3o$377bobo8bobo27b6o13b
oo9bobo46b5o8bobo38bo6bo11boo7boo4bo35boo20boo39boo6boo17b3o4bobo33b3o
75bo6boo8b3o$389boo26b8o20bo3bo47bo3bo8bobboo35boo6boo12bo6bo3boo47bo
13bo36bobbo4bobbo16boo5boo121bo$371boo16bo26boo6boo9b3o6bobo51bobo48b
3o6b3o17bobo36bo14bo49b6obb6o15boo37boo95boo3boo$337b3o29bobbo7boo20bo
14b8o10b3o6bobo36boo14b3o48boo6boo18bobo35boo65bobbo4bobbo17bobo34boo
96boo3boo$336bo3bo27bo7boo4bo17b3o15b6o12bo8bo36boo17boo48bo6bo20bo36b
obo16boo47boo6boo7boo10bo37bo17boo8bo21b3o52bobo$335bo5bo18boo6bo6bo6b
o16bo19b4o9boo50bo16bo24bo39b3o66bo9bo54bobo66bo8b3o22bo55bo$336bo3bo
19boo6bo7b6o17boo30bobo68b3o22bo40bo67b3o5b3o55bo67b3o4b5o20bo44boo10b
o$337b3o29bobbo60bo8booboboo55bo4b5o11b3o39bo8boo3boo55bo4b5o62boo3boo
55bo3boo3boo53bo9bobo7bobbo$337b3o3boo26boo20bo48bo5bo5booboboo47bob3o
bo6bo54bo5bo28boo29boo3boo61boo3boo28b3o87bobo7boo10b3o$344bo47bo50bo
3bo28b3o12boo9bo6bo3bo6b3o87bobo23bo6b5o63b5o8b3o20bo10bo10bo64bo3bo7b
oo$344bobo5boo24boo3boo7b3o49b3o7bo5bo17bo11b4o7bobo6b3o6b5o53bo3bo6b
oo3boo17bo10boobboo6b4o4bo3bo64bobo8bo3bo18bo10boo9boo8bo55bo3bo7boo$
345boo5bobbo23b5o31bo8boo51bo7bobobbobb3o5boobo6bo6boo3boo23bo8bobbo
17b3o9b3o25bobobbob4o5boobobo4bobo35boo38bo5bo23bo4bobo7boo3boo4bo15b
oo38bo3bo10b3o$356bo9bobo10booboo29bobo6bobbo29booboo24bobbobboo9boob
oo41bobo10bo28bo3bo22bo3bo3boboo5b3obobbo4b3o32bo3bo5bobb3o16b3o8bo3bo
22bobo13b3o24bobo38bo3bo$335b3o18bo7bo3bo10booboo22boo4bobo7bo3bobboo
26bo25boo9bo6boobo8boo19bo5boo3boo3bo5boo3bobbo25bobo23bo12bo4booboboo
6boo25boo3bo5bo9bo3bo24b3o22bobo15boo12boo12bo38bo3bo$334booboo3bo13bo
7bo15b3o13b3o7boo3bobbo7bobboobb3o49boo3bo8bo5bobo3boo4bo6bo11bobo5boo
3boo3bo4boboboo3b4o23bo23bo4bo14b4ob3o4bo26boobboobo3bo8bo4bobo22b3o
21bobbo16boo5boo4bo52bo3bo$334booboo4boo7bobbo7bo4bo26bo3bo12bobo16boo
bo5boo41boo10bo6bo4bobo4b3o3bo12boo10boo3bo14b4o5boo40bo19bo4bobo4b3o
28bo5bo16boo4boo28boo9bobo17bo5bobo4b3o50bobo$334b5o3boo8boo10bo20bo8b
o5bo12bobo4b3o8bobbo5boo5boo20boo6boo5bobbo21bo6bo30bobo5boo8bobbo5boo
5boo20b3o5boo3bo3bo22bo6bo29bo3bo17boo4boo5boo20bobo5boo3bobo24bo6bo
51bo8boo3boo$333boo3boo24bo3bo6boo8bobo6bo5bo14bo15boobo12bo20bobo5bob
o6bobo21boo12boo23bo16b4o12bo23bo4bobo5bobo22boo37boo18boo11bo23bo4bob
o5bo24boo$355bobo8bobo6bobo7boo10bo31b3o16b3o5boo12bo5bo46bo40b4o14b3o
5boo12bo5bo88bobo14b3o5boo18bo101bo3bo$355boo20bo17bo3bo29boo19bo5boo
17boo47b3o37bo19bo5boo17boo88bo18bo5boo17boo41b3o58b3o8bobo$356bo20boo
17b3o127bo14bo246bo12boo44b3o7bo$397bo144bo244bo13bo55bo$334boo13bobo
188b3o256bobo55bobbo$350boo25bobbo215boo132b3o66boo56b3o$350bo12b4o14b
o10b5o64b3o131bobo134bo$362bo3bo10bo3bo9bo4bo66bo133bo133bo116boo$336b
oo28bo11b4o14bo65bo316boo67boo$336boo16boo6bobbo25bo3bo382bobo$342boo
9bobo37bo155bo230bo$342b3o10bo31b3o157bobo$333boo9boobo11bo19bo14bo5b
3o145boo173boo$333bo5bo4bobbo10boo18bobo4bo5bobobo4bo42boo9boo112boo7b
oo9b3o120boo9bobo39bobo$338bo5boobo9boo4boobboo10bo5bo5bobbo6bo41bobo
7bobo112bo8bobbo9bo120b3o10bo38bobbo3boo$334bo3bo3b3o11b3o4boobboo16bo
5bo54bo8bo5bo72boo23boo5bobo12bo7bo5bo117boobo11bo33boo5b3oboobboo103b
oo$336bo5boo13boo4boo22b3o53bobbo13bobo72bo22bobo5boo13bo12b4o115bobbo
10boo31boo3bo3bo3bo3bobo76bobo24bo$358boo86bo13boobo71bobo6bo12b3o21bo
11boobobo114boobo9boo3boo29boo5bobo8bo78bo23bobo5boo23boo$359bo25b3o
48boo5bobo14booboo71boo6b4o8b3o11boo5bobbo11b3obobbo104boo5b3o11b3o28b
oo5bobbobboo6bobbo78bo24boo5boo23bo$383bo5bo18boo25bobo5boo15boobo81b
4o8b3o9bobo5boo14booboboo103bobo5boo13boo27bobo6bobo13bo75bobbo34boo
10bo7bobo$377bo5bo5bobbo15bobo24bo24bobo3boo77bobbo9bobo8bo24b4ob3o
101bo23boo5boo19bo21bobo6boo69b3o34b3o7bobo7boo$376bobo4bo5bobobo14bo
25boo25bo4bobo76b4o10boo7boo25bo4bobo99boo24bo5bobo17boo21boo7bobo105b
oo6boo$377bo14bo75bo75b4o54bo133bo51bo102boo9boo$385b3o80boo74bo57boo
132boo50boo101boo9boo$904bobo10bo$894bo11bo8b3o$883bobbo7bobo17bo$415b
3o449b4o11bo11boo18boo$415bo451bo3bo10bo3bo12bo$416bo450bo14b4o12boo$
868bobbo26bobo$$895bo$423bobbo8bo140bo318boo12boo3boo$423bo10bobo137b
3o317bobo12bo5bo$419bobbo3boo5bo3boo134bo$416b4o3boobobo4bo3boo134boo
331boobbo3bo$415b4o14bo3boo466boo4b3o$415bobbo8boo5bobo3boo437bo7bo19b
o$415b4o16bo4bobo434bobo5b4o$410boo4b4o22bo432boo8boobbobboo$409bobo7b
o22boo431boo11boobboo$409bo465boo7bo10boo$408boo161bo299boo4bobo4bo10b
3o$570b3o297bobo6bo4bo10boo13bo$569b5o296bo21boo7boo5booboo$568boo3boo
294boo21boo7bobo$903bo3bo5bo$903boo$572bo334booboboo$572bo$$568boo$
569bo$566b3o$566bo$907boo$908bo$905b3o$905bo!
