<?php

/**
 * BaseReport
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                                  $reportId                                                  Type: integer, primary key
 * @property string                                               $name                                                      Type: string(255)
 * @property int                                                  $reportGroupId                                             Type: integer
 * @property bool                                                 $useFilterField                                            Type: boolean
 * @property string                                               $type                                                      Type: string(255)
 * @property ReportGroup                                          $ReportGroup                                               
 * @property Doctrine_Collection|SelectedFilterField[]            $SelectedFilterField                                       
 * @property Doctrine_Collection|SelectedCompositeDisplayField[]  $SelectedCompositeDisplayField                             
 * @property Doctrine_Collection|SelectedDisplayField[]           $SelectedDisplayField                                      
 * @property Doctrine_Collection|SelectedGroupField[]             $SelectedGroupField                                        
 * @property Doctrine_Collection|SelectedDisplayFieldGroup[]      $SelectedDisplayFieldGroup                                 
 *  
 * @method int                                                    getReportid()                                              Type: integer, primary key
 * @method string                                                 getName()                                                  Type: string(255)
 * @method int                                                    getReportgroupid()                                         Type: integer
 * @method bool                                                   getUsefilterfield()                                        Type: boolean
 * @method string                                                 getType()                                                  Type: string(255)
 * @method ReportGroup                                            getReportGroup()                                           
 * @method Doctrine_Collection|SelectedFilterField[]              getSelectedFilterField()                                   
 * @method Doctrine_Collection|SelectedCompositeDisplayField[]    getSelectedCompositeDisplayField()                         
 * @method Doctrine_Collection|SelectedDisplayField[]             getSelectedDisplayField()                                  
 * @method Doctrine_Collection|SelectedGroupField[]               getSelectedGroupField()                                    
 * @method Doctrine_Collection|SelectedDisplayFieldGroup[]        getSelectedDisplayFieldGroup()                             
 *  
 * @method Report                                                 setReportid(int $val)                                      Type: integer, primary key
 * @method Report                                                 setName(string $val)                                       Type: string(255)
 * @method Report                                                 setReportgroupid(int $val)                                 Type: integer
 * @method Report                                                 setUsefilterfield(bool $val)                               Type: boolean
 * @method Report                                                 setType(string $val)                                       Type: string(255)
 * @method Report                                                 setReportGroup(ReportGroup $val)                           
 * @method Report                                                 setSelectedFilterField(Doctrine_Collection $val)           
 * @method Report                                                 setSelectedCompositeDisplayField(Doctrine_Collection $val) 
 * @method Report                                                 setSelectedDisplayField(Doctrine_Collection $val)          
 * @method Report                                                 setSelectedGroupField(Doctrine_Collection $val)            
 * @method Report                                                 setSelectedDisplayFieldGroup(Doctrine_Collection $val)     
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseReport extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_report');
        $this->hasColumn('report_id as reportId', 'integer', null, array(
             'autoincrement' => true,
             'type' => 'integer',
             'primary' => true,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'notnull' => true,
             'length' => 255,
             ));
        $this->hasColumn('report_group_id as reportGroupId', 'integer', null, array(
             'type' => 'integer',
             'notnull' => true,
             ));
        $this->hasColumn('use_filter_field as useFilterField', 'boolean', null, array(
             'type' => 'boolean',
             'notnull' => true,
             ));
        $this->hasColumn('type', 'string', 255, array(
             'type' => 'string',
             'notnull' => false,
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('ReportGroup', array(
             'local' => 'reportGroupId',
             'foreign' => 'reportGroupId',
             'onDelete' => 'cascade'));

        $this->hasMany('SelectedFilterField', array(
             'local' => 'reportId',
             'foreign' => 'report_id'));

        $this->hasMany('SelectedCompositeDisplayField', array(
             'local' => 'reportId',
             'foreign' => 'report_id'));

        $this->hasMany('SelectedDisplayField', array(
             'local' => 'reportId',
             'foreign' => 'report_id'));

        $this->hasMany('SelectedGroupField', array(
             'local' => 'reportId',
             'foreign' => 'report_id'));

        $this->hasMany('SelectedDisplayFieldGroup', array(
             'local' => 'reportId',
             'foreign' => 'report_id'));
    }
}