/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

class MetalUtils {
    static BufferedImage pattern2D;
    static Color lightColor;
    static Color darkColor;

    static void fillMetalPattern(Component c, Graphics g, int x, int y, int w, int h, Color light, Color dark) {
        if (g instanceof Graphics2D) {
            MetalUtils.fillMetalPattern2D((Graphics2D)g, x, y, w, h, light, dark);
        } else {
            int xOff = 0;
            int mY = y;
            while (mY < y + h) {
                if ((mY - y) % 2 == 0) {
                    g.setColor(light);
                } else {
                    g.setColor(dark);
                }
                int mX = x + xOff;
                while (mX < x + w) {
                    g.drawLine(mX, mY, mX, mY);
                    mX += 4;
                }
                if (++xOff > 3) {
                    xOff = 0;
                }
                ++mY;
            }
        }
    }

    static void fillMetalPattern2D(Graphics2D g2d, int x, int y, int w, int h, Color light, Color dark) {
        if (pattern2D == null || !darkColor.equals(dark) || !lightColor.equals(light)) {
            MetalUtils.initializePattern(light, dark);
        }
        TexturePaint texture = new TexturePaint(pattern2D, new Rectangle2D.Double(0.0, 0.0, 4, 2));
        g2d.setPaint(texture);
        g2d.fillRect(x, y, w, h);
    }

    static void initializePattern(Color light, Color dark) {
        pattern2D = new BufferedImage(4, 4, 1);
        lightColor = light;
        darkColor = dark;
        Graphics g = pattern2D.getGraphics();
        g.setColor(light);
        g.fillRect(0, 0, 1, 1);
        g.fillRect(2, 2, 1, 1);
        g.setColor(dark);
        g.fillRect(1, 1, 1, 1);
        g.fillRect(3, 3, 1, 1);
        g.dispose();
    }

    MetalUtils() {
    }
}

