<?php

declare(strict_types=1);

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

namespace TYPO3\CMS\Frontend\Typolink;

use TYPO3\CMS\Frontend\Exception;

/**
 * Exception which is thrown when a link could not be set
 */
class UnableToLinkException extends Exception
{
    public function __construct(string $message = '', int $code = 0, ?\Throwable $previous = null, protected string $linkText = '')
    {
        parent::__construct($message, $code, $previous);
    }

    /**
     * Returns the link text when the link could not been set
     */
    public function getLinkText(): string
    {
        return $this->linkText;
    }
}
