/*! @name videojs-playlist-ui @version 5.0.0 @license Apache-2.0 */
(function (QUnit, sinon, videojs) {
	'use strict';

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var QUnit__default = /*#__PURE__*/_interopDefaultLegacy(QUnit);
	var sinon__default = /*#__PURE__*/_interopDefaultLegacy(sinon);
	var videojs__default = /*#__PURE__*/_interopDefaultLegacy(videojs);

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getAugmentedNamespace(n) {
		if (n.__esModule) return n;
		var a = Object.defineProperty({}, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var _nodeResolve_empty = {};

	var _nodeResolve_empty$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		'default': _nodeResolve_empty
	});

	var require$$0 = /*@__PURE__*/getAugmentedNamespace(_nodeResolve_empty$1);

	var topLevel = typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : typeof window !== 'undefined' ? window : {};
	var minDoc = require$$0;
	var doccy;
	if (typeof document !== 'undefined') {
	  doccy = document;
	} else {
	  doccy = topLevel['__GLOBAL_DOCUMENT_CACHE@4'];
	  if (!doccy) {
	    doccy = topLevel['__GLOBAL_DOCUMENT_CACHE@4'] = minDoc;
	  }
	}
	var document_1 = doccy;

	var win;
	if (typeof window !== "undefined") {
	  win = window;
	} else if (typeof commonjsGlobal !== "undefined") {
	  win = commonjsGlobal;
	} else if (typeof self !== "undefined") {
	  win = self;
	} else {
	  win = {};
	}
	var window_1 = win;

	/*! @name videojs-playlist @version 5.1.0 @license Apache-2.0 */

	/**
	 * Validates a number of seconds to use as the auto-advance delay.
	 *
	 * @private
	 * @param   {number} s
	 *          The number to check
	 *
	 * @return  {boolean}
	 *          Whether this is a valid second or not
	 */
	const validSeconds = s => typeof s === 'number' && !isNaN(s) && s >= 0 && s < Infinity;
	/**
	 * Resets the auto-advance behavior of a player.
	 *
	 * @param {Player} player
	 *        The player to reset the behavior on
	 */

	let reset = player => {
	  const aa = player.playlist.autoadvance_;
	  if (aa.timeout) {
	    player.clearTimeout(aa.timeout);
	  }
	  if (aa.trigger) {
	    player.off('ended', aa.trigger);
	  }
	  aa.timeout = null;
	  aa.trigger = null;
	};
	/**
	 * Sets up auto-advance behavior on a player.
	 *
	 * @param  {Player} player
	 *         the current player
	 *
	 * @param  {number} delay
	 *         The number of seconds to wait before each auto-advance.
	 *
	 * @return {undefined}
	 *         Used to short circuit function logic
	 */

	const setup$1 = (player, delay) => {
	  reset(player); // Before queuing up new auto-advance behavior, check if `seconds` was
	  // called with a valid value.

	  if (!validSeconds(delay)) {
	    player.playlist.autoadvance_.delay = null;
	    return;
	  }
	  player.playlist.autoadvance_.delay = delay;
	  player.playlist.autoadvance_.trigger = function () {
	    // This calls setup again, which will reset the existing auto-advance and
	    // set up another auto-advance for the next "ended" event.
	    const cancelOnPlay = () => setup$1(player, delay); // If there is a "play" event while we're waiting for an auto-advance,
	    // we need to cancel the auto-advance. This could mean the user seeked
	    // back into the content or restarted the content. This is reproducible
	    // with an auto-advance > 0.

	    player.one('play', cancelOnPlay);
	    player.playlist.autoadvance_.timeout = player.setTimeout(() => {
	      reset(player);
	      player.off('play', cancelOnPlay);
	      player.playlist.next();
	    }, delay * 1000);
	  };
	  player.one('ended', player.playlist.autoadvance_.trigger);
	};

	/**
	 * Removes all remote text tracks from a player.
	 *
	 * @param  {Player} player
	 *         The player to clear tracks on
	 */

	const clearTracks = player => {
	  const tracks = player.remoteTextTracks();
	  let i = tracks && tracks.length || 0; // This uses a `while` loop rather than `forEach` because the
	  // `TextTrackList` object is a live DOM list (not an array).

	  while (i--) {
	    player.removeRemoteTextTrack(tracks[i]);
	  }
	};
	/**
	 * Plays an item on a player's playlist.
	 *
	 * @param  {Player} player
	 *         The player to play the item on
	 *
	 * @param  {Object} item
	 *         A source from the playlist.
	 *
	 * @return {Player}
	 *         The player that is now playing the item
	 */

	const playItem = (player, item) => {
	  const replay = !player.paused() || player.ended();
	  player.trigger('beforeplaylistitem', item.originalValue || item);
	  if (item.playlistItemId_) {
	    player.playlist.currentPlaylistItemId_ = item.playlistItemId_;
	  }
	  player.poster(item.poster || '');
	  player.src(item.sources);
	  clearTracks(player);
	  player.ready(() => {
	    (item.textTracks || []).forEach(player.addRemoteTextTrack.bind(player));
	    player.trigger('playlistitem', item.originalValue || item);
	    if (replay) {
	      const playPromise = player.play(); // silence error when a pause interrupts a play request
	      // on browsers which return a promise

	      if (typeof playPromise !== 'undefined' && typeof playPromise.then === 'function') {
	        playPromise.then(null, e => {});
	      }
	    }
	    setup$1(player, player.playlist.autoadvance_.delay);
	  });
	  return player;
	};
	let guid = 1;
	/**
	 * Transform any primitive playlist item value into an object.
	 *
	 * For non-object values, adds a property to the transformed item containing
	 * original value passed.
	 *
	 * For all items, add a unique ID to each playlist item object. This id is
	 * used to determine the index of an item in the playlist array in cases where
	 * there are multiple otherwise identical items.
	 *
	 * @param  {Object} newItem
	 *         An playlist item object, but accepts any value.
	 *
	 * @return {Object}
	 */

	const preparePlaylistItem = newItem => {
	  let item = newItem;
	  if (!newItem || typeof newItem !== 'object') {
	    // Casting to an Object in this way allows primitives to retain their
	    // primitiveness (i.e. they will be cast back to primitives as needed).
	    item = Object(newItem);
	    item.originalValue = newItem;
	  }
	  item.playlistItemId_ = guid++;
	  return item;
	};
	/**
	 * Look through an array of playlist items and passes them to
	 * preparePlaylistItem.
	 *
	 * @private
	 *
	 * @param  {Array} arr
	 *         An array of playlist items
	 *
	 * @return {Array}
	 *         A new array with transformed items
	 */

	const preparePlaylistItems = arr => arr.map(preparePlaylistItem);
	/**
	 * Look through an array of playlist items for a specific playlist item id.
	 *
	 * @private
	 * @param   {Array} list
	 *          An array of playlist items to look through
	 *
	 * @param   {number} currentItemId
	 *          The current item ID.
	 *
	 * @return  {number}
	 *          The index of the playlist item or -1 if not found
	 */

	const indexInPlaylistItemIds = (list, currentItemId) => {
	  for (let i = 0; i < list.length; i++) {
	    if (list[i].playlistItemId_ === currentItemId) {
	      return i;
	    }
	  }
	  return -1;
	};
	/**
	 * Given two sources, check to see whether the two sources are equal.
	 * If both source urls have a protocol, the protocols must match, otherwise, protocols
	 * are ignored.
	 *
	 * @private
	 * @param {string|Object} source1
	 *        The first source
	 *
	 * @param {string|Object} source2
	 *        The second source
	 *
	 * @return {boolean}
	 *         The result
	 */

	const sourceEquals = (source1, source2) => {
	  let src1 = source1;
	  let src2 = source2;
	  if (typeof source1 === 'object') {
	    src1 = source1.src;
	  }
	  if (typeof source2 === 'object') {
	    src2 = source2.src;
	  }
	  if (/^\/\//.test(src1)) {
	    src2 = src2.slice(src2.indexOf('//'));
	  }
	  if (/^\/\//.test(src2)) {
	    src1 = src1.slice(src1.indexOf('//'));
	  }
	  return src1 === src2;
	};
	/**
	 * Look through an array of playlist items for a specific `source`;
	 * checking both the value of elements and the value of their `src`
	 * property.
	 *
	 * @private
	 * @param   {Array} arr
	 *          An array of playlist items to look through
	 *
	 * @param   {string} src
	 *          The source to look for
	 *
	 * @return  {number}
	 *          The index of that source or -1
	 */

	const indexInSources = (arr, src) => {
	  for (let i = 0; i < arr.length; i++) {
	    const sources = arr[i].sources;
	    if (Array.isArray(sources)) {
	      for (let j = 0; j < sources.length; j++) {
	        const source = sources[j];
	        if (source && sourceEquals(source, src)) {
	          return i;
	        }
	      }
	    }
	  }
	  return -1;
	};
	/**
	 * Randomize the contents of an array.
	 *
	 * @private
	 * @param  {Array} arr
	 *         An array.
	 *
	 * @return {Array}
	 *         The same array that was passed in.
	 */

	const randomize = arr => {
	  let index = -1;
	  const lastIndex = arr.length - 1;
	  while (++index < arr.length) {
	    const rand = index + Math.floor(Math.random() * (lastIndex - index + 1));
	    const value = arr[rand];
	    arr[rand] = arr[index];
	    arr[index] = value;
	  }
	  return arr;
	};
	/**
	 * Factory function for creating new playlist implementation on the given player.
	 *
	 * API summary:
	 *
	 * playlist(['a', 'b', 'c']) // setter
	 * playlist() // getter
	 * playlist.currentItem() // getter, 0
	 * playlist.currentItem(1) // setter, 1
	 * playlist.next() // 'c'
	 * playlist.previous() // 'b'
	 * playlist.first() // 'a'
	 * playlist.last() // 'c'
	 * playlist.autoadvance(5) // 5 second delay
	 * playlist.autoadvance() // cancel autoadvance
	 *
	 * @param  {Player} player
	 *         The current player
	 *
	 * @param  {Array=} initialList
	 *         If given, an initial list of sources with which to populate
	 *         the playlist.
	 *
	 * @param  {number=}  initialIndex
	 *         If given, the index of the item in the list that should
	 *         be loaded first. If -1, no video is loaded. If omitted, The
	 *         the first video is loaded.
	 *
	 * @return {Function}
	 *         Returns the playlist function specific to the given player.
	 */

	function factory(player, initialList, initialIndex = 0) {
	  let list = null;
	  let changing = false;
	  /**
	   * Get/set the playlist for a player.
	   *
	   * This function is added as an own property of the player and has its
	   * own methods which can be called to manipulate the internal state.
	   *
	   * @param  {Array} [newList]
	   *         If given, a new list of sources with which to populate the
	   *         playlist. Without this, the function acts as a getter.
	   *
	   * @param  {number}  [newIndex]
	   *         If given, the index of the item in the list that should
	   *         be loaded first. If -1, no video is loaded. If omitted, The
	   *         the first video is loaded.
	   *
	   * @return {Array}
	   *         The playlist
	   */

	  const playlist = player.playlist = (nextPlaylist, newIndex = 0) => {
	    if (changing) {
	      throw new Error('do not call playlist() during a playlist change');
	    }
	    if (Array.isArray(nextPlaylist)) {
	      // @todo - Simplify this to `list.slice()` for v5.
	      const previousPlaylist = Array.isArray(list) ? list.slice() : null;
	      list = preparePlaylistItems(nextPlaylist); // Mark the playlist as changing during the duringplaylistchange lifecycle.

	      changing = true;
	      player.trigger({
	        type: 'duringplaylistchange',
	        nextIndex: newIndex,
	        nextPlaylist,
	        previousIndex: playlist.currentIndex_,
	        // @todo - Simplify this to simply pass along `previousPlaylist` for v5.
	        previousPlaylist: previousPlaylist || []
	      });
	      changing = false;
	      if (newIndex !== -1) {
	        playlist.currentItem(newIndex);
	      } // The only time the previous playlist is null is the first call to this
	      // function. This allows us to fire the `duringplaylistchange` event
	      // every time the playlist is populated and to maintain backward
	      // compatibility by not firing the `playlistchange` event on the initial
	      // population of the list.
	      //
	      // @todo - Remove this condition in preparation for v5.

	      if (previousPlaylist) {
	        player.setTimeout(() => {
	          player.trigger({
	            type: 'playlistchange',
	            action: 'change'
	          });
	        }, 0);
	      }
	    } // Always return a shallow clone of the playlist list.
	    // We also want to return originalValue if any item in the list has it.

	    return list.map(item => item.originalValue || item);
	  }; // On a new source, if there is no current item, disable auto-advance.

	  player.on('loadstart', () => {
	    if (playlist.currentItem() === -1) {
	      reset(player);
	    }
	  });
	  playlist.currentIndex_ = -1;
	  playlist.player_ = player;
	  playlist.autoadvance_ = {};
	  playlist.repeat_ = false;
	  playlist.currentPlaylistItemId_ = null;
	  /**
	   * Get or set the current item in the playlist.
	   *
	   * During the duringplaylistchange event, acts only as a getter.
	   *
	   * @param  {number} [index]
	   *         If given as a valid value, plays the playlist item at that index.
	   *
	   * @return {number}
	   *         The current item index.
	   */

	  playlist.currentItem = index => {
	    // If the playlist is changing, only act as a getter.
	    if (changing) {
	      return playlist.currentIndex_;
	    } // Act as a setter when the index is given and is a valid number.

	    if (typeof index === 'number' && playlist.currentIndex_ !== index && index >= 0 && index < list.length) {
	      playlist.currentIndex_ = index;
	      playItem(playlist.player_, list[playlist.currentIndex_]); // When playing multiple videos in a playlist the videojs PosterImage
	      // will be hidden using CSS. However, in some browsers the native poster
	      // attribute will briefly appear while the new source loads. Prevent
	      // this by hiding every poster after the first play list item. This
	      // doesn't cover every use case for showing/hiding the poster, but
	      // it will significantly improve the user experience.

	      if (index > 0) {
	        player.poster('');
	      }
	      return playlist.currentIndex_;
	    }
	    const src = playlist.player_.currentSrc() || ''; // If there is a currentPlaylistItemId_, validate that it matches the
	    // current source URL returned by the player. This is sufficient evidence
	    // to suggest that the source was set by the playlist plugin. This code
	    // exists primarily to deal with playlists where multiple items have the
	    // same source.

	    if (playlist.currentPlaylistItemId_) {
	      const indexInItemIds = indexInPlaylistItemIds(list, playlist.currentPlaylistItemId_);
	      const item = list[indexInItemIds]; // Found a match, this is our current index!

	      if (item && Array.isArray(item.sources) && indexInSources([item], src) > -1) {
	        playlist.currentIndex_ = indexInItemIds;
	        return playlist.currentIndex_;
	      } // If this does not match the current source, null it out so subsequent
	      // calls can skip this step.

	      playlist.currentPlaylistItemId_ = null;
	    } // Finally, if we don't have a valid, current playlist item ID, we can
	    // auto-detect it based on the player's current source URL.

	    playlist.currentIndex_ = playlist.indexOf(src);
	    return playlist.currentIndex_;
	  };
	  /**
	   * A custom DOM event that is fired when new item(s) are added to the current
	   * playlist (rather than replacing the entire playlist).
	   *
	   * Unlike playlistchange, this is fired synchronously as it does not
	   * affect playback.
	   *
	   * @typedef  {Object} PlaylistAddEvent
	   * @see      [CustomEvent Properties]{@link https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent}
	   * @property {string} type
	   *           Always "playlistadd"
	   *
	   * @property {number} count
	   *           The number of items that were added.
	   *
	   * @property {number} index
	   *           The starting index where item(s) were added.
	   */

	  /**
	   * A custom DOM event that is fired when new item(s) are removed from the
	   * current playlist (rather than replacing the entire playlist).
	   *
	   * This is fired synchronously as it does not affect playback.
	   *
	   * @typedef  {Object} PlaylistRemoveEvent
	   * @see      [CustomEvent Properties]{@link https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent}
	   * @property {string} type
	   *           Always "playlistremove"
	   *
	   * @property {number} count
	   *           The number of items that were removed.
	   *
	   * @property {number} index
	   *           The starting index where item(s) were removed.
	   */

	  /**
	   * Add one or more items to the playlist.
	   *
	   * @fires  {PlaylistAddEvent}
	   * @throws {Error}
	   *         If called during the duringplaylistchange event, throws an error.
	   *
	   * @param  {string|Object|Array}  item
	   *         An item - or array of items - to be added to the playlist.
	   *
	   * @param  {number} [index]
	   *         If given as a valid value, injects the new playlist item(s)
	   *         starting from that index. Otherwise, the item(s) are appended.
	   */

	  playlist.add = (items, index) => {
	    if (changing) {
	      throw new Error('cannot modify a playlist that is currently changing');
	    }
	    if (typeof index !== 'number' || index < 0 || index > list.length) {
	      index = list.length;
	    }
	    if (!Array.isArray(items)) {
	      items = [items];
	    }
	    list.splice(index, 0, ...preparePlaylistItems(items)); // playlistchange is triggered synchronously in this case because it does
	    // not change the current media source

	    player.trigger({
	      type: 'playlistchange',
	      action: 'add'
	    });
	    player.trigger({
	      type: 'playlistadd',
	      count: items.length,
	      index
	    });
	  };
	  /**
	   * Remove one or more items from the playlist.
	   *
	   * @fires  {PlaylistRemoveEvent}
	   * @throws {Error}
	   *         If called during the duringplaylistchange event, throws an error.
	   *
	   * @param  {number} index
	   *         If a valid index in the current playlist, removes the item at that
	   *         index from the playlist.
	   *
	   *         If no valid index is given, nothing is removed from the playlist.
	   *
	   * @param  {number} [count=1]
	   *         The number of items to remove from the playlist.
	   */

	  playlist.remove = (index, count = 1) => {
	    if (changing) {
	      throw new Error('cannot modify a playlist that is currently changing');
	    }
	    if (typeof index !== 'number' || index < 0 || index > list.length) {
	      return;
	    }
	    list.splice(index, count); // playlistchange is triggered synchronously in this case because it does
	    // not change the current media source

	    player.trigger({
	      type: 'playlistchange',
	      action: 'remove'
	    });
	    player.trigger({
	      type: 'playlistremove',
	      count,
	      index
	    });
	  };
	  /**
	   * Checks if the playlist contains a value.
	   *
	   * @param  {string|Object|Array} value
	   *         The value to check
	   *
	   * @return {boolean}
	   *         The result
	   */

	  playlist.contains = value => {
	    return playlist.indexOf(value) !== -1;
	  };
	  /**
	   * Gets the index of a value in the playlist or -1 if not found.
	   *
	   * @param  {string|Object|Array} value
	   *         The value to find the index of
	   *
	   * @return {number}
	   *         The index or -1
	   */

	  playlist.indexOf = value => {
	    if (typeof value === 'string') {
	      return indexInSources(list, value);
	    }
	    const sources = Array.isArray(value) ? value : value.sources;
	    for (let i = 0; i < sources.length; i++) {
	      const source = sources[i];
	      if (typeof source === 'string') {
	        return indexInSources(list, source);
	      } else if (source.src) {
	        return indexInSources(list, source.src);
	      }
	    }
	    return -1;
	  };
	  /**
	   * Get the index of the current item in the playlist. This is identical to
	   * calling `currentItem()` with no arguments.
	   *
	   * @return {number}
	   *         The current item index.
	   */

	  playlist.currentIndex = () => playlist.currentItem();
	  /**
	   * Get the index of the last item in the playlist.
	   *
	   * @return {number}
	   *         The index of the last item in the playlist or -1 if there are no
	   *         items.
	   */

	  playlist.lastIndex = () => list.length - 1;
	  /**
	   * Get the index of the next item in the playlist.
	   *
	   * @return {number}
	   *         The index of the next item in the playlist or -1 if there is no
	   *         current item.
	   */

	  playlist.nextIndex = () => {
	    const current = playlist.currentItem();
	    if (current === -1) {
	      return -1;
	    }
	    const lastIndex = playlist.lastIndex(); // When repeating, loop back to the beginning on the last item.

	    if (playlist.repeat_ && current === lastIndex) {
	      return 0;
	    } // Don't go past the end of the playlist.

	    return Math.min(current + 1, lastIndex);
	  };
	  /**
	   * Get the index of the previous item in the playlist.
	   *
	   * @return {number}
	   *         The index of the previous item in the playlist or -1 if there is
	   *         no current item.
	   */

	  playlist.previousIndex = () => {
	    const current = playlist.currentItem();
	    if (current === -1) {
	      return -1;
	    } // When repeating, loop back to the end of the playlist.

	    if (playlist.repeat_ && current === 0) {
	      return playlist.lastIndex();
	    } // Don't go past the beginning of the playlist.

	    return Math.max(current - 1, 0);
	  };
	  /**
	   * Plays the first item in the playlist.
	   *
	   * @return {Object|undefined}
	   *         Returns undefined and has no side effects if the list is empty.
	   */

	  playlist.first = () => {
	    if (changing) {
	      return;
	    }
	    const newItem = playlist.currentItem(0);
	    if (list.length) {
	      return list[newItem].originalValue || list[newItem];
	    }
	    playlist.currentIndex_ = -1;
	  };
	  /**
	   * Plays the last item in the playlist.
	   *
	   * @return {Object|undefined}
	   *         Returns undefined and has no side effects if the list is empty.
	   */

	  playlist.last = () => {
	    if (changing) {
	      return;
	    }
	    const newItem = playlist.currentItem(playlist.lastIndex());
	    if (list.length) {
	      return list[newItem].originalValue || list[newItem];
	    }
	    playlist.currentIndex_ = -1;
	  };
	  /**
	   * Plays the next item in the playlist.
	   *
	   * @return {Object|undefined}
	   *         Returns undefined and has no side effects if on last item.
	   */

	  playlist.next = () => {
	    if (changing) {
	      return;
	    }
	    const index = playlist.nextIndex();
	    if (index !== playlist.currentIndex_) {
	      const newItem = playlist.currentItem(index);
	      return list[newItem].originalValue || list[newItem];
	    }
	  };
	  /**
	   * Plays the previous item in the playlist.
	   *
	   * @return {Object|undefined}
	   *         Returns undefined and has no side effects if on first item.
	   */

	  playlist.previous = () => {
	    if (changing) {
	      return;
	    }
	    const index = playlist.previousIndex();
	    if (index !== playlist.currentIndex_) {
	      const newItem = playlist.currentItem(index);
	      return list[newItem].originalValue || list[newItem];
	    }
	  };
	  /**
	   * Set up auto-advance on the playlist.
	   *
	   * @param  {number} [delay]
	   *         The number of seconds to wait before each auto-advance.
	   */

	  playlist.autoadvance = delay => {
	    setup$1(playlist.player_, delay);
	  };
	  /**
	   * Sets `repeat` option, which makes the "next" video of the last video in
	   * the playlist be the first video in the playlist.
	   *
	   * @param  {boolean} [val]
	   *         The value to set repeat to
	   *
	   * @return {boolean}
	   *         The current value of repeat
	   */

	  playlist.repeat = val => {
	    if (val === undefined) {
	      return playlist.repeat_;
	    }
	    if (typeof val !== 'boolean') {
	      videojs__default["default"].log.error('videojs-playlist: Invalid value for repeat', val);
	      return;
	    }
	    playlist.repeat_ = !!val;
	    return playlist.repeat_;
	  };
	  /**
	   * Sorts the playlist array.
	   *
	   * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/sort}
	   * @fires playlistsorted
	   *
	   * @param {Function} compare
	   *        A comparator function as per the native Array method.
	   */

	  playlist.sort = compare => {
	    // Bail if the array is empty.
	    if (!list.length) {
	      return;
	    }
	    list.sort(compare); // If the playlist is changing, don't trigger events.

	    if (changing) {
	      return;
	    }
	    /**
	     * Triggered after the playlist is sorted internally.
	     *
	     * @event playlistsorted
	     * @type {Object}
	     */

	    player.trigger('playlistsorted');
	  };
	  /**
	   * Reverses the playlist array.
	   *
	   * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reverse}
	   * @fires playlistsorted
	   */

	  playlist.reverse = () => {
	    // Bail if the array is empty.
	    if (!list.length) {
	      return;
	    }
	    list.reverse(); // If the playlist is changing, don't trigger events.

	    if (changing) {
	      return;
	    }
	    /**
	     * Triggered after the playlist is sorted internally.
	     *
	     * @event playlistsorted
	     * @type {Object}
	     */

	    player.trigger('playlistsorted');
	  };
	  /**
	   * Shuffle the contents of the list randomly.
	   *
	   * @see   {@link https://github.com/lodash/lodash/blob/40e096b6d5291a025e365a0f4c010d9a0efb9a69/shuffle.js}
	   * @fires playlistsorted
	   * @todo  Make the `rest` option default to `true` in v5.0.0.
	   * @param {Object} [options]
	   *        An object containing shuffle options.
	   *
	   * @param {boolean} [options.rest = false]
	   *        By default, the entire playlist is randomized. However, this may
	   *        not be desirable in all cases, such as when a user is already
	   *        watching a video.
	   *
	   *        When `true` is passed for this option, it will only shuffle
	   *        playlist items after the current item. For example, when on the
	   *        first item, will shuffle the second item and beyond.
	   */

	  playlist.shuffle = ({
	    rest
	  } = {}) => {
	    let index = 0;
	    let arr = list; // When options.rest is true, start randomization at the item after the
	    // current item.

	    if (rest) {
	      index = playlist.currentIndex_ + 1;
	      arr = list.slice(index);
	    } // Bail if the array is empty or too short to shuffle.

	    if (arr.length <= 1) {
	      return;
	    }
	    randomize(arr); // When options.rest is true, splice the randomized sub-array back into
	    // the original array.

	    if (rest) {
	      list.splice(...[index, arr.length].concat(arr));
	    } // If the playlist is changing, don't trigger events.

	    if (changing) {
	      return;
	    }
	    /**
	     * Triggered after the playlist is sorted internally.
	     *
	     * @event playlistsorted
	     * @type {Object}
	     */

	    player.trigger('playlistsorted');
	  }; // If an initial list was given, populate the playlist with it.

	  if (Array.isArray(initialList)) {
	    playlist(initialList, initialIndex); // If there is no initial list given, silently set an empty array.
	  } else {
	    list = [];
	  }
	  return playlist;
	}
	var version$1 = "5.1.0";
	const registerPlugin = videojs__default["default"].registerPlugin || videojs__default["default"].plugin;
	/**
	 * The video.js playlist plugin. Invokes the playlist-maker to create a
	 * playlist function on the specific player.
	 *
	 * @param {Array} list
	 *        a list of sources
	 *
	 * @param {number} item
	 *        The index to start at
	 */

	const plugin = function (list, item) {
	  factory(this, list, item);
	};
	registerPlugin('playlist', plugin);
	plugin.VERSION = version$1;

	var version = "5.0.0";

	function cov_1mxbo1hw9z() {
	  var path = "/Users/poneill/dev/videojs-playlist-ui/src/playlist-menu-item.js";
	  var hash = "5dc6058daf6156feb0b6ade2a9ee32d9474598a1";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/poneill/dev/videojs-playlist-ui/src/playlist-menu-item.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 4,
	          column: 18
	        },
	        end: {
	          line: 4,
	          column: 51
	        }
	      },
	      "1": {
	        start: {
	          line: 6,
	          column: 24
	        },
	        end: {
	          line: 54,
	          column: 1
	        }
	      },
	      "2": {
	        start: {
	          line: 7,
	          column: 2
	        },
	        end: {
	          line: 12,
	          column: 3
	        }
	      },
	      "3": {
	        start: {
	          line: 8,
	          column: 24
	        },
	        end: {
	          line: 8,
	          column: 53
	        }
	      },
	      "4": {
	        start: {
	          line: 10,
	          column: 4
	        },
	        end: {
	          line: 10,
	          column: 88
	        }
	      },
	      "5": {
	        start: {
	          line: 11,
	          column: 4
	        },
	        end: {
	          line: 11,
	          column: 23
	        }
	      },
	      "6": {
	        start: {
	          line: 14,
	          column: 18
	        },
	        end: {
	          line: 14,
	          column: 51
	        }
	      },
	      "7": {
	        start: {
	          line: 16,
	          column: 2
	        },
	        end: {
	          line: 16,
	          column: 47
	        }
	      },
	      "8": {
	        start: {
	          line: 18,
	          column: 2
	        },
	        end: {
	          line: 52,
	          column: 3
	        }
	      },
	      "9": {
	        start: {
	          line: 20,
	          column: 16
	        },
	        end: {
	          line: 20,
	          column: 45
	        }
	      },
	      "10": {
	        start: {
	          line: 22,
	          column: 4
	        },
	        end: {
	          line: 22,
	          column: 25
	        }
	      },
	      "11": {
	        start: {
	          line: 23,
	          column: 4
	        },
	        end: {
	          line: 23,
	          column: 24
	        }
	      },
	      "12": {
	        start: {
	          line: 24,
	          column: 4
	        },
	        end: {
	          line: 24,
	          column: 17
	        }
	      },
	      "13": {
	        start: {
	          line: 25,
	          column: 4
	        },
	        end: {
	          line: 25,
	          column: 29
	        }
	      },
	      "14": {
	        start: {
	          line: 31,
	          column: 4
	        },
	        end: {
	          line: 40,
	          column: 5
	        }
	      },
	      "15": {
	        start: {
	          line: 31,
	          column: 17
	        },
	        end: {
	          line: 31,
	          column: 18
	        }
	      },
	      "16": {
	        start: {
	          line: 32,
	          column: 22
	        },
	        end: {
	          line: 32,
	          column: 34
	        }
	      },
	      "17": {
	        start: {
	          line: 33,
	          column: 21
	        },
	        end: {
	          line: 33,
	          column: 53
	        }
	      },
	      "18": {
	        start: {
	          line: 36,
	          column: 6
	        },
	        end: {
	          line: 38,
	          column: 7
	        }
	      },
	      "19": {
	        start: {
	          line: 37,
	          column: 8
	        },
	        end: {
	          line: 37,
	          column: 37
	        }
	      },
	      "20": {
	        start: {
	          line: 39,
	          column: 6
	        },
	        end: {
	          line: 39,
	          column: 34
	        }
	      },
	      "21": {
	        start: {
	          line: 43,
	          column: 20
	        },
	        end: {
	          line: 43,
	          column: 51
	        }
	      },
	      "22": {
	        start: {
	          line: 44,
	          column: 16
	        },
	        end: {
	          line: 44,
	          column: 45
	        }
	      },
	      "23": {
	        start: {
	          line: 46,
	          column: 4
	        },
	        end: {
	          line: 46,
	          column: 25
	        }
	      },
	      "24": {
	        start: {
	          line: 47,
	          column: 4
	        },
	        end: {
	          line: 47,
	          column: 17
	        }
	      },
	      "25": {
	        start: {
	          line: 48,
	          column: 4
	        },
	        end: {
	          line: 50,
	          column: 5
	        }
	      },
	      "26": {
	        start: {
	          line: 49,
	          column: 6
	        },
	        end: {
	          line: 49,
	          column: 32
	        }
	      },
	      "27": {
	        start: {
	          line: 51,
	          column: 4
	        },
	        end: {
	          line: 51,
	          column: 29
	        }
	      },
	      "28": {
	        start: {
	          line: 53,
	          column: 2
	        },
	        end: {
	          line: 53,
	          column: 17
	        }
	      },
	      "29": {
	        start: {
	          line: 59,
	          column: 4
	        },
	        end: {
	          line: 61,
	          column: 5
	        }
	      },
	      "30": {
	        start: {
	          line: 60,
	          column: 6
	        },
	        end: {
	          line: 60,
	          column: 84
	        }
	      },
	      "31": {
	        start: {
	          line: 63,
	          column: 4
	        },
	        end: {
	          line: 63,
	          column: 60
	        }
	      },
	      "32": {
	        start: {
	          line: 64,
	          column: 4
	        },
	        end: {
	          line: 64,
	          column: 32
	        }
	      },
	      "33": {
	        start: {
	          line: 65,
	          column: 4
	        },
	        end: {
	          line: 65,
	          column: 34
	        }
	      },
	      "34": {
	        start: {
	          line: 67,
	          column: 4
	        },
	        end: {
	          line: 67,
	          column: 46
	        }
	      },
	      "35": {
	        start: {
	          line: 69,
	          column: 4
	        },
	        end: {
	          line: 69,
	          column: 25
	        }
	      },
	      "36": {
	        start: {
	          line: 71,
	          column: 4
	        },
	        end: {
	          line: 71,
	          column: 56
	        }
	      },
	      "37": {
	        start: {
	          line: 72,
	          column: 4
	        },
	        end: {
	          line: 72,
	          column: 44
	        }
	      },
	      "38": {
	        start: {
	          line: 79,
	          column: 4
	        },
	        end: {
	          line: 81,
	          column: 5
	        }
	      },
	      "39": {
	        start: {
	          line: 80,
	          column: 6
	        },
	        end: {
	          line: 80,
	          column: 33
	        }
	      },
	      "40": {
	        start: {
	          line: 85,
	          column: 4
	        },
	        end: {
	          line: 85,
	          column: 82
	        }
	      },
	      "41": {
	        start: {
	          line: 86,
	          column: 4
	        },
	        end: {
	          line: 88,
	          column: 5
	        }
	      },
	      "42": {
	        start: {
	          line: 87,
	          column: 6
	        },
	        end: {
	          line: 87,
	          column: 26
	        }
	      },
	      "43": {
	        start: {
	          line: 92,
	          column: 15
	        },
	        end: {
	          line: 92,
	          column: 43
	        }
	      },
	      "44": {
	        start: {
	          line: 93,
	          column: 17
	        },
	        end: {
	          line: 93,
	          column: 35
	        }
	      },
	      "45": {
	        start: {
	          line: 94,
	          column: 28
	        },
	        end: {
	          line: 94,
	          column: 57
	        }
	      },
	      "46": {
	        start: {
	          line: 96,
	          column: 4
	        },
	        end: {
	          line: 104,
	          column: 5
	        }
	      },
	      "47": {
	        start: {
	          line: 97,
	          column: 23
	        },
	        end: {
	          line: 97,
	          column: 45
	        }
	      },
	      "48": {
	        start: {
	          line: 99,
	          column: 6
	        },
	        end: {
	          line: 103,
	          column: 9
	        }
	      },
	      "49": {
	        start: {
	          line: 100,
	          column: 22
	        },
	        end: {
	          line: 100,
	          column: 36
	        }
	      },
	      "50": {
	        start: {
	          line: 102,
	          column: 8
	        },
	        end: {
	          line: 102,
	          column: 32
	        }
	      },
	      "51": {
	        start: {
	          line: 106,
	          column: 4
	        },
	        end: {
	          line: 106,
	          column: 39
	        }
	      },
	      "52": {
	        start: {
	          line: 107,
	          column: 4
	        },
	        end: {
	          line: 107,
	          column: 35
	        }
	      },
	      "53": {
	        start: {
	          line: 110,
	          column: 4
	        },
	        end: {
	          line: 110,
	          column: 53
	        }
	      },
	      "54": {
	        start: {
	          line: 111,
	          column: 4
	        },
	        end: {
	          line: 111,
	          column: 35
	        }
	      },
	      "55": {
	        start: {
	          line: 114,
	          column: 4
	        },
	        end: {
	          line: 122,
	          column: 5
	        }
	      },
	      "56": {
	        start: {
	          line: 115,
	          column: 23
	        },
	        end: {
	          line: 115,
	          column: 53
	        }
	      },
	      "57": {
	        start: {
	          line: 116,
	          column: 19
	        },
	        end: {
	          line: 116,
	          column: 57
	        }
	      },
	      "58": {
	        start: {
	          line: 118,
	          column: 6
	        },
	        end: {
	          line: 118,
	          column: 51
	        }
	      },
	      "59": {
	        start: {
	          line: 119,
	          column: 6
	        },
	        end: {
	          line: 119,
	          column: 72
	        }
	      },
	      "60": {
	        start: {
	          line: 120,
	          column: 6
	        },
	        end: {
	          line: 120,
	          column: 58
	        }
	      },
	      "61": {
	        start: {
	          line: 121,
	          column: 6
	        },
	        end: {
	          line: 121,
	          column: 31
	        }
	      },
	      "62": {
	        start: {
	          line: 125,
	          column: 25
	        },
	        end: {
	          line: 125,
	          column: 55
	        }
	      },
	      "63": {
	        start: {
	          line: 126,
	          column: 27
	        },
	        end: {
	          line: 126,
	          column: 55
	        }
	      },
	      "64": {
	        start: {
	          line: 128,
	          column: 4
	        },
	        end: {
	          line: 128,
	          column: 61
	        }
	      },
	      "65": {
	        start: {
	          line: 129,
	          column: 4
	        },
	        end: {
	          line: 129,
	          column: 70
	        }
	      },
	      "66": {
	        start: {
	          line: 130,
	          column: 4
	        },
	        end: {
	          line: 130,
	          column: 55
	        }
	      },
	      "67": {
	        start: {
	          line: 131,
	          column: 4
	        },
	        end: {
	          line: 131,
	          column: 45
	        }
	      },
	      "68": {
	        start: {
	          line: 134,
	          column: 29
	        },
	        end: {
	          line: 134,
	          column: 58
	        }
	      },
	      "69": {
	        start: {
	          line: 136,
	          column: 4
	        },
	        end: {
	          line: 136,
	          column: 64
	        }
	      },
	      "70": {
	        start: {
	          line: 137,
	          column: 4
	        },
	        end: {
	          line: 137,
	          column: 49
	        }
	      },
	      "71": {
	        start: {
	          line: 140,
	          column: 21
	        },
	        end: {
	          line: 140,
	          column: 51
	        }
	      },
	      "72": {
	        start: {
	          line: 141,
	          column: 23
	        },
	        end: {
	          line: 141,
	          column: 47
	        }
	      },
	      "73": {
	        start: {
	          line: 143,
	          column: 4
	        },
	        end: {
	          line: 143,
	          column: 44
	        }
	      },
	      "74": {
	        start: {
	          line: 144,
	          column: 4
	        },
	        end: {
	          line: 144,
	          column: 62
	        }
	      },
	      "75": {
	        start: {
	          line: 145,
	          column: 4
	        },
	        end: {
	          line: 145,
	          column: 47
	        }
	      },
	      "76": {
	        start: {
	          line: 146,
	          column: 4
	        },
	        end: {
	          line: 146,
	          column: 43
	        }
	      },
	      "77": {
	        start: {
	          line: 149,
	          column: 20
	        },
	        end: {
	          line: 149,
	          column: 50
	        }
	      },
	      "78": {
	        start: {
	          line: 150,
	          column: 22
	        },
	        end: {
	          line: 150,
	          column: 66
	        }
	      },
	      "79": {
	        start: {
	          line: 152,
	          column: 4
	        },
	        end: {
	          line: 152,
	          column: 44
	        }
	      },
	      "80": {
	        start: {
	          line: 153,
	          column: 4
	        },
	        end: {
	          line: 153,
	          column: 60
	        }
	      },
	      "81": {
	        start: {
	          line: 154,
	          column: 4
	        },
	        end: {
	          line: 154,
	          column: 45
	        }
	      },
	      "82": {
	        start: {
	          line: 155,
	          column: 4
	        },
	        end: {
	          line: 155,
	          column: 42
	        }
	      },
	      "83": {
	        start: {
	          line: 158,
	          column: 4
	        },
	        end: {
	          line: 158,
	          column: 63
	        }
	      },
	      "84": {
	        start: {
	          line: 161,
	          column: 4
	        },
	        end: {
	          line: 169,
	          column: 5
	        }
	      },
	      "85": {
	        start: {
	          line: 162,
	          column: 28
	        },
	        end: {
	          line: 162,
	          column: 57
	        }
	      },
	      "86": {
	        start: {
	          line: 163,
	          column: 30
	        },
	        end: {
	          line: 163,
	          column: 52
	        }
	      },
	      "87": {
	        start: {
	          line: 165,
	          column: 6
	        },
	        end: {
	          line: 165,
	          column: 59
	        }
	      },
	      "88": {
	        start: {
	          line: 166,
	          column: 6
	        },
	        end: {
	          line: 166,
	          column: 74
	        }
	      },
	      "89": {
	        start: {
	          line: 167,
	          column: 6
	        },
	        end: {
	          line: 167,
	          column: 59
	        }
	      },
	      "90": {
	        start: {
	          line: 168,
	          column: 6
	        },
	        end: {
	          line: 168,
	          column: 50
	        }
	      },
	      "91": {
	        start: {
	          line: 171,
	          column: 4
	        },
	        end: {
	          line: 171,
	          column: 14
	        }
	      },
	      "92": {
	        start: {
	          line: 175,
	          column: 0
	        },
	        end: {
	          line: 175,
	          column: 64
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 6,
	            column: 24
	          },
	          end: {
	            line: 6,
	            column: 25
	          }
	        },
	        loc: {
	          start: {
	            line: 6,
	            column: 44
	          },
	          end: {
	            line: 54,
	            column: 1
	          }
	        },
	        line: 6
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 58,
	            column: 2
	          },
	          end: {
	            line: 58,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 58,
	            column: 46
	          },
	          end: {
	            line: 74,
	            column: 3
	          }
	        },
	        line: 58
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 76,
	            column: 2
	          },
	          end: {
	            line: 76,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 76,
	            column: 24
	          },
	          end: {
	            line: 82,
	            column: 3
	          }
	        },
	        line: 76
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 84,
	            column: 2
	          },
	          end: {
	            line: 84,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 84,
	            column: 29
	          },
	          end: {
	            line: 89,
	            column: 3
	          }
	        },
	        line: 84
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 91,
	            column: 2
	          },
	          end: {
	            line: 91,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 91,
	            column: 13
	          },
	          end: {
	            line: 172,
	            column: 3
	          }
	        },
	        line: 91
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 99,
	            column: 23
	          },
	          end: {
	            line: 99,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 99,
	            column: 30
	          },
	          end: {
	            line: 103,
	            column: 7
	          }
	        },
	        line: 99
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 7,
	            column: 2
	          },
	          end: {
	            line: 12,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 7,
	            column: 2
	          },
	          end: {
	            line: 12,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 7,
	            column: 2
	          },
	          end: {
	            line: 12,
	            column: 3
	          }
	        }],
	        line: 7
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 18,
	            column: 2
	          },
	          end: {
	            line: 52,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 18,
	            column: 2
	          },
	          end: {
	            line: 52,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 18,
	            column: 2
	          },
	          end: {
	            line: 52,
	            column: 3
	          }
	        }],
	        line: 18
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 59,
	            column: 4
	          },
	          end: {
	            line: 61,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 59,
	            column: 4
	          },
	          end: {
	            line: 61,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 59,
	            column: 4
	          },
	          end: {
	            line: 61,
	            column: 5
	          }
	        }],
	        line: 59
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 79,
	            column: 4
	          },
	          end: {
	            line: 81,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 79,
	            column: 4
	          },
	          end: {
	            line: 81,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 79,
	            column: 4
	          },
	          end: {
	            line: 81,
	            column: 5
	          }
	        }],
	        line: 79
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 79,
	            column: 8
	          },
	          end: {
	            line: 79,
	            column: 48
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 79,
	            column: 8
	          },
	          end: {
	            line: 79,
	            column: 26
	          }
	        }, {
	          start: {
	            line: 79,
	            column: 30
	          },
	          end: {
	            line: 79,
	            column: 48
	          }
	        }],
	        line: 79
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 86,
	            column: 4
	          },
	          end: {
	            line: 88,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 86,
	            column: 4
	          },
	          end: {
	            line: 88,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 86,
	            column: 4
	          },
	          end: {
	            line: 88,
	            column: 5
	          }
	        }],
	        line: 86
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 96,
	            column: 4
	          },
	          end: {
	            line: 104,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 96,
	            column: 4
	          },
	          end: {
	            line: 104,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 96,
	            column: 4
	          },
	          end: {
	            line: 104,
	            column: 5
	          }
	        }],
	        line: 96
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 114,
	            column: 4
	          },
	          end: {
	            line: 122,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 114,
	            column: 4
	          },
	          end: {
	            line: 122,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 114,
	            column: 4
	          },
	          end: {
	            line: 122,
	            column: 5
	          }
	        }],
	        line: 114
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 150,
	            column: 22
	          },
	          end: {
	            line: 150,
	            column: 66
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 150,
	            column: 22
	          },
	          end: {
	            line: 150,
	            column: 31
	          }
	        }, {
	          start: {
	            line: 150,
	            column: 35
	          },
	          end: {
	            line: 150,
	            column: 66
	          }
	        }],
	        line: 150
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 161,
	            column: 4
	          },
	          end: {
	            line: 169,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 161,
	            column: 4
	          },
	          end: {
	            line: 169,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 161,
	            column: 4
	          },
	          end: {
	            line: 169,
	            column: 5
	          }
	        }],
	        line: 161
	      },
	      "10": {
	        loc: {
	          start: {
	            line: 163,
	            column: 30
	          },
	          end: {
	            line: 163,
	            column: 52
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 163,
	            column: 30
	          },
	          end: {
	            line: 163,
	            column: 46
	          }
	        }, {
	          start: {
	            line: 163,
	            column: 50
	          },
	          end: {
	            line: 163,
	            column: 52
	          }
	        }],
	        line: 163
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0,
	      "47": 0,
	      "48": 0,
	      "49": 0,
	      "50": 0,
	      "51": 0,
	      "52": 0,
	      "53": 0,
	      "54": 0,
	      "55": 0,
	      "56": 0,
	      "57": 0,
	      "58": 0,
	      "59": 0,
	      "60": 0,
	      "61": 0,
	      "62": 0,
	      "63": 0,
	      "64": 0,
	      "65": 0,
	      "66": 0,
	      "67": 0,
	      "68": 0,
	      "69": 0,
	      "70": 0,
	      "71": 0,
	      "72": 0,
	      "73": 0,
	      "74": 0,
	      "75": 0,
	      "76": 0,
	      "77": 0,
	      "78": 0,
	      "79": 0,
	      "80": 0,
	      "81": 0,
	      "82": 0,
	      "83": 0,
	      "84": 0,
	      "85": 0,
	      "86": 0,
	      "87": 0,
	      "88": 0,
	      "89": 0,
	      "90": 0,
	      "91": 0,
	      "92": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0],
	      "10": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "5dc6058daf6156feb0b6ade2a9ee32d9474598a1"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});
	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }
	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_1mxbo1hw9z = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}
	cov_1mxbo1hw9z();
	const Component$1 = (cov_1mxbo1hw9z().s[0]++, videojs__default["default"].getComponent('Component'));
	cov_1mxbo1hw9z().s[1]++;
	const createThumbnail = function (thumbnail) {
	  cov_1mxbo1hw9z().f[0]++;
	  cov_1mxbo1hw9z().s[2]++;
	  if (!thumbnail) {
	    cov_1mxbo1hw9z().b[0][0]++;
	    const placeholder = (cov_1mxbo1hw9z().s[3]++, document_1.createElement('div'));
	    cov_1mxbo1hw9z().s[4]++;
	    placeholder.className = 'vjs-playlist-thumbnail vjs-playlist-thumbnail-placeholder';
	    cov_1mxbo1hw9z().s[5]++;
	    return placeholder;
	  } else {
	    cov_1mxbo1hw9z().b[0][1]++;
	  }
	  const picture = (cov_1mxbo1hw9z().s[6]++, document_1.createElement('picture'));
	  cov_1mxbo1hw9z().s[7]++;
	  picture.className = 'vjs-playlist-thumbnail';
	  cov_1mxbo1hw9z().s[8]++;
	  if (typeof thumbnail === 'string') {
	    cov_1mxbo1hw9z().b[1][0]++; // simple thumbnails
	    const img = (cov_1mxbo1hw9z().s[9]++, document_1.createElement('img'));
	    cov_1mxbo1hw9z().s[10]++;
	    img.loading = 'lazy';
	    cov_1mxbo1hw9z().s[11]++;
	    img.src = thumbnail;
	    cov_1mxbo1hw9z().s[12]++;
	    img.alt = '';
	    cov_1mxbo1hw9z().s[13]++;
	    picture.appendChild(img);
	  } else {
	    cov_1mxbo1hw9z().b[1][1]++;
	    cov_1mxbo1hw9z().s[14]++; // responsive thumbnails
	    // additional variations of a <picture> are specified as
	    // <source> elements
	    for (let i = (cov_1mxbo1hw9z().s[15]++, 0); i < thumbnail.length - 1; i++) {
	      const variant = (cov_1mxbo1hw9z().s[16]++, thumbnail[i]);
	      const source = (cov_1mxbo1hw9z().s[17]++, document_1.createElement('source')); // transfer the properties of each variant onto a <source>
	      cov_1mxbo1hw9z().s[18]++;
	      for (const prop in variant) {
	        cov_1mxbo1hw9z().s[19]++;
	        source[prop] = variant[prop];
	      }
	      cov_1mxbo1hw9z().s[20]++;
	      picture.appendChild(source);
	    } // the default version of a <picture> is specified by an <img>
	    const variant = (cov_1mxbo1hw9z().s[21]++, thumbnail[thumbnail.length - 1]);
	    const img = (cov_1mxbo1hw9z().s[22]++, document_1.createElement('img'));
	    cov_1mxbo1hw9z().s[23]++;
	    img.loading = 'lazy';
	    cov_1mxbo1hw9z().s[24]++;
	    img.alt = '';
	    cov_1mxbo1hw9z().s[25]++;
	    for (const prop in variant) {
	      cov_1mxbo1hw9z().s[26]++;
	      img[prop] = variant[prop];
	    }
	    cov_1mxbo1hw9z().s[27]++;
	    picture.appendChild(img);
	  }
	  cov_1mxbo1hw9z().s[28]++;
	  return picture;
	};
	class PlaylistMenuItem extends Component$1 {
	  constructor(player, playlistItem, settings) {
	    cov_1mxbo1hw9z().f[1]++;
	    cov_1mxbo1hw9z().s[29]++;
	    if (!playlistItem.item) {
	      cov_1mxbo1hw9z().b[2][0]++;
	      cov_1mxbo1hw9z().s[30]++;
	      throw new Error('Cannot construct a PlaylistMenuItem without an item option');
	    } else {
	      cov_1mxbo1hw9z().b[2][1]++;
	    }
	    cov_1mxbo1hw9z().s[31]++;
	    playlistItem.showDescription = settings.showDescription;
	    cov_1mxbo1hw9z().s[32]++;
	    super(player, playlistItem);
	    cov_1mxbo1hw9z().s[33]++;
	    this.item = playlistItem.item;
	    cov_1mxbo1hw9z().s[34]++;
	    this.playOnSelect = settings.playOnSelect;
	    cov_1mxbo1hw9z().s[35]++;
	    this.emitTapEvents();
	    cov_1mxbo1hw9z().s[36]++;
	    this.on(['click', 'tap'], this.switchPlaylistItem_);
	    cov_1mxbo1hw9z().s[37]++;
	    this.on('keydown', this.handleKeyDown_);
	  }
	  handleKeyDown_(event) {
	    cov_1mxbo1hw9z().f[2]++;
	    cov_1mxbo1hw9z().s[38]++; // keycode 13 is <Enter>
	    // keycode 32 is <Space>
	    if ((cov_1mxbo1hw9z().b[4][0]++, event.which === 13) || (cov_1mxbo1hw9z().b[4][1]++, event.which === 32)) {
	      cov_1mxbo1hw9z().b[3][0]++;
	      cov_1mxbo1hw9z().s[39]++;
	      this.switchPlaylistItem_();
	    } else {
	      cov_1mxbo1hw9z().b[3][1]++;
	    }
	  }
	  switchPlaylistItem_(event) {
	    cov_1mxbo1hw9z().f[3]++;
	    cov_1mxbo1hw9z().s[40]++;
	    this.player_.playlist.currentItem(this.player_.playlist().indexOf(this.item));
	    cov_1mxbo1hw9z().s[41]++;
	    if (this.playOnSelect) {
	      cov_1mxbo1hw9z().b[5][0]++;
	      cov_1mxbo1hw9z().s[42]++;
	      this.player_.play();
	    } else {
	      cov_1mxbo1hw9z().b[5][1]++;
	    }
	  }
	  createEl() {
	    cov_1mxbo1hw9z().f[4]++;
	    const li = (cov_1mxbo1hw9z().s[43]++, document_1.createElement('li'));
	    const item = (cov_1mxbo1hw9z().s[44]++, this.options_.item);
	    const showDescription = (cov_1mxbo1hw9z().s[45]++, this.options_.showDescription);
	    cov_1mxbo1hw9z().s[46]++;
	    if (typeof item.data === 'object') {
	      cov_1mxbo1hw9z().b[6][0]++;
	      const dataKeys = (cov_1mxbo1hw9z().s[47]++, Object.keys(item.data));
	      cov_1mxbo1hw9z().s[48]++;
	      dataKeys.forEach(key => {
	        cov_1mxbo1hw9z().f[5]++;
	        const value = (cov_1mxbo1hw9z().s[49]++, item.data[key]);
	        cov_1mxbo1hw9z().s[50]++;
	        li.dataset[key] = value;
	      });
	    } else {
	      cov_1mxbo1hw9z().b[6][1]++;
	    }
	    cov_1mxbo1hw9z().s[51]++;
	    li.className = 'vjs-playlist-item';
	    cov_1mxbo1hw9z().s[52]++;
	    li.setAttribute('tabIndex', 0); // Thumbnail image
	    cov_1mxbo1hw9z().s[53]++;
	    this.thumbnail = createThumbnail(item.thumbnail);
	    cov_1mxbo1hw9z().s[54]++;
	    li.appendChild(this.thumbnail); // Duration
	    cov_1mxbo1hw9z().s[55]++;
	    if (item.duration) {
	      cov_1mxbo1hw9z().b[7][0]++;
	      const duration = (cov_1mxbo1hw9z().s[56]++, document_1.createElement('time'));
	      const time = (cov_1mxbo1hw9z().s[57]++, videojs__default["default"].time.formatTime(item.duration));
	      cov_1mxbo1hw9z().s[58]++;
	      duration.className = 'vjs-playlist-duration';
	      cov_1mxbo1hw9z().s[59]++;
	      duration.setAttribute('datetime', 'PT0H0M' + item.duration + 'S');
	      cov_1mxbo1hw9z().s[60]++;
	      duration.appendChild(document_1.createTextNode(time));
	      cov_1mxbo1hw9z().s[61]++;
	      li.appendChild(duration);
	    } else {
	      cov_1mxbo1hw9z().b[7][1]++;
	    } // Now playing
	    const nowPlayingEl = (cov_1mxbo1hw9z().s[62]++, document_1.createElement('span'));
	    const nowPlayingText = (cov_1mxbo1hw9z().s[63]++, this.localize('Now Playing'));
	    cov_1mxbo1hw9z().s[64]++;
	    nowPlayingEl.className = 'vjs-playlist-now-playing-text';
	    cov_1mxbo1hw9z().s[65]++;
	    nowPlayingEl.appendChild(document_1.createTextNode(nowPlayingText));
	    cov_1mxbo1hw9z().s[66]++;
	    nowPlayingEl.setAttribute('title', nowPlayingText);
	    cov_1mxbo1hw9z().s[67]++;
	    this.thumbnail.appendChild(nowPlayingEl); // Title container contains title and "up next"
	    const titleContainerEl = (cov_1mxbo1hw9z().s[68]++, document_1.createElement('div'));
	    cov_1mxbo1hw9z().s[69]++;
	    titleContainerEl.className = 'vjs-playlist-title-container';
	    cov_1mxbo1hw9z().s[70]++;
	    this.thumbnail.appendChild(titleContainerEl); // Up next
	    const upNextEl = (cov_1mxbo1hw9z().s[71]++, document_1.createElement('span'));
	    const upNextText = (cov_1mxbo1hw9z().s[72]++, this.localize('Up Next'));
	    cov_1mxbo1hw9z().s[73]++;
	    upNextEl.className = 'vjs-up-next-text';
	    cov_1mxbo1hw9z().s[74]++;
	    upNextEl.appendChild(document_1.createTextNode(upNextText));
	    cov_1mxbo1hw9z().s[75]++;
	    upNextEl.setAttribute('title', upNextText);
	    cov_1mxbo1hw9z().s[76]++;
	    titleContainerEl.appendChild(upNextEl); // Video title
	    const titleEl = (cov_1mxbo1hw9z().s[77]++, document_1.createElement('cite'));
	    const titleText = (cov_1mxbo1hw9z().s[78]++, (cov_1mxbo1hw9z().b[8][0]++, item.name) || (cov_1mxbo1hw9z().b[8][1]++, this.localize('Untitled Video')));
	    cov_1mxbo1hw9z().s[79]++;
	    titleEl.className = 'vjs-playlist-name';
	    cov_1mxbo1hw9z().s[80]++;
	    titleEl.appendChild(document_1.createTextNode(titleText));
	    cov_1mxbo1hw9z().s[81]++;
	    titleEl.setAttribute('title', titleText);
	    cov_1mxbo1hw9z().s[82]++;
	    titleContainerEl.appendChild(titleEl); // Populate thumbnails alt with the video title
	    cov_1mxbo1hw9z().s[83]++;
	    this.thumbnail.getElementsByTagName('img').alt = titleText; // We add thumbnail video description only if specified in playlist options
	    cov_1mxbo1hw9z().s[84]++;
	    if (showDescription) {
	      cov_1mxbo1hw9z().b[9][0]++;
	      const descriptionEl = (cov_1mxbo1hw9z().s[85]++, document_1.createElement('div'));
	      const descriptionText = (cov_1mxbo1hw9z().s[86]++, (cov_1mxbo1hw9z().b[10][0]++, item.description) || (cov_1mxbo1hw9z().b[10][1]++, ''));
	      cov_1mxbo1hw9z().s[87]++;
	      descriptionEl.className = 'vjs-playlist-description';
	      cov_1mxbo1hw9z().s[88]++;
	      descriptionEl.appendChild(document_1.createTextNode(descriptionText));
	      cov_1mxbo1hw9z().s[89]++;
	      descriptionEl.setAttribute('title', descriptionText);
	      cov_1mxbo1hw9z().s[90]++;
	      titleContainerEl.appendChild(descriptionEl);
	    } else {
	      cov_1mxbo1hw9z().b[9][1]++;
	    }
	    cov_1mxbo1hw9z().s[91]++;
	    return li;
	  }
	}
	cov_1mxbo1hw9z().s[92]++;
	videojs__default["default"].registerComponent('PlaylistMenuItem', PlaylistMenuItem);

	function cov_szjn60m9j() {
	  var path = "/Users/poneill/dev/videojs-playlist-ui/src/playlist-menu.js";
	  var hash = "566dd9e877850f931b64c9732badaa22c5add5c9";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/poneill/dev/videojs-playlist-ui/src/playlist-menu.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 8,
	          column: 25
	        },
	        end: {
	          line: 10,
	          column: 1
	        }
	      },
	      "1": {
	        start: {
	          line: 9,
	          column: 2
	        },
	        end: {
	          line: 9,
	          column: 30
	        }
	      },
	      "2": {
	        start: {
	          line: 11,
	          column: 28
	        },
	        end: {
	          line: 17,
	          column: 1
	        }
	      },
	      "3": {
	        start: {
	          line: 12,
	          column: 2
	        },
	        end: {
	          line: 12,
	          column: 33
	        }
	      },
	      "4": {
	        start: {
	          line: 14,
	          column: 2
	        },
	        end: {
	          line: 16,
	          column: 3
	        }
	      },
	      "5": {
	        start: {
	          line: 15,
	          column: 4
	        },
	        end: {
	          line: 15,
	          column: 70
	        }
	      },
	      "6": {
	        start: {
	          line: 19,
	          column: 15
	        },
	        end: {
	          line: 21,
	          column: 1
	        }
	      },
	      "7": {
	        start: {
	          line: 20,
	          column: 2
	        },
	        end: {
	          line: 20,
	          column: 29
	        }
	      },
	      "8": {
	        start: {
	          line: 23,
	          column: 18
	        },
	        end: {
	          line: 25,
	          column: 1
	        }
	      },
	      "9": {
	        start: {
	          line: 24,
	          column: 2
	        },
	        end: {
	          line: 24,
	          column: 32
	        }
	      },
	      "10": {
	        start: {
	          line: 27,
	          column: 18
	        },
	        end: {
	          line: 27,
	          column: 51
	        }
	      },
	      "11": {
	        start: {
	          line: 32,
	          column: 4
	        },
	        end: {
	          line: 32,
	          column: 27
	        }
	      },
	      "12": {
	        start: {
	          line: 33,
	          column: 4
	        },
	        end: {
	          line: 33,
	          column: 20
	        }
	      },
	      "13": {
	        start: {
	          line: 35,
	          column: 4
	        },
	        end: {
	          line: 39,
	          column: 5
	        }
	      },
	      "14": {
	        start: {
	          line: 36,
	          column: 6
	        },
	        end: {
	          line: 36,
	          column: 47
	        }
	      },
	      "15": {
	        start: {
	          line: 38,
	          column: 6
	        },
	        end: {
	          line: 38,
	          column: 45
	        }
	      },
	      "16": {
	        start: {
	          line: 44,
	          column: 4
	        },
	        end: {
	          line: 46,
	          column: 5
	        }
	      },
	      "17": {
	        start: {
	          line: 45,
	          column: 6
	        },
	        end: {
	          line: 45,
	          column: 44
	        }
	      },
	      "18": {
	        start: {
	          line: 48,
	          column: 4
	        },
	        end: {
	          line: 48,
	          column: 27
	        }
	      },
	      "19": {
	        start: {
	          line: 50,
	          column: 4
	        },
	        end: {
	          line: 52,
	          column: 5
	        }
	      },
	      "20": {
	        start: {
	          line: 51,
	          column: 6
	        },
	        end: {
	          line: 51,
	          column: 33
	        }
	      },
	      "21": {
	        start: {
	          line: 54,
	          column: 4
	        },
	        end: {
	          line: 63,
	          column: 7
	        }
	      },
	      "22": {
	        start: {
	          line: 59,
	          column: 6
	        },
	        end: {
	          line: 61,
	          column: 7
	        }
	      },
	      "23": {
	        start: {
	          line: 60,
	          column: 8
	        },
	        end: {
	          line: 60,
	          column: 15
	        }
	      },
	      "24": {
	        start: {
	          line: 62,
	          column: 6
	        },
	        end: {
	          line: 62,
	          column: 20
	        }
	      },
	      "25": {
	        start: {
	          line: 65,
	          column: 4
	        },
	        end: {
	          line: 65,
	          column: 78
	        }
	      },
	      "26": {
	        start: {
	          line: 65,
	          column: 44
	        },
	        end: {
	          line: 65,
	          column: 76
	        }
	      },
	      "27": {
	        start: {
	          line: 66,
	          column: 4
	        },
	        end: {
	          line: 66,
	          column: 84
	        }
	      },
	      "28": {
	        start: {
	          line: 66,
	          column: 47
	        },
	        end: {
	          line: 66,
	          column: 82
	        }
	      },
	      "29": {
	        start: {
	          line: 70,
	          column: 4
	        },
	        end: {
	          line: 72,
	          column: 7
	        }
	      },
	      "30": {
	        start: {
	          line: 71,
	          column: 6
	        },
	        end: {
	          line: 71,
	          column: 38
	        }
	      },
	      "31": {
	        start: {
	          line: 74,
	          column: 4
	        },
	        end: {
	          line: 76,
	          column: 7
	        }
	      },
	      "32": {
	        start: {
	          line: 75,
	          column: 6
	        },
	        end: {
	          line: 75,
	          column: 41
	        }
	      },
	      "33": {
	        start: {
	          line: 78,
	          column: 4
	        },
	        end: {
	          line: 81,
	          column: 7
	        }
	      },
	      "34": {
	        start: {
	          line: 79,
	          column: 6
	        },
	        end: {
	          line: 79,
	          column: 20
	        }
	      },
	      "35": {
	        start: {
	          line: 80,
	          column: 6
	        },
	        end: {
	          line: 80,
	          column: 33
	        }
	      },
	      "36": {
	        start: {
	          line: 83,
	          column: 4
	        },
	        end: {
	          line: 85,
	          column: 7
	        }
	      },
	      "37": {
	        start: {
	          line: 84,
	          column: 6
	        },
	        end: {
	          line: 84,
	          column: 21
	        }
	      },
	      "38": {
	        start: {
	          line: 89,
	          column: 4
	        },
	        end: {
	          line: 89,
	          column: 77
	        }
	      },
	      "39": {
	        start: {
	          line: 93,
	          column: 4
	        },
	        end: {
	          line: 96,
	          column: 5
	        }
	      },
	      "40": {
	        start: {
	          line: 94,
	          column: 6
	        },
	        end: {
	          line: 94,
	          column: 43
	        }
	      },
	      "41": {
	        start: {
	          line: 94,
	          column: 30
	        },
	        end: {
	          line: 94,
	          column: 41
	        }
	      },
	      "42": {
	        start: {
	          line: 95,
	          column: 6
	        },
	        end: {
	          line: 95,
	          column: 28
	        }
	      },
	      "43": {
	        start: {
	          line: 100,
	          column: 21
	        },
	        end: {
	          line: 100,
	          column: 50
	        }
	      },
	      "44": {
	        start: {
	          line: 101,
	          column: 15
	        },
	        end: {
	          line: 101,
	          column: 64
	        }
	      },
	      "45": {
	        start: {
	          line: 102,
	          column: 18
	        },
	        end: {
	          line: 102,
	          column: 68
	        }
	      },
	      "46": {
	        start: {
	          line: 104,
	          column: 4
	        },
	        end: {
	          line: 108,
	          column: 5
	        }
	      },
	      "47": {
	        start: {
	          line: 105,
	          column: 6
	        },
	        end: {
	          line: 105,
	          column: 42
	        }
	      },
	      "48": {
	        start: {
	          line: 106,
	          column: 6
	        },
	        end: {
	          line: 106,
	          column: 48
	        }
	      },
	      "49": {
	        start: {
	          line: 107,
	          column: 6
	        },
	        end: {
	          line: 107,
	          column: 33
	        }
	      },
	      "50": {
	        start: {
	          line: 110,
	          column: 4
	        },
	        end: {
	          line: 110,
	          column: 18
	        }
	      },
	      "51": {
	        start: {
	          line: 113,
	          column: 4
	        },
	        end: {
	          line: 120,
	          column: 5
	        }
	      },
	      "52": {
	        start: {
	          line: 113,
	          column: 17
	        },
	        end: {
	          line: 113,
	          column: 18
	        }
	      },
	      "53": {
	        start: {
	          line: 114,
	          column: 19
	        },
	        end: {
	          line: 116,
	          column: 23
	        }
	      },
	      "54": {
	        start: {
	          line: 118,
	          column: 6
	        },
	        end: {
	          line: 118,
	          column: 28
	        }
	      },
	      "55": {
	        start: {
	          line: 119,
	          column: 6
	        },
	        end: {
	          line: 119,
	          column: 33
	        }
	      },
	      "56": {
	        start: {
	          line: 124,
	          column: 4
	        },
	        end: {
	          line: 131,
	          column: 5
	        }
	      },
	      "57": {
	        start: {
	          line: 125,
	          column: 6
	        },
	        end: {
	          line: 125,
	          column: 45
	        }
	      },
	      "58": {
	        start: {
	          line: 126,
	          column: 6
	        },
	        end: {
	          line: 126,
	          column: 52
	        }
	      },
	      "59": {
	        start: {
	          line: 127,
	          column: 6
	        },
	        end: {
	          line: 127,
	          column: 32
	        }
	      },
	      "60": {
	        start: {
	          line: 130,
	          column: 6
	        },
	        end: {
	          line: 130,
	          column: 32
	        }
	      },
	      "61": {
	        start: {
	          line: 134,
	          column: 26
	        },
	        end: {
	          line: 134,
	          column: 61
	        }
	      },
	      "62": {
	        start: {
	          line: 136,
	          column: 4
	        },
	        end: {
	          line: 144,
	          column: 5
	        }
	      },
	      "63": {
	        start: {
	          line: 137,
	          column: 6
	        },
	        end: {
	          line: 137,
	          column: 50
	        }
	      },
	      "64": {
	        start: {
	          line: 139,
	          column: 24
	        },
	        end: {
	          line: 139,
	          column: 78
	        }
	      },
	      "65": {
	        start: {
	          line: 141,
	          column: 6
	        },
	        end: {
	          line: 143,
	          column: 7
	        }
	      },
	      "66": {
	        start: {
	          line: 142,
	          column: 8
	        },
	        end: {
	          line: 142,
	          column: 68
	        }
	      },
	      "67": {
	        start: {
	          line: 160,
	          column: 21
	        },
	        end: {
	          line: 160,
	          column: 44
	        }
	      },
	      "68": {
	        start: {
	          line: 161,
	          column: 18
	        },
	        end: {
	          line: 161,
	          column: 54
	        }
	      },
	      "69": {
	        start: {
	          line: 163,
	          column: 4
	        },
	        end: {
	          line: 165,
	          column: 5
	        }
	      },
	      "70": {
	        start: {
	          line: 164,
	          column: 6
	        },
	        end: {
	          line: 164,
	          column: 13
	        }
	      },
	      "71": {
	        start: {
	          line: 167,
	          column: 19
	        },
	        end: {
	          line: 167,
	          column: 68
	        }
	      },
	      "72": {
	        start: {
	          line: 168,
	          column: 22
	        },
	        end: {
	          line: 168,
	          column: 69
	        }
	      },
	      "73": {
	        start: {
	          line: 172,
	          column: 20
	        },
	        end: {
	          line: 172,
	          column: 44
	        }
	      },
	      "74": {
	        start: {
	          line: 174,
	          column: 22
	        },
	        end: {
	          line: 180,
	          column: 6
	        }
	      },
	      "75": {
	        start: {
	          line: 175,
	          column: 23
	        },
	        end: {
	          line: 175,
	          column: 80
	        }
	      },
	      "76": {
	        start: {
	          line: 177,
	          column: 6
	        },
	        end: {
	          line: 177,
	          column: 49
	        }
	      },
	      "77": {
	        start: {
	          line: 179,
	          column: 6
	        },
	        end: {
	          line: 179,
	          column: 22
	        }
	      },
	      "78": {
	        start: {
	          line: 182,
	          column: 4
	        },
	        end: {
	          line: 182,
	          column: 46
	        }
	      },
	      "79": {
	        start: {
	          line: 197,
	          column: 23
	        },
	        end: {
	          line: 197,
	          column: 61
	        }
	      },
	      "80": {
	        start: {
	          line: 199,
	          column: 4
	        },
	        end: {
	          line: 201,
	          column: 5
	        }
	      },
	      "81": {
	        start: {
	          line: 200,
	          column: 6
	        },
	        end: {
	          line: 200,
	          column: 13
	        }
	      },
	      "82": {
	        start: {
	          line: 203,
	          column: 4
	        },
	        end: {
	          line: 203,
	          column: 41
	        }
	      },
	      "83": {
	        start: {
	          line: 203,
	          column: 28
	        },
	        end: {
	          line: 203,
	          column: 39
	        }
	      },
	      "84": {
	        start: {
	          line: 204,
	          column: 4
	        },
	        end: {
	          line: 204,
	          column: 36
	        }
	      },
	      "85": {
	        start: {
	          line: 209,
	          column: 21
	        },
	        end: {
	          line: 209,
	          column: 44
	        }
	      },
	      "86": {
	        start: {
	          line: 211,
	          column: 4
	        },
	        end: {
	          line: 216,
	          column: 5
	        }
	      },
	      "87": {
	        start: {
	          line: 214,
	          column: 6
	        },
	        end: {
	          line: 214,
	          column: 29
	        }
	      },
	      "88": {
	        start: {
	          line: 215,
	          column: 6
	        },
	        end: {
	          line: 215,
	          column: 13
	        }
	      },
	      "89": {
	        start: {
	          line: 218,
	          column: 4
	        },
	        end: {
	          line: 225,
	          column: 5
	        }
	      },
	      "90": {
	        start: {
	          line: 218,
	          column: 17
	        },
	        end: {
	          line: 218,
	          column: 18
	        }
	      },
	      "91": {
	        start: {
	          line: 219,
	          column: 6
	        },
	        end: {
	          line: 224,
	          column: 7
	        }
	      },
	      "92": {
	        start: {
	          line: 222,
	          column: 8
	        },
	        end: {
	          line: 222,
	          column: 31
	        }
	      },
	      "93": {
	        start: {
	          line: 223,
	          column: 8
	        },
	        end: {
	          line: 223,
	          column: 15
	        }
	      },
	      "94": {
	        start: {
	          line: 228,
	          column: 24
	        },
	        end: {
	          line: 228,
	          column: 59
	        }
	      },
	      "95": {
	        start: {
	          line: 230,
	          column: 4
	        },
	        end: {
	          line: 246,
	          column: 5
	        }
	      },
	      "96": {
	        start: {
	          line: 230,
	          column: 17
	        },
	        end: {
	          line: 230,
	          column: 18
	        }
	      },
	      "97": {
	        start: {
	          line: 231,
	          column: 19
	        },
	        end: {
	          line: 231,
	          column: 32
	        }
	      },
	      "98": {
	        start: {
	          line: 233,
	          column: 6
	        },
	        end: {
	          line: 245,
	          column: 7
	        }
	      },
	      "99": {
	        start: {
	          line: 234,
	          column: 8
	        },
	        end: {
	          line: 234,
	          column: 31
	        }
	      },
	      "100": {
	        start: {
	          line: 235,
	          column: 8
	        },
	        end: {
	          line: 237,
	          column: 9
	        }
	      },
	      "101": {
	        start: {
	          line: 236,
	          column: 10
	        },
	        end: {
	          line: 236,
	          column: 75
	        }
	      },
	      "102": {
	        start: {
	          line: 238,
	          column: 8
	        },
	        end: {
	          line: 238,
	          column: 24
	        }
	      },
	      "103": {
	        start: {
	          line: 239,
	          column: 13
	        },
	        end: {
	          line: 245,
	          column: 7
	        }
	      },
	      "104": {
	        start: {
	          line: 240,
	          column: 8
	        },
	        end: {
	          line: 240,
	          column: 34
	        }
	      },
	      "105": {
	        start: {
	          line: 241,
	          column: 8
	        },
	        end: {
	          line: 241,
	          column: 21
	        }
	      },
	      "106": {
	        start: {
	          line: 243,
	          column: 8
	        },
	        end: {
	          line: 243,
	          column: 34
	        }
	      },
	      "107": {
	        start: {
	          line: 244,
	          column: 8
	        },
	        end: {
	          line: 244,
	          column: 24
	        }
	      },
	      "108": {
	        start: {
	          line: 250,
	          column: 0
	        },
	        end: {
	          line: 250,
	          column: 56
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 8,
	            column: 25
	          },
	          end: {
	            line: 8,
	            column: 26
	          }
	        },
	        loc: {
	          start: {
	            line: 8,
	            column: 38
	          },
	          end: {
	            line: 10,
	            column: 1
	          }
	        },
	        line: 8
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 11,
	            column: 28
	          },
	          end: {
	            line: 11,
	            column: 29
	          }
	        },
	        loc: {
	          start: {
	            line: 11,
	            column: 41
	          },
	          end: {
	            line: 17,
	            column: 1
	          }
	        },
	        line: 11
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 19,
	            column: 15
	          },
	          end: {
	            line: 19,
	            column: 16
	          }
	        },
	        loc: {
	          start: {
	            line: 19,
	            column: 28
	          },
	          end: {
	            line: 21,
	            column: 1
	          }
	        },
	        line: 19
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 23,
	            column: 18
	          },
	          end: {
	            line: 23,
	            column: 19
	          }
	        },
	        loc: {
	          start: {
	            line: 23,
	            column: 31
	          },
	          end: {
	            line: 25,
	            column: 1
	          }
	        },
	        line: 23
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 31,
	            column: 2
	          },
	          end: {
	            line: 31,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 31,
	            column: 31
	          },
	          end: {
	            line: 86,
	            column: 3
	          }
	        },
	        line: 31
	      },
	      "5": {
	        name: "(anonymous_5)",
	        decl: {
	          start: {
	            line: 54,
	            column: 71
	          },
	          end: {
	            line: 54,
	            column: 72
	          }
	        },
	        loc: {
	          start: {
	            line: 54,
	            column: 78
	          },
	          end: {
	            line: 63,
	            column: 5
	          }
	        },
	        line: 54
	      },
	      "6": {
	        name: "(anonymous_6)",
	        decl: {
	          start: {
	            line: 65,
	            column: 37
	          },
	          end: {
	            line: 65,
	            column: 38
	          }
	        },
	        loc: {
	          start: {
	            line: 65,
	            column: 44
	          },
	          end: {
	            line: 65,
	            column: 76
	          }
	        },
	        line: 65
	      },
	      "7": {
	        name: "(anonymous_7)",
	        decl: {
	          start: {
	            line: 66,
	            column: 40
	          },
	          end: {
	            line: 66,
	            column: 41
	          }
	        },
	        loc: {
	          start: {
	            line: 66,
	            column: 47
	          },
	          end: {
	            line: 66,
	            column: 82
	          }
	        },
	        line: 66
	      },
	      "8": {
	        name: "(anonymous_8)",
	        decl: {
	          start: {
	            line: 70,
	            column: 31
	          },
	          end: {
	            line: 70,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 70,
	            column: 37
	          },
	          end: {
	            line: 72,
	            column: 5
	          }
	        },
	        line: 70
	      },
	      "9": {
	        name: "(anonymous_9)",
	        decl: {
	          start: {
	            line: 74,
	            column: 29
	          },
	          end: {
	            line: 74,
	            column: 30
	          }
	        },
	        loc: {
	          start: {
	            line: 74,
	            column: 35
	          },
	          end: {
	            line: 76,
	            column: 5
	          }
	        },
	        line: 74
	      },
	      "10": {
	        name: "(anonymous_10)",
	        decl: {
	          start: {
	            line: 78,
	            column: 23
	          },
	          end: {
	            line: 78,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 78,
	            column: 29
	          },
	          end: {
	            line: 81,
	            column: 5
	          }
	        },
	        line: 78
	      },
	      "11": {
	        name: "(anonymous_11)",
	        decl: {
	          start: {
	            line: 83,
	            column: 31
	          },
	          end: {
	            line: 83,
	            column: 32
	          }
	        },
	        loc: {
	          start: {
	            line: 83,
	            column: 37
	          },
	          end: {
	            line: 85,
	            column: 5
	          }
	        },
	        line: 83
	      },
	      "12": {
	        name: "(anonymous_12)",
	        decl: {
	          start: {
	            line: 88,
	            column: 2
	          },
	          end: {
	            line: 88,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 88,
	            column: 13
	          },
	          end: {
	            line: 90,
	            column: 3
	          }
	        },
	        line: 88
	      },
	      "13": {
	        name: "(anonymous_13)",
	        decl: {
	          start: {
	            line: 92,
	            column: 2
	          },
	          end: {
	            line: 92,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 92,
	            column: 11
	          },
	          end: {
	            line: 97,
	            column: 3
	          }
	        },
	        line: 92
	      },
	      "14": {
	        name: "(anonymous_14)",
	        decl: {
	          start: {
	            line: 94,
	            column: 25
	          },
	          end: {
	            line: 94,
	            column: 26
	          }
	        },
	        loc: {
	          start: {
	            line: 94,
	            column: 30
	          },
	          end: {
	            line: 94,
	            column: 41
	          }
	        },
	        line: 94
	      },
	      "15": {
	        name: "(anonymous_15)",
	        decl: {
	          start: {
	            line: 99,
	            column: 2
	          },
	          end: {
	            line: 99,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 99,
	            column: 20
	          },
	          end: {
	            line: 145,
	            column: 3
	          }
	        },
	        line: 99
	      },
	      "16": {
	        name: "(anonymous_16)",
	        decl: {
	          start: {
	            line: 159,
	            column: 2
	          },
	          end: {
	            line: 159,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 159,
	            column: 26
	          },
	          end: {
	            line: 183,
	            column: 3
	          }
	        },
	        line: 159
	      },
	      "17": {
	        name: "(anonymous_17)",
	        decl: {
	          start: {
	            line: 174,
	            column: 32
	          },
	          end: {
	            line: 174,
	            column: 33
	          }
	        },
	        loc: {
	          start: {
	            line: 174,
	            column: 42
	          },
	          end: {
	            line: 180,
	            column: 5
	          }
	        },
	        line: 174
	      },
	      "18": {
	        name: "(anonymous_18)",
	        decl: {
	          start: {
	            line: 196,
	            column: 2
	          },
	          end: {
	            line: 196,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 196,
	            column: 29
	          },
	          end: {
	            line: 205,
	            column: 3
	          }
	        },
	        line: 196
	      },
	      "19": {
	        name: "(anonymous_19)",
	        decl: {
	          start: {
	            line: 203,
	            column: 23
	          },
	          end: {
	            line: 203,
	            column: 24
	          }
	        },
	        loc: {
	          start: {
	            line: 203,
	            column: 28
	          },
	          end: {
	            line: 203,
	            column: 39
	          }
	        },
	        line: 203
	      },
	      "20": {
	        name: "(anonymous_20)",
	        decl: {
	          start: {
	            line: 207,
	            column: 2
	          },
	          end: {
	            line: 207,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 207,
	            column: 11
	          },
	          end: {
	            line: 247,
	            column: 3
	          }
	        },
	        line: 207
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 14,
	            column: 2
	          },
	          end: {
	            line: 16,
	            column: 3
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 14,
	            column: 2
	          },
	          end: {
	            line: 16,
	            column: 3
	          }
	        }, {
	          start: {
	            line: 14,
	            column: 2
	          },
	          end: {
	            line: 16,
	            column: 3
	          }
	        }],
	        line: 14
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 35,
	            column: 4
	          },
	          end: {
	            line: 39,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 35,
	            column: 4
	          },
	          end: {
	            line: 39,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 35,
	            column: 4
	          },
	          end: {
	            line: 39,
	            column: 5
	          }
	        }],
	        line: 35
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 44,
	            column: 4
	          },
	          end: {
	            line: 46,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 44,
	            column: 4
	          },
	          end: {
	            line: 46,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 44,
	            column: 4
	          },
	          end: {
	            line: 46,
	            column: 5
	          }
	        }],
	        line: 44
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 50,
	            column: 4
	          },
	          end: {
	            line: 52,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 50,
	            column: 4
	          },
	          end: {
	            line: 52,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 50,
	            column: 4
	          },
	          end: {
	            line: 52,
	            column: 5
	          }
	        }],
	        line: 50
	      },
	      "4": {
	        loc: {
	          start: {
	            line: 59,
	            column: 6
	          },
	          end: {
	            line: 61,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 59,
	            column: 6
	          },
	          end: {
	            line: 61,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 59,
	            column: 6
	          },
	          end: {
	            line: 61,
	            column: 7
	          }
	        }],
	        line: 59
	      },
	      "5": {
	        loc: {
	          start: {
	            line: 59,
	            column: 10
	          },
	          end: {
	            line: 59,
	            column: 77
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 59,
	            column: 10
	          },
	          end: {
	            line: 59,
	            column: 37
	          }
	        }, {
	          start: {
	            line: 59,
	            column: 41
	          },
	          end: {
	            line: 59,
	            column: 77
	          }
	        }],
	        line: 59
	      },
	      "6": {
	        loc: {
	          start: {
	            line: 93,
	            column: 4
	          },
	          end: {
	            line: 96,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 93,
	            column: 4
	          },
	          end: {
	            line: 96,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 93,
	            column: 4
	          },
	          end: {
	            line: 96,
	            column: 5
	          }
	        }],
	        line: 93
	      },
	      "7": {
	        loc: {
	          start: {
	            line: 93,
	            column: 8
	          },
	          end: {
	            line: 93,
	            column: 39
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 93,
	            column: 8
	          },
	          end: {
	            line: 93,
	            column: 18
	          }
	        }, {
	          start: {
	            line: 93,
	            column: 22
	          },
	          end: {
	            line: 93,
	            column: 39
	          }
	        }],
	        line: 93
	      },
	      "8": {
	        loc: {
	          start: {
	            line: 100,
	            column: 21
	          },
	          end: {
	            line: 100,
	            column: 50
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 100,
	            column: 21
	          },
	          end: {
	            line: 100,
	            column: 44
	          }
	        }, {
	          start: {
	            line: 100,
	            column: 48
	          },
	          end: {
	            line: 100,
	            column: 50
	          }
	        }],
	        line: 100
	      },
	      "9": {
	        loc: {
	          start: {
	            line: 104,
	            column: 4
	          },
	          end: {
	            line: 108,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 104,
	            column: 4
	          },
	          end: {
	            line: 108,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 104,
	            column: 4
	          },
	          end: {
	            line: 108,
	            column: 5
	          }
	        }],
	        line: 104
	      },
	      "10": {
	        loc: {
	          start: {
	            line: 124,
	            column: 4
	          },
	          end: {
	            line: 131,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 124,
	            column: 4
	          },
	          end: {
	            line: 131,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 124,
	            column: 4
	          },
	          end: {
	            line: 131,
	            column: 5
	          }
	        }],
	        line: 124
	      },
	      "11": {
	        loc: {
	          start: {
	            line: 136,
	            column: 4
	          },
	          end: {
	            line: 144,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 136,
	            column: 4
	          },
	          end: {
	            line: 144,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 136,
	            column: 4
	          },
	          end: {
	            line: 144,
	            column: 5
	          }
	        }],
	        line: 136
	      },
	      "12": {
	        loc: {
	          start: {
	            line: 136,
	            column: 8
	          },
	          end: {
	            line: 136,
	            column: 47
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 136,
	            column: 8
	          },
	          end: {
	            line: 136,
	            column: 25
	          }
	        }, {
	          start: {
	            line: 136,
	            column: 29
	          },
	          end: {
	            line: 136,
	            column: 47
	          }
	        }],
	        line: 136
	      },
	      "13": {
	        loc: {
	          start: {
	            line: 141,
	            column: 6
	          },
	          end: {
	            line: 143,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 141,
	            column: 6
	          },
	          end: {
	            line: 143,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 141,
	            column: 6
	          },
	          end: {
	            line: 143,
	            column: 7
	          }
	        }],
	        line: 141
	      },
	      "14": {
	        loc: {
	          start: {
	            line: 163,
	            column: 4
	          },
	          end: {
	            line: 165,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 163,
	            column: 4
	          },
	          end: {
	            line: 165,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 163,
	            column: 4
	          },
	          end: {
	            line: 165,
	            column: 5
	          }
	        }],
	        line: 163
	      },
	      "15": {
	        loc: {
	          start: {
	            line: 172,
	            column: 20
	          },
	          end: {
	            line: 172,
	            column: 44
	          }
	        },
	        type: "binary-expr",
	        locations: [{
	          start: {
	            line: 172,
	            column: 20
	          },
	          end: {
	            line: 172,
	            column: 36
	          }
	        }, {
	          start: {
	            line: 172,
	            column: 40
	          },
	          end: {
	            line: 172,
	            column: 44
	          }
	        }],
	        line: 172
	      },
	      "16": {
	        loc: {
	          start: {
	            line: 199,
	            column: 4
	          },
	          end: {
	            line: 201,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 199,
	            column: 4
	          },
	          end: {
	            line: 201,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 199,
	            column: 4
	          },
	          end: {
	            line: 201,
	            column: 5
	          }
	        }],
	        line: 199
	      },
	      "17": {
	        loc: {
	          start: {
	            line: 211,
	            column: 4
	          },
	          end: {
	            line: 216,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 211,
	            column: 4
	          },
	          end: {
	            line: 216,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 211,
	            column: 4
	          },
	          end: {
	            line: 216,
	            column: 5
	          }
	        }],
	        line: 211
	      },
	      "18": {
	        loc: {
	          start: {
	            line: 219,
	            column: 6
	          },
	          end: {
	            line: 224,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 219,
	            column: 6
	          },
	          end: {
	            line: 224,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 219,
	            column: 6
	          },
	          end: {
	            line: 224,
	            column: 7
	          }
	        }],
	        line: 219
	      },
	      "19": {
	        loc: {
	          start: {
	            line: 233,
	            column: 6
	          },
	          end: {
	            line: 245,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 233,
	            column: 6
	          },
	          end: {
	            line: 245,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 233,
	            column: 6
	          },
	          end: {
	            line: 245,
	            column: 7
	          }
	        }],
	        line: 233
	      },
	      "20": {
	        loc: {
	          start: {
	            line: 235,
	            column: 8
	          },
	          end: {
	            line: 237,
	            column: 9
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 235,
	            column: 8
	          },
	          end: {
	            line: 237,
	            column: 9
	          }
	        }, {
	          start: {
	            line: 235,
	            column: 8
	          },
	          end: {
	            line: 237,
	            column: 9
	          }
	        }],
	        line: 235
	      },
	      "21": {
	        loc: {
	          start: {
	            line: 239,
	            column: 13
	          },
	          end: {
	            line: 245,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 239,
	            column: 13
	          },
	          end: {
	            line: 245,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 239,
	            column: 13
	          },
	          end: {
	            line: 245,
	            column: 7
	          }
	        }],
	        line: 239
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0,
	      "28": 0,
	      "29": 0,
	      "30": 0,
	      "31": 0,
	      "32": 0,
	      "33": 0,
	      "34": 0,
	      "35": 0,
	      "36": 0,
	      "37": 0,
	      "38": 0,
	      "39": 0,
	      "40": 0,
	      "41": 0,
	      "42": 0,
	      "43": 0,
	      "44": 0,
	      "45": 0,
	      "46": 0,
	      "47": 0,
	      "48": 0,
	      "49": 0,
	      "50": 0,
	      "51": 0,
	      "52": 0,
	      "53": 0,
	      "54": 0,
	      "55": 0,
	      "56": 0,
	      "57": 0,
	      "58": 0,
	      "59": 0,
	      "60": 0,
	      "61": 0,
	      "62": 0,
	      "63": 0,
	      "64": 0,
	      "65": 0,
	      "66": 0,
	      "67": 0,
	      "68": 0,
	      "69": 0,
	      "70": 0,
	      "71": 0,
	      "72": 0,
	      "73": 0,
	      "74": 0,
	      "75": 0,
	      "76": 0,
	      "77": 0,
	      "78": 0,
	      "79": 0,
	      "80": 0,
	      "81": 0,
	      "82": 0,
	      "83": 0,
	      "84": 0,
	      "85": 0,
	      "86": 0,
	      "87": 0,
	      "88": 0,
	      "89": 0,
	      "90": 0,
	      "91": 0,
	      "92": 0,
	      "93": 0,
	      "94": 0,
	      "95": 0,
	      "96": 0,
	      "97": 0,
	      "98": 0,
	      "99": 0,
	      "100": 0,
	      "101": 0,
	      "102": 0,
	      "103": 0,
	      "104": 0,
	      "105": 0,
	      "106": 0,
	      "107": 0,
	      "108": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0],
	      "4": [0, 0],
	      "5": [0, 0],
	      "6": [0, 0],
	      "7": [0, 0],
	      "8": [0, 0],
	      "9": [0, 0],
	      "10": [0, 0],
	      "11": [0, 0],
	      "12": [0, 0],
	      "13": [0, 0],
	      "14": [0, 0],
	      "15": [0, 0],
	      "16": [0, 0],
	      "17": [0, 0],
	      "18": [0, 0],
	      "19": [0, 0],
	      "20": [0, 0],
	      "21": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "566dd9e877850f931b64c9732badaa22c5add5c9"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});
	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }
	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_szjn60m9j = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}
	cov_szjn60m9j();
	// so it won't conflict with `vjs-icon-play
	// since it'll get added when we mouse out
	cov_szjn60m9j().s[0]++;
	const addSelectedClass = function (el) {
	  cov_szjn60m9j().f[0]++;
	  cov_szjn60m9j().s[1]++;
	  el.addClass('vjs-selected');
	};
	cov_szjn60m9j().s[2]++;
	const removeSelectedClass = function (el) {
	  cov_szjn60m9j().f[1]++;
	  cov_szjn60m9j().s[3]++;
	  el.removeClass('vjs-selected');
	  cov_szjn60m9j().s[4]++;
	  if (el.thumbnail) {
	    cov_szjn60m9j().b[0][0]++;
	    cov_szjn60m9j().s[5]++;
	    videojs__default["default"].dom.removeClass(el.thumbnail, 'vjs-playlist-now-playing');
	  } else {
	    cov_szjn60m9j().b[0][1]++;
	  }
	};
	cov_szjn60m9j().s[6]++;
	const upNext = function (el) {
	  cov_szjn60m9j().f[2]++;
	  cov_szjn60m9j().s[7]++;
	  el.addClass('vjs-up-next');
	};
	cov_szjn60m9j().s[8]++;
	const notUpNext = function (el) {
	  cov_szjn60m9j().f[3]++;
	  cov_szjn60m9j().s[9]++;
	  el.removeClass('vjs-up-next');
	};
	const Component = (cov_szjn60m9j().s[10]++, videojs__default["default"].getComponent('Component'));
	class PlaylistMenu extends Component {
	  constructor(player, options) {
	    cov_szjn60m9j().f[4]++;
	    cov_szjn60m9j().s[11]++;
	    super(player, options);
	    cov_szjn60m9j().s[12]++;
	    this.items = [];
	    cov_szjn60m9j().s[13]++;
	    if (options.horizontal) {
	      cov_szjn60m9j().b[1][0]++;
	      cov_szjn60m9j().s[14]++;
	      this.addClass('vjs-playlist-horizontal');
	    } else {
	      cov_szjn60m9j().b[1][1]++;
	      cov_szjn60m9j().s[15]++;
	      this.addClass('vjs-playlist-vertical');
	    } // If CSS pointer events aren't supported, we have to prevent
	    // clicking on playlist items during ads with slightly more
	    // invasive techniques. Details in the stylesheet.
	    cov_szjn60m9j().s[16]++;
	    if (options.supportsCssPointerEvents) {
	      cov_szjn60m9j().b[2][0]++;
	      cov_szjn60m9j().s[17]++;
	      this.addClass('vjs-csspointerevents');
	    } else {
	      cov_szjn60m9j().b[2][1]++;
	    }
	    cov_szjn60m9j().s[18]++;
	    this.createPlaylist_();
	    cov_szjn60m9j().s[19]++;
	    if (!videojs__default["default"].browser.TOUCH_ENABLED) {
	      cov_szjn60m9j().b[3][0]++;
	      cov_szjn60m9j().s[20]++;
	      this.addClass('vjs-mouse');
	    } else {
	      cov_szjn60m9j().b[3][1]++;
	    }
	    cov_szjn60m9j().s[21]++;
	    this.on(player, ['loadstart', 'playlistchange', 'playlistsorted'], e => {
	      cov_szjn60m9j().f[5]++;
	      cov_szjn60m9j().s[22]++; // The playlistadd and playlistremove events are handled separately. These
	      // also fire the playlistchange event with an `action` property, so can
	      // exclude them here.
	      if ((cov_szjn60m9j().b[5][0]++, e.type === 'playlistchange') && (cov_szjn60m9j().b[5][1]++, ['add', 'remove'].includes(e.action))) {
	        cov_szjn60m9j().b[4][0]++;
	        cov_szjn60m9j().s[23]++;
	        return;
	      } else {
	        cov_szjn60m9j().b[4][1]++;
	      }
	      cov_szjn60m9j().s[24]++;
	      this.update();
	    });
	    cov_szjn60m9j().s[25]++;
	    this.on(player, ['playlistadd'], e => {
	      cov_szjn60m9j().f[6]++;
	      cov_szjn60m9j().s[26]++;
	      return this.addItems_(e.index, e.count);
	    });
	    cov_szjn60m9j().s[27]++;
	    this.on(player, ['playlistremove'], e => {
	      cov_szjn60m9j().f[7]++;
	      cov_szjn60m9j().s[28]++;
	      return this.removeItems_(e.index, e.count);
	    }); // Keep track of whether an ad is playing so that the menu
	    // appearance can be adapted appropriately
	    cov_szjn60m9j().s[29]++;
	    this.on(player, 'adstart', () => {
	      cov_szjn60m9j().f[8]++;
	      cov_szjn60m9j().s[30]++;
	      this.addClass('vjs-ad-playing');
	    });
	    cov_szjn60m9j().s[31]++;
	    this.on(player, 'adend', () => {
	      cov_szjn60m9j().f[9]++;
	      cov_szjn60m9j().s[32]++;
	      this.removeClass('vjs-ad-playing');
	    });
	    cov_szjn60m9j().s[33]++;
	    this.on('dispose', () => {
	      cov_szjn60m9j().f[10]++;
	      cov_szjn60m9j().s[34]++;
	      this.empty_();
	      cov_szjn60m9j().s[35]++;
	      player.playlistMenu = null;
	    });
	    cov_szjn60m9j().s[36]++;
	    this.on(player, 'dispose', () => {
	      cov_szjn60m9j().f[11]++;
	      cov_szjn60m9j().s[37]++;
	      this.dispose();
	    });
	  }
	  createEl() {
	    cov_szjn60m9j().f[12]++;
	    cov_szjn60m9j().s[38]++;
	    return videojs__default["default"].dom.createEl('div', {
	      className: this.options_.className
	    });
	  }
	  empty_() {
	    cov_szjn60m9j().f[13]++;
	    cov_szjn60m9j().s[39]++;
	    if ((cov_szjn60m9j().b[7][0]++, this.items) && (cov_szjn60m9j().b[7][1]++, this.items.length)) {
	      cov_szjn60m9j().b[6][0]++;
	      cov_szjn60m9j().s[40]++;
	      this.items.forEach(i => {
	        cov_szjn60m9j().f[14]++;
	        cov_szjn60m9j().s[41]++;
	        return i.dispose();
	      });
	      cov_szjn60m9j().s[42]++;
	      this.items.length = 0;
	    } else {
	      cov_szjn60m9j().b[6][1]++;
	    }
	  }
	  createPlaylist_() {
	    cov_szjn60m9j().f[15]++;
	    const playlist = (cov_szjn60m9j().s[43]++, (cov_szjn60m9j().b[8][0]++, this.player_.playlist()) || (cov_szjn60m9j().b[8][1]++, []));
	    let list = (cov_szjn60m9j().s[44]++, this.el_.querySelector('.vjs-playlist-item-list'));
	    let overlay = (cov_szjn60m9j().s[45]++, this.el_.querySelector('.vjs-playlist-ad-overlay'));
	    cov_szjn60m9j().s[46]++;
	    if (!list) {
	      cov_szjn60m9j().b[9][0]++;
	      cov_szjn60m9j().s[47]++;
	      list = document_1.createElement('ol');
	      cov_szjn60m9j().s[48]++;
	      list.className = 'vjs-playlist-item-list';
	      cov_szjn60m9j().s[49]++;
	      this.el_.appendChild(list);
	    } else {
	      cov_szjn60m9j().b[9][1]++;
	    }
	    cov_szjn60m9j().s[50]++;
	    this.empty_(); // create new items
	    cov_szjn60m9j().s[51]++;
	    for (let i = (cov_szjn60m9j().s[52]++, 0); i < playlist.length; i++) {
	      const item = (cov_szjn60m9j().s[53]++, new PlaylistMenuItem(this.player_, {
	        item: playlist[i]
	      }, this.options_));
	      cov_szjn60m9j().s[54]++;
	      this.items.push(item);
	      cov_szjn60m9j().s[55]++;
	      list.appendChild(item.el_);
	    } // Inject the ad overlay. We use this element to block clicks during ad
	    // playback and darken the menu to indicate inactivity
	    cov_szjn60m9j().s[56]++;
	    if (!overlay) {
	      cov_szjn60m9j().b[10][0]++;
	      cov_szjn60m9j().s[57]++;
	      overlay = document_1.createElement('li');
	      cov_szjn60m9j().s[58]++;
	      overlay.className = 'vjs-playlist-ad-overlay';
	      cov_szjn60m9j().s[59]++;
	      list.appendChild(overlay);
	    } else {
	      cov_szjn60m9j().b[10][1]++;
	      cov_szjn60m9j().s[60]++; // Move overlay to end of list
	      list.appendChild(overlay);
	    } // select the current playlist item
	    const selectedIndex = (cov_szjn60m9j().s[61]++, this.player_.playlist.currentItem());
	    cov_szjn60m9j().s[62]++;
	    if ((cov_szjn60m9j().b[12][0]++, this.items.length) && (cov_szjn60m9j().b[12][1]++, selectedIndex >= 0)) {
	      cov_szjn60m9j().b[11][0]++;
	      cov_szjn60m9j().s[63]++;
	      addSelectedClass(this.items[selectedIndex]);
	      const thumbnail = (cov_szjn60m9j().s[64]++, this.items[selectedIndex].$('.vjs-playlist-thumbnail'));
	      cov_szjn60m9j().s[65]++;
	      if (thumbnail) {
	        cov_szjn60m9j().b[13][0]++;
	        cov_szjn60m9j().s[66]++;
	        videojs__default["default"].dom.addClass(thumbnail, 'vjs-playlist-now-playing');
	      } else {
	        cov_szjn60m9j().b[13][1]++;
	      }
	    } else {
	      cov_szjn60m9j().b[11][1]++;
	    }
	  } /**
	    * Adds a number of playlist items to the UI.
	    *
	    * Each item that was added to the underlying playlist in a certain range
	    * has a new PlaylistMenuItem created for it.
	    *
	    * @param  {number} index
	    *         The index at which to start adding items.
	    *
	    * @param  {number} count
	    *         The number of items to add.
	    */
	  addItems_(index, count) {
	    cov_szjn60m9j().f[16]++;
	    const playlist = (cov_szjn60m9j().s[67]++, this.player_.playlist());
	    const items = (cov_szjn60m9j().s[68]++, playlist.slice(index, count + index));
	    cov_szjn60m9j().s[69]++;
	    if (!items.length) {
	      cov_szjn60m9j().b[14][0]++;
	      cov_szjn60m9j().s[70]++;
	      return;
	    } else {
	      cov_szjn60m9j().b[14][1]++;
	    }
	    const listEl = (cov_szjn60m9j().s[71]++, this.el_.querySelector('.vjs-playlist-item-list'));
	    const listNodes = (cov_szjn60m9j().s[72]++, this.el_.querySelectorAll('.vjs-playlist-item')); // When appending to the list, `insertBefore` will only reliably accept
	    // `null` as the second argument, so we need to explicitly fall back to it.
	    const refNode = (cov_szjn60m9j().s[73]++, (cov_szjn60m9j().b[15][0]++, listNodes[index]) || (cov_szjn60m9j().b[15][1]++, null));
	    const menuItems = (cov_szjn60m9j().s[74]++, items.map(item => {
	      cov_szjn60m9j().f[17]++;
	      const menuItem = (cov_szjn60m9j().s[75]++, new PlaylistMenuItem(this.player_, {
	        item
	      }, this.options_));
	      cov_szjn60m9j().s[76]++;
	      listEl.insertBefore(menuItem.el_, refNode);
	      cov_szjn60m9j().s[77]++;
	      return menuItem;
	    }));
	    cov_szjn60m9j().s[78]++;
	    this.items.splice(index, 0, ...menuItems);
	  } /**
	    * Removes a number of playlist items from the UI.
	    *
	    * Each PlaylistMenuItem component is disposed properly.
	    *
	    * @param  {number} index
	    *         The index at which to start removing items.
	    *
	    * @param  {number} count
	    *         The number of items to remove.
	    */
	  removeItems_(index, count) {
	    cov_szjn60m9j().f[18]++;
	    const components = (cov_szjn60m9j().s[79]++, this.items.slice(index, count + index));
	    cov_szjn60m9j().s[80]++;
	    if (!components.length) {
	      cov_szjn60m9j().b[16][0]++;
	      cov_szjn60m9j().s[81]++;
	      return;
	    } else {
	      cov_szjn60m9j().b[16][1]++;
	    }
	    cov_szjn60m9j().s[82]++;
	    components.forEach(c => {
	      cov_szjn60m9j().f[19]++;
	      cov_szjn60m9j().s[83]++;
	      return c.dispose();
	    });
	    cov_szjn60m9j().s[84]++;
	    this.items.splice(index, count);
	  }
	  update() {
	    cov_szjn60m9j().f[20]++; // replace the playlist items being displayed, if necessary
	    const playlist = (cov_szjn60m9j().s[85]++, this.player_.playlist());
	    cov_szjn60m9j().s[86]++;
	    if (this.items.length !== playlist.length) {
	      cov_szjn60m9j().b[17][0]++;
	      cov_szjn60m9j().s[87]++; // if the menu is currently empty or the state is obviously out
	      // of date, rebuild everything.
	      this.createPlaylist_();
	      cov_szjn60m9j().s[88]++;
	      return;
	    } else {
	      cov_szjn60m9j().b[17][1]++;
	    }
	    cov_szjn60m9j().s[89]++;
	    for (let i = (cov_szjn60m9j().s[90]++, 0); i < this.items.length; i++) {
	      cov_szjn60m9j().s[91]++;
	      if (this.items[i].item !== playlist[i]) {
	        cov_szjn60m9j().b[18][0]++;
	        cov_szjn60m9j().s[92]++; // if any of the playlist items have changed, rebuild the
	        // entire playlist
	        this.createPlaylist_();
	        cov_szjn60m9j().s[93]++;
	        return;
	      } else {
	        cov_szjn60m9j().b[18][1]++;
	      }
	    } // the playlist itself is unchanged so just update the selection
	    const currentItem = (cov_szjn60m9j().s[94]++, this.player_.playlist.currentItem());
	    cov_szjn60m9j().s[95]++;
	    for (let i = (cov_szjn60m9j().s[96]++, 0); i < this.items.length; i++) {
	      const item = (cov_szjn60m9j().s[97]++, this.items[i]);
	      cov_szjn60m9j().s[98]++;
	      if (i === currentItem) {
	        cov_szjn60m9j().b[19][0]++;
	        cov_szjn60m9j().s[99]++;
	        addSelectedClass(item);
	        cov_szjn60m9j().s[100]++;
	        if (document_1.activeElement !== item.el()) {
	          cov_szjn60m9j().b[20][0]++;
	          cov_szjn60m9j().s[101]++;
	          videojs__default["default"].dom.addClass(item.thumbnail, 'vjs-playlist-now-playing');
	        } else {
	          cov_szjn60m9j().b[20][1]++;
	        }
	        cov_szjn60m9j().s[102]++;
	        notUpNext(item);
	      } else {
	        cov_szjn60m9j().b[19][1]++;
	        cov_szjn60m9j().s[103]++;
	        if (i === currentItem + 1) {
	          cov_szjn60m9j().b[21][0]++;
	          cov_szjn60m9j().s[104]++;
	          removeSelectedClass(item);
	          cov_szjn60m9j().s[105]++;
	          upNext(item);
	        } else {
	          cov_szjn60m9j().b[21][1]++;
	          cov_szjn60m9j().s[106]++;
	          removeSelectedClass(item);
	          cov_szjn60m9j().s[107]++;
	          notUpNext(item);
	        }
	      }
	    }
	  }
	}
	cov_szjn60m9j().s[108]++;
	videojs__default["default"].registerComponent('PlaylistMenu', PlaylistMenu);

	function cov_1wu0dhrxa3() {
	  var path = "/Users/poneill/dev/videojs-playlist-ui/src/plugin.js";
	  var hash = "8bad79100979367823b99fdcdb42d070474d954d";
	  var global = new Function("return this")();
	  var gcv = "__coverage__";
	  var coverageData = {
	    path: "/Users/poneill/dev/videojs-playlist-ui/src/plugin.js",
	    statementMap: {
	      "0": {
	        start: {
	          line: 7,
	          column: 33
	        },
	        end: {
	          line: 12,
	          column: 4
	        }
	      },
	      "1": {
	        start: {
	          line: 8,
	          column: 18
	        },
	        end: {
	          line: 8,
	          column: 45
	        }
	      },
	      "2": {
	        start: {
	          line: 10,
	          column: 2
	        },
	        end: {
	          line: 10,
	          column: 48
	        }
	      },
	      "3": {
	        start: {
	          line: 11,
	          column: 2
	        },
	        end: {
	          line: 11,
	          column: 48
	        }
	      },
	      "4": {
	        start: {
	          line: 14,
	          column: 17
	        },
	        end: {
	          line: 18,
	          column: 1
	        }
	      },
	      "5": {
	        start: {
	          line: 20,
	          column: 15
	        },
	        end: {
	          line: 20,
	          column: 42
	        }
	      },
	      "6": {
	        start: {
	          line: 41,
	          column: 4
	        },
	        end: {
	          line: 41,
	          column: 27
	        }
	      },
	      "7": {
	        start: {
	          line: 43,
	          column: 4
	        },
	        end: {
	          line: 46,
	          column: 5
	        }
	      },
	      "8": {
	        start: {
	          line: 44,
	          column: 6
	        },
	        end: {
	          line: 44,
	          column: 96
	        }
	      },
	      "9": {
	        start: {
	          line: 45,
	          column: 6
	        },
	        end: {
	          line: 45,
	          column: 13
	        }
	      },
	      "10": {
	        start: {
	          line: 48,
	          column: 4
	        },
	        end: {
	          line: 48,
	          column: 67
	        }
	      },
	      "11": {
	        start: {
	          line: 50,
	          column: 4
	        },
	        end: {
	          line: 52,
	          column: 5
	        }
	      },
	      "12": {
	        start: {
	          line: 51,
	          column: 6
	        },
	        end: {
	          line: 51,
	          column: 53
	        }
	      },
	      "13": {
	        start: {
	          line: 57,
	          column: 4
	        },
	        end: {
	          line: 57,
	          column: 80
	        }
	      },
	      "14": {
	        start: {
	          line: 64,
	          column: 4
	        },
	        end: {
	          line: 64,
	          column: 20
	        }
	      },
	      "15": {
	        start: {
	          line: 65,
	          column: 4
	        },
	        end: {
	          line: 65,
	          column: 32
	        }
	      },
	      "16": {
	        start: {
	          line: 80,
	          column: 4
	        },
	        end: {
	          line: 84,
	          column: 5
	        }
	      },
	      "17": {
	        start: {
	          line: 80,
	          column: 17
	        },
	        end: {
	          line: 80,
	          column: 18
	        }
	      },
	      "18": {
	        start: {
	          line: 81,
	          column: 6
	        },
	        end: {
	          line: 83,
	          column: 7
	        }
	      },
	      "19": {
	        start: {
	          line: 82,
	          column: 8
	        },
	        end: {
	          line: 82,
	          column: 20
	        }
	      },
	      "20": {
	        start: {
	          line: 85,
	          column: 4
	        },
	        end: {
	          line: 85,
	          column: 17
	        }
	      },
	      "21": {
	        start: {
	          line: 98,
	          column: 16
	        },
	        end: {
	          line: 98,
	          column: 58
	        }
	      },
	      "22": {
	        start: {
	          line: 100,
	          column: 4
	        },
	        end: {
	          line: 104,
	          column: 5
	        }
	      },
	      "23": {
	        start: {
	          line: 100,
	          column: 17
	        },
	        end: {
	          line: 100,
	          column: 18
	        }
	      },
	      "24": {
	        start: {
	          line: 101,
	          column: 6
	        },
	        end: {
	          line: 103,
	          column: 7
	        }
	      },
	      "25": {
	        start: {
	          line: 102,
	          column: 8
	        },
	        end: {
	          line: 102,
	          column: 22
	        }
	      },
	      "26": {
	        start: {
	          line: 108,
	          column: 0
	        },
	        end: {
	          line: 108,
	          column: 49
	        }
	      },
	      "27": {
	        start: {
	          line: 110,
	          column: 0
	        },
	        end: {
	          line: 110,
	          column: 29
	        }
	      }
	    },
	    fnMap: {
	      "0": {
	        name: "(anonymous_0)",
	        decl: {
	          start: {
	            line: 7,
	            column: 34
	          },
	          end: {
	            line: 7,
	            column: 35
	          }
	        },
	        loc: {
	          start: {
	            line: 7,
	            column: 40
	          },
	          end: {
	            line: 12,
	            column: 1
	          }
	        },
	        line: 7
	      },
	      "1": {
	        name: "(anonymous_1)",
	        decl: {
	          start: {
	            line: 40,
	            column: 2
	          },
	          end: {
	            line: 40,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 40,
	            column: 31
	          },
	          end: {
	            line: 58,
	            column: 3
	          }
	        },
	        line: 40
	      },
	      "2": {
	        name: "(anonymous_2)",
	        decl: {
	          start: {
	            line: 63,
	            column: 2
	          },
	          end: {
	            line: 63,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 63,
	            column: 12
	          },
	          end: {
	            line: 66,
	            column: 3
	          }
	        },
	        line: 63
	      },
	      "3": {
	        name: "(anonymous_3)",
	        decl: {
	          start: {
	            line: 79,
	            column: 2
	          },
	          end: {
	            line: 79,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 79,
	            column: 19
	          },
	          end: {
	            line: 86,
	            column: 3
	          }
	        },
	        line: 79
	      },
	      "4": {
	        name: "(anonymous_4)",
	        decl: {
	          start: {
	            line: 97,
	            column: 2
	          },
	          end: {
	            line: 97,
	            column: 3
	          }
	        },
	        loc: {
	          start: {
	            line: 97,
	            column: 23
	          },
	          end: {
	            line: 105,
	            column: 3
	          }
	        },
	        line: 97
	      }
	    },
	    branchMap: {
	      "0": {
	        loc: {
	          start: {
	            line: 43,
	            column: 4
	          },
	          end: {
	            line: 46,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 43,
	            column: 4
	          },
	          end: {
	            line: 46,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 43,
	            column: 4
	          },
	          end: {
	            line: 46,
	            column: 5
	          }
	        }],
	        line: 43
	      },
	      "1": {
	        loc: {
	          start: {
	            line: 50,
	            column: 4
	          },
	          end: {
	            line: 52,
	            column: 5
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 50,
	            column: 4
	          },
	          end: {
	            line: 52,
	            column: 5
	          }
	        }, {
	          start: {
	            line: 50,
	            column: 4
	          },
	          end: {
	            line: 52,
	            column: 5
	          }
	        }],
	        line: 50
	      },
	      "2": {
	        loc: {
	          start: {
	            line: 81,
	            column: 6
	          },
	          end: {
	            line: 83,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 81,
	            column: 6
	          },
	          end: {
	            line: 83,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 81,
	            column: 6
	          },
	          end: {
	            line: 83,
	            column: 7
	          }
	        }],
	        line: 81
	      },
	      "3": {
	        loc: {
	          start: {
	            line: 101,
	            column: 6
	          },
	          end: {
	            line: 103,
	            column: 7
	          }
	        },
	        type: "if",
	        locations: [{
	          start: {
	            line: 101,
	            column: 6
	          },
	          end: {
	            line: 103,
	            column: 7
	          }
	        }, {
	          start: {
	            line: 101,
	            column: 6
	          },
	          end: {
	            line: 103,
	            column: 7
	          }
	        }],
	        line: 101
	      }
	    },
	    s: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0,
	      "5": 0,
	      "6": 0,
	      "7": 0,
	      "8": 0,
	      "9": 0,
	      "10": 0,
	      "11": 0,
	      "12": 0,
	      "13": 0,
	      "14": 0,
	      "15": 0,
	      "16": 0,
	      "17": 0,
	      "18": 0,
	      "19": 0,
	      "20": 0,
	      "21": 0,
	      "22": 0,
	      "23": 0,
	      "24": 0,
	      "25": 0,
	      "26": 0,
	      "27": 0
	    },
	    f: {
	      "0": 0,
	      "1": 0,
	      "2": 0,
	      "3": 0,
	      "4": 0
	    },
	    b: {
	      "0": [0, 0],
	      "1": [0, 0],
	      "2": [0, 0],
	      "3": [0, 0]
	    },
	    _coverageSchema: "1a1c01bbd47fc00a2c39e90264f33305004495a9",
	    hash: "8bad79100979367823b99fdcdb42d070474d954d"
	  };
	  var coverage = global[gcv] || (global[gcv] = {});
	  if (!coverage[path] || coverage[path].hash !== hash) {
	    coverage[path] = coverageData;
	  }
	  var actualCoverage = coverage[path];
	  {
	    // @ts-ignore
	    cov_1wu0dhrxa3 = function () {
	      return actualCoverage;
	    };
	  }
	  return actualCoverage;
	}
	cov_1wu0dhrxa3();
	const supportsCssPointerEvents = (cov_1wu0dhrxa3().s[0]++, (() => {
	  cov_1wu0dhrxa3().f[0]++;
	  const element = (cov_1wu0dhrxa3().s[1]++, document_1.createElement('x'));
	  cov_1wu0dhrxa3().s[2]++;
	  element.style.cssText = 'pointer-events:auto';
	  cov_1wu0dhrxa3().s[3]++;
	  return element.style.pointerEvents === 'auto';
	})());
	const defaults = (cov_1wu0dhrxa3().s[4]++, {
	  className: 'vjs-playlist',
	  playOnSelect: false,
	  supportsCssPointerEvents
	});
	const Plugin = (cov_1wu0dhrxa3().s[5]++, videojs__default["default"].getPlugin('plugin')); /**
	                                                                       * Initialize the plugin on a player.
	                                                                       *
	                                                                       * @param  {Object} [options]
	                                                                       *         An options object.
	                                                                       *
	                                                                       * @param  {HTMLElement} [options.el]
	                                                                       *         A DOM element to use as a root node for the playlist.
	                                                                       *
	                                                                       * @param  {string} [options.className]
	                                                                       *         An HTML class name to use to find a root node for the playlist.
	                                                                       *
	                                                                       * @param  {boolean} [options.playOnSelect = false]
	                                                                       *         If true, will attempt to begin playback upon selecting a new
	                                                                       *         playlist item in the UI.
	                                                                       */
	class PlaylistUI extends Plugin {
	  constructor(player, options) {
	    cov_1wu0dhrxa3().f[1]++;
	    cov_1wu0dhrxa3().s[6]++;
	    super(player, options);
	    cov_1wu0dhrxa3().s[7]++;
	    if (!player.usingPlugin('playlist')) {
	      cov_1wu0dhrxa3().b[0][0]++;
	      cov_1wu0dhrxa3().s[8]++;
	      player.log.error('videojs-playlist plugin is required by the videojs-playlist-ui plugin');
	      cov_1wu0dhrxa3().s[9]++;
	      return;
	    } else {
	      cov_1wu0dhrxa3().b[0][1]++;
	    }
	    cov_1wu0dhrxa3().s[10]++;
	    options = this.options_ = videojs__default["default"].obj.merge(defaults, options);
	    cov_1wu0dhrxa3().s[11]++;
	    if (!videojs__default["default"].dom.isEl(options.el)) {
	      cov_1wu0dhrxa3().b[1][0]++;
	      cov_1wu0dhrxa3().s[12]++;
	      options.el = this.findRoot_(options.className);
	    } else {
	      cov_1wu0dhrxa3().b[1][1]++;
	    } // Expose the playlist menu component on the player as well as the plugin
	    // This is a bit of an anti-pattern, but it's been that way forever and
	    // there are likely to be integrations relying on it.
	    cov_1wu0dhrxa3().s[13]++;
	    this.playlistMenu = player.playlistMenu = new PlaylistMenu(player, options);
	  } /**
	    * Dispose the plugin.
	    */
	  dispose() {
	    cov_1wu0dhrxa3().f[2]++;
	    cov_1wu0dhrxa3().s[14]++;
	    super.dispose();
	    cov_1wu0dhrxa3().s[15]++;
	    this.playlistMenu.dispose();
	  } /**
	    * Returns a boolean indicating whether an element has child elements.
	    *
	    * Note that this is distinct from whether it has child _nodes_.
	    *
	    * @param  {HTMLElement} el
	    *         A DOM element.
	    *
	    * @return {boolean}
	    *         Whether the element has child elements.
	    */
	  hasChildEls_(el) {
	    cov_1wu0dhrxa3().f[3]++;
	    cov_1wu0dhrxa3().s[16]++;
	    for (let i = (cov_1wu0dhrxa3().s[17]++, 0); i < el.childNodes.length; i++) {
	      cov_1wu0dhrxa3().s[18]++;
	      if (videojs__default["default"].dom.isEl(el.childNodes[i])) {
	        cov_1wu0dhrxa3().b[2][0]++;
	        cov_1wu0dhrxa3().s[19]++;
	        return true;
	      } else {
	        cov_1wu0dhrxa3().b[2][1]++;
	      }
	    }
	    cov_1wu0dhrxa3().s[20]++;
	    return false;
	  } /**
	    * Finds the first empty root element.
	    *
	    * @param  {string} className
	    *         An HTML class name to search for.
	    *
	    * @return {HTMLElement}
	    *         A DOM element to use as the root for a playlist.
	    */
	  findRoot_(className) {
	    cov_1wu0dhrxa3().f[4]++;
	    const all = (cov_1wu0dhrxa3().s[21]++, document_1.querySelectorAll('.' + className));
	    cov_1wu0dhrxa3().s[22]++;
	    for (let i = (cov_1wu0dhrxa3().s[23]++, 0); i < all.length; i++) {
	      cov_1wu0dhrxa3().s[24]++;
	      if (!this.hasChildEls_(all[i])) {
	        cov_1wu0dhrxa3().b[3][0]++;
	        cov_1wu0dhrxa3().s[25]++;
	        return all[i];
	      } else {
	        cov_1wu0dhrxa3().b[3][1]++;
	      }
	    }
	  }
	}
	cov_1wu0dhrxa3().s[26]++;
	videojs__default["default"].registerPlugin('playlistUi', PlaylistUI);
	cov_1wu0dhrxa3().s[27]++;
	PlaylistUI.VERSION = version;

	/* eslint-disable no-console */
	const playlist = [{
	  name: 'Movie 1',
	  description: 'Movie 1 description',
	  duration: 100,
	  data: {
	    id: '1',
	    foo: 'bar'
	  },
	  sources: [{
	    src: '//example.com/movie1.mp4',
	    type: 'video/mp4'
	  }]
	}, {
	  sources: [{
	    src: '//example.com/movie2.mp4',
	    type: 'video/mp4'
	  }],
	  thumbnail: '//example.com/movie2.jpg'
	}];
	const resolveUrl = url => {
	  const a = document_1.createElement('a');
	  a.href = url;
	  return a.href;
	};
	const Html5 = videojs__default["default"].getTech('Html5');
	QUnit__default["default"].test('the environment is sane', function (assert) {
	  assert.ok(true, 'everything is swell');
	});
	function setup() {
	  this.oldVideojsBrowser = videojs__default["default"].browser;
	  videojs__default["default"].browser = videojs__default["default"].obj.merge({}, videojs__default["default"].browser);
	  this.fixture = document_1.querySelector('#qunit-fixture');

	  // force HTML support so the tests run in a reasonable
	  // environment under phantomjs
	  this.realIsHtmlSupported = Html5.isSupported;
	  Html5.isSupported = function () {
	    return true;
	  };

	  // create a video element
	  const video = document_1.createElement('video');
	  this.fixture.appendChild(video);

	  // create a video.js player
	  this.player = videojs__default["default"](video);

	  // Create two playlist container elements.
	  this.fixture.appendChild(videojs__default["default"].dom.createEl('div', {
	    className: 'vjs-playlist'
	  }));
	  this.fixture.appendChild(videojs__default["default"].dom.createEl('div', {
	    className: 'vjs-playlist'
	  }));
	}
	function teardown() {
	  videojs__default["default"].browser = this.oldVideojsBrowser;
	  Html5.isSupported = this.realIsHtmlSupported;
	  this.player.dispose();
	  this.player = null;
	  videojs__default["default"].dom.emptyEl(this.fixture);
	}
	QUnit__default["default"].module('videojs-playlist-ui', {
	  beforeEach: setup,
	  afterEach: teardown
	});
	QUnit__default["default"].test('registers itself', function (assert) {
	  assert.ok(this.player.playlistUi, 'registered the plugin');
	});
	QUnit__default["default"].test('errors if used without the playlist plugin', function (assert) {
	  sinon__default["default"].spy(this.player.log, 'error');
	  this.player.playlist = null;
	  this.player.playlistUi();
	  assert.ok(this.player.log.error.calledOnce, 'player.log.error was called');
	});
	QUnit__default["default"].test('is empty if the playlist plugin isn\'t initialized', function (assert) {
	  this.player.playlistUi();
	  const items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.ok(this.fixture.querySelector('.vjs-playlist'), 'created the menu');
	  assert.strictEqual(items.length, 0, 'displayed no items');
	});
	QUnit__default["default"].test('can be initialized with an element', function (assert) {
	  const elem = videojs__default["default"].dom.createEl('div');
	  this.player.playlist(playlist);
	  this.player.playlistUi({
	    el: elem
	  });
	  assert.strictEqual(elem.querySelectorAll('li.vjs-playlist-item').length, playlist.length, 'created an element for each playlist item');
	});
	QUnit__default["default"].test('can look for an element with the class "vjs-playlist" that is not already in use', function (assert) {
	  const firstEl = this.fixture.querySelectorAll('.vjs-playlist')[0];
	  const secondEl = this.fixture.querySelectorAll('.vjs-playlist')[1];

	  // Give the firstEl a child, so the plugin thinks it is in use and moves on
	  // to the next one.
	  firstEl.appendChild(videojs__default["default"].dom.createEl('div'));
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  assert.strictEqual(this.player.playlistMenu.el(), secondEl, 'used the first matching/empty element');
	  assert.strictEqual(secondEl.querySelectorAll('li.vjs-playlist-item').length, playlist.length, 'found an element for each playlist item');
	});
	QUnit__default["default"].test('can look for an element with a custom class that is not already in use', function (assert) {
	  const firstEl = videojs__default["default"].dom.createEl('div', {
	    className: 'super-playlist'
	  });
	  const secondEl = videojs__default["default"].dom.createEl('div', {
	    className: 'super-playlist'
	  });

	  // Give the firstEl a child, so the plugin thinks it is in use and moves on
	  // to the next one.
	  firstEl.appendChild(videojs__default["default"].dom.createEl('div'));
	  this.fixture.appendChild(firstEl);
	  this.fixture.appendChild(secondEl);
	  this.player.playlist(playlist);
	  this.player.playlistUi({
	    className: 'super-playlist'
	  });
	  assert.strictEqual(this.player.playlistMenu.el(), secondEl, 'used the first matching/empty element');
	  assert.strictEqual(this.fixture.querySelectorAll('li.vjs-playlist-item').length, playlist.length, 'created an element for each playlist item');
	});
	QUnit__default["default"].test('specializes the class name if touch input is absent', function (assert) {
	  videojs__default["default"].browser.TOUCH_ENABLED = false;
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  assert.ok(this.player.playlistMenu.hasClass('vjs-mouse'), 'marked the playlist menu');
	});
	QUnit__default["default"].test('can be re-initialized without doubling the contents of the list', function (assert) {
	  const el = this.fixture.querySelectorAll('.vjs-playlist')[0];
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  this.player.playlistUi();
	  this.player.playlistUi();
	  assert.strictEqual(this.player.playlistMenu.el(), el, 'used the first matching/empty element');
	  assert.strictEqual(el.querySelectorAll('li.vjs-playlist-item').length, playlist.length, 'found an element for each playlist item');
	});
	QUnit__default["default"].module('videojs-playlist-ui: Components', {
	  beforeEach: setup,
	  afterEach: teardown
	});

	// --------------------
	// Creation and Updates
	// --------------------

	QUnit__default["default"].test('includes the video name if provided', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  const items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items[0].querySelector('.vjs-playlist-name').textContent, playlist[0].name, 'wrote the name');
	  assert.strictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Untitled Video', 'wrote a placeholder for the name');
	});
	QUnit__default["default"].test('includes the video description if user specifies it', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi({
	    showDescription: true
	  });
	  const items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items[0].querySelector('.vjs-playlist-description').textContent, playlist[0].description, 'description is displayed');
	});
	QUnit__default["default"].test('hides video description by default', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  const items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items[0].querySelector('.vjs-playlist-description'), null, 'description is not displayed');
	});
	QUnit__default["default"].test('includes custom data attribute if provided', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  const items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items[0].dataset.id, playlist[0].data.id, 'set a single data attribute');
	  assert.strictEqual(items[0].dataset.id, '1', 'set a single data attribute (actual value)');
	  assert.strictEqual(items[0].dataset.foo, playlist[0].data.foo, 'set an addtional data attribute');
	  assert.strictEqual(items[0].dataset.foo, 'bar', 'set an addtional data attribute');
	});
	QUnit__default["default"].test('outputs a <picture> for simple thumbnails', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  const pictures = this.fixture.querySelectorAll('.vjs-playlist-item picture');
	  assert.strictEqual(pictures.length, 1, 'output one picture');
	  const imgs = pictures[0].querySelectorAll('img');
	  assert.strictEqual(imgs.length, 1, 'output one img');
	  assert.strictEqual(imgs[0].src, window_1.location.protocol + playlist[1].thumbnail, 'set the src attribute');
	});
	QUnit__default["default"].test('outputs a <picture> for responsive thumbnails', function (assert) {
	  const playlistOverride = [{
	    sources: [{
	      src: '//example.com/movie.mp4',
	      type: 'video/mp4'
	    }],
	    thumbnail: [{
	      srcset: '/test/example/oceans.jpg',
	      type: 'image/jpeg',
	      media: '(min-width: 400px;)'
	    }, {
	      src: '/test/example/oceans-low.jpg'
	    }]
	  }];
	  this.player.playlist(playlistOverride);
	  this.player.playlistUi();
	  const sources = this.fixture.querySelectorAll('.vjs-playlist-item picture source');
	  const imgs = this.fixture.querySelectorAll('.vjs-playlist-item picture img');
	  assert.strictEqual(sources.length, 1, 'output one source');
	  assert.strictEqual(sources[0].srcset, playlistOverride[0].thumbnail[0].srcset, 'wrote the srcset attribute');
	  assert.strictEqual(sources[0].type, playlistOverride[0].thumbnail[0].type, 'wrote the type attribute');
	  assert.strictEqual(sources[0].media, playlistOverride[0].thumbnail[0].media, 'wrote the type attribute');
	  assert.strictEqual(imgs.length, 1, 'output one img');
	  assert.strictEqual(imgs[0].src, resolveUrl(playlistOverride[0].thumbnail[1].src), 'output the img src attribute');
	});
	QUnit__default["default"].test('outputs a placeholder for items without thumbnails', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  const thumbnails = this.fixture.querySelectorAll('.vjs-playlist-item .vjs-playlist-thumbnail');
	  assert.strictEqual(thumbnails.length, playlist.length, 'output two thumbnails');
	  assert.strictEqual(thumbnails[0].nodeName.toLowerCase(), 'div', 'the second is a placeholder');
	});
	QUnit__default["default"].test('includes the duration if one is provided', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  const durations = this.fixture.querySelectorAll('.vjs-playlist-item .vjs-playlist-duration');
	  assert.strictEqual(durations.length, 1, 'skipped the item without a duration');
	  assert.strictEqual(durations[0].textContent, '1:40', 'wrote the duration');
	  assert.strictEqual(durations[0].getAttribute('datetime'), 'PT0H0M' + playlist[0].duration + 'S', 'wrote a machine-readable datetime');
	});
	QUnit__default["default"].test('marks the selected playlist item on startup', function (assert) {
	  this.player.playlist(playlist);
	  this.player.currentSrc = () => playlist[0].sources[0].src;
	  this.player.playlistUi();
	  const selectedItems = this.fixture.querySelectorAll('.vjs-playlist-item.vjs-selected');
	  assert.strictEqual(selectedItems.length, 1, 'marked one playlist item');
	  assert.strictEqual(selectedItems[0].querySelector('.vjs-playlist-name').textContent, playlist[0].name, 'marked the first playlist item');
	});
	QUnit__default["default"].test('updates the selected playlist item on loadstart', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  this.player.playlist.currentItem(1);
	  this.player.currentSrc = () => playlist[1].sources[0].src;
	  this.player.trigger('loadstart');
	  const selectedItems = this.fixture.querySelectorAll('.vjs-playlist-item.vjs-selected');
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist-item').length, playlist.length, 'displayed the correct number of items');
	  assert.strictEqual(selectedItems.length, 1, 'marked one playlist item');
	  assert.strictEqual(selectedItems[0].querySelector('img').src, resolveUrl(playlist[1].thumbnail), 'marked the second playlist item');
	});
	QUnit__default["default"].test('selects no item if the playlist is not in use', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlist.currentItem = () => -1;
	  this.player.playlistUi();
	  this.player.trigger('loadstart');
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist-item.vjs-selected').length, 0, 'no items selected');
	});
	QUnit__default["default"].test('updates on "playlistchange", different lengths', function (assert) {
	  this.player.playlist([]);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 0, 'no items initially');
	  this.player.playlist(playlist);
	  this.player.trigger('playlistchange');
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'updated with the new items');
	});
	QUnit__default["default"].test('updates on "playlistchange", equal lengths', function (assert) {
	  this.player.playlist([{
	    sources: []
	  }, {
	    sources: []
	  }]);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist(playlist);
	  this.player.trigger('playlistchange');
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'updated with the new items');
	  assert.strictEqual(this.player.playlistMenu.items[0].item, playlist[0], 'we have updated items');
	  assert.strictEqual(this.player.playlistMenu.items[1].item, playlist[1], 'we have updated items');
	});
	QUnit__default["default"].test('updates on "playlistchange", update selection', function (assert) {
	  this.player.playlist(playlist);
	  this.player.currentSrc = function () {
	    return playlist[0].sources[0].src;
	  };
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  assert.ok(/vjs-selected/.test(items[0].getAttribute('class')), 'first item is selected by default');
	  this.player.playlist.currentItem(1);
	  this.player.currentSrc = function () {
	    return playlist[1].sources[0].src;
	  };
	  this.player.trigger('playlistchange');
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'updated with the new items');
	  assert.ok(/vjs-selected/.test(items[1].getAttribute('class')), 'second item is selected after update');
	  assert.ok(!/vjs-selected/.test(items[0].getAttribute('class')), 'first item is not selected after update');
	});
	QUnit__default["default"].test('updates on "playlistsorted", different lengths', function (assert) {
	  this.player.playlist([]);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 0, 'no items initially');
	  this.player.playlist(playlist);
	  this.player.trigger('playlistsorted');
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'updated with the new items');
	});
	QUnit__default["default"].test('updates on "playlistsorted", equal lengths', function (assert) {
	  this.player.playlist([{
	    sources: []
	  }, {
	    sources: []
	  }]);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist(playlist);
	  this.player.trigger('playlistsorted');
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'updated with the new items');
	  assert.strictEqual(this.player.playlistMenu.items[0].item, playlist[0], 'we have updated items');
	  assert.strictEqual(this.player.playlistMenu.items[1].item, playlist[1], 'we have updated items');
	});
	QUnit__default["default"].test('updates on "playlistsorted", update selection', function (assert) {
	  this.player.playlist(playlist);
	  this.player.currentSrc = function () {
	    return playlist[0].sources[0].src;
	  };
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  assert.ok(/vjs-selected/.test(items[0].getAttribute('class')), 'first item is selected by default');
	  this.player.playlist.currentItem(1);
	  this.player.currentSrc = function () {
	    return playlist[1].sources[0].src;
	  };
	  this.player.trigger('playlistsorted');
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'updated with the new items');
	  assert.ok(/vjs-selected/.test(items[1].getAttribute('class')), 'second item is selected after update');
	  assert.ok(!/vjs-selected/.test(items[0].getAttribute('class')), 'first item is not selected after update');
	});
	QUnit__default["default"].test('tracks when an ad is playing', function (assert) {
	  this.player.playlist([]);
	  this.player.playlistUi();
	  this.player.duration = () => 5;
	  const playlistMenu = this.player.playlistMenu;
	  assert.ok(!playlistMenu.hasClass('vjs-ad-playing'), 'does not have class vjs-ad-playing');
	  this.player.trigger('adstart');
	  assert.ok(playlistMenu.hasClass('vjs-ad-playing'), 'has class vjs-ad-playing');
	  this.player.trigger('adend');
	  assert.ok(!playlistMenu.hasClass('vjs-ad-playing'), 'does not have class vjs-ad-playing');
	});

	// -----------
	// Interaction
	// -----------

	QUnit__default["default"].test('changes the selection when tapped', function (assert) {
	  let playCalled = false;
	  this.player.playlist(playlist);
	  this.player.playlistUi({
	    playOnSelect: true
	  });
	  this.player.play = function () {
	    playCalled = true;
	  };
	  let sources;
	  this.player.src = src => {
	    if (src) {
	      sources = src;
	    }
	    return sources[0];
	  };
	  this.player.currentSrc = () => sources[0].src;
	  this.player.playlistMenu.items[1].trigger('tap');
	  // trigger a loadstart synchronously to simplify the test
	  this.player.trigger('loadstart');
	  assert.ok(this.player.playlistMenu.items[1].hasClass('vjs-selected'), 'selected the new item');
	  assert.ok(!this.player.playlistMenu.items[0].hasClass('vjs-selected'), 'deselected the old item');
	  assert.strictEqual(playCalled, true, 'play gets called if option is set');
	});
	QUnit__default["default"].test('play should not get called by default upon selection of menu items ', function (assert) {
	  let playCalled = false;
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  this.player.play = function () {
	    playCalled = true;
	  };
	  let sources;
	  this.player.src = src => {
	    if (src) {
	      sources = src;
	    }
	    return sources[0];
	  };
	  this.player.currentSrc = () => sources[0].src;
	  this.player.playlistMenu.items[1].trigger('tap');
	  // trigger a loadstart synchronously to simplify the test
	  this.player.trigger('loadstart');
	  assert.strictEqual(playCalled, false, 'play should not get called by default');
	});
	QUnit__default["default"].test('disposing the playlist menu nulls out the player\'s reference to it', function (assert) {
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist').length, 2, 'there are two playlist containers at the start');
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  this.player.playlistMenu.dispose();
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist').length, 1, 'only the unused playlist container is left');
	  assert.strictEqual(this.player.playlistMenu, null, 'the playlistMenu property is null');
	});
	QUnit__default["default"].test('disposing the playlist menu removes playlist menu items', function (assert) {
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist').length, 2, 'there are two playlist containers at the start');
	  this.player.playlist(playlist);
	  this.player.playlistUi();

	  // Cache some references so we can refer to them after disposal.
	  const items = [].concat(this.player.playlistMenu.items);
	  this.player.playlistMenu.dispose();
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist').length, 1, 'only the unused playlist container is left');
	  assert.strictEqual(this.player.playlistMenu, null, 'the playlistMenu property is null');
	  items.forEach(i => {
	    assert.strictEqual(i.el_, null, `the item "${i.id_}" has been disposed`);
	  });
	});
	QUnit__default["default"].test('disposing the player also disposes the playlist menu', function (assert) {
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist').length, 2, 'there are two playlist containers at the start');
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  this.player.dispose();
	  assert.strictEqual(this.fixture.querySelectorAll('.vjs-playlist').length, 1, 'only the unused playlist container is left');
	  assert.strictEqual(this.player.playlistMenu, null, 'the playlistMenu property is null');
	});
	QUnit__default["default"].module('videojs-playlist-ui: add/remove', {
	  beforeEach: setup,
	  afterEach: teardown
	});
	QUnit__default["default"].test('adding zero items at the start of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([], 0);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'correct number of items');
	});
	QUnit__default["default"].test('adding one item at the start of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add({
	    name: 'Test 1'
	  }, 0);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 3, 'correct number of items');
	  assert.strictEqual(items[0].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'has the correct name in the playlist DOM');
	});
	QUnit__default["default"].test('adding two items at the start of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([{
	    name: 'Test 1'
	  }, {
	    name: 'Test 2'
	  }], 0);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 4, 'correct number of items');
	  assert.strictEqual(items[0].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'has the correct name in the playlist DOM');
	  assert.strictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 2', 'has the correct name in the playlist DOM');
	});
	QUnit__default["default"].test('adding one item in the middle of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add({
	    name: 'Test 1'
	  }, 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 3, 'correct number of items');
	  assert.strictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'has the correct name in the playlist DOM');
	});
	QUnit__default["default"].test('adding two items in the middle of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([{
	    name: 'Test 1'
	  }, {
	    name: 'Test 2'
	  }], 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 4, 'correct number of items');
	  assert.strictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'has the correct name in the playlist DOM');
	  assert.strictEqual(items[2].querySelector('.vjs-playlist-name').textContent, 'Test 2', 'has the correct name in the playlist DOM');
	});
	QUnit__default["default"].test('adding one item at the end of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add({
	    name: 'Test 1'
	  }, playlist.length);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 3, 'correct number of items');
	  assert.strictEqual(items[2].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'has the correct name in the playlist DOM');
	});
	QUnit__default["default"].test('adding two items at the end of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([{
	    name: 'Test 1'
	  }, {
	    name: 'Test 2'
	  }], playlist.length);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 4, 'correct number of items');
	  assert.strictEqual(items[2].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'has the correct name in the playlist DOM');
	  assert.strictEqual(items[3].querySelector('.vjs-playlist-name').textContent, 'Test 2', 'has the correct name in the playlist DOM');
	});
	QUnit__default["default"].test('removing zero items at the start of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.remove(0, 0);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, playlist.length, 'correct number of items');
	});
	QUnit__default["default"].test('removing one item at the start of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add({
	    name: 'Test 1'
	  }, 0);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 3, 'correct number of items');
	  this.player.playlist.remove(0, 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'correct number of items');
	  assert.notStrictEqual(items[0].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'the added item was properly removed from the DOM');
	});
	QUnit__default["default"].test('removing two items at the start of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([{
	    name: 'Test 1'
	  }, {
	    name: 'Test 2'
	  }], 0);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 4, 'correct number of items');
	  this.player.playlist.remove(0, 2);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.notStrictEqual(items[0].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'the added item was properly removed from the DOM');
	  assert.notStrictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 2', 'the added item was properly removed from the DOM');
	});
	QUnit__default["default"].test('removing one item in the middle of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add({
	    name: 'Test 1'
	  }, 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 3, 'correct number of items');
	  this.player.playlist.remove(1, 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'correct number of items');
	  assert.notStrictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'the added item was properly removed from the DOM');
	});
	QUnit__default["default"].test('removing two items in the middle of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([{
	    name: 'Test 1'
	  }, {
	    name: 'Test 2'
	  }], 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 4, 'correct number of items');
	  this.player.playlist.remove(1, 2);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.notStrictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'the added item was properly removed from the DOM');
	  assert.strictEqual(items[2], undefined, 'the added item was properly removed from the DOM');
	});
	QUnit__default["default"].test('removing one item at the end of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add({
	    name: 'Test 1'
	  }, 2);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 3, 'correct number of items');
	  this.player.playlist.remove(2, 1);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'correct number of items');
	  assert.notStrictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'the added item was properly removed from the DOM');
	});
	QUnit__default["default"].test('removing two items at the end of the playlist', function (assert) {
	  this.player.playlist(playlist);
	  this.player.playlistUi();
	  let items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'two items initially');
	  this.player.playlist.add([{
	    name: 'Test 1'
	  }, {
	    name: 'Test 2'
	  }], 2);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 4, 'correct number of items');
	  this.player.playlist.remove(2, 2);
	  items = this.fixture.querySelectorAll('.vjs-playlist-item');
	  assert.strictEqual(items.length, 2, 'correct number of items');
	  assert.notStrictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 1', 'the added item was properly removed from the DOM');
	  assert.notStrictEqual(items[1].querySelector('.vjs-playlist-name').textContent, 'Test 2', 'the added item was properly removed from the DOM');
	});

})(QUnit, sinon, videojs);
