/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.variant;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.GroupTracksMenuAction;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.variant.Genotype;
import org.broad.igv.variant.Variant;
import org.broad.igv.variant.VariantTrack;

public class VariantMenu
extends IGVPopupMenu {
    private static Logger log = Logger.getLogger(VariantMenu.class);
    private VariantTrack track;
    private Collection<String> selectedSamples;
    static boolean depthSortingDirection;
    static boolean genotypeSortingDirection;
    static boolean sampleSortingDirection;
    static boolean qualitySortingDirection;

    public VariantMenu(VariantTrack variantTrack, Variant variant) {
        this.track = variantTrack;
        if (this.track.hasAlignmentFiles()) {
            this.selectedSamples = this.track.getSelectedSamples();
        }
        JLabel popupTitle = new JLabel("<html><b>" + this.track.getName(), 2);
        Font newFont = this.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        this.add(popupTitle);
        this.addSeparator();
        List<Track> selectedTracks = Arrays.asList(variantTrack);
        this.add(TrackMenuUtils.getTrackRenameItem(selectedTracks));
        this.add(TrackMenuUtils.getChangeFontSizeItem(selectedTracks));
        this.addSeparator();
        JLabel colorSiteByItem = new JLabel("<html>&nbsp;&nbsp;<b>Color By", 2);
        this.add(colorSiteByItem);
        this.add(this.getColorBandByAllelFrequency());
        this.add(this.getColorBandByAlleleFraction());
        if (this.track.isEnableMethylationRateSupport()) {
            this.addSeparator();
            JLabel colorByItem = new JLabel("<html>&nbsp;&nbsp;<b>Color Samples By", 2);
            this.add(colorByItem);
            this.add(this.getColorByGenotype());
            this.add(this.getColorByMethylationRate());
        }
        this.addSeparator();
        for (JMenuItem jMenuItem : this.getSortMenuItems(variant)) {
            this.add(jMenuItem);
            jMenuItem.setEnabled(variant != null);
        }
        if (AttributeManager.getInstance().getVisibleAttributes().size() > 0) {
            this.addSeparator();
            this.add(this.getGenotypeGroupItem());
        }
        this.addSeparator();
        JLabel displayHeading = new JLabel("Display Mode", 2);
        this.add(displayHeading);
        for (JMenuItem item3 : this.getDisplayModeItems()) {
            this.add(item3);
        }
        this.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Change Squished Row Height...");
        jMenuItem.addActionListener(evt -> {
            int currentValue = this.track.getSquishedHeight();
            Integer newValue = TrackMenuUtils.getIntegerInput("Squished row height", currentValue);
            if (newValue != null) {
                this.track.setSquishedHeight(newValue);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        this.add(jMenuItem);
        this.add(this.getHideFilteredItem());
        this.add(this.getFeatureVisibilityItem());
        if (this.track.hasAlignmentFiles()) {
            this.addSeparator();
            this.add(this.getLoadBamsItem());
        }
    }

    private JMenuItem getFeatureVisibilityItem() {
        JMenuItem item = new JMenuItem("Set Feature Visibility Window...");
        item.addActionListener(evt -> {
            this.changeVisibilityWindow();
            IGV.getInstance().getContentPane().repaint();
        });
        return item;
    }

    private JMenuItem getColorBandByAllelFrequency() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Allele Frequency", this.track.getSiteColorMode() == VariantTrack.ColorMode.ALLELE_FREQUENCY);
        item.addActionListener(evt -> {
            this.track.setSiteColorMode(VariantTrack.ColorMode.ALLELE_FREQUENCY);
            IGV.getInstance().getContentPane().repaint();
        });
        return item;
    }

    private JMenuItem getColorBandByAlleleFraction() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Allele Fraction", this.track.getSiteColorMode() == VariantTrack.ColorMode.ALLELE_FRACTION);
        item.addActionListener(evt -> {
            this.track.setSiteColorMode(VariantTrack.ColorMode.ALLELE_FRACTION);
            IGV.getInstance().getContentPane().repaint();
        });
        return item;
    }

    private JMenuItem getColorByGenotype() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Genotype", this.track.getColorMode() == VariantTrack.ColorMode.GENOTYPE);
        item.addActionListener(evt -> {
            this.track.setColorMode(VariantTrack.ColorMode.GENOTYPE);
            IGV.getInstance().getContentPane().repaint();
        });
        return item;
    }

    private JMenuItem getColorByMethylationRate() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Methylation Rate", this.track.getColorMode() == VariantTrack.ColorMode.METHYLATION_RATE);
        item.addActionListener(evt -> {
            this.track.setColorMode(VariantTrack.ColorMode.METHYLATION_RATE);
            IGV.getInstance().getContentPane().repaint();
        });
        return item;
    }

    private JMenuItem getHideFilteredItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Hide Filtered Sites", this.track.getHideFiltered());
        item.addActionListener(evt -> {
            this.track.setHideFiltered(!this.track.getHideFiltered());
            IGV.getInstance().getContentPane().repaint();
        });
        return item;
    }

    public JMenuItem getGenotypeSortItem(Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Genotype");
        if (variant != null) {
            item.addActionListener(evt -> {
                GenotypeComparator compare = new GenotypeComparator(variant);
                genotypeSortingDirection = !genotypeSortingDirection;
                this.track.sortSamples(compare);
                IGV.getInstance().getContentPane().repaint();
            });
        }
        return item;
    }

    public JMenuItem getGenotypeGroupItem() {
        JMenuItem item = new JMenuItem("Group By...");
        item.addActionListener(evt -> new GroupTracksMenuAction("", 0, IGV.getInstance()).doGroupBy());
        item.setEnabled(AttributeManager.getInstance().getVisibleAttributes().size() > 0);
        return item;
    }

    public JMenuItem getSampleNameSortItem(Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Sample Name");
        if (variant != null) {
            item.addActionListener(evt -> {
                Comparator<String> compare = new Comparator<String>(){

                    @Override
                    public int compare(String o, String o1) {
                        if (sampleSortingDirection) {
                            return o.compareTo(o1);
                        }
                        return o1.compareTo(o);
                    }
                };
                sampleSortingDirection = !sampleSortingDirection;
                this.track.sortSamples(compare);
                IGV.getInstance().getContentPane().repaint();
            });
        }
        return item;
    }

    public JMenuItem getDepthSortItem(Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Depth");
        if (variant != null) {
            item.addActionListener(evt -> {
                DepthComparator compare = new DepthComparator(variant);
                depthSortingDirection = !depthSortingDirection;
                this.track.sortSamples(compare);
                IGV.getInstance().getContentPane().repaint();
            });
        }
        return item;
    }

    public JMenuItem getQualitySortItem(Variant variant) {
        JMenuItem item = new JMenuItem("Sort By Quality");
        if (variant != null) {
            double quality = variant.getPhredScaledQual();
            if (quality > -1.0) {
                item.addActionListener(evt -> {
                    QualityComparator compare = new QualityComparator(variant);
                    qualitySortingDirection = !qualitySortingDirection;
                    this.track.sortSamples(compare);
                    IGV.getInstance().getContentPane().repaint();
                });
            } else {
                item.setEnabled(false);
            }
        }
        return item;
    }

    public void changeVisibilityWindow() {
        TrackMenuUtils.changeFeatureVisibilityWindow(Arrays.asList(this.track));
    }

    public Collection<JMenuItem> getSortMenuItems(Variant variant) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        items.add(this.getGenotypeSortItem(variant));
        items.add(this.getSampleNameSortItem(variant));
        items.add(this.getDepthSortItem(variant));
        items.add(this.getQualitySortItem(variant));
        return items;
    }

    public List<JMenuItem> getDisplayModeItems() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ButtonGroup group = new ButtonGroup();
        Track.DisplayMode displayMode = this.track.getDisplayMode();
        JRadioButtonMenuItem m1 = new JRadioButtonMenuItem("Collapsed");
        m1.setSelected(displayMode == Track.DisplayMode.COLLAPSED);
        m1.addActionListener(evt -> {
            this.track.setDisplayMode(Track.DisplayMode.COLLAPSED);
            this.track.repaint();
        });
        JRadioButtonMenuItem m2 = new JRadioButtonMenuItem("Squished");
        m2.setSelected(displayMode == Track.DisplayMode.SQUISHED);
        m2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setDisplayMode(Track.DisplayMode.SQUISHED);
                VariantMenu.this.track.repaint();
            }
        });
        JRadioButtonMenuItem m3 = new JRadioButtonMenuItem("Expanded");
        m3.setSelected(displayMode == Track.DisplayMode.EXPANDED);
        m3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.setDisplayMode(Track.DisplayMode.EXPANDED);
                VariantMenu.this.track.repaint();
            }
        });
        items.add(m1);
        items.add(m2);
        items.add(m3);
        group.add(m1);
        group.add(m2);
        group.add(m3);
        return items;
    }

    private JMenuItem getLoadBamsItem() {
        JMenuItem item = new JMenuItem("Load alignments");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariantMenu.this.track.loadSelectedBams();
            }
        });
        item.setEnabled(this.selectedSamples != null && this.selectedSamples.size() > 0);
        return item;
    }

    static class QualityComparator
    implements Comparator<String> {
        Variant variant;

        QualityComparator(Variant variant) {
            this.variant = variant;
        }

        @Override
        public int compare(String s1, String s2) {
            double qual1 = this.variant.getGenotype(s1).getPhredScaledQual();
            double qual2 = this.variant.getGenotype(s2).getPhredScaledQual();
            int sign = qualitySortingDirection ? -1 : 1;
            return sign * Double.compare(qual1, qual2);
        }
    }

    static class DepthComparator
    implements Comparator<String> {
        Variant variant;

        DepthComparator(Variant variant) {
            this.variant = variant;
        }

        @Override
        public int compare(String s1, String s2) {
            double readDepth1 = this.variant.getGenotype(s1).getAttributeAsDouble("DP");
            double readDepth2 = this.variant.getGenotype(s2).getAttributeAsDouble("DP");
            int sign = depthSortingDirection ? -1 : 1;
            return sign * Double.compare(readDepth1, readDepth2);
        }
    }

    static class GenotypeComparator
    implements Comparator<String> {
        Variant variant;

        GenotypeComparator(Variant variant) {
            this.variant = variant;
        }

        @Override
        public int compare(String e1, String e2) {
            int genotype1 = this.classifyGenotype(this.variant.getGenotype(e1));
            int genotype2 = this.classifyGenotype(this.variant.getGenotype(e2));
            if (genotype2 == genotype1) {
                return 0;
            }
            if (genotype2 > genotype1) {
                return genotypeSortingDirection ? 1 : -1;
            }
            return genotypeSortingDirection ? -1 : 1;
        }

        private int classifyGenotype(Genotype genotype) {
            if (genotype.isNoCall()) {
                return genotypeSortingDirection ? 1 : 10;
            }
            if (genotype.isHomVar()) {
                return 4;
            }
            if (genotype.isHet()) {
                return 3;
            }
            if (genotype.isHomRef()) {
                return genotypeSortingDirection ? 2 : 9;
            }
            return -1;
        }
    }
}

