/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    private static final long serialVersionUID = -2671257302660747028L;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('F');
    public static final int SIZE = 32;
    private final float value;

    public static final String toString(float f) {
        return VMDouble.toString(f, true);
    }

    public static final Float valueOf(String s) {
        return new Float(Float.parseFloat(s));
    }

    public static final Float valueOf(float val) {
        return new Float(val);
    }

    public static final float parseFloat(String str) {
        return (float)Double.parseDouble(str);
    }

    public static final boolean isNaN(float v) {
        boolean bl = false;
        if (v != v) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isInfinite(float v) {
        boolean bl = false;
        if (v == Float.POSITIVE_INFINITY || v == Float.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public final boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public final String toString() {
        return Float.toString(this.value);
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return (long)this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Float)) {
            return false;
        }
        float f = ((Float)obj).value;
        if (this.value == f) {
            boolean bl = false;
            if (this.value != 0.0f || 1.0f / this.value == 1.0f / f) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (Float.isNaN(this.value) && Float.isNaN(f)) {
            bl = true;
        }
        return bl;
    }

    public static final int floatToIntBits(float value) {
        return VMFloat.floatToIntBits(value);
    }

    public static final int floatToRawIntBits(float value) {
        return VMFloat.floatToRawIntBits(value);
    }

    public static final float intBitsToFloat(int bits) {
        return VMFloat.intBitsToFloat(bits);
    }

    public final int compareTo(Float f) {
        return Float.compare(this.value, f.value);
    }

    public final int compareTo(Object o) {
        return Float.compare(this.value, ((Float)o).value);
    }

    public static final int compare(float x, float y) {
        if (Float.isNaN(x)) {
            return 1 - Float.isNaN(y);
        }
        if (Float.isNaN(y)) {
            return -1;
        }
        if (x == 0.0f && y == 0.0f) {
            return (int)(1.0f / x - 1.0f / y);
        }
        if (x == y) {
            return 0;
        }
        return x > y ? 1 : -1;
    }

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) {
        this.value = Float.parseFloat(s);
    }
}

