/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.intermediate;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ParameterDef;
import org.jetbrains.dekaf.exceptions.DBSessionIsClosedException;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateSeance;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSeance;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSeance;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateSession;
import org.jetbrains.dekaf.util.Objects;

public class AdaptIntermediateSession
implements IntegralIntermediateSession {
    @NotNull
    private final PrimeIntermediateSession myRemoteSession;

    public AdaptIntermediateSession(@NotNull PrimeIntermediateSession remoteSession) {
        this.myRemoteSession = remoteSession;
    }

    @Override
    public void beginTransaction() {
        this.myRemoteSession.beginTransaction();
    }

    @Override
    public boolean isInTransaction() {
        return this.myRemoteSession.isInTransaction();
    }

    @Override
    public void commit() {
        this.myRemoteSession.commit();
    }

    @Override
    public void rollback() {
        this.myRemoteSession.rollback();
    }

    @Override
    @NotNull
    public IntegralIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameters) {
        PrimeIntermediateSeance remoteSeance = this.myRemoteSession.openSeance(statementText, outParameters);
        return new AdaptIntermediateSeance(remoteSeance);
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        if (serviceName.equalsIgnoreCase("intermediate-service")) {
            return Objects.castTo(serviceClass, this.myRemoteSession);
        }
        return this.myRemoteSession.getSpecificService(serviceClass, serviceName);
    }

    @Override
    public long ping() {
        if (this.myRemoteSession.isClosed()) {
            throw new DBSessionIsClosedException("The intermediate session is closed.");
        }
        return this.myRemoteSession.ping();
    }

    @Override
    public void close() {
        this.myRemoteSession.close();
    }

    @Override
    public boolean isClosed() {
        return this.myRemoteSession.isClosed();
    }
}

