/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.LineTokenizerBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LineTokenizer
extends LineTokenizerBase<String> {
    private final char[] myChars;
    private final String myText;

    public LineTokenizer(@NotNull String text) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(0);
        }
        this.myChars = text.toCharArray();
        this.myText = text;
    }

    @NotNull
    public String[] execute() {
        ArrayList<String> lines = new ArrayList<String>();
        this.doExecute(lines);
        String[] stringArray = ArrayUtil.toStringArray(lines);
        if (stringArray == null) {
            LineTokenizer.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Override
    protected void addLine(List<? super String> lines, int start, int end, boolean appendNewLine) {
        if (appendNewLine) {
            lines.add(this.myText.substring(start, end) + "\n");
        } else {
            lines.add(this.myText.substring(start, end));
        }
    }

    @Override
    protected char charAt(int index) {
        return this.myChars[index];
    }

    @Override
    protected int length() {
        return this.myChars.length;
    }

    @Override
    @NotNull
    protected String substring(int start, int end) {
        String string = this.myText.substring(start, end);
        if (string == null) {
            LineTokenizer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String concatLines(@NotNull String[] lines) {
        if (lines == null) {
            LineTokenizer.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        for (String line : lines) {
            buffer.append(line);
        }
        String string = buffer.substring(0, buffer.length());
        if (string == null) {
            LineTokenizer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String correctLineSeparators(@NotNull String text) {
        if (text == null) {
            LineTokenizer.$$$reportNull$$$0(5);
        }
        String string = LineTokenizer.concatLines(new LineTokenizer(text).execute());
        if (string == null) {
            LineTokenizer.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/LineTokenizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/LineTokenizer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "concatLines";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "correctLineSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "concatLines";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "correctLineSeparators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

