/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.rename;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.indexing.FileBasedIndex;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssColorValueRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.css.actions.rename.CssColorValueRenameHandler");

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement element;
        if (dataContext == null) {
            CssColorValueRenameHandler.$$$reportNull$$$0(0);
        }
        return (element = CssColorValueRenameHandler.getCssElement(dataContext)) != null && CssPsiColorUtil.getColorTerm(element) != null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            CssColorValueRenameHandler.$$$reportNull$$$0(1);
        }
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        Color color;
        if (project == null) {
            CssColorValueRenameHandler.$$$reportNull$$$0(2);
        }
        if (!this.isRenaming(dataContext)) {
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = CssColorValueRenameHandler.getCssElement(dataContext);
        if (element != null && (color = CssPsiColorUtil.getColor(element)) != null) {
            CssTerm term = CssUtil.getEnclosingTerm(element);
            LOG.assertTrue(term != null);
            new CssColorValueRenameDialog(project, (PsiElement)term, editor, CssPsiColorUtil.toHexColor(color).substring(1)).show();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            CssColorValueRenameHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            CssColorValueRenameHandler.$$$reportNull$$$0(4);
        }
    }

    private static List<PsiElement> gatherElementsToRename(Project project, PsiElement _element, String stringColor) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        PsiManager manager = PsiManager.getInstance((Project)project);
        FileBasedIndex index = FileBasedIndex.getInstance();
        FileBasedIndex.ValueProcessor processor = (file, value) -> {
            PsiFile psiFile = manager.findFile(file);
            if (psiFile != null) {
                value.forEach(offset -> {
                    PsiElement anotherElement = psiFile.findElementAt(offset);
                    CssTerm term = CssUtil.getEnclosingTerm(anotherElement);
                    if (term != _element.getParent().getChildren()[0]) {
                        LOG.assertTrue(term != null);
                        result.add((PsiElement)new CssColorValueFakeRenameElement((PsiElement)term));
                    }
                    return true;
                });
            }
            return true;
        };
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        index.processValues(CssIndex.CSS_INDEX, (Object)CssIndexValue.COLOR.indexKey(stringColor), null, processor, scope);
        index.processValues(CssIndex.CSS_INDEX, (Object)CssIndexValue.COLOR_RGB.indexKey(stringColor), null, processor, scope);
        return result;
    }

    @Nullable
    static PsiElement getCssElement(@Nullable DataContext context) {
        PsiFile psiFile;
        if (context == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            return psiFile.findElementAt(editor.getCaretModel().getOffset());
        }
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/actions/rename/CssColorValueRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRenaming";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CssColorValueRenameDialog
    extends RenameDialog {
        private final String myColorString;
        private final PsiElement myElement;

        private CssColorValueRenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, Editor editor, String colorString) {
            if (project == null) {
                CssColorValueRenameDialog.$$$reportNull$$$0(0);
            }
            if (psiElement == null) {
                CssColorValueRenameDialog.$$$reportNull$$$0(1);
            }
            super(project, (PsiElement)new CssColorValueFakeRenameElement(psiElement), psiElement, editor);
            this.myColorString = colorString;
            this.myElement = new CssColorValueFakeRenameElement(psiElement);
        }

        protected boolean areButtonsValid() {
            String newName = this.getNewName();
            return this.isValidColorValue(newName);
        }

        private boolean isValidColorValue(String newName) {
            CssTerm term = CssElementFactory.getInstance((Project)this.myProject).createTerm(newName, CssPsiUtil.getStylesheetLanguage((PsiElement)this.myElement));
            return CssTermTypes.COLOR == term.getTermType();
        }

        protected void doAction() {
            this.close(0);
            String newName = this.getNewName();
            RenameRefactoring rename = RefactoringFactory.getInstance((Project)this.myProject).createRename(this.myElement, newName);
            rename.setSearchInComments(this.isSearchInComments());
            rename.setSearchInNonJavaFiles(this.isSearchInNonJavaFiles());
            rename.setPreviewUsages(this.isPreviewUsages());
            List elements = CssColorValueRenameHandler.gatherElementsToRename(this.getProject(), this.myElement, this.myColorString);
            for (PsiElement element : elements) {
                rename.addElement(element, newName);
            }
            rename.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/actions/rename/CssColorValueRenameHandler$CssColorValueRenameDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CssColorValueFakeRenameElement
    extends RenameableFakePsiElement {
        private final PsiElement myElement;

        protected CssColorValueFakeRenameElement(PsiElement element) {
            super((PsiElement)element.getContainingFile());
            this.myElement = element;
        }

        public String getName() {
            return this.myElement.getText();
        }

        public PsiElement getParent() {
            return this.myElement.getParent();
        }

        public String getTypeName() {
            return "color";
        }

        public Icon getIcon() {
            return null;
        }

        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                CssColorValueFakeRenameElement.$$$reportNull$$$0(0);
            }
            if (!this.myElement.isValid()) {
                return null;
            }
            if (this.myElement instanceof CssTerm) {
                CssTerm term = CssElementFactory.getInstance((Project)this.getProject()).createTerm(name, CssPsiUtil.getStylesheetLanguage((PsiElement)this.myElement));
                return this.myElement.replace((PsiElement)term);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/actions/rename/CssColorValueRenameHandler$CssColorValueFakeRenameElement", "setName"));
        }
    }
}

