/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.ui.explorer.PhingBuildFileNodeDescriptor;
import com.jetbrains.php.phing.ui.explorer.PhingNodeDescriptor;
import com.jetbrains.php.phing.ui.explorer.PhingTargetNodeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingExplorerTreeStructure
extends AbstractTreeStructure {
    private static final Logger LOG = Logger.getInstance(PhingExplorerTreeStructure.class);
    private static final Comparator<PhingBuildFile> BUILD_FILE_COMPARATOR = (o1, o2) -> o1.getPresentableName().compareTo(o2.getPresentableName());
    private static final Comparator<PhingBuildTarget> TARGET_COMPARATOR = (o1, o2) -> {
        String fileName2;
        if (o1.isDefault()) {
            return -1;
        }
        if (o2.isDefault()) {
            return 1;
        }
        String fileName1 = o1.getFile().getName();
        if (fileName1.equals(fileName2 = o2.getFile().getName())) {
            return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)false);
        }
        if (o1.getFile().equals(o1.getContextFile())) {
            return -1;
        }
        if (o2.getFile().equals(o2.getContextFile())) {
            return 1;
        }
        return fileName1.compareTo(fileName2);
    };
    private final Project myProject;
    private final Object myRoot = new Object();
    private final PsiDocumentManager myPsiDocumentManager;

    public PhingExplorerTreeStructure(Project project) {
        this.myProject = project;
        this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
    }

    @NotNull
    public PhingNodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(0);
        }
        if (element == this.myRoot) {
            RootNodeDescriptor rootNodeDescriptor = new RootNodeDescriptor(this.myProject, parentDescriptor);
            if (rootNodeDescriptor == null) {
                PhingExplorerTreeStructure.$$$reportNull$$$0(1);
            }
            return rootNodeDescriptor;
        }
        if (element instanceof String) {
            TextInfoNodeDescriptor textInfoNodeDescriptor = new TextInfoNodeDescriptor(this.myProject, parentDescriptor, (String)element);
            if (textInfoNodeDescriptor == null) {
                PhingExplorerTreeStructure.$$$reportNull$$$0(2);
            }
            return textInfoNodeDescriptor;
        }
        if (element instanceof PhingBuildFile) {
            PhingBuildFileNodeDescriptor phingBuildFileNodeDescriptor = new PhingBuildFileNodeDescriptor(this.myProject, parentDescriptor, (PhingBuildFile)element);
            if (phingBuildFileNodeDescriptor == null) {
                PhingExplorerTreeStructure.$$$reportNull$$$0(3);
            }
            return phingBuildFileNodeDescriptor;
        }
        if (element instanceof PhingBuildTarget) {
            PhingTargetNodeDescriptor phingTargetNodeDescriptor = new PhingTargetNodeDescriptor(this.myProject, parentDescriptor, (PhingBuildTarget)element);
            if (phingTargetNodeDescriptor == null) {
                PhingExplorerTreeStructure.$$$reportNull$$$0(4);
            }
            return phingTargetNodeDescriptor;
        }
        LOG.error("Unknown element for this tree structure " + element);
        if (null == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        if (element == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(6);
        }
        PhingStateService stateService = PhingStateService.getInstance(this.myProject);
        if (element == this.myRoot) {
            List<PhingBuildFile> buildFiles = stateService.getBuildFiles();
            if (!buildFiles.isEmpty()) {
                Object[] files = buildFiles.toArray(new PhingBuildFile[0]);
                Arrays.sort(files, BUILD_FILE_COMPARATOR);
                if (files == null) {
                    PhingExplorerTreeStructure.$$$reportNull$$$0(7);
                }
                return files;
            }
            Object[] objectArray = new Object[]{PhingBundle.message("phing.tree.structure.no.build.files.message", new Object[0])};
            if (objectArray == null) {
                PhingExplorerTreeStructure.$$$reportNull$$$0(8);
            }
            return objectArray;
        }
        if (element instanceof PhingBuildFile) {
            Object[] result;
            PhingBuildFile buildFile = (PhingBuildFile)element;
            PhingBuildFileParsedData parsedData = stateService.getParsedData(buildFile);
            if (parsedData == null) {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    PhingExplorerTreeStructure.$$$reportNull$$$0(9);
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            if (stateService.isHideTargets()) {
                List<String> targetsToHide = buildFile.getTargetsToHide();
                ArrayList<PhingBuildTarget> targets = new ArrayList<PhingBuildTarget>();
                for (PhingBuildTarget target : parsedData.getTargets()) {
                    if (target.isHiddenByAttribute() || targetsToHide.contains(target.getName())) continue;
                    targets.add(target);
                }
                result = targets.toArray(new PhingBuildTarget[0]);
            } else {
                List<PhingBuildTarget> targets = parsedData.getTargets();
                result = targets.toArray(new PhingBuildTarget[0]);
            }
            Arrays.sort(result, TARGET_COMPARATOR);
            if (result == null) {
                PhingExplorerTreeStructure.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(11);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public Object getParentElement(@NotNull Object element) {
        if (element == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(12);
        }
        if (element instanceof PhingBuildTarget) {
            VirtualFile file = ((PhingBuildTarget)element).getContextFile();
            return PhingStateService.getInstance(((PhingBuildTarget)element).getProject()).getBuildFile(file);
        }
        if (element instanceof PhingBuildFile) {
            return this.myRoot;
        }
        return null;
    }

    public void commit() {
        this.myPsiDocumentManager.commitAllDocuments();
    }

    public boolean hasSomethingToCommit() {
        return this.myPsiDocumentManager.hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = PhingExplorerTreeStructure.asyncCommitDocuments((Project)this.myProject);
        if (actionCallback == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(13);
        }
        return actionCallback;
    }

    public boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(14);
        }
        return true;
    }

    @NotNull
    public Object getRootElement() {
        Object object = this.myRoot;
        if (object == null) {
            PhingExplorerTreeStructure.$$$reportNull$$$0(15);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/ui/explorer/PhingExplorerTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/ui/explorer/PhingExplorerTreeStructure";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParentElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isToBuildChildrenInBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TextInfoNodeDescriptor
    extends PhingNodeDescriptor {
        private TextInfoNodeDescriptor(Project project, NodeDescriptor parentDescriptor, String text) {
            super(project, parentDescriptor);
            this.myName = text;
            this.myColor = JBColor.BLUE;
        }

        public Object getElement() {
            return this.myName;
        }

        public boolean update() {
            return true;
        }

        @Override
        public boolean isAutoExpand() {
            return true;
        }
    }

    private final class RootNodeDescriptor
    extends PhingNodeDescriptor {
        private RootNodeDescriptor(Project project, NodeDescriptor parentDescriptor) {
            super(project, parentDescriptor);
        }

        @Override
        public boolean isAutoExpand() {
            return true;
        }

        public Object getElement() {
            return PhingExplorerTreeStructure.this.myRoot;
        }

        public boolean update() {
            this.myName = "";
            return false;
        }
    }
}

