/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.indexing.FileBasedIndex;
import java.net.URI;
import java.net.URISyntaxException;
import org.intellij.images.index.ImageInfoIndex;
import org.jetbrains.annotations.Nullable;

public class ImageDocumentationProvider
extends AbstractDocumentationProvider {
    private static final int MAX_IMAGE_SIZE = 300;

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        VirtualFile file2;
        Ref result2 = Ref.create();
        if (element instanceof PsiFileSystemItem && !((PsiFileSystemItem)element).isDirectory() && (file2 = ((PsiFileSystemItem)element).getVirtualFile()) instanceof VirtualFileWithId && !DumbService.isDumb((Project)element.getProject())) {
            ImageInfoIndex.processValues(file2, (FileBasedIndex.ValueProcessor<ImageInfoIndex.ImageInfo>)((FileBasedIndex.ValueProcessor)(file1, value) -> {
                int imageWidth = value.width;
                int imageHeight = value.height;
                int maxSize2 = Math.max(value.width, value.height);
                if (maxSize2 > 300) {
                    double scaleFactor = 300.0 / (double)maxSize2;
                    imageWidth = (int)((double)imageWidth * scaleFactor);
                    imageHeight = (int)((double)imageHeight * scaleFactor);
                }
                try {
                    String path = file1.getPath();
                    if (SystemInfo.isWindows) {
                        path = "/" + path;
                    }
                    String url = new URI("file", null, path, null).toString();
                    result2.set((Object)String.format("<img src=\"%s\" width=\"%s\" height=\"%s\"><p>%sx%s, %sbpp</p>", url, imageWidth, imageHeight, value.width, value.height, value.bpp));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                return true;
            }), element.getProject());
        }
        return (String)result2.get();
    }
}

