/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.actions.persistence;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.internal.statistic.eventLog.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="IntentionsCollector", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
public class IntentionsCollector
implements PersistentStateComponent<State> {
    private static final String GROUP_ID = "statistics.actions.intentions";
    private State myState = new State();
    private static final List<String> PREFIXES_TO_STRIP = Arrays.asList("com.intellij.codeInsight.", "com.intellij.");

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            IntentionsCollector.$$$reportNull$$$0(0);
        }
    }

    public void record(@NotNull IntentionAction action, @NotNull Language language) {
        if (action == null) {
            IntentionsCollector.$$$reportNull$$$0(1);
        }
        if (language == null) {
            IntentionsCollector.$$$reportNull$$$0(2);
        }
        String id = IntentionsCollector.getIntentionId(action);
        String key = language.getID() + " " + id;
        FeatureUsageLogger.INSTANCE.log(GROUP_ID, key, FUSUsageContext.OS_CONTEXT.getData());
    }

    @NotNull
    private static String getIntentionId(@NotNull IntentionAction action) {
        Class<?> clazz;
        PluginType type;
        LocalQuickFix fix;
        if (action == null) {
            IntentionsCollector.$$$reportNull$$$0(3);
        }
        IntentionAction handler2 = action;
        if (action instanceof IntentionActionDelegate) {
            IntentionAction delegate = ((IntentionActionDelegate)action).getDelegate();
            if (delegate != action) {
                String string = IntentionsCollector.getIntentionId(delegate);
                if (string == null) {
                    IntentionsCollector.$$$reportNull$$$0(4);
                }
                return string;
            }
        } else if (action instanceof QuickFixWrapper && (fix = ((QuickFixWrapper)action).getFix()) != action) {
            handler2 = fix;
        }
        if (!(type = StatisticsUtilKt.getPluginType(clazz = handler2.getClass())).isSafeToReport()) {
            String string = type.name();
            if (string == null) {
                IntentionsCollector.$$$reportNull$$$0(5);
            }
            return string;
        }
        String fqn = clazz.getName();
        for (String prefix : PREFIXES_TO_STRIP) {
            fqn = StringUtil.trimStart((String)fqn, (String)prefix);
        }
        if (!type.isPlatformOrJBBundled()) {
            fqn = "[!]" + fqn;
        }
        String string = fqn;
        if (string == null) {
            IntentionsCollector.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static IntentionsCollector getInstance() {
        return (IntentionsCollector)ServiceManager.getService(IntentionsCollector.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/IntentionsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/actions/persistence/IntentionsCollector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "record";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionId";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        @Tag(value="Intentions")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="name", valueAttributeName="count")
        public Map<String, Integer> myIntentions = new HashMap<String, Integer>();
    }
}

