/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.TaskProblemsHolder;
import com.intellij.plugins.watcher.TaskRunner;
import com.intellij.plugins.watcher.inspections.TaskInspectionBase;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskProblemsInspection
extends TaskInspectionBase {
    @NotNull
    public String getShortName() {
        String string = TaskProblemsInspection.getInspectionShortName();
        if (string == null) {
            TaskProblemsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getInspectionShortName() {
        if ("TaskProblemsInspection" == null) {
            TaskProblemsInspection.$$$reportNull$$$0(1);
        }
        return "TaskProblemsInspection";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("File watcher problems" == null) {
            TaskProblemsInspection.$$$reportNull$$$0(2);
        }
        return "File watcher problems";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TaskProblemDescription> descriptions;
        if (file == null) {
            TaskProblemsInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            TaskProblemsInspection.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        TaskProblemsHolder problemsHolder = TaskRunner.getInstance().getProblemsHolder();
        List<TaskProblemDescription> list = descriptions = virtualFile != null ? problemsHolder.findProblems(file) : Collections.emptyList();
        if (descriptions.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>(descriptions.size());
        for (TaskProblemDescription description : descriptions) {
            ProblemDescriptor descriptor = TaskProblemsInspection.createProblemDescriptor(description, file, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptors.add(descriptor);
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static ProblemDescriptor createProblemDescriptor(TaskProblemDescription taskProblemDescription, @NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement element;
        int lineStartOffset;
        if (file == null) {
            TaskProblemsInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            TaskProblemsInspection.$$$reportNull$$$0(6);
        }
        Document document = file.getViewProvider().getDocument();
        Integer line = taskProblemDescription.getLine();
        if (document == null || line == null) {
            return null;
        }
        if (0 > line || line >= document.getLineCount()) {
            return null;
        }
        int errorStartOffset = lineStartOffset = document.getLineStartOffset(line.intValue());
        boolean afterEndOfLine = false;
        if (taskProblemDescription.getColumn() != null) {
            int lineEndOffset = document.getLineEndOffset(line.intValue());
            boolean bl = afterEndOfLine = (errorStartOffset += taskProblemDescription.getColumn().intValue()) == lineEndOffset;
        }
        if ((element = file.findElementAt(errorStartOffset)) == null && lineStartOffset < errorStartOffset) {
            element = file.findElementAt(errorStartOffset - 1);
        }
        if (element != null) {
            if (afterEndOfLine) {
                element = TaskProblemsInspection.findLastElementInLine(element, document, line);
            }
            String message = taskProblemDescription.getMessage();
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            if (message != null && StringUtil.containsIgnoreCase((String)message, (String)"error")) {
                highlightType = ProblemHighlightType.GENERIC_ERROR;
            }
            String descriptionMessage = TaskProblemsInspection.createDescription(message);
            return manager.createProblemDescriptor(element, descriptionMessage, LocalQuickFix.EMPTY_ARRAY, highlightType, isOnTheFly, afterEndOfLine);
        }
        return null;
    }

    @NotNull
    private static String createDescription(@Nullable String message) {
        if (StringUtil.isEmpty((String)message)) {
            String string = BackgroundTaskBundle.message("inspection.empty.message", new Object[0]);
            if (string == null) {
                TaskProblemsInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (message.contains("\n")) {
            String string = "<html><body><pre>" + message + "</pre></body></html>";
            if (string == null) {
                TaskProblemsInspection.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            TaskProblemsInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static PsiElement findLastElementInLine(@NotNull PsiElement initialElement, @NotNull Document document, int documentLine) {
        if (initialElement == null) {
            TaskProblemsInspection.$$$reportNull$$$0(10);
        }
        if (document == null) {
            TaskProblemsInspection.$$$reportNull$$$0(11);
        }
        PsiElement element = PsiTreeUtil.lastChild((PsiElement)initialElement);
        while (element != null) {
            if (!(element instanceof PsiErrorElement) && element.getTextLength() > 0) {
                int endOffset = element.getTextRange().getEndOffset();
                if (endOffset < 0 || document.getTextLength() < endOffset) {
                    throw new AssertionError((Object)"Element end offset is out of document");
                }
                int endLineNumber = document.getLineNumber(endOffset);
                if (endLineNumber == documentLine) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        TaskProblemsInspection.$$$reportNull$$$0(12);
                    }
                    return psiElement;
                }
                if (endLineNumber < documentLine) {
                    PsiElement psiElement = initialElement;
                    if (psiElement == null) {
                        TaskProblemsInspection.$$$reportNull$$$0(13);
                    }
                    return psiElement;
                }
            }
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        PsiElement psiElement = initialElement;
        if (psiElement == null) {
            TaskProblemsInspection.$$$reportNull$$$0(14);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/inspections/TaskProblemsInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/inspections/TaskProblemsInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescription";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findLastElementInLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLastElementInLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

