/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.frameworks.IntegrationUtil;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DrupalFormattingManager {
    private DrupalFormattingManager() {
    }

    public static void offerDrupalFormatting(DrupalDataService.State newState, DrupalDataService.State oldState, final Project project) {
        if (!newState.isEnabled() || oldState.isEnabled()) {
            return;
        }
        final PredefinedCodeStyle[] styles = DrupalFormattingManager.getPredefinedStyles();
        boolean isSet = true;
        for (PredefinedCodeStyle style : styles) {
            isSet &= IntegrationUtil.isFormattingStyleSet((Project)project, (PredefinedCodeStyle)style);
        }
        if (isSet) {
            return;
        }
        Function<Notification, AnAction> setAction = notification -> new DumbAwareAction("Set", (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IntegrationUtil.setPredefinedCodeStyleToProject((Project)project, (PredefinedCodeStyle[])styles);
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/init/DrupalFormattingManager$1", "actionPerformed"));
            }
        };
        DrupalUtil.notifyGlobally(project, DrupalBundle.message("plugin.title", new Object[0]), DrupalBundle.message("drupal.offer.formatting", new Object[0]), NotificationType.INFORMATION, setAction);
    }

    @NotNull
    private static PredefinedCodeStyle[] getPredefinedStyles() {
        PredefinedCodeStyle[] extensions;
        ArrayList<PredefinedCodeStyle> styles = new ArrayList<PredefinedCodeStyle>();
        for (PredefinedCodeStyle extension : extensions = (PredefinedCodeStyle[])PredefinedCodeStyle.EP_NAME.getExtensions()) {
            if (!extension.getName().contains("Drupal") || !extension.getClass().getPackage().getName().startsWith("com.jetbrains.php.drupal")) continue;
            styles.add(extension);
        }
        PredefinedCodeStyle[] predefinedCodeStyleArray = styles.toArray(PredefinedCodeStyle.EMPTY_ARRAY);
        if (predefinedCodeStyleArray == null) {
            DrupalFormattingManager.$$$reportNull$$$0(0);
        }
        return predefinedCodeStyleArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/drupal/init/DrupalFormattingManager", "getPredefinedStyles"));
    }
}

