/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageScopeGroupingRule
extends SingleParentUsageGroupingRule
implements DumbAware {
    private static final UsageScopeGroup TEST = new UsageScopeGroup(0){

        @Override
        public Icon getIcon(boolean isOpen) {
            return AllIcons.Modules.TestSourceFolder;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if ("Test" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "Test";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$1", "getText"));
        }
    };
    private static final UsageScopeGroup PRODUCTION = new UsageScopeGroup(1){

        @Override
        public Icon getIcon(boolean isOpen) {
            return PlatformIcons.SOURCE_FOLDERS_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if ("Production" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "Production";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$2", "getText"));
        }
    };
    private static final UsageScopeGroup LIBRARY = new UsageScopeGroup(2){

        @Override
        public Icon getIcon(boolean isOpen) {
            return PlatformIcons.LIBRARY_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            if ("Library" == null) {
                3.$$$reportNull$$$0(0);
            }
            return "Library";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$3", "getText"));
        }
    };

    @Override
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, @NotNull UsageTarget[] targets) {
        boolean isInLib;
        if (usage == null) {
            UsageScopeGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            UsageScopeGroupingRule.$$$reportNull$$$0(1);
        }
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElementUsage elementUsage = (PsiElementUsage)usage;
        PsiElement element = elementUsage.getElement();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
        if (virtualFile2 == null) {
            return null;
        }
        Project project = element.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        boolean bl = isInLib = fileIndex.isInLibraryClasses(virtualFile2) || fileIndex.isInLibrarySource(virtualFile2);
        if (isInLib) {
            return LIBRARY;
        }
        return TestSourcesFilter.isTestSources(virtualFile2, project) ? TEST : PRODUCTION;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/usages/impl/rules/UsageScopeGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class UsageScopeGroup
    implements UsageGroup {
        private final int myCode;

        private UsageScopeGroup(int code) {
            this.myCode = code;
        }

        @Override
        public void update() {
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void navigate(boolean focus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                UsageScopeGroup.$$$reportNull$$$0(0);
            }
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsageScopeGroup)) {
                return false;
            }
            UsageScopeGroup usageTypeGroup = (UsageScopeGroup)o;
            return this.myCode == usageTypeGroup.myCode;
        }

        public int hashCode() {
            return this.myCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/UsageScopeGroupingRule$UsageScopeGroup", "compareTo"));
        }
    }
}

