/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;

public class HgFileRevision
implements VcsFileRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private final String myBranchName;
    private final Date myRevisionDate;
    private final String myAuthor;
    private final String myCommitMessage;
    private final Set<String> myFilesModified;
    private final Set<String> myFilesAdded;
    private final Set<String> myFilesDeleted;
    private final Map<String, String> myFilesMoved;

    public HgFileRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber vcsRevisionNumber, String branchName, Date revisionDate, String author, String commitMessage, Set<String> filesModified, Set<String> filesAdded, Set<String> filesDeleted, Map<String, String> filesMoved) {
        if (hgFile == null) {
            HgFileRevision.$$$reportNull$$$0(0);
        }
        if (vcsRevisionNumber == null) {
            HgFileRevision.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFile = hgFile;
        this.myRevisionNumber = vcsRevisionNumber;
        this.myBranchName = branchName;
        this.myRevisionDate = revisionDate;
        this.myAuthor = author;
        this.myCommitMessage = commitMessage;
        this.myFilesModified = filesModified;
        this.myFilesAdded = filesAdded;
        this.myFilesDeleted = filesDeleted;
        this.myFilesMoved = filesMoved;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = this.myRevisionNumber;
        if (hgRevisionNumber == null) {
            HgFileRevision.$$$reportNull$$$0(2);
        }
        return hgRevisionNumber;
    }

    public String getBranchName() {
        return this.myBranchName;
    }

    @Nullable
    public RepositoryLocation getChangedRepositoryPath() {
        return null;
    }

    public Date getRevisionDate() {
        return this.myRevisionDate;
    }

    @Nullable
    public String getAuthor() {
        return this.myAuthor;
    }

    @Nullable
    public String getCommitMessage() {
        return this.myCommitMessage;
    }

    @NotNull
    public Set<String> getModifiedFiles() {
        Set<String> set = this.myFilesModified;
        if (set == null) {
            HgFileRevision.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getAddedFiles() {
        Set<String> set = this.myFilesAdded;
        if (set == null) {
            HgFileRevision.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getDeletedFiles() {
        Set<String> set = this.myFilesDeleted;
        if (set == null) {
            HgFileRevision.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Map<String, String> getMovedFiles() {
        Map<String, String> map = this.myFilesMoved;
        if (map == null) {
            HgFileRevision.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    public byte[] loadContent() {
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myFile);
        byte[] byArray = HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat);
        if (byArray == null) {
            HgFileRevision.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    public byte[] getContent() throws IOException, VcsException {
        return this.loadContent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgFileRevision revision = (HgFileRevision)o;
        if (!this.myFile.equals(revision.myFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.myFile, this.myRevisionNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hgFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRevisionNumber";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgFileRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgFileRevision";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedFiles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMovedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

