/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import org.jetbrains.annotations.NotNull;

public class PhpQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public PhpQuoteHandler() {
        super(new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpTokenTypes.chBACKTRICK});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (this.isInsideLiteral(iterator)) {
            int start = iterator.getStart();
            return offset == start;
        }
        IElementType tokenType = iterator.getTokenType();
        return tokenType == PhpTokenTypes.chLDOUBLE_QUOTE || tokenType == PhpTokenTypes.chLSINGLE_QUOTE;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (this.isInsideLiteral(iterator)) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 1 && offset == end - 1;
        }
        IElementType tokenType = iterator.getTokenType();
        return tokenType == PhpTokenTypes.chRDOUBLE_QUOTE || tokenType == PhpTokenTypes.chRSINGLE_QUOTE;
    }

    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator, int offset) {
        Document document;
        int lineEndOffset;
        if (editor == null) {
            PhpQuoteHandler.$$$reportNull$$$0(0);
        }
        if (iterator == null) {
            PhpQuoteHandler.$$$reportNull$$$0(1);
        }
        if (offset < (lineEndOffset = (document = editor.getDocument()).getLineEndOffset(document.getLineNumber(offset)))) {
            CharSequence charSequence = document.getCharsSequence();
            char openQuote = charSequence.charAt(offset);
            int nextCharOffset = offset + 1;
            if (nextCharOffset < lineEndOffset && charSequence.charAt(nextCharOffset) == openQuote) {
                return true;
            }
            for (int i = nextCharOffset + 1; i < lineEndOffset; ++i) {
                if (charSequence.charAt(i) != openQuote) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "iterator";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/PhpQuoteHandler";
        objectArray[2] = "hasNonClosedLiteral";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

