/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.listener;

import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.debug.connection.PhpDebugServer;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.xdebug.connection.XdebugExternalConnectionsProjectManager;
import com.jetbrains.php.debug.xdebug.connection.XdebugServerConnectionManager;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerExternalConnectionsProjectManager;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerServerConnectionManager;
import com.jetbrains.php.debug.zend.settingsBroadcasting.ZendDebuggerBroadcastingServer;
import com.jetbrains.php.debug.zend.settingsBroadcasting.ZendDebuggerBroadcastingServerConnectionManager;
import com.jetbrains.php.util.connection.ServerConnection;
import com.jetbrains.php.util.connection.ServerConnectionListener;
import com.jetbrains.php.util.connection.ServerConnectionStatus;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpDebugExternalConnectionsAccepter
implements ServerConnectionListener<ServerConnection>,
Disposable {
    public static final String NOTIFICATION_ID = "PhpDebugListener";
    private final List<ServerConnection> myServerConnectionList;
    private final Object myLock;
    private final Project myProject;

    public PhpDebugExternalConnectionsAccepter(@NotNull Project project) {
        if (project == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(0);
        }
        this.myServerConnectionList = new ArrayList<ServerConnection>();
        this.myLock = new Object();
        this.myProject = project;
        XdebugExternalConnectionsProjectManager.getInstance(this.myProject);
        ZendDebuggerExternalConnectionsProjectManager.getInstance(this.myProject);
    }

    public static PhpDebugExternalConnectionsAccepter getInstance(Project project) {
        return (PhpDebugExternalConnectionsAccepter)ServiceManager.getService((Project)project, PhpDebugExternalConnectionsAccepter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreListeningState() {
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
        assert (state != null);
        Object object = this.myLock;
        synchronized (object) {
            if (state.isListeningStarted() && !this.isStarted()) {
                this.start();
                ((StateChangedListener)this.myProject.getMessageBus().syncPublisher(StateChangedListener.TOPIC)).stateChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSwitch() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.isStarted()) {
                this.stop();
            } else {
                this.start();
            }
        }
        ((StateChangedListener)this.myProject.getMessageBus().syncPublisher(StateChangedListener.TOPIC)).stateChanged();
    }

    private void start() {
        PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
        assert (state != null);
        if (state.isXDebugCanAcceptExternalConnections()) {
            int xDebugDebugPort = state.getXDebugDebugPort();
            try {
                this.start((PhpDebugServer)XdebugServerConnectionManager.getInstance().start(xDebugDebugPort));
            }
            catch (ExecutionException e) {
                this.notify(PhpBundle.message("debug.cannot.start.listening.for.connections.from.0", XdebugExtension.INSTANCE.getName()), e.getMessage());
            }
        }
        if (state.isZendDebuggerCanAcceptExternalConnections()) {
            int zendDebuggerDebugPort = state.getZendDebuggerDebugPort();
            try {
                this.start((PhpDebugServer)ZendDebuggerServerConnectionManager.getInstance().start(zendDebuggerDebugPort));
            }
            catch (ExecutionException e) {
                this.notify(PhpBundle.message("debug.cannot.start.listening.for.connections.from.0", ZendDebuggerExtension.INSTANCE.getName()), e.getMessage());
            }
            try {
                int settingsBroadcastingPort = state.getZendDebuggerSettingsBroadcastingPort();
                this.start(ZendDebuggerBroadcastingServerConnectionManager.getInstance().start(this.myProject, settingsBroadcastingPort, zendDebuggerDebugPort));
            }
            catch (ExecutionException e) {
                this.notify(PhpBundle.message("debug.cannot.start", ZendDebuggerBroadcastingServer.DESCRIPTIVE_NAME), e.getMessage());
            }
        }
        state.setListeningStarted(this.isStarted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.myLock;
        synchronized (object) {
            for (ServerConnection serverConnection : this.myServerConnectionList) {
                serverConnection.removeListener(this);
                if (serverConnection instanceof PhpDebugServer) {
                    ((PhpDebugServer)serverConnection).unregisterExternalConnectionListener(this);
                    continue;
                }
                if (!(serverConnection instanceof ZendDebuggerBroadcastingServer)) continue;
                ((ZendDebuggerBroadcastingServer)serverConnection).unregisterExternalConnectionListener(this);
            }
            this.myServerConnectionList.clear();
            PhpProjectDebugConfiguration.State state = PhpProjectDebugConfiguration.getInstance(this.myProject).getState();
            assert (state != null);
            state.setListeningStarted(this.isStarted());
        }
    }

    private void start(@NotNull PhpDebugServer debugServer) throws ExecutionException {
        if (debugServer == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(1);
        }
        debugServer.addListener(this, (Disposable)this.myProject);
        debugServer.registerExternalConnectionListener(this);
        this.myServerConnectionList.add(debugServer);
    }

    private void start(@NotNull ZendDebuggerBroadcastingServer broadcastingServer) throws ExecutionException {
        if (broadcastingServer == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(2);
        }
        broadcastingServer.addListener(this, (Disposable)this.myProject);
        broadcastingServer.registerExternalConnectionListener(this);
        this.myServerConnectionList.add(broadcastingServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myServerConnectionList.size() != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(@NotNull ServerConnection serverConnection, @NotNull ServerConnectionStatus status) {
        if (serverConnection == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(3);
        }
        if (status == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            switch (status) {
                case STARTED: 
                case STOPPED: {
                    this.myServerConnectionList.remove(serverConnection);
                }
            }
        }
    }

    public void dispose() {
        this.stop();
    }

    protected void notify(@NotNull String title, @NotNull String text) {
        if (title == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(5);
        }
        if (text == null) {
            PhpDebugExternalConnectionsAccepter.$$$reportNull$$$0(6);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_ID, title, text, NotificationType.WARNING), (Project)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugServer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "broadcastingServer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConnection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/listener/PhpDebugExternalConnectionsAccepter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "statusChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notify";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface StateChangedListener {
        public static final Topic<StateChangedListener> TOPIC = Topic.create((String)"stateChanged", StateChangedListener.class);

        public void stateChanged();
    }
}

