/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.net.URISyntaxException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public final class MarkdownCssSettings {
    public static final MarkdownCssSettings DEFAULT = new MarkdownCssSettings(false);
    public static final MarkdownCssSettings DARCULA = new MarkdownCssSettings(true);
    @Attribute(value="UriEnabled")
    private boolean myUriEnabled;
    @Attribute(value="StylesheetUri")
    @NotNull
    private String myStylesheetUri;
    @Attribute(value="TextEnabled")
    private boolean myTextEnabled;
    @Attribute(value="StylesheetText")
    @NotNull
    private String myStylesheetText;

    private MarkdownCssSettings() {
        this(UIUtil.isUnderDarcula());
    }

    private MarkdownCssSettings(boolean isDarcula) {
        this(false, MarkdownCssSettings.getPredefinedCssURI(isDarcula), false, "");
    }

    public MarkdownCssSettings(boolean uriEnabled, @NotNull String stylesheetUri, boolean textEnabled, @NotNull String stylesheetText) {
        if (stylesheetUri == null) {
            MarkdownCssSettings.$$$reportNull$$$0(0);
        }
        if (stylesheetText == null) {
            MarkdownCssSettings.$$$reportNull$$$0(1);
        }
        this.myUriEnabled = uriEnabled;
        this.myStylesheetUri = stylesheetUri;
        this.myTextEnabled = textEnabled;
        this.myStylesheetText = stylesheetText;
    }

    public boolean isUriEnabled() {
        return this.myUriEnabled;
    }

    @NotNull
    public String getStylesheetUri() {
        String string = this.myStylesheetUri;
        if (string == null) {
            MarkdownCssSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isTextEnabled() {
        return this.myTextEnabled;
    }

    @NotNull
    public String getStylesheetText() {
        String string = this.myStylesheetText;
        if (string == null) {
            MarkdownCssSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownCssSettings settings = (MarkdownCssSettings)o;
        if (this.myUriEnabled != settings.myUriEnabled) {
            return false;
        }
        if (this.myTextEnabled != settings.myTextEnabled) {
            return false;
        }
        if (!this.myStylesheetUri.equals(settings.myStylesheetUri)) {
            return false;
        }
        return this.myStylesheetText.equals(settings.myStylesheetText);
    }

    @NotNull
    public static MarkdownCssSettings getDefaultCssSettings(boolean isDarcula) {
        MarkdownCssSettings markdownCssSettings = isDarcula ? DARCULA : DEFAULT;
        if (markdownCssSettings == null) {
            MarkdownCssSettings.$$$reportNull$$$0(4);
        }
        return markdownCssSettings;
    }

    @NotNull
    private static String getPredefinedCssURI(boolean isDarcula) {
        String string;
        String fileName = isDarcula ? "darcula.css" : "default.css";
        try {
            URL resource = MarkdownCssSettings.class.getResource(fileName);
            string = resource != null ? resource.toURI().toString() : "";
        }
        catch (URISyntaxException e) {
            Logger.getInstance(MarkdownCssSettings.class).error((Throwable)e);
            if ("" == null) {
                MarkdownCssSettings.$$$reportNull$$$0(6);
            }
            return "";
        }
        if (string == null) {
            MarkdownCssSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    public int hashCode() {
        int result = this.myUriEnabled ? 1 : 0;
        result = 31 * result + this.myStylesheetUri.hashCode();
        result = 31 * result + (this.myTextEnabled ? 1 : 0);
        result = 31 * result + this.myStylesheetText.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheetUri";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheetText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/settings/MarkdownCssSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/settings/MarkdownCssSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesheetUri";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStylesheetText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCssSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedCssURI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Holder {
        public void setMarkdownCssSettings(@NotNull MarkdownCssSettings var1);

        @NotNull
        public MarkdownCssSettings getMarkdownCssSettings();
    }
}

