/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptReferenceContributor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGenerateReferencePathIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement resolve;
        int newlineOffset;
        PsiElement ws;
        if (project == null) {
            TypeScriptGenerateReferencePathIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptGenerateReferencePathIntention.$$$reportNull$$$0(1);
        }
        PsiFile file2 = element.getContainingFile();
        PsiComment lastReferencePathComment = null;
        PsiElement child = file2.getFirstChild();
        while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
            String path;
            if (child instanceof PsiComment && (path = TypeScriptReferenceContributor.findReferencePath((PsiComment)child)) != null) {
                lastReferencePathComment = (PsiComment)child;
            }
            child = child.getNextSibling();
        }
        int offset = 0;
        if (lastReferencePathComment != null && (ws = lastReferencePathComment.getNextSibling()) instanceof PsiWhiteSpace && (newlineOffset = ws.getText().indexOf(10)) >= 0) {
            offset = ws.getTextRange().getStartOffset() + newlineOffset + 1;
        }
        if ((resolve = ((JSReferenceExpression)element.getParent()).resolve()) == null) {
            return;
        }
        String relativePath = VfsUtilCore.findRelativePath((VirtualFile)file2.getVirtualFile(), (VirtualFile)resolve.getContainingFile().getVirtualFile(), (char)'/');
        editor.getDocument().insertString(offset, (CharSequence)("///<reference path=\"" + relativePath + "\"/>\n"));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile containingFile;
        if (project == null) {
            TypeScriptGenerateReferencePathIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptGenerateReferencePathIntention.$$$reportNull$$$0(3);
        }
        if (!((containingFile = element.getContainingFile()) instanceof JSFile) || ((JSFile)containingFile).isCommonJSModule() || !(element.getParent() instanceof JSReferenceExpression) || !DialectDetector.isTypeScript(element)) {
            return false;
        }
        PsiElement resolve = ((JSReferenceExpression)element.getParent()).resolve();
        if (resolve == null) {
            return false;
        }
        PsiFile referencedFile = resolve.getContainingFile();
        PsiFile currentFile = element.getContainingFile();
        if (referencedFile == null || currentFile == null) {
            return false;
        }
        if (referencedFile.isEquivalentTo((PsiElement)currentFile) || TypeScriptLibraryProvider.getAllLibraries(project).contains(referencedFile.getVirtualFile())) {
            return false;
        }
        PsiElement currentElement = element.getParent().getParent().getFirstChild();
        while (true) {
            PsiElement nextSibling;
            TypeScriptExternalModuleReference externalModuleReference;
            if (currentElement instanceof PsiComment) {
                PsiFile file2 = TypeScriptReferenceContributor.findReferencedFile((PsiComment)currentElement);
                if (file2 != null && file2.isEquivalentTo((PsiElement)referencedFile)) {
                    return false;
                }
            } else if (currentElement instanceof TypeScriptImportStatement && (externalModuleReference = ((TypeScriptImportStatement)currentElement).getExternalModuleReference()) != null) {
                Collection elements = externalModuleReference.multiResolve();
                for (PsiElement importResolve : elements) {
                    if (!(importResolve instanceof PsiFile) || !importResolve.isEquivalentTo((PsiElement)referencedFile)) continue;
                    return false;
                }
            }
            if ((nextSibling = currentElement.getNextSibling()) != null) {
                currentElement = nextSibling;
                continue;
            }
            PsiElement parent = currentElement.getParent();
            if (parent instanceof PsiFile) {
                return true;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent == null) {
                return true;
            }
            currentElement = grandParent.getFirstChild();
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"ts.generate.reference.path.name", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptGenerateReferencePathIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptGenerateReferencePathIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptGenerateReferencePathIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

