/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamedToFunctionExpressionIntention
extends JavaScriptIntention {
    public JSNamedToFunctionExpressionIntention() {
        this.setText(JSBundle.message((String)"js.named.to.anonymous.family.name", (Object[])new Object[0]));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.named.to.anonymous.family.name", (Object[])new Object[0]);
        if (string == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(1);
        }
        return currentFile;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSFunction declaration = JSNamedToFunctionExpressionIntention.getFunction(element);
        if (declaration == null || StringUtil.isEmpty((String)declaration.getName()) || declaration.getKind() != JSFunction.FunctionKind.SIMPLE || TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)declaration)) {
            return false;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)declaration);
        boolean isClassMember = declaration.getParent() instanceof JSClass;
        if (isClassMember && !JSClassUtils.isES6ClassImplementation(dialect)) {
            return false;
        }
        this.setText(JSNamedToFunctionExpressionIntention.canConvertToArrowFunction(dialect, declaration) ? JSBundle.message((String)"js.named.to.arrow.text", (Object[])new Object[]{isClassMember ? "field" : "variable"}) : JSBundle.message((String)"js.named.to.function.expression.text", (Object[])new Object[0]));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(5);
        }
        JSFunction declaration = JSNamedToFunctionExpressionIntention.getFunction(element);
        assert (declaration != null);
        boolean isClassMember = declaration.getParent() instanceof JSClass;
        if (!JSRefactoringUtil.showConflictsDialog(declaration.getProject(), JSNamedToFunctionExpressionIntention.getConflicts(declaration, isClassMember))) {
            return;
        }
        Ref hasReassignments = new Ref((Object)Boolean.FALSE);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> hasReassignments.set((Object)((Boolean)ApplicationManager.getApplication().runReadAction(() -> ReferencesSearch.search((PsiElement)declaration, (SearchScope)declaration.getUseScope()).forEach(reference -> !(reference instanceof JSReferenceExpression) || !(((JSReferenceExpression)reference).getParent() instanceof JSDefinitionExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)reference, declaration.getName()))) == false ? 1 : 0)), "Find Usages", true, declaration.getProject())) {
            return;
        }
        WriteAction.run(() -> JSNamedToFunctionExpressionIntention.performReplacement(declaration, isClassMember, hasReassignments.get() == Boolean.TRUE));
    }

    private static void performReplacement(@NotNull JSFunction function, boolean isClassMember, boolean hasReassignments) {
        JSExpression initializer;
        JSVarStatement varStatement;
        if (function == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(6);
        }
        String functionName = function.getName();
        assert (functionName != null);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)function);
        String varPrefix = !hasReassignments && DialectDetector.hasFeature(dialectOptionHolder, JSLanguageFeature.CONST_DEFINITIONS) ? "const " : JSChangeUtil.getVariablePrefix(dialectOptionHolder);
        JSVarStatement jSVarStatement = varStatement = isClassMember ? JSChangeUtil.createClassMemberPsiFromTextWithContext(functionName + " = null" + semicolon, (PsiElement)function, JSVarStatement.class) : JSChangeUtil.createStatementPsiFromTextWithContext(String.format("%s %s = null%s", varPrefix, functionName, semicolon), (PsiElement)function, JSVarStatement.class);
        assert (varStatement != null);
        JSVariable firstVariable = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables());
        JSExpression jSExpression = initializer = firstVariable != null ? firstVariable.getInitializer() : null;
        assert (initializer != null);
        JSFunctionsRefactoringUtil.moveNonFunctionAttributes(function, (JSAttributeListOwner)varStatement);
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)function);
        JSDocumentationUtils.copyJSDocComment(docComment, (PsiElement)varStatement);
        if (JSNamedToFunctionExpressionIntention.canConvertToArrowFunction(dialectOptionHolder, function)) {
            initializer.replace((JSExpression)JSFunctionsRefactoringUtil.createArrowFunction(function));
        } else {
            initializer.replace((JSExpression)JSFunctionsRefactoringUtil.createAnonymousFunctionExpression(function));
        }
        if (function.getParent() instanceof ES6ExportDefaultAssignment) {
            ES6ExportDefaultAssignment exportDefault = (ES6ExportDefaultAssignment)function.getParent();
            JSExpression expression = exportDefault.getExpression();
            assert (expression != null);
            expression.replace(JSChangeUtil.createExpressionPsiWithContext(functionName, (PsiElement)function, JSExpression.class));
            JSChangeUtil.doAddBefore(exportDefault.getParent(), (PsiElement)varStatement, (PsiElement)exportDefault);
        } else {
            function.replace((PsiElement)varStatement);
        }
    }

    @Nullable
    private static MultiMap<PsiElement, String> getConflicts(@NotNull JSFunction declaration, boolean isClassMember) {
        if (declaration == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(7);
        }
        if (isClassMember) {
            return null;
        }
        MultiMap conflicts = new MultiMap();
        PsiElement useScope = (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.getLexicalScope((JSNamedElement)declaration), (Object)declaration.getContainingFile());
        JSElement currentBlock = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)declaration, (Class[])new Class[]{JSExecutionScope.class, JSBlockStatement.class});
        Object[] statements = (JSSourceElement[])ObjectUtils.coalesce((Object)PsiTreeUtil.getChildrenOfType((PsiElement)currentBlock, JSSourceElement.class), (Object)JSStatement.EMPTY);
        JSSourceElement containingDeclaration = (JSSourceElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)declaration, (Class[])new Class[]{JSSourceElement.class});
        int declarationIndex = ArrayUtil.indexOf((Object[])statements, (Object)containingDeclaration);
        while (currentBlock != null) {
            JSNamedToFunctionExpressionIntention.checkUsedInStatements((JSSourceElement[])statements, declaration, declarationIndex < 0 ? statements.length : declarationIndex, (MultiMap<PsiElement, String>)conflicts);
            declarationIndex = -1;
            currentBlock = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)currentBlock, (Class[])new Class[]{JSExecutionScope.class, JSBlockStatement.class});
            if (currentBlock instanceof JSFunction || PsiTreeUtil.isAncestor((PsiElement)currentBlock, (PsiElement)useScope, (boolean)false)) {
                return conflicts;
            }
            if (currentBlock == null) continue;
            statements = (JSSourceElement[])ObjectUtils.coalesce((Object)PsiTreeUtil.getChildrenOfType((PsiElement)currentBlock, JSStatement.class), (Object)JSSourceElement.EMPTY_ARRAY);
        }
        return conflicts;
    }

    private static void checkUsedInStatements(@NotNull JSSourceElement[] statements, final @NotNull JSFunction target, int lastIndex, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (statements == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(8);
        }
        if (target == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(9);
        }
        if (conflicts == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(10);
        }
        for (int i = 0; i < lastIndex; ++i) {
            JSSourceElement statement = statements[i];
            final Ref referencesFunction = new Ref();
            statement.accept((PsiElementVisitor)new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

                @Override
                protected boolean skipLambdas() {
                    return true;
                }

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (node.getQualifier() == null && target.isEquivalentTo(node.resolve())) {
                        referencesFunction.set((Object)Boolean.TRUE);
                        this.stopWalking();
                    }
                }

                public void visitJSClass(JSClass aClass) {
                }
            });
            if (!Boolean.TRUE.equals(referencesFunction.get())) continue;
            conflicts.putValue((Object)statement, (Object)JSBundle.message((String)"js.named.to.function.hoisting.conflict.text", (Object[])new Object[0]));
        }
    }

    private static boolean canConvertToArrowFunction(@Nullable DialectOptionHolder dialect, @NotNull JSFunction declaration) {
        if (declaration == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(11);
        }
        return dialect != null && dialect.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS) && !declaration.isGenerator() && !declaration.isReferencesArguments() && (declaration.getParent() instanceof JSClass || PsiTreeUtil.findChildOfType((PsiElement)declaration, JSThisExpression.class) == null);
    }

    @Nullable
    private static JSFunction getFunction(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSNamedToFunctionExpressionIntention.$$$reportNull$$$0(12);
        }
        if ((parent = element.getParent()) instanceof JSParameter) {
            parent = parent.getParent();
        }
        if (parent instanceof JSParameterList) {
            parent = parent.getParent();
        }
        if (parent instanceof JSFunctionDeclaration) {
            return (JSFunctionDeclaration)parent;
        }
        if (parent instanceof JSFunctionExpression && parent.getParent() instanceof ES6ExportDefaultAssignment) {
            return (JSFunctionExpression)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSNamedToFunctionExpressionIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSNamedToFunctionExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performReplacement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConflicts";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkUsedInStatements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canConvertToArrowFunction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

