/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.model.DomModel;
import com.intellij.util.xml.model.MultipleDomModelFactory;
import com.intellij.util.xml.model.SimpleModelFactory;
import com.intellij.util.xml.model.impl.CachedMultipleDomModelFactory;
import com.intellij.util.xml.model.impl.CachedSimpleDomModelFactory;
import com.intellij.util.xml.model.impl.DomModelFactoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDomModelFactory<S extends UserDataHolder, T extends DomElement, M extends DomModel<T>, C extends PsiElement>
extends DomModelFactoryHelper<T>
implements SimpleModelFactory<T, M>,
MultipleDomModelFactory<S, T, M> {
    private final Project myProject;
    private final SimpleModelFactory<T, M> mySimpleDomModelFactory;
    private final MultipleDomModelFactory<S, T, M> myMultipleDomModelFactory;

    protected BaseDomModelFactory(@NotNull Class<T> aClass, Project project, @NonNls String name) {
        if (aClass == null) {
            BaseDomModelFactory.$$$reportNull$$$0(0);
        }
        super(aClass, DomService.getInstance().createModelMerger());
        this.myProject = project;
        this.mySimpleDomModelFactory = this.createSimpleModelFactory(aClass, this.getModelMerger(), project, name);
        this.myMultipleDomModelFactory = this.createMultipleDomModelFactory(aClass, this.getModelMerger(), project, name);
    }

    protected abstract S getModelScope(XmlFile var1);

    @Nullable
    protected abstract List<M> computeAllModels(@NotNull S var1);

    protected abstract M createCombinedModel(@NotNull Set<XmlFile> var1, @NotNull DomFileElement<T> var2, M var3, S var4);

    @Nullable
    public M getModel(@NotNull C context) {
        PsiFile psiFile;
        if (context == null) {
            BaseDomModelFactory.$$$reportNull$$$0(1);
        }
        if ((psiFile = context.getContainingFile()) instanceof XmlFile) {
            return this.getModelByConfigFile((XmlFile)psiFile);
        }
        return null;
    }

    @Override
    @NotNull
    public List<M> getAllModels(@NotNull S scope) {
        if (scope == null) {
            BaseDomModelFactory.$$$reportNull$$$0(2);
        }
        List<M> list = this.myMultipleDomModelFactory.getAllModels(scope);
        if (list == null) {
            BaseDomModelFactory.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public M getModelByConfigFile(@Nullable XmlFile psiFile) {
        return this.mySimpleDomModelFactory.getModelByConfigFile(psiFile);
    }

    @NotNull
    public Object[] computeDependencies(@Nullable M model, @Nullable S scope) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        if (scope != null) {
            dependencies.add(ProjectRootManager.getInstance((Project)this.getProject()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            BaseDomModelFactory.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @Nullable
    protected M computeModel(@NotNull XmlFile psiFile, @Nullable S scope) {
        if (psiFile == null) {
            BaseDomModelFactory.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            return null;
        }
        List<M> models = this.getAllModels(scope);
        for (DomModel model : models) {
            Set<XmlFile> configFiles = model.getConfigFiles();
            if (!configFiles.contains(psiFile)) continue;
            return (M)model;
        }
        return null;
    }

    @Override
    @Nullable
    public M getCombinedModel(@Nullable S scope) {
        return this.myMultipleDomModelFactory.getCombinedModel(scope);
    }

    @Override
    @NotNull
    public Set<XmlFile> getAllConfigFiles(@NotNull S scope) {
        if (scope == null) {
            BaseDomModelFactory.$$$reportNull$$$0(6);
        }
        Set<XmlFile> set = this.myMultipleDomModelFactory.getAllConfigFiles(scope);
        if (set == null) {
            BaseDomModelFactory.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Override
    @Nullable
    public DomFileElement<T> createMergedModelRoot(Set<XmlFile> configFiles) {
        return this.mySimpleDomModelFactory.createMergedModelRoot(configFiles);
    }

    private CachedMultipleDomModelFactory<S, T, M, C> createMultipleDomModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, String name) {
        return new CachedMultipleDomModelFactory<S, T, M, C>(aClass, modelMerger, project, name){

            @Override
            public M getModel(@NotNull C context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                return BaseDomModelFactory.this.getModel(context);
            }

            @Override
            protected List<M> computeAllModels(@NotNull S scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(1);
                }
                return BaseDomModelFactory.this.computeAllModels(scope);
            }

            @Override
            protected M createCombinedModel(Set<XmlFile> configFiles, DomFileElement<T> mergedModel, M firstModel, S scope) {
                return BaseDomModelFactory.this.createCombinedModel(configFiles, mergedModel, firstModel, scope);
            }

            @Override
            @NotNull
            public Object[] computeDependencies(@Nullable M model, @Nullable S scope) {
                Object[] objectArray = BaseDomModelFactory.this.computeDependencies(model, scope);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return objectArray;
            }

            @Override
            public S getModelScope(@NotNull XmlFile xmlFile) {
                if (xmlFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                return BaseDomModelFactory.this.getModelScope(xmlFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/xml/model/impl/BaseDomModelFactory$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "xmlFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/xml/model/impl/BaseDomModelFactory$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "computeDependencies";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getModel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "computeAllModels";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getModelScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private CachedSimpleDomModelFactory<T, M, S> createSimpleModelFactory(Class<T> aClass, ModelMerger modelMerger, Project project, String name) {
        return new CachedSimpleDomModelFactory<T, M, S>(aClass, modelMerger, project, name){

            @Override
            protected M computeModel(@NotNull XmlFile psiFile, @Nullable S scope) {
                if (psiFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                return BaseDomModelFactory.this.computeModel(psiFile, scope);
            }

            @Override
            @NotNull
            public Object[] computeDependencies(@Nullable M model, @Nullable S scope) {
                Object[] objectArray = BaseDomModelFactory.this.computeDependencies(model, scope);
                if (objectArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            @Override
            public S getModelScope(@NotNull XmlFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(2);
                }
                return BaseDomModelFactory.this.getModelScope(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/xml/model/impl/BaseDomModelFactory$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/xml/model/impl/BaseDomModelFactory$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "computeDependencies";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "computeModel";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getModelScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/model/impl/BaseDomModelFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/model/impl/BaseDomModelFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModels";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllModels";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllConfigFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

