/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.RazorRepository;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.StringUtils;

class RazorHistoryParser {
    private RazorRepository repository = new RazorRepository();
    private static final Pattern ACTION_TYPE_PATTERN = Pattern.compile("^(INTRODUCE|CHECK-OUT|CHECK-IN|UN-CHECK-OUT|RENAME|EDIT_PROPS|ALTERED|CHECK-POINT|REVERT|INTRODUCE_AND_EDIT|BRANCH|BUMP|MERGE-CHECK-IN|PROMOTE)\\s+(\\S*)\\s+([\\.0-9]+)?\\s+(\\S*)\\s+(\\S*)\\s*$");
    private static final Pattern ADDITIONAL_INFO_PATTERN = Pattern.compile("^##(TITLE|NOTES|AUDIT|ISSUE):\\s+(.*)\\s*$");
    private static final boolean DUMP_HISTORY_ENTRY_ADDITIONS = false;

    RazorHistoryParser() {
    }

    History parse(File file, Repository repos) throws HistoryException {
        try {
            return this.parseFile(file, repos);
        }
        catch (IOException ioe) {
            throw new HistoryException(ioe);
        }
    }

    private History parseFile(File file, Repository repos) throws IOException {
        this.repository = (RazorRepository)repos;
        File mappedFile = this.repository.getRazorHistoryFileFor(file);
        this.parseDebug("Mapping " + file.getPath() + " to '" + mappedFile.getPath() + "'");
        if (!mappedFile.exists()) {
            this.parseProblem("History File Mapping is NON-EXISTENT (" + mappedFile.getAbsolutePath() + ")");
            return null;
        }
        if (mappedFile.isDirectory()) {
            this.parseProblem("History File Mapping is a DIRECTORY (" + mappedFile.getAbsolutePath() + ")");
            return null;
        }
        try (FileReader contents = new FileReader(mappedFile.getAbsoluteFile());){
            History history = this.parseContents(new BufferedReader(contents));
            return history;
        }
    }

    protected History parseContents(BufferedReader contents) throws IOException {
        String line;
        DateFormat df = this.repository.getDateFormat();
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        HistoryEntry entry = null;
        boolean ignoreEntry = false;
        boolean seenActionType = false;
        boolean lastWasTitle = true;
        Matcher actionMatcher = ACTION_TYPE_PATTERN.matcher("");
        Matcher infoMatcher = ADDITIONAL_INFO_PATTERN.matcher("");
        while ((line = contents.readLine()) != null) {
            this.parseDebug("Processing '" + line + "'");
            if (StringUtils.isOnlyWhitespace(line)) {
                if (entry != null && entry.getDate() != null) {
                    entries.add(entry);
                    this.dumpEntry(entry);
                }
                entry = new HistoryEntry();
                ignoreEntry = false;
                seenActionType = false;
                continue;
            }
            if (ignoreEntry) continue;
            if (seenActionType) {
                infoMatcher.reset(line);
                if (infoMatcher.find()) {
                    String infoType = infoMatcher.group(1);
                    String details = infoMatcher.group(2);
                    if ("TITLE".equals(infoType)) {
                        this.parseDebug("Setting Message : '" + details + "'");
                        entry.setMessage(details);
                        lastWasTitle = true;
                        continue;
                    }
                    if ("ISSUE".equals(infoType)) {
                        this.parseDebug("Adding CR : '" + details + "'");
                        entry.addChangeRequest(details);
                        continue;
                    }
                    this.parseDebug("Ignoring Info Type Line '" + line + "'");
                    continue;
                }
                if (!line.startsWith("##") && line.charAt(0) == '#') {
                    this.parseDebug("Seen Comment : '" + line + "'");
                    if (lastWasTitle) {
                        entry.appendMessage("");
                        lastWasTitle = false;
                    }
                    entry.appendMessage(line.substring(1));
                    continue;
                }
                this.parseProblem("Expecting addlInfo and got '" + line + "'");
                continue;
            }
            actionMatcher.reset(line);
            if (actionMatcher.find()) {
                seenActionType = true;
                if (entry != null && entry.getDate() != null) {
                    entries.add(entry);
                    this.dumpEntry(entry);
                }
                entry = new HistoryEntry();
                String actionType = actionMatcher.group(1);
                String userName = actionMatcher.group(2);
                String revision = actionMatcher.group(3);
                String state = actionMatcher.group(4);
                String dateTime = actionMatcher.group(5);
                this.parseDebug("New History Event Seen : actionType = " + actionType + ", userName = " + userName + ", revision = " + revision + ", state = " + state + ", dateTime = " + dateTime);
                if (actionType.startsWith("INTRODUCE") || actionType.contains("CHECK-IN") || "CHECK-POINT".equals(actionType) || "REVERT".equals(actionType)) {
                    entry.setAuthor(userName);
                    entry.setRevision(revision);
                    entry.setActive("Active".equals(state));
                    Date date = null;
                    try {
                        date = df.parse(dateTime);
                    }
                    catch (ParseException pe) {
                        OpenGrokLogger.getLogger().log(Level.WARNING, "Could not parse date: " + dateTime, pe);
                    }
                    entry.setDate(date);
                    ignoreEntry = false;
                    continue;
                }
                ignoreEntry = true;
                continue;
            }
            this.parseProblem("Expecting actionType and got '" + line + "'");
        }
        if (entry != null && entry.getDate() != null) {
            entries.add(entry);
            this.dumpEntry(entry);
        }
        History history = new History();
        history.setHistoryEntries(entries);
        return history;
    }

    private void dumpEntry(HistoryEntry entry) {
    }

    private void parseDebug(String message) {
        OpenGrokLogger.getLogger().log(Level.FINE, "RazorHistoryParser: " + message);
    }

    private void parseProblem(String message) {
        OpenGrokLogger.getLogger().log(Level.SEVERE, "PROBLEM: RazorHistoryParser - " + message);
    }
}

