/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0010*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkTypeAndArguments", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "reportOn", "Lorg/jetbrains/kotlin/KtSourceElement;", "singleExpressionType", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "getSingleExpressionType", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAmbiguousAnonymousTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAmbiguousAnonymousTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1761#2,3:91\n1563#2:96\n1634#2,3:97\n40#3:94\n1#4:95\n*S KotlinDebug\n*F\n+ 1 FirAmbiguousAnonymousTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAmbiguousAnonymousTypeChecker\n*L\n30#1:91,3\n75#1:96\n75#1:97,3\n34#1:94\n*E\n"})
public final class FirAmbiguousAnonymousTypeChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirAmbiguousAnonymousTypeChecker INSTANCE = new FirAmbiguousAnonymousTypeChecker();

    private FirAmbiguousAnonymousTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        block17: {
            Object object;
            Object it;
            block16: {
                FirCallableDeclaration $i$f$isInline22;
                block14: {
                    KtSourceElement ktSourceElement;
                    block15: {
                        boolean bl;
                        block13: {
                            Intrinsics.checkNotNullParameter(context2, "context");
                            Intrinsics.checkNotNullParameter(reporter, "reporter");
                            Intrinsics.checkNotNullParameter(declaration, "declaration");
                            if (!(declaration instanceof FirFunction) && !(declaration instanceof FirProperty)) {
                                return;
                            }
                            if (DeclarationUtilsKt.getHasExplicitReturnType(((FirCallableDeclaration)declaration).getSymbol())) {
                                return;
                            }
                            Iterable $this$any$iv = context2.getContainingDeclarations();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (FirDeclaration)element$iv;
                                    boolean bl2 = false;
                                    if (!(DeclarationUtilsKt.isLocalMember((FirDeclaration)it) || it instanceof FirAnonymousObject)) continue;
                                    bl = true;
                                    break block13;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            return;
                        }
                        FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration;
                        boolean $i$f$isInline22 = false;
                        if (!TypeUtilsKt.shouldApproximateAnonymousTypesOfNonLocalDeclaration(TypeUtilsKt.visibilityForApproximation(declaration, CollectionsKt.lastOrNull(context2.getContainingDeclarations())), $this$isInline$iv.getStatus().isInline())) {
                            return;
                        }
                        $i$f$isInline22 = (FirCallableDeclaration)declaration;
                        if (!($i$f$isInline22 instanceof FirProperty)) break block14;
                        object = ((FirProperty)declaration).getInitializer();
                        if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null) break block15;
                        Pair<ConeKotlinType, KtSourceElement> it2 = object;
                        boolean bl3 = false;
                        Pair<Pair<ConeKotlinType, KtSourceElement>, KtSourceElement> pair = TuplesKt.to(it2, ((FirProperty)declaration).getSource());
                        object = pair;
                        if (pair != null) break block16;
                    }
                    FirAmbiguousAnonymousTypeChecker $this$check_u24lambda_u242 = this;
                    boolean bl = false;
                    FirPropertyAccessor getter2 = ((FirProperty)declaration).getGetter();
                    if (((FirProperty)declaration).getDelegate() != null) {
                        ktSourceElement = ((FirProperty)declaration).getSource();
                    } else {
                        FirPropertyAccessor firPropertyAccessor = getter2;
                        ktSourceElement = firPropertyAccessor != null ? firPropertyAccessor.getSource() : null;
                    }
                    KtSourceElement getterDeclarationSource = ktSourceElement;
                    FirPureAbstractElement firPureAbstractElement = getter2;
                    object = TuplesKt.to(firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getBody()) != null ? $this$check_u24lambda_u242.getSingleExpressionType((FirBlock)firPureAbstractElement) : null, getterDeclarationSource);
                    break block16;
                }
                if ($i$f$isInline22 instanceof FirFunction) {
                    FirBlock firBlock = ((FirFunction)declaration).getBody();
                    object = TuplesKt.to(firBlock != null ? this.getSingleExpressionType(firBlock) : null, ((FirFunction)declaration).getSource());
                } else {
                    throw new IllegalStateException("Should not be there".toString());
                }
            }
            Pair<ConeKotlinType, KtSourceElement> pair = object;
            ConeKotlinType type = pair.component1();
            KtSourceElement source = pair.component2();
            ConeKotlinType coneKotlinType = type;
            if (coneKotlinType == null) break block17;
            it = coneKotlinType;
            boolean bl = false;
            INSTANCE.checkTypeAndArguments((ConeKotlinType)it, context2, reporter, source);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAndArguments(ConeKotlinType type, CheckerContext context2, DiagnosticReporter reporter, KtSourceElement reportOn) {
        FirClassifierSymbol<?> classSymbol = ToSymbolUtilsKt.toSymbol(type, context2.getSession());
        if (classSymbol instanceof FirAnonymousObjectSymbol && ((FirAnonymousObjectSymbol)classSymbol).getResolvedSuperTypeRefs().size() > 1) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            Iterable object = ((FirAnonymousObjectSymbol)classSymbol).getResolvedSuperTypeRefs();
            KtDiagnosticFactory1<Collection<ConeKotlinType>> ktDiagnosticFactory1 = FirErrors.INSTANCE.getAMBIGUOUS_ANONYMOUS_TYPE_INFERRED();
            AbstractKtSourceElement abstractKtSourceElement = reportOn;
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$map = false;
            Iterable iterable = object;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getConeType());
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)collection, (DiagnosticContext)context2, null, 16, null);
        }
        for (ConeTypeProjection typeArgument : type.getTypeArguments()) {
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeArgument);
            if (coneKotlinType == null) continue;
            this.checkTypeAndArguments(coneKotlinType, context2, reporter, reportOn);
        }
    }

    private final ConeKotlinType getSingleExpressionType(FirBlock $this$singleExpressionType) {
        FirSingleExpressionBlock firSingleExpressionBlock = $this$singleExpressionType instanceof FirSingleExpressionBlock ? (FirSingleExpressionBlock)$this$singleExpressionType : null;
        FirStatement firStatement = firSingleExpressionBlock != null ? firSingleExpressionBlock.getStatement() : null;
        FirExpression firExpression = firStatement instanceof FirReturnExpression ? (FirReturnExpression)firStatement : null;
        return firExpression != null && (firExpression = firExpression.getResult()) != null ? FirTypeUtilsKt.getResolvedType(firExpression) : null;
    }
}

