/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.Kafka$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServerStartable;
import kafka.server.KafkaServerStartable$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.concurrent.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class Kafka$
implements Logging {
    public static Kafka$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new Kafka$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Kafka$ kafka$ = this;
        synchronized (kafka$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Properties getPropsFromArgs(String[] args) {
        Properties props;
        block2: {
            OptionParser optionParser = new OptionParser(false);
            ArgumentAcceptingOptionSpec overrideOpt = optionParser.accepts("override", "Optional property that should override values set in server.properties file").withRequiredArg().ofType(String.class);
            if (args.length == 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, new StringOps(Predef$.MODULE$.augmentString("USAGE: java [options] %s server.properties [--override property=value]*")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaServer.class.getSimpleName()})));
            }
            props = Utils.loadProps((String)args[0]);
            if (args.length <= 1) break block2;
            OptionSet options = optionParser.parse((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(1, args.length));
            if (options.nonOptionArguments().size() > 0) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(optionParser, "Found non argument parameters: " + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(options.nonOptionArguments().toArray())).mkString(","));
            }
            Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)overrideOpt)).asScala()), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2()));
        }
        return props;
    }

    private void registerLoggingSignalHandler() {
        block0: {
            Map jvmSignalHandlers = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
            SignalHandler handler = new SignalHandler(jvmSignalHandlers){
                private final Map jvmSignalHandlers$1;

                public void handle(Signal signal) {
                    Kafka$.MODULE$.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Terminating process due to signal ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{signal})));
                    this.jvmSignalHandlers$1.get((Object)signal.getName()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        anon.2.$anonfun$handle$2(signal, x$1);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$handle$2(Signal signal$1, SignalHandler x$1) {
                    x$1.handle(signal$1);
                }
                {
                    this.jvmSignalHandlers$1 = jvmSignalHandlers$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handle$1(sun.misc.Signal ), $anonfun$handle$2$adapted(sun.misc.Signal sun.misc.SignalHandler )}, serializedLambda);
                }
            };
            if (OperatingSystem.IS_WINDOWS) break block0;
            Kafka$.registerHandler$1("TERM", jvmSignalHandlers, handler);
            Kafka$.registerHandler$1("INT", jvmSignalHandlers, handler);
            Kafka$.registerHandler$1("HUP", jvmSignalHandlers, handler);
        }
    }

    public void main(String[] args) {
        try {
            Properties serverProps = this.getPropsFromArgs(args);
            KafkaServerStartable kafkaServerStartable = KafkaServerStartable$.MODULE$.fromProps(serverProps);
            this.registerLoggingSignalHandler();
            Runtime.getRuntime().addShutdownHook(new Thread(kafkaServerStartable){
                private final KafkaServerStartable kafkaServerStartable$1;

                public void run() {
                    this.kafkaServerStartable$1.shutdown();
                }
                {
                    this.kafkaServerStartable$1 = kafkaServerStartable$1;
                    super("kafka-shutdown-hook");
                }
            });
            kafkaServerStartable.startup();
            kafkaServerStartable.awaitShutdown();
        }
        catch (Throwable e) {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exiting Kafka due to fatal exception", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private static final void registerHandler$1(String signalName, Map jvmSignalHandlers$1, SignalHandler handler$1) {
        block0: {
            SignalHandler oldHandler = Signal.handle(new Signal(signalName), handler$1);
            if (oldHandler == null) break block0;
            jvmSignalHandlers$1.put((Object)signalName, (Object)oldHandler);
        }
    }

    private Kafka$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

