/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollUtils {
    public static <T> List<T> filter(Collection<T> unfiltered, Predicate<? super T> predicate) {
        if (unfiltered == null) {
            return null;
        }
        Collection filteredColl = Collections2.filter(unfiltered, predicate);
        ArrayList filteredList = new ArrayList(filteredColl);
        return filteredList;
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name, T defaultValue) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <T extends Enum<T>> T findValueOf(Class<T> collectionClass, String value) {
        if (value == null) {
            return null;
        }
        Enum[] enumConstants = (Enum[])collectionClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Input must be an enum: " + collectionClass);
        }
        for (Enum valued : enumConstants) {
            if (!value.equals(valued.name()) && !value.equalsIgnoreCase(((Valued)((Object)valued)).getValue())) continue;
            return (T)valued;
        }
        return null;
    }

    public static interface Valued {
        public String getValue();
    }
}

