/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gmptogtp;

import java.io.InputStream;
import java.io.OutputStream;
import net.sf.gogui.gmp.Gmp;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gtp.GtpCommand;
import net.sf.gogui.gtp.GtpEngine;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.version.Version;

public class GmpToGtp
extends GtpEngine {
    private boolean m_firstGame = true;
    private final boolean m_simple;
    private final boolean m_wait;
    private final int m_colorIndex;
    private final int m_size;
    private final String m_title;
    private final Gmp m_gmp;

    public GmpToGtp(String string, InputStream inputStream, OutputStream outputStream, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        super(null);
        this.m_simple = bl3;
        this.m_colorIndex = n2;
        this.m_wait = bl2;
        this.m_gmp = new Gmp(inputStream, outputStream, n, n2, bl3, bl);
        this.m_title = string;
        this.m_size = n;
    }

    public void handleCommand(GtpCommand gtpCommand) throws GtpError {
        if (gtpCommand.getCommand().equals("boardsize")) {
            this.cmdBoardsize(gtpCommand);
        } else if (gtpCommand.getCommand().equals("clear_board")) {
            this.cmdClearBoard(gtpCommand);
        } else if (gtpCommand.getCommand().equals("genmove")) {
            this.cmdGenmove(gtpCommand);
        } else if (gtpCommand.getCommand().equals("gmp_queue")) {
            this.cmdQueue(gtpCommand);
        } else if (gtpCommand.getCommand().equals("gmp_talk")) {
            this.cmdTalk(gtpCommand);
        } else if (!gtpCommand.getCommand().equals("gogui_interrupt")) {
            if (gtpCommand.getCommand().equals("gogui_title")) {
                gtpCommand.getResponse().append(this.m_title);
            } else if (gtpCommand.getCommand().equals("list_commands")) {
                gtpCommand.getResponse().append("boardsize\nclear_board\ngenmove\ngmp_talk\ngmp_queue\ngogui_interrupt\ngogui_title\nlist_commands\nname\nplay\nundo\nversion\nquit\n");
            } else if (gtpCommand.getCommand().equals("name")) {
                gtpCommand.getResponse().append("GmpToGtp");
            } else if (gtpCommand.getCommand().equals("play")) {
                this.cmdPlay(gtpCommand);
            } else if (gtpCommand.getCommand().equals("protocol_version")) {
                gtpCommand.getResponse().append("2");
            } else if (!gtpCommand.getCommand().equals("quit")) {
                if (gtpCommand.getCommand().equals("undo")) {
                    this.cmdUndo(gtpCommand);
                } else if (gtpCommand.getCommand().equals("version")) {
                    gtpCommand.getResponse().append(Version.get());
                } else {
                    throw new GtpError("unknown command");
                }
            }
        }
    }

    public void interruptCommand() {
        this.m_gmp.interruptCommand();
    }

    private void cmdBoardsize(GtpCommand gtpCommand) throws GtpError {
        int n = gtpCommand.getIntArg();
        if (n != this.m_size) {
            throw new GtpError("size must be " + this.m_size);
        }
    }

    private void cmdClearBoard(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        StringBuffer stringBuffer = new StringBuffer();
        if (!(this.m_wait && this.m_firstGame || this.m_simple && this.m_colorIndex == 1)) {
            if (!this.m_gmp.newGame(this.m_size, stringBuffer)) {
                throw new GtpError(stringBuffer.toString());
            }
            return;
        }
        this.m_firstGame = false;
        if (!this.m_gmp.waitNewGame(this.m_size, stringBuffer)) {
            throw new GtpError(stringBuffer.toString());
        }
    }

    private void cmdGenmove(GtpCommand gtpCommand) throws GtpError {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = gtpCommand.getColorArg() == GoColor.BLACK;
        Gmp.Move move = this.m_gmp.waitMove(bl, stringBuffer);
        if (move == null) {
            throw new GtpError(stringBuffer.toString());
        }
        if (move.m_x < 0) {
            gtpCommand.getResponse().append("PASS");
            return;
        }
        int n = 65 + move.m_x;
        if (n >= 73) {
            ++n;
        }
        gtpCommand.getResponse().append((char)n);
        gtpCommand.getResponse().append(move.m_y + 1);
    }

    private void cmdPlay(GtpCommand gtpCommand) throws GtpError {
        StringBuffer stringBuffer;
        gtpCommand.checkNuArg(2);
        GoColor goColor = gtpCommand.getColorArg(0);
        GoPoint goPoint = gtpCommand.getPointArg(1, this.m_size);
        int n = -1;
        int n2 = -1;
        if (goPoint != null) {
            n = goPoint.getX();
            n2 = goPoint.getY();
        }
        if (!this.m_gmp.play(goColor == GoColor.BLACK, n, n2, stringBuffer = new StringBuffer())) {
            throw new GtpError(stringBuffer.toString());
        }
    }

    private void cmdQueue(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.m_gmp.queue(stringBuffer)) {
            throw new GtpError(stringBuffer.toString());
        }
    }

    private void cmdTalk(GtpCommand gtpCommand) throws GtpError {
        String string = gtpCommand.getLine();
        int n = string.indexOf(32);
        if (n > 0 && !string.substring(n + 1).trim().equals("")) {
            if (!this.m_gmp.sendTalk(string.substring(n + 1))) {
                throw new GtpError("Write error");
            }
        } else {
            gtpCommand.getResponse().append(this.m_gmp.getTalk());
        }
    }

    private void cmdUndo(GtpCommand gtpCommand) throws GtpError {
        gtpCommand.checkArgNone();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.m_gmp.undo(stringBuffer)) {
            throw new GtpError(stringBuffer.toString());
        }
    }
}

