/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gmp;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.gogui.gmp.Cmd;
import net.sf.gogui.gmp.Util;
import net.sf.gogui.gmp.WriteThread;
import net.sf.gogui.utils.StringUtils;

class MainThread
extends Thread {
    private static final int STATE_IDLE = 0;
    private static final int STATE_DISCONNECTED = 1;
    private static final int STATE_WAIT_OK = 2;
    private static final int STATE_DENY = 3;
    private static final int STATE_INTERRUPTED = 4;
    private static final int STATE_WAIT_ANSWER_OK = 5;
    private static final int STATE_WAIT_ANSWER = 6;
    private final boolean m_verbose;
    private boolean m_hisLastSeq;
    private boolean m_myLastSeq;
    private final boolean m_simple;
    private int m_lastQuery;
    private int m_state = 0;
    private final int m_colorIndex;
    private int m_pending;
    private final int m_size;
    private int m_queryCount;
    private static int[] s_queries;
    private int[] m_inBuffer = new int[4];
    private final InputStream m_in;
    private final Object m_mutex = new Object();
    private final StringBuffer m_talkBuffer = new StringBuffer();
    private final StringBuffer m_talkLine = new StringBuffer();
    private final ArrayList m_cmdQueue = new ArrayList(32);
    private final WriteThread m_writeThread;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MainThread(InputStream inputStream, OutputStream outputStream, int n, int n2, boolean bl, boolean bl2) {
        if (!$assertionsDisabled && n < 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > 22) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 > 2) {
            throw new AssertionError();
        }
        this.m_verbose = bl2;
        this.m_in = inputStream;
        this.m_size = n;
        this.m_colorIndex = n2;
        this.m_simple = bl;
        this.m_writeThread = new WriteThread(outputStream, bl2);
        this.m_writeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTalk() {
        Object object = this.m_mutex;
        synchronized (object) {
            String string = this.m_talkBuffer.toString();
            this.m_talkBuffer.setLength(0);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptCommand() {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_state = 4;
            this.m_mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queue(StringBuffer stringBuffer) {
        Object object = this.m_mutex;
        synchronized (object) {
            int n = this.m_cmdQueue.size();
            for (int i = 0; i < n; ++i) {
                Cmd cmd = (Cmd)this.m_cmdQueue.get(i);
                stringBuffer.append(cmd.toString(this.m_size, this.m_lastQuery));
                stringBuffer.append('\n');
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object;
        try {
            object = new byte[16];
            while (true) {
                int n = this.m_in.read((byte[])object);
                Object object2 = this.m_mutex;
                synchronized (object2) {
                    if (n < 0) {
                        break;
                    }
                    for (int i = 0; i < n; ++i) {
                        int n2 = object[i];
                        if (n2 < 0) {
                            n2 += 256;
                        }
                        Util.log("recv " + Util.format(n2), this.m_verbose);
                        this.handleByte(n2);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
        }
        Object object3 = this.m_mutex;
        object = object3;
        synchronized (object3) {
            this.m_state = 1;
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            Util.log("input stream was closed", this.m_verbose);
            this.m_writeThread.interrupt();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(Cmd cmd, StringBuffer stringBuffer) {
        Object object = this.m_mutex;
        synchronized (object) {
            while (this.m_state == 5 || this.m_state == 6) {
                try {
                    MainThread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.m_state == 2) {
                stringBuffer.append("Command in progress");
                return false;
            }
            if (this.m_state == 1) {
                stringBuffer.append("GMP connection broken");
                return false;
            }
            if (this.m_cmdQueue.size() > 0) {
                Cmd cmd2 = (Cmd)this.m_cmdQueue.get(0);
                if (!cmd2.equals(cmd)) {
                    stringBuffer.append("Received ");
                    stringBuffer.append(cmd2.toString(this.m_size, this.m_lastQuery));
                    return false;
                }
                this.m_cmdQueue.remove(0);
                return true;
            }
            this.sendCmd(cmd.m_cmd, cmd.m_val);
            block15: while (true) {
                try {
                    this.m_mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted");
                }
                switch (this.m_state) {
                    case 0: {
                        return true;
                    }
                    case 3: {
                        stringBuffer.append("Command denied");
                        this.m_state = 0;
                        return false;
                    }
                    case 2: {
                        continue block15;
                    }
                    case 4: {
                        stringBuffer.append("GMP connection closed");
                        this.m_state = 1;
                        return false;
                    }
                    case 1: {
                        stringBuffer.append("GMP connection broken");
                        return false;
                    }
                }
                break;
            }
            return false;
        }
    }

    public boolean sendTalk(String string) {
        return this.m_writeThread.sendTalk(string);
    }

    public WaitResult waitCmd(int n, int n2, int n3) {
        Object object = this.m_mutex;
        synchronized (object) {
            WaitResult waitResult = new WaitResult();
            waitResult.m_success = false;
            while (true) {
                if (this.m_cmdQueue.size() > 0) {
                    Cmd cmd = (Cmd)this.m_cmdQueue.get(0);
                    if (cmd.m_cmd != n || (cmd.m_val & n2) != n3) {
                        waitResult.m_response = "Received " + cmd.toString(this.m_size, this.m_lastQuery);
                        return waitResult;
                    }
                    waitResult.m_success = true;
                    waitResult.m_val = cmd.m_val;
                    this.m_cmdQueue.remove(0);
                    return waitResult;
                }
                if (this.m_state == 1) {
                    waitResult.m_response = "GMP connection broken";
                    return waitResult;
                }
                try {
                    Util.log("Waiting for " + Cmd.cmdToString(n) + "...", this.m_verbose);
                    this.m_mutex.wait();
                    if (this.m_state != 4) continue;
                    waitResult.m_response = "Interrupted";
                    return waitResult;
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted");
                    continue;
                }
                break;
            }
        }
    }

    private void answerQuery(int n) {
        int n2 = 0;
        this.m_lastQuery = n;
        if (n == 11) {
            n2 = this.m_colorIndex;
        } else if (n == 9) {
            n2 = this.m_size;
        } else if (n == 8) {
            n2 = 1;
        }
        this.sendCmd(4, n2);
    }

    private boolean checkChecksum() {
        int n = this.m_inBuffer[0];
        int n2 = this.m_inBuffer[2];
        int n3 = this.m_inBuffer[3];
        int n4 = this.getChecksum(n, n2, n3);
        return n4 == this.m_inBuffer[1];
    }

    private int getChecksum(int n, int n2, int n3) {
        return (n + n2 + n3 | 0x80) & 0xFF;
    }

    private boolean getAck() {
        int n = this.m_inBuffer[0] & 2;
        return n != 0;
    }

    private Cmd getCmd() {
        int n = this.m_inBuffer[2] >> 4 & 7;
        int n2 = (this.m_inBuffer[2] & 7) << 7 | this.m_inBuffer[3] & 0x7F;
        return new Cmd(n, n2);
    }

    private boolean getSeq() {
        int n = this.m_inBuffer[0] & 1;
        return n != 0;
    }

    private void handleByte(int n) {
        if (n > 3 && n < 128) {
            char c = (char)n;
            if (c == '\r') {
                Util.log("talk char '\\r'", this.m_verbose);
                return;
            }
            if (c == '\n') {
                Util.log("talk char '\\n'", this.m_verbose);
                Util.log("talk: " + this.m_talkLine, this.m_verbose);
                this.m_talkLine.setLength(0);
                return;
            }
            Util.log("talk '" + c + "'", this.m_verbose);
            this.m_talkLine.append(c);
            this.m_talkBuffer.append(c);
            return;
        }
        if (n < 4) {
            if (this.m_pending > 0) {
                Util.log("new start byte. discarding old bytes", this.m_verbose);
            }
            this.m_inBuffer[0] = n;
            this.m_pending = 3;
            return;
        }
        if (this.m_pending > 0) {
            int n2 = 4 - this.m_pending;
            if (!$assertionsDisabled && n2 <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 >= 4) {
                throw new AssertionError();
            }
            this.m_inBuffer[n2] = n;
            --this.m_pending;
            if (this.m_pending == 0) {
                if (!this.checkChecksum()) {
                    Util.log("bad checksum", this.m_verbose);
                    return;
                }
                this.handlePacket();
            }
            return;
        }
        Util.log("discarding command byte", this.m_verbose);
    }

    private void handleCmd(Cmd cmd) {
        Util.log("received " + cmd.toString(this.m_size, this.m_lastQuery), this.m_verbose);
        if (cmd.m_cmd == 3) {
            this.answerQuery(cmd.m_val);
        } else if (cmd.m_cmd == 4) {
            if (this.m_queryCount < s_queries.length - 1) {
                int n;
                ++this.m_queryCount;
                this.m_lastQuery = n = s_queries[this.m_queryCount];
                this.sendCmd(3, n);
            } else {
                this.sendOk();
                this.m_state = 0;
                this.m_mutex.notifyAll();
            }
        } else if (cmd.m_cmd == 2 && this.m_simple) {
            int n;
            this.m_cmdQueue.add(cmd);
            this.m_queryCount = 0;
            this.m_lastQuery = n = s_queries[this.m_queryCount];
            this.sendCmd(3, n);
            this.m_mutex.notifyAll();
        } else {
            this.sendOk();
            if (cmd.m_cmd == 1) {
                if (this.m_state == 5) {
                    this.m_state = 0;
                } else {
                    this.m_state = 3;
                    this.m_mutex.notifyAll();
                }
            } else {
                this.m_cmdQueue.add(cmd);
                this.m_state = 0;
                this.m_mutex.notifyAll();
            }
        }
    }

    private void handlePacket() {
        Cmd cmd = this.getCmd();
        boolean bl = this.getSeq();
        boolean bl2 = this.getAck();
        if (this.m_state == 2 || this.m_state == 5 || this.m_state == 6) {
            if (cmd.m_cmd == 0) {
                if (bl2 != this.m_myLastSeq) {
                    Util.log("sequence error", this.m_verbose);
                    return;
                }
                Util.log("received OK", this.m_verbose);
                this.m_state = 0;
                this.m_writeThread.stopSend();
                this.m_mutex.notifyAll();
                return;
            }
            if (bl == this.m_hisLastSeq) {
                Util.log("old cmd. resending OK", this.m_verbose);
                this.sendOk();
                return;
            }
            if (bl2 == this.m_myLastSeq) {
                this.m_state = 0;
                this.m_writeThread.stopSend();
                this.m_hisLastSeq = bl;
                this.handleCmd(cmd);
                return;
            }
            Util.log("ignore conflict", this.m_verbose);
            this.m_writeThread.resend();
        } else {
            if (!$assertionsDisabled && this.m_state != 0) {
                throw new AssertionError();
            }
            if (cmd.m_cmd == 0) {
                Util.log("ignoring unexpected OK", this.m_verbose);
                return;
            }
            if (bl2 != this.m_myLastSeq) {
                Util.log("ignoring old cmd", this.m_verbose);
                return;
            }
            if (bl == this.m_hisLastSeq) {
                Util.log("old cmd. resending OK", this.m_verbose);
                this.sendOk();
                return;
            }
            this.m_hisLastSeq = bl;
            this.handleCmd(cmd);
        }
    }

    private byte makeCmdByte1(int n, int n2) {
        return (byte)(0x80 | n << 4 | (n2 &= 0x3FF) >> 7);
    }

    private byte makeCmdByte2(int n) {
        return (byte)(0x80 | n & 0x7F);
    }

    private boolean sendCmd(int n, int n2) {
        boolean bl;
        Util.log("send " + new Cmd(n, n2).toString(this.m_size, this.m_lastQuery), this.m_verbose);
        boolean bl2 = bl = n == 0;
        if (!bl) {
            this.m_myLastSeq = !this.m_myLastSeq;
        }
        byte[] byArray = new byte[4];
        byArray[0] = (byte)(this.m_myLastSeq ? 1 : 0);
        byArray[0] = (byte)(byArray[0] | (byte)(this.m_hisLastSeq ? 2 : 0));
        byArray[2] = this.makeCmdByte1(n, n2);
        byArray[3] = this.makeCmdByte2(n2);
        this.setChecksum(byArray);
        this.m_writeThread.sendPacket(byArray, bl);
        if (!bl) {
            this.m_state = n == 4 ? 5 : (n == 3 ? 6 : 2);
        }
        return true;
    }

    private boolean sendOk() {
        return this.sendCmd(0, 0);
    }

    private void setChecksum(byte[] byArray) {
        byte by = byArray[0];
        byte by2 = byArray[2];
        byte by3 = byArray[3];
        int n = this.getChecksum(by, by2, by3);
        byArray[1] = (byte)(0x80 | n);
    }

    static {
        $assertionsDisabled = !MainThread.class.desiredAssertionStatus();
        s_queries = new int[]{11, 8};
    }

    public static class WaitResult {
        public boolean m_success;
        public String m_response;
        public int m_val;
    }
}

